/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.render;

import com.spacekiller.util.render.FontButton;
import com.spacekiller.util.render.FontOutline;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.AbstractButton;
import javax.swing.plaf.basic.BasicButtonUI;

public class FontButtonUI
extends BasicButtonUI {
    @Override
    protected void paintText(Graphics g, AbstractButton b, Rectangle textRect, String text) {
        if (g instanceof Graphics2D) {
            FontMetrics fm = g.getFontMetrics(b.getFont());
            int textX = textRect.x + this.getTextShiftOffset();
            int textY = textRect.y + fm.getAscent() + this.getTextShiftOffset();
            if (b.isEnabled()) {
                this.paintEnabledText(b, (Graphics2D)g, text, textX, textY);
            } else {
                this.paintDisabledText(b, (Graphics2D)g, text, textX, textY);
            }
            return;
        }
        super.paintText(g, b, textRect, text);
    }

    protected void paintEnabledText(AbstractButton b, Graphics2D g2, String s, int textX, int textY) {
        FontButton button = (FontButton)b;
        Paint fillPaint = button.getFillPaint();
        Paint outlinePaint = button.getOutlinePaint();
        this.paintOutlineText(button, g2, s, textX, textY, fillPaint, outlinePaint);
    }

    protected void paintDisabledText(AbstractButton b, Graphics2D g2, String s, int textX, int textY) {
        FontButton button = (FontButton)b;
        Paint fillPaint = button.getDisabledFillPaint();
        Paint outlinePaint = button.getDisabledOutlinePaint();
        this.paintOutlineText(button, g2, s, textX, textY, fillPaint, outlinePaint);
    }

    protected void paintOutlineText(FontButton button, Graphics2D g2, String s, int textX, int textY, Paint fillPaint, Paint outlinePaint) {
        FontOutline outline = button.getFontOutline();
        RenderingHints oldHints = g2.getRenderingHints();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        outline.drawText(g2, textX, textY, fillPaint, outlinePaint);
        g2.setRenderingHints(oldHints);
    }
}

