/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.render;

import com.spacekiller.util.render.PerspectiveTransform;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.WritableRaster;

public class PerspectiveOp
implements RasterOp,
BufferedImageOp {
    private PerspectiveTransform transform;
    private PerspectiveTransform inverse;
    private RenderingHints hints;

    public PerspectiveOp(PerspectiveTransform transform, RenderingHints hints) throws NoninvertibleTransformException, CloneNotSupportedException {
        if (transform == null) {
            throw new NullPointerException("transform");
        }
        this.transform = transform;
        this.inverse = transform.createInverse();
        this.hints = hints;
    }

    public PerspectiveOp(PerspectiveTransform transform, PerspectiveTransform inverse, RenderingHints hints) {
        if (transform == null) {
            throw new NullPointerException("transform");
        }
        if (inverse == null) {
            throw new NullPointerException("inverse");
        }
        this.transform = transform;
        this.inverse = inverse;
        this.hints = hints;
    }

    @Override
    public Rectangle2D getBounds2D(BufferedImage src) {
        return this.getBounds2D(src.getRaster());
    }

    @Override
    public Rectangle2D getBounds2D(Raster src) {
        int w = src.getWidth();
        int h = src.getHeight();
        double[] pts = new double[]{0.0, 0.0, w, 0.0, w, h, 0.0, h};
        this.transform.transform(pts, 0, pts, 0, 4);
        double fmaxX = pts[0];
        double fmaxY = pts[1];
        double fminX = pts[0];
        double fminY = pts[1];
        for (int i = 2; i < 8; i += 2) {
            if (pts[i] > fmaxX) {
                fmaxX = pts[i];
            } else if (pts[i] < fminX) {
                fminX = pts[i];
            }
            if (pts[i + 1] > fmaxY) {
                fmaxY = pts[i + 1];
                continue;
            }
            if (!(pts[i + 1] < fminY)) continue;
            fminY = pts[i + 1];
        }
        return new Rectangle2D.Double(fminX, fminY, fmaxX - fminX, fmaxY - fminY);
    }

    @Override
    public BufferedImage createCompatibleDestImage(BufferedImage src, ColorModel destCM) {
        int h;
        if (destCM != null && destCM.getTransferType() != 3) {
            throw new IllegalArgumentException("Unsupported destination data type: " + destCM.getTransferType() + " != " + 3);
        }
        Rectangle r = this.getBounds2D(src).getBounds();
        int w = (int)r.getX() + (int)r.getWidth();
        if (w < 1) {
            w = 1;
        }
        if ((h = (int)r.getY() + (int)r.getHeight()) < 1) {
            h = 1;
        }
        return new BufferedImage(w, h, 2);
    }

    @Override
    public WritableRaster createCompatibleDestRaster(Raster src) {
        int h;
        Rectangle r = this.getBounds2D(src).getBounds();
        int w = (int)r.getWidth();
        if (w < 1) {
            w = 1;
        }
        if ((h = (int)r.getHeight()) < 1) {
            h = 1;
        }
        return src.createCompatibleWritableRaster((int)r.getX(), (int)r.getY(), w, h);
    }

    @Override
    public Point2D getPoint2D(Point2D srcPt, Point2D dstPt) {
        return this.transform.transform(srcPt, dstPt);
    }

    @Override
    public RenderingHints getRenderingHints() {
        return this.hints;
    }

    @Override
    public BufferedImage filter(BufferedImage src, BufferedImage dest) {
        if (src == null) {
            throw new NullPointerException("src image is null");
        }
        if (src == dest) {
            throw new IllegalArgumentException("src image cannot be the same as the dst image");
        }
        if (dest == null) {
            dest = this.createCompatibleDestImage(src, null);
        }
        this.filter(src.getRaster(), dest.getRaster());
        return dest;
    }

    @Override
    public WritableRaster filter(Raster src, WritableRaster dest) {
        Object hint;
        if (src.getTransferType() != 3) {
            throw new IllegalArgumentException("Unsupported source data type: " + src.getTransferType() + " != " + 3);
        }
        int sx = src.getMinX();
        int sy = src.getMinY();
        int sw = src.getWidth();
        int sh = src.getHeight();
        if (dest == null) {
            dest = this.createCompatibleDestRaster(src);
        } else if (dest.getTransferType() != 3) {
            throw new IllegalArgumentException("Unsupported destination data type: " + dest.getTransferType() + " != " + 3);
        }
        int dx = dest.getMinX();
        int dy = dest.getMinY();
        int dw = dest.getWidth();
        int dh = dest.getHeight();
        int[] sa = new int[sw * sh];
        src.getDataElements(sx, sy, sw, sh, sa);
        int[] da = new int[dw * dh];
        Object object = hint = this.hints == null ? null : this.hints.get(RenderingHints.KEY_RENDERING);
        if (hint == RenderingHints.VALUE_RENDER_SPEED) {
            this.filterSpeed(sa, sw, sh, da, dw, dh);
        } else {
            this.filterQuality(sa, sw, sh, da, dw, dh);
        }
        dest.setDataElements(dx, dy, dw, dh, da);
        return dest;
    }

    public void filterSpeed(int[] sa, int sw, int sh, int[] da, int dw, int dh) {
        int i = 0;
        double[] srcPts = new double[2];
        double[] dstPts = new double[2];
        for (int y = 0; y < dh; ++y) {
            srcPts[1] = y;
            for (int x = 0; x < dw; ++x) {
                srcPts[0] = x;
                this.inverse.transform(srcPts, 0, dstPts, 0, 1);
                da[i++] = this.getPix((long)dstPts[0], (long)dstPts[1], sa, sw, sh);
            }
        }
    }

    protected int getPix(long x, long y, int[] a, int w, int h) {
        return x < 0L || y < 0L || x >= (long)w || y >= (long)h ? 0 : a[(int)x + (int)y * w];
    }

    public void filterQuality(int[] sa, int sw, int sh, int[] da, int dw, int dh) {
        int i = 0;
        double[] srcPts = new double[2];
        double[] dstPts = new double[2];
        for (int y = 0; y < dh; ++y) {
            srcPts[1] = y;
            for (int x = 0; x < dw; ++x) {
                srcPts[0] = x;
                this.inverse.transform(srcPts, 0, dstPts, 0, 1);
                da[i++] = this.getPix(dstPts[0], dstPts[1], sa, sw, sh);
            }
        }
    }

    protected int getPix(double x, double y, int[] a, int w, int h) {
        long py2;
        long px2;
        long px = (long)Math.floor(x);
        long py = (long)Math.floor(y);
        double rx = x - (double)px;
        double ry = y - (double)py;
        if (rx < 0.5) {
            px2 = px - 1L;
        } else {
            px2 = px + 1L;
            rx = 1.0 - rx;
        }
        if (ry < 0.5) {
            py2 = py - 1L;
        } else {
            py2 = py + 1L;
            ry = 1.0 - ry;
        }
        int v0 = this.getPix(px, py, a, w, h);
        int v1 = this.getPix(px2, py, a, w, h);
        int v2 = this.getPix(px, py2, a, w, h);
        int v3 = this.getPix(px2, py2, a, w, h);
        return this.mix(v0, v1, v2, v3, rx, ry);
    }

    protected int mix(int v0, int v1, int v2, int v3, double rx, double ry) {
        double f0 = rx + ry;
        double f1 = 0.5 - rx + ry;
        double f2 = rx + (0.5 - ry);
        double f3 = 0.5 - rx + (0.5 - ry);
        int b = (int)(((double)(v0 & 0xFF) * f0 + (double)(v1 & 0xFF) * f1 + (double)(v2 & 0xFF) * f2 + (double)(v3 & 0xFF) * f3) / 2.0);
        int g = (int)(((double)(v0 >>> 8 & 0xFF) * f0 + (double)(v1 >>> 8 & 0xFF) * f1 + (double)(v2 >>> 8 & 0xFF) * f2 + (double)(v3 >>> 8 & 0xFF) * f3) / 2.0);
        int r = (int)(((double)(v0 >>> 16 & 0xFF) * f0 + (double)(v1 >>> 16 & 0xFF) * f1 + (double)(v2 >>> 16 & 0xFF) * f2 + (double)(v3 >>> 16 & 0xFF) * f3) / 2.0);
        int a = (int)(((double)(v0 >>> 24 & 0xFF) * f0 + (double)(v1 >>> 24 & 0xFF) * f1 + (double)(v2 >>> 24 & 0xFF) * f2 + (double)(v3 >>> 24 & 0xFF) * f3) / 2.0);
        return a << 24 | r << 16 | g << 8 | b;
    }
}

