/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.render;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;

public class RotatingIcon
implements Icon {
    private Icon icon;
    private int width;
    private int height;
    private double theta;

    public RotatingIcon(Icon icon) {
        this.icon = icon;
        double w = icon.getIconWidth();
        double h = icon.getIconHeight();
        double q = Math.sqrt(w * w + h * h);
        this.height = this.width = (int)Math.round(q);
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g;
        int tx = x + this.width / 2;
        int ty = y + this.height / 2;
        g2d.translate(tx, ty);
        g2d.rotate(this.theta);
        this.icon.paintIcon(c, g, -this.icon.getIconWidth() / 2, -this.icon.getIconHeight() / 2);
        g2d.rotate(-this.theta);
        g2d.translate(-tx, -ty);
    }

    public double getTheta() {
        return this.theta;
    }

    public void setTheta(double theta) {
        this.theta = theta;
    }

    public void reset() {
        this.setTheta(0.0);
    }
}

