/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.workspace;

import com.spacekiller.util.Data;
import com.spacekiller.util.beans.DefaultBeanContextServices;
import com.spacekiller.util.workspace.DefaultProjectReference;
import com.spacekiller.util.workspace.Project;
import com.spacekiller.util.workspace.ProjectReference;
import com.spacekiller.util.workspace.ProjectType;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextMembershipEvent;
import java.beans.beancontext.BeanContextMembershipListener;
import java.io.Serializable;
import java.util.Collection;
import java.util.Random;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class DefaultProject
extends DefaultBeanContextServices
implements Project,
Serializable {
    private static final long serialVersionUID = 7490587608268515249L;
    private static Random random;
    private Object projectId;
    private String projectTypeName;
    private String name;
    private Project[] importedProjects;
    private Project[] exportedProjects;
    private transient ProjectType projectType;
    private transient boolean modified = false;
    private transient Object projectPath;
    private transient DefaultListModel importedProjectListModel = new DefaultListModel();
    private transient DefaultListModel accessibleProjectListModel = new DefaultListModel();
    private transient DefaultListModel exportedProjectListModel = new DefaultListModel();
    private transient Vector contexts = new Vector();
    private transient ProjectContextListener projectContextListener = new ProjectContextListener();
    private transient ExportedProjectListener exportedProjectListener = new ExportedProjectListener();
    private static final Logger logger;

    public DefaultProject(ProjectType projectType, String name) {
        this.setProjectType(projectType);
        this.setProjectTypeName(projectType.getName());
        this.setProjectId(DefaultProject.generateProjectId());
        this.setName(name);
        this.addBeanContext(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object generateProjectId() {
        Class<DefaultProject> clazz = DefaultProject.class;
        synchronized (DefaultProject.class) {
            if (random == null) {
                random = new Random();
            }
            long r = Math.abs(random.nextLong() + System.currentTimeMillis());
            // ** MonitorExit[var0] (shouldn't be in output)
            return Data.toLong((long)r);
        }
    }

    protected synchronized void addBeanContext(BeanContext bc) {
        if (bc == null || this.contexts.contains(bc)) {
            return;
        }
        logger.fine("addBeanContext: " + bc);
        this.contexts.add(bc);
        bc.addBeanContextMembershipListener(this.projectContextListener);
        for (Object o : bc) {
            if (o == null || !(o instanceof BeanContext)) continue;
            this.addBeanContext((BeanContext)o);
        }
    }

    public synchronized void addExportedProject(Project exportedProject) {
        if (this.getExportedProjectListModel().contains(exportedProject)) {
            return;
        }
        int oldCount = this.getExportedProjectCount();
        int newCount = oldCount + 1;
        Project[] newArray = new Project[newCount];
        System.arraycopy(this.exportedProjects, 0, newArray, 0, oldCount);
        newArray[oldCount] = exportedProject;
        this.exportedProjects = newArray;
        this.getExportedProjectListModel().addElement(exportedProject);
    }

    public synchronized void addImportedProject(Project importedProject) {
        if (this.getImportedProjectListModel().contains(importedProject)) {
            return;
        }
        this.getImportedProjectListModel().addElement(importedProject);
        this.refreshAccessibleProjects();
    }

    protected synchronized void childrenAdded(BeanContextMembershipEvent bcme) {
        BeanContext bc = bcme.getBeanContext();
        if (!this.contexts.contains(bc)) {
            return;
        }
    }

    protected synchronized void childrenRemoved(BeanContextMembershipEvent bcme) {
        BeanContext bc = bcme.getBeanContext();
        if (!this.contexts.contains(bc)) {
            return;
        }
    }

    protected synchronized void enumerateAccessibleProjects(Collection dstProjects) {
        int num = this.getImportedProjectCount();
        for (int c = 0; c < num; ++c) {
            Project imp = this.getImportedProjectAt(c);
            if (imp == null || dstProjects.contains(imp)) continue;
            dstProjects.add(imp);
            this.enumerateExportedProjectsRecursive(imp, dstProjects);
        }
    }

    protected synchronized void enumerateExportedProjectsRecursive(Project pro, Collection dstProjects) {
        int count = pro.getExportedProjectCount();
        for (int c = 0; c < count; ++c) {
            Project sub = pro.getExportedProjectAt(c);
            if (sub == null || dstProjects.contains(sub)) continue;
            dstProjects.add(sub);
            this.enumerateExportedProjectsRecursive(sub, dstProjects);
        }
    }

    protected void finalize() throws Throwable {
        int count = this.contexts.size();
        for (int c = count - 1; c >= 0; --c) {
            this.removeBeanContext((BeanContext)this.contexts.get(c));
        }
    }

    @Override
    public Project getAccessibleProjectAt(int i) {
        return (Project)this.getAccessibleProjectListModel().getElementAt(i);
    }

    @Override
    public int getAccessibleProjectCount() {
        return this.getAccessibleProjectListModel().getSize();
    }

    protected DefaultListModel getAccessibleProjectListModel() {
        if (this.accessibleProjectListModel == null) {
            this.accessibleProjectListModel = new DefaultListModel();
        }
        return this.accessibleProjectListModel;
    }

    @Override
    public Project getExportedProjectAt(int i) {
        return this.exportedProjects[i];
    }

    @Override
    public int getExportedProjectCount() {
        return this.exportedProjects == null ? 0 : this.exportedProjects.length;
    }

    protected DefaultListModel getExportedProjectListModel() {
        if (this.exportedProjectListModel == null) {
            this.exportedProjectListModel = new DefaultListModel();
        }
        return this.exportedProjectListModel;
    }

    @Override
    public Project getImportedProjectAt(int i) {
        return this.importedProjects[i];
    }

    @Override
    public int getImportedProjectCount() {
        return this.importedProjects == null ? 0 : this.importedProjects.length;
    }

    protected DefaultListModel getImportedProjectListModel() {
        if (this.importedProjectListModel == null) {
            this.importedProjectListModel = new DefaultListModel();
        }
        return this.importedProjectListModel;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object getProjectPath() {
        return this.projectPath;
    }

    @Override
    public ProjectReference getProjectReference() {
        DefaultProjectReference rc = new DefaultProjectReference();
        rc.setProjectName(this.getName());
        rc.setProjectTypeName(this.getProjectTypeName());
        rc.setProjectClassName(this.getClass().getName());
        rc.setProjectPath(this.getProjectPath());
        return rc;
    }

    @Override
    public final ProjectType getProjectType() {
        return this.projectType;
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }

    protected synchronized void refreshAccessibleProjects() {
        Project pro;
        int c;
        Vector accessibleProjects = new Vector();
        this.enumerateAccessibleProjects(accessibleProjects);
        int count = this.accessibleProjectListModel.getSize();
        for (c = count - 1; c >= 0; --c) {
            pro = (Project)this.accessibleProjectListModel.getElementAt(c);
            if (pro != null && accessibleProjects.contains(pro)) continue;
            pro.removeExportedProjectListener(this.exportedProjectListener);
            this.accessibleProjectListModel.removeElementAt(c);
        }
        count = accessibleProjects.size();
        for (c = 0; c < count; ++c) {
            pro = (Project)accessibleProjects.get(c);
            if (this.accessibleProjectListModel.contains(pro)) continue;
            this.accessibleProjectListModel.addElement(pro);
            pro.addExportedProjectListener(this.exportedProjectListener);
        }
    }

    protected synchronized void removeBeanContext(BeanContext bc) {
        if (bc == null || !this.contexts.contains(bc)) {
            return;
        }
        this.contexts.remove(bc);
        bc.removeBeanContextMembershipListener(this.projectContextListener);
        for (Object o : bc) {
            if (o == null || !(o instanceof BeanContext)) continue;
            this.removeBeanContext((BeanContext)o);
        }
    }

    public synchronized void removeExportedProject(Project exportedProject) {
        if (!this.getExportedProjectListModel().contains(exportedProject)) {
            return;
        }
        this.getExportedProjectListModel().removeElement(exportedProject);
    }

    public synchronized void removeImportedProject(Project importedProject) {
        if (importedProject == null) {
            return;
        }
        if (!this.getImportedProjectListModel().contains(importedProject)) {
            return;
        }
        int count = this.getExportedProjectCount();
        for (int c = count - 1; c >= 0; --c) {
            Project ref = this.getExportedProjectAt(c);
            if (ref != importedProject) continue;
            this.removeExportedProject(ref);
        }
        this.getImportedProjectListModel().removeElement(importedProject);
        this.refreshAccessibleProjects();
    }

    public void setModified(boolean newModified) {
        this.modified = newModified;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public void setProjectPath(Object newProjectPath) {
        this.projectPath = newProjectPath;
    }

    void setProjectType(ProjectType newProjectType) {
        this.projectType = newProjectType;
    }

    public String toString() {
        return String.valueOf(this.getName());
    }

    @Override
    public String getProjectTypeName() {
        return this.projectTypeName;
    }

    void setProjectTypeName(String projectTypeName) {
        this.projectTypeName = projectTypeName;
    }

    protected BeanContext getChildContext(String name) {
        if (name == null) {
            return null;
        }
        for (Object o : this) {
            if (o == null || !(o instanceof BeanContext) || !name.equals(this.getContextName((BeanContext)o))) continue;
            return (BeanContext)o;
        }
        return null;
    }

    protected String getContextName(BeanContext bc) {
        return String.valueOf(bc);
    }

    @Override
    public void addExportedProjectListener(ListDataListener l) {
        this.getExportedProjectListModel().addListDataListener(l);
    }

    @Override
    public void addImportedProjectListener(ListDataListener l) {
        this.getImportedProjectListModel().addListDataListener(l);
    }

    @Override
    public void removeExportedProjectListener(ListDataListener l) {
        if (this.exportedProjectListModel != null) {
            this.exportedProjectListModel.removeListDataListener(l);
        }
    }

    @Override
    public void removeImportedProjectListener(ListDataListener l) {
        if (this.importedProjectListModel != null) {
            this.importedProjectListModel.removeListDataListener(l);
        }
    }

    @Override
    public Object getProjectId() {
        return this.projectId;
    }

    void setProjectId(Object projectId) {
        this.projectId = projectId;
    }

    static {
        logger = Logger.getLogger(DefaultProject.class.getName());
    }

    protected class ExportedProjectListener
    implements ListDataListener {
        protected ExportedProjectListener() {
        }

        @Override
        public void intervalAdded(ListDataEvent ev) {
            DefaultProject.this.refreshAccessibleProjects();
        }

        @Override
        public void intervalRemoved(ListDataEvent ev) {
            DefaultProject.this.refreshAccessibleProjects();
        }

        @Override
        public void contentsChanged(ListDataEvent ev) {
            DefaultProject.this.refreshAccessibleProjects();
        }
    }

    protected class ProjectContextListener
    implements BeanContextMembershipListener {
        protected ProjectContextListener() {
        }

        @Override
        public void childrenAdded(BeanContextMembershipEvent bcme) {
            DefaultProject.this.childrenAdded(bcme);
        }

        @Override
        public void childrenRemoved(BeanContextMembershipEvent bcme) {
            DefaultProject.this.childrenRemoved(bcme);
        }
    }
}

