/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection;

import com.spacekiller.infection.Debug;
import com.spacekiller.infection.Infection;
import com.spacekiller.infection.InfectionAccess;
import com.spacekiller.infection.InfectionIndex;
import com.spacekiller.infection.InfectionInstallation;
import com.spacekiller.infection.InfectionInstaller;
import com.spacekiller.infection.InfectionInstance;
import com.spacekiller.infection.InfectionRuntime;
import com.spacekiller.infection.InfectionRuntimeImpl;
import com.spacekiller.infection.cmd.InfectionCommandLineImpl;
import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

final class InfectionAccessImpl
implements InfectionAccess {
    private Infection infection;

    InfectionAccessImpl(Infection infection) {
        this.infection = infection;
    }

    @Override
    public String getInfectionVersionInfoString() {
        return this.infection.getInfectionVersionInfoString();
    }

    @Override
    public String getJavaVersionInfoString() {
        return Debug.getJavaVersionInfoString();
    }

    @Override
    public String getOperatingSystemInfoString() {
        return Debug.getOperatingSystemInfoString();
    }

    @Override
    public InfectionRuntime getRuntimeInstance(InfectionInstance instance) throws Exception {
        return this.infection.getRuntimeInstance(instance);
    }

    @Override
    public File getInstanceConfigFile(InfectionRuntime runtime) throws Exception {
        return this.infection.getInstanceConfigFile(runtime);
    }

    @Override
    public void startInfectionRuntime(InfectionInstallation installation, InfectionIndex index, InfectionInstance instance, Map runtimeProperties) throws Throwable {
        this.infection.startInfectionRuntime(installation, index, instance, runtimeProperties);
    }

    @Override
    public void restartInfectionRuntime(InfectionRuntime rt, InfectionInstallation installation, InfectionIndex index, InfectionInstance instance, Map runtimeProperties) throws Throwable {
        this.infection.restartInfectionRuntime(rt, installation, index, instance, runtimeProperties);
    }

    @Override
    public Thread startAutoSoftwareUpdate(InfectionInstallation installation, InfectionIndex index, InfectionInstance instance) throws Exception {
        boolean promptCheck = false;
        boolean promptDownload = false;
        boolean promptApply = false;
        File indexFile = installation.getIndexFile();
        File workingDir = instance.getWorkingDir();
        String[] args = new String[]{};
        HashMap props = new HashMap();
        InfectionRuntimeImpl runtime = new InfectionRuntimeImpl(this.infection, indexFile, installation, index, instance, workingDir, args, props);
        boolean unattended = true;
        Thread thread = this.infection.startAutoSoftwareUpdate(runtime, promptCheck, promptDownload, promptApply, unattended);
        return thread;
    }

    @Override
    public int executeCommand(Infection infection, InfectionInstaller installer, InfectionInstallation installation, InfectionIndex index, InfectionInstance instance, InputStream stdin, PrintStream stdout, PrintStream stderr, URL infectionJarURL, URL distributionJarURL, String[] cmdArgs, boolean openShell) throws Exception {
        InfectionCommandLineImpl cli = new InfectionCommandLineImpl(infection, installer, installation, index, instance, stdin, stdout, stderr, infectionJarURL, distributionJarURL);
        int cliExitCode = openShell ? cli.shell(cmdArgs) : cli.execute(cmdArgs);
        return cliExitCode;
    }
}

