/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection;

import com.spacekiller.infection.Artifact;
import com.spacekiller.infection.DistributionLicense;
import com.spacekiller.infection.InfectionSite;
import com.spacekiller.infection.JavaVM;
import com.spacekiller.infection.util.InfectionXmlUtil;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class InfectionIndex {
    private InfectionSite site;
    private String path;
    private List sites = new ArrayList();
    private List artifacts = new ArrayList();
    private List instances = new ArrayList();
    private List jvms = new ArrayList();
    private List licenses = new ArrayList();

    protected InfectionIndex() {
    }

    public InfectionIndex(InfectionSite site) {
        this();
        this.site = site;
        this.path = site.getURL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InfectionIndex(File configFile) throws Exception {
        this();
        String url = configFile.toURI().toURL().toString();
        this.site = new InfectionSite(url);
        this.path = url;
        if (configFile.exists()) {
            FileInputStream fin = new FileInputStream(configFile);
            try {
                InfectionXmlUtil xmlUtil = new InfectionXmlUtil(this);
                xmlUtil.loadIndex(fin);
            }
            finally {
                fin.close();
            }
        }
    }

    public InfectionSite getSite() {
        return this.site;
    }

    public String getPath() {
        return this.path;
    }

    public synchronized int getSiteCount() {
        return this.sites.size();
    }

    public synchronized InfectionSite getSiteAt(int i) {
        return (InfectionSite)this.sites.get(i);
    }

    public synchronized void addSite(InfectionSite site) {
        if (site == null) {
            return;
        }
        String name = site.getName();
        if (name == null) {
            return;
        }
        Iterator i = this.sites.iterator();
        while (i.hasNext()) {
            InfectionSite is = (InfectionSite)i.next();
            if (!name.equals(is.getName())) continue;
            i.remove();
        }
        this.sites.add(site);
    }

    public synchronized void removeSite(InfectionSite site) {
        this.sites.remove(site);
    }

    public synchronized int getArtifactCount() {
        return this.artifacts.size();
    }

    public synchronized Artifact getArtifactAt(int i) {
        return (Artifact)this.artifacts.get(i);
    }

    public synchronized Artifact getArtifact(String name, String version) {
        if (name == null) {
            return null;
        }
        if (version == null) {
            return null;
        }
        int num = this.artifacts.size();
        for (int c = 0; c < num; ++c) {
            Artifact art = (Artifact)this.artifacts.get(c);
            String n = art.getName();
            String v = art.getVersion();
            if (n == null || v == null || !n.equals(name) || !v.equals(version)) continue;
            return art;
        }
        return null;
    }

    public synchronized void addArtifact(Artifact a) {
        if (a != null) {
            this.artifacts.add(a);
        }
    }

    public synchronized void removeArtifact(Artifact a) {
        this.artifacts.remove(a);
    }

    public synchronized int getInstanceCount() {
        return this.instances.size();
    }

    public synchronized String getInstancePathAt(int instanceIndex) {
        return (String)this.instances.get(instanceIndex);
    }

    public synchronized void addInstancePath(String path) {
        if (path != null && !this.instances.contains(path)) {
            this.instances.add(path);
        }
    }

    public synchronized void removeInstancePath(String path) {
        this.instances.remove(path);
    }

    public synchronized void removeInstancePathAt(int instanceIndex) {
        this.instances.remove(instanceIndex);
    }

    public synchronized int getInstanceIndex(String path) {
        int num = this.instances.size();
        for (int i = 0; i < num; ++i) {
            String s = (String)this.instances.get(i);
            if (!s.equals(path)) continue;
            return i;
        }
        return -1;
    }

    public synchronized int getJavaVMCount() {
        return this.jvms.size();
    }

    public synchronized JavaVM getJavaVMAt(int index) {
        return (JavaVM)this.jvms.get(index);
    }

    public synchronized void addJavaVM(JavaVM jvm) {
        if (jvm != null && !this.jvms.contains(jvm)) {
            this.jvms.add(jvm);
        }
    }

    public synchronized void removeJavaVM(JavaVM jvm) {
        this.jvms.remove(jvm);
    }

    public synchronized int getLicenseCount() {
        return this.licenses.size();
    }

    public synchronized DistributionLicense getLicenseAt(int index) {
        return (DistributionLicense)this.licenses.get(index);
    }

    public synchronized void addLicense(DistributionLicense lic) {
        this.licenses.add(lic);
    }

    public synchronized void removeLicense(DistributionLicense lic) {
        this.licenses.remove(lic);
    }
}

