/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection;

import com.spacekiller.infection.Artifact;
import com.spacekiller.infection.ArtifactDependency;
import com.spacekiller.infection.Infection;
import com.spacekiller.infection.InfectionIndex;
import com.spacekiller.infection.InfectionInstallation;
import com.spacekiller.infection.InfectionInstance;
import com.spacekiller.infection.InfectionSite;
import com.spacekiller.infection.InfectionUtil;
import com.spacekiller.infection.JavaProcess;
import com.spacekiller.infection.JavaVM;
import com.spacekiller.infection.JavaVMTester;
import com.spacekiller.infection.install.InstallerTask;
import com.spacekiller.infection.install.InstallerTaskListener;
import com.spacekiller.infection.install.InstallerTaskManager;
import com.spacekiller.infection.util.FileEntry;
import com.spacekiller.infection.util.InfectionXmlUtil;
import com.spacekiller.infection.util.ZipOutStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.StreamCorruptedException;
import java.net.URL;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.swing.DefaultListModel;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;

public class InfectionInstaller {
    static final Logger logger = Logger.getLogger(InfectionInstaller.class.getName());
    private static final int UNIX_MODE_NA = -1;
    private static final int UNIX_MODE_755 = 493;
    private static JavaVM defaultJavaVM;
    private File installationDirectory;
    private boolean recursiveSites;
    private List defaultSites;
    private int maxConcurrentDownloads = 5;
    private DefaultListModel downloadElements;

    public InfectionInstaller() {
        this.setRecursiveSites(true);
        this.defaultSites = new ArrayList();
        this.downloadElements = new DefaultListModel();
    }

    public ArtifactDependency[] getDistributionArtifactDependencies(String distributionName) {
        ArtifactDependency distDep = new ArtifactDependency(distributionName, null);
        ArtifactDependency[] deps = new ArtifactDependency[]{distDep};
        return deps;
    }

    public boolean isRecursiveSites() {
        return this.recursiveSites;
    }

    public void setRecursiveSites(boolean recursiveSites) {
        this.recursiveSites = recursiveSites;
    }

    public void addDefaultSite(InfectionSite site) {
        if (site != null) {
            this.defaultSites.add(site);
        }
    }

    public void removeDefaultSite(InfectionSite site) {
        this.defaultSites.remove(site);
    }

    public int getDefaultSiteCount() {
        return this.defaultSites.size();
    }

    public InfectionSite getDefaultSiteAt(int i) {
        return (InfectionSite)this.defaultSites.get(i);
    }

    public ListModel getDownloadJobListModel() {
        return this.downloadElements;
    }

    protected void handleException(Throwable e) {
        logger.log(Level.SEVERE, e.getMessage(), e);
    }

    public File getInstallationDirectory() {
        return this.installationDirectory;
    }

    public void setInstallationDirectory(File installationDirectory) {
        this.installationDirectory = installationDirectory;
    }

    public void downloadArtifacts(final InstallerTask[] tasks, InstallerTaskListener listener) throws Exception {
        InstallerTaskManager manager = new InstallerTaskManager(this.maxConcurrentDownloads);
        manager.setListener(listener);
        int num = tasks.length;
        for (int c = 0; c < num; ++c) {
            InstallerTask el = tasks[c];
            if (el == null) continue;
            manager.addTask(el);
        }
        Runnable run = new Runnable(){

            @Override
            public void run() {
                InfectionInstaller.this.downloadElements.clear();
                for (InstallerTask el : tasks) {
                    if (el == null) continue;
                    InfectionInstaller.this.downloadElements.addElement(el);
                }
            }
        };
        SwingUtilities.invokeLater(run);
        manager.run();
    }

    public int getMaxConcurrentDownloads() {
        return this.maxConcurrentDownloads;
    }

    public void setMaxConcurrentDownloads(int maxConcurrentDownloads) {
        this.maxConcurrentDownloads = maxConcurrentDownloads;
    }

    public void initInstallationDirectory(InfectionInstallation installation) throws Exception {
        int i;
        int num;
        File indexDir = installation.getIndexDirectory();
        if (!indexDir.exists() && !indexDir.mkdirs()) {
            throw new Exception("Cannot create installation directory: " + indexDir);
        }
        int numActiveSites = 0;
        InfectionIndex index = installation.getIndex();
        if (index != null) {
            num = index.getSiteCount();
            for (i = 0; i < num; ++i) {
                InfectionSite site = index.getSiteAt(i);
                if (site == null || !site.isActive()) continue;
                ++numActiveSites;
            }
        }
        if (numActiveSites < 1) {
            num = this.getDefaultSiteCount();
            for (i = 0; i < num; ++i) {
                index.addSite(this.getDefaultSiteAt(i));
            }
            this.saveIndex(installation, index);
        }
    }

    protected File resolveInfectionArtifactFile(InfectionInstallation installation, InfectionIndex index, InfectionInstance instance) throws Exception {
        String artifactName = "mminfection";
        Artifact artifact = this.resolveArtifact(installation, index, instance, artifactName);
        return this.resolveArtifactFile(installation, index, artifact);
    }

    protected File resolveDistributionArtifactFile(InfectionInstallation installation, InfectionIndex index, InfectionInstance instance) throws Exception {
        String artifactName = instance.getDistributionName();
        Artifact artifact = this.resolveArtifact(installation, index, instance, artifactName);
        return this.resolveArtifactFile(installation, index, artifact);
    }

    private Artifact resolveArtifact(InfectionInstallation installation, InfectionIndex index, InfectionInstance instance, String artifactName) throws Exception {
        Artifact startupArtifact = null;
        int artCount = instance.getArtifactCount();
        for (int c = 0; c < artCount; ++c) {
            Artifact art = instance.getArtifactAt(c);
            if (!artifactName.equals(art.getName())) continue;
            startupArtifact = art;
        }
        if (startupArtifact == null) {
            throw new Exception("Artifact not found: " + artifactName);
        }
        Artifact artifact = index.getArtifact(startupArtifact.getName(), startupArtifact.getVersion());
        if (artifact == null) {
            throw new Exception("Artifact not found: " + startupArtifact);
        }
        return artifact;
    }

    private File resolveArtifactFile(InfectionInstallation installation, InfectionIndex index, Artifact artifact) throws Exception {
        String path = artifact.getPath();
        if (path == null) {
            throw new Exception("Artifact not found: " + artifact + ", path=" + path);
        }
        File artFile = new File(path);
        File baseDir = installation.getIndexDirectory();
        artFile = InfectionUtil.getAbsoluteFile(artFile, baseDir);
        return artFile;
    }

    public void initInstanceDirectory(InfectionInstallation installation, InfectionIndex index, InfectionInstance instance) throws Exception {
        try {
            File instanceDir;
            String distTitle;
            Infection infection = Infection.getInstance();
            String distArtifactName = instance.getDistributionName();
            logger.info("Distribution artifact name: " + distArtifactName);
            if (distArtifactName == null) {
                throw new Exception("Distribution artifact not specified: " + instance);
            }
            Artifact distArtifact = this.resolveArtifact(installation, index, instance, distArtifactName);
            String distName = distArtifact.getName();
            if (distName == null) {
                distName = "unknown";
            }
            if ((distTitle = distArtifact.getTitle()) == null) {
                distTitle = distName;
            }
            String mainArtifactName = "mminfection";
            Artifact mainArtifact = this.resolveArtifact(installation, index, instance, mainArtifactName);
            String mainJarFile = mainArtifact.getPath();
            String distJarFile = distArtifact.getPath();
            File indexDir = installation.getIndexDirectory();
            if (indexDir != null) {
                String indexDirPath = indexDir.getPath();
                mainJarFile = indexDirPath + "/" + mainJarFile;
                distJarFile = indexDirPath + "/" + distJarFile;
            }
            if ((instanceDir = instance.getInstanceFile().getParentFile()) != null) {
                File relMainJarFile = InfectionUtil.getRelativeFile(new File(mainJarFile), instanceDir);
                mainJarFile = relMainJarFile.getPath();
                File relDistJarFile = InfectionUtil.getRelativeFile(new File(distJarFile), instanceDir);
                distJarFile = relDistJarFile.getPath();
            }
            StringBuffer sbuf = new StringBuffer();
            String[] jvmArgsArray = this.getInstanceJvmArgs(instance);
            for (int c = 0; c < jvmArgsArray.length; ++c) {
                if (c > 0) {
                    sbuf.append(' ');
                }
                sbuf.append(jvmArgsArray[c]);
            }
            String jvmArgs = sbuf.toString();
            String mainArgs = "";
            JavaVM jvm = instance.getJavaVM();
            byte[] icoData = infection.getDistributionResourceData("ico");
            byte[] iconData = infection.getDistributionResourceData("icon");
            String configFilePath = "instance.ini";
            String startupShellFileName = "startup.sh";
            String startupBatchFileName = "startup.bat";
            String infectShellFileName = "infect.sh";
            String infectBatchFileName = "infect.bat";
            InfectionUtil.InstanceUpdate update = new InfectionUtil.InstanceUpdate();
            update.setInstanceDir(instanceDir);
            update.setJavaVM(jvm);
            update.setJvmArgs(jvmArgs);
            update.setMainArgs(mainArgs);
            update.setApplName(distName);
            update.setApplTitle(distTitle);
            update.setApplDescr(null);
            update.setIcoData(icoData);
            update.setIconData(iconData);
            update.setMainJarFile(mainJarFile);
            update.setDistJarFile(distJarFile);
            update.setConfigFilePath(configFilePath);
            update.setStartupBatchFileName(startupBatchFileName);
            update.setStartupShellFileName(startupShellFileName);
            update.setInfectBatchFileName(infectBatchFileName);
            update.setInfectShellFileName(infectShellFileName);
            InfectionUtil.getInstance().updateInstance(update);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void installJar(URL sourceURL, File destFile) throws Exception {
        try {
            URL url2;
            if (destFile.exists() && sourceURL.equals(url2 = destFile.toURI().toURL())) {
                return;
            }
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Installing: " + destFile + " from " + sourceURL);
            }
            InputStream in = sourceURL.openStream();
            try {
                int num;
                byte[] buf = new byte[65536];
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                while ((num = in.read(buf)) >= 0) {
                    bout.write(buf, 0, num);
                }
                buf = null;
                bout.flush();
                byte[] data = bout.toByteArray();
                bout.close();
                bout = null;
                FileOutputStream fout = new FileOutputStream(destFile);
                try {
                    fout.write(data, 0, data.length);
                }
                finally {
                    fout.close();
                }
            }
            catch (FileNotFoundException e) {
                logger.log(Level.FINE, e.getMessage(), e);
            }
            finally {
                in.close();
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Certificate[] getJarSignerCertificates(File file) throws Exception {
        boolean verify = true;
        JarFile jarFile = new JarFile(file, verify);
        HashSet<Certificate> signerCerts = new HashSet<Certificate>();
        byte[] buf = new byte[65536];
        Enumeration<JarEntry> en = jarFile.entries();
        if (en != null) {
            while (en.hasMoreElements()) {
                JarEntry entry = en.nextElement();
                InputStream in = jarFile.getInputStream(entry);
                try {
                    int n;
                    while ((n = in.read(buf)) >= 0) {
                    }
                }
                finally {
                    in.close();
                }
                Certificate[] certs = entry.getCertificates();
                if (certs == null || certs.length <= 0) continue;
                Certificate signer = certs[0];
                signerCerts.add(signer);
            }
        }
        Certificate[] rc = new Certificate[signerCerts.size()];
        rc = signerCerts.toArray(rc);
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSite(InfectionInstallation inst, InfectionIndex index, InfectionSite newSite) throws Exception {
        InfectionIndex infectionIndex = index;
        synchronized (infectionIndex) {
            index.addSite(newSite);
            this.saveIndex(inst, index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSite(InfectionInstallation inst, InfectionIndex index, InfectionSite site) throws Exception {
        InfectionIndex infectionIndex = index;
        synchronized (infectionIndex) {
            index.removeSite(site);
            this.saveIndex(inst, index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void installArtifact(InfectionInstallation inst, InfectionIndex index, Artifact fact, File tempFile) throws Exception {
        logger.info("" + this + ".installArtifact: " + fact);
        long installTime = System.currentTimeMillis();
        InfectionIndex infectionIndex = index;
        synchronized (infectionIndex) {
            String indexDirPath;
            String factId;
            String factFileName = factId = this.buildArtifactId(fact);
            String factPath = fact.getPath();
            if (factPath != null) {
                factFileName = factPath;
                int k = factFileName.lastIndexOf("/");
                if (k >= 0 && (factFileName = factFileName.substring(k + 1)).length() < 1) {
                    factFileName = factId;
                }
                if ((k = factFileName.lastIndexOf(File.separator)) >= 0 && (factFileName = factFileName.substring(k + File.separator.length())).length() < 1) {
                    factFileName = factId;
                }
            }
            int fileSize = (int)tempFile.length();
            int factLength = fact.getLength();
            if (factLength != -1 && fileSize != factLength) {
                throw new StreamCorruptedException("Invalid file length: " + fileSize + " != " + factLength);
            }
            byte[] buf = new byte[32768];
            CRC32 crc = new CRC32();
            FileInputStream fin = new FileInputStream(tempFile);
            try {
                int n;
                while ((n = fin.read(buf)) >= 0) {
                    crc.update(buf, 0, n);
                }
            }
            finally {
                fin.close();
            }
            int chksum = (int)crc.getValue();
            int factChecksum = fact.getChecksum();
            if (factChecksum != -1 && chksum != factChecksum) {
                throw new StreamCorruptedException("Invalid file checksum: " + chksum + " != " + factChecksum);
            }
            File indexDir = inst.getIndexDirectory();
            File targetDir = new File(indexDir, factId);
            File targetFile = new File(targetDir, factFileName);
            if (targetDir.exists()) {
                throw new Exception("Target directory already exists: " + targetDir);
            }
            this.installArtifact(fact, tempFile, targetFile, buf, chksum);
            String targetPath = targetFile.getPath();
            if (indexDir != null && targetPath.startsWith(indexDirPath = indexDir.getPath())) {
                if ((targetPath = targetPath.substring(indexDirPath.length())).startsWith(File.separator)) {
                    targetPath = targetPath.substring(File.separator.length());
                }
                if (targetPath.startsWith("/")) {
                    targetPath = targetPath.substring(1);
                }
            }
            Artifact reg = fact.cloneArtifact();
            reg.setName(fact.getName());
            reg.setVersion(fact.getVersion());
            reg.setTitle(fact.getTitle());
            reg.setPath(targetPath);
            reg.setLength(fileSize);
            reg.setTime(fact.getTime());
            reg.setChecksum(chksum);
            reg.setDeploy(fact.getDeploy());
            reg.setVendor(fact.getVendor());
            reg.setInstallTime(installTime);
            reg.setOsPrefix(fact.getOsPrefix());
            reg.setOsArch(fact.getOsArch());
            index.addArtifact(reg);
            this.saveIndex(inst, index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installArtifact(Artifact fact, File tempFile, File targetFile, byte[] buf, int chksum) throws Exception {
        String deployMethod = fact.getDeploy();
        File targetDir = targetFile.getParentFile();
        boolean targetDirExists = targetDir.exists();
        if (!targetDirExists && !targetDir.mkdirs()) {
            throw new Exception("Cannot create target directory: " + targetDir);
        }
        boolean success = false;
        try {
            this.copyArtifact(tempFile, targetFile, buf, chksum);
            if (deployMethod != null && "unzip".equals(deployMethod)) {
                this.unzipArtifact(targetFile, targetDir, buf);
            }
            success = true;
        }
        finally {
            if (!success && !targetDirExists) {
                this.removeDirRecursive(targetDir);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyArtifact(File tempFile, File targetFile, byte[] buf, int chksum) throws Exception {
        logger.info("Installing artifact: " + targetFile);
        FileInputStream fin = new FileInputStream(tempFile);
        FileOutputStream fout = new FileOutputStream(targetFile);
        boolean copyOk = false;
        int chksum2 = 0;
        try {
            int num;
            CRC32 crc = new CRC32();
            while ((num = fin.read(buf)) >= 0) {
                crc.update(buf, 0, num);
                fout.write(buf, 0, num);
            }
            chksum2 = (int)crc.getValue();
            copyOk = true;
            if (copyOk && chksum2 != chksum) {
                throw new StreamCorruptedException("Invalid checksum after copying file: " + targetFile);
            }
        }
        finally {
            fin.close();
            fout.close();
            if (copyOk) {
                if (tempFile.exists() && !tempFile.delete()) {
                    logger.warning("Warning: Could not delete corrupted file: " + tempFile);
                }
            } else if (targetFile.exists() && !targetFile.delete()) {
                logger.warning("Warning: Could not delete corrupted file: " + targetFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unzipArtifact(File zipFile, File targetDir, byte[] buf) throws Exception {
        logger.info("Extracting artifact: " + zipFile);
        logger.info("Artifact directory: " + targetDir);
        ZipFile zip = new ZipFile(zipFile);
        try {
            Enumeration<? extends ZipEntry> en = zip.entries();
            while (en.hasMoreElements()) {
                ZipEntry entry = en.nextElement();
                String fname = entry.getName();
                long time = entry.getTime();
                File f = new File(targetDir, fname);
                if (entry.isDirectory()) {
                    if (f.exists() || f.mkdirs()) continue;
                    throw new Exception("Cannot create artifact sub-directory: " + f);
                }
                InputStream zin = zip.getInputStream(entry);
                try {
                    logger.fine(" - extracting: " + f);
                    File dir = f.getParentFile();
                    if (!dir.exists() && !dir.mkdirs()) {
                        throw new Exception("Cannot create artifact sub-directory: " + dir);
                    }
                    FileOutputStream fout = new FileOutputStream(f);
                    try {
                        int num;
                        while ((num = zin.read(buf)) >= 0) {
                            fout.write(buf, 0, num);
                        }
                        fout.close();
                        fout = null;
                        f.setLastModified(time);
                    }
                    catch (Exception e) {
                        if (fout != null) {
                            fout.close();
                            fout = null;
                        }
                        f.delete();
                    }
                    finally {
                        if (fout == null) continue;
                        fout.close();
                        fout = null;
                    }
                }
                finally {
                    zin.close();
                }
            }
        }
        finally {
            zip.close();
        }
    }

    private void removeDirRecursive(File dir) throws Exception {
        if (!dir.exists()) {
            return;
        }
        if (!dir.isDirectory()) {
            return;
        }
        File[] files = dir.listFiles();
        for (int c = 0; c < files.length; ++c) {
            File f = files[c];
            if (f.isDirectory()) {
                this.removeDirRecursive(f);
                continue;
            }
            if (f.delete()) continue;
            throw new Exception("Unable to delete file: " + f);
        }
        if (!dir.delete()) {
            throw new Exception("Unable to delete directory: " + dir);
        }
    }

    public File resolveInstanceConfigFile(InfectionInstallation installation, String instancePath) {
        File file = new File(instancePath);
        File baseDir = installation.getIndexDirectory();
        File instanceFile = InfectionUtil.getAbsoluteFile(file, baseDir);
        return instanceFile;
    }

    public synchronized Artifact[] enumerateUnusedArtifacts(InfectionInstallation installation, InfectionIndex index) throws Exception {
        int num = index.getArtifactCount();
        ArrayList<Artifact> artifactList = new ArrayList<Artifact>();
        HashMap<String, Artifact> installedMap = new HashMap<String, Artifact>();
        for (int c = 0; c < num; ++c) {
            String ver;
            String name;
            Artifact fact = index.getArtifactAt(c);
            if (fact == null || (name = fact.getName()) == null || (ver = fact.getVersion()) == null) continue;
            artifactList.add(fact);
            String key = name + "$" + ver;
            installedMap.put(key, fact);
        }
        int installedCount = artifactList.size();
        logger.info("Number of installed artifacts: " + installedCount);
        HashMap<String, Artifact> usedMap = new HashMap<String, Artifact>();
        int numInstances = index.getInstanceCount();
        logger.fine("Number of instances: " + numInstances);
        for (int i = 0; i < numInstances; ++i) {
            String path = index.getInstancePathAt(i);
            try {
                File instanceFile = this.resolveInstanceConfigFile(installation, path);
                if (!instanceFile.exists()) {
                    logger.fine("Instance file not found: " + instanceFile);
                    continue;
                }
                InfectionInstance theInstance = new InfectionInstance(instanceFile);
                int n = theInstance.getArtifactCount();
                for (int j = 0; j < n; ++j) {
                    String key;
                    Artifact fact;
                    String ver;
                    String name;
                    Artifact art = theInstance.getArtifactAt(j);
                    if (art == null || (name = art.getName()) == null || (ver = art.getVersion()) == null || (fact = (Artifact)installedMap.get(key = name + "$" + ver)) == null) continue;
                    usedMap.put(key, fact);
                }
                continue;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        int usedCount = usedMap.size();
        logger.info("Number of used artifacts: " + usedCount);
        ArrayList<Artifact> unusedList = new ArrayList<Artifact>();
        for (Artifact a : artifactList) {
            String key;
            String ver;
            String name = a.getName();
            if (name == null || (ver = a.getVersion()) == null || usedMap.containsKey(key = name + "$" + ver)) continue;
            unusedList.add(a);
        }
        int unusedCount = unusedList.size();
        logger.info("Number of unused artifacts: " + unusedCount);
        return unusedList.toArray(new Artifact[unusedList.size()]);
    }

    public synchronized Artifact[] cleanupUnusedArtifacts(InfectionInstallation installation, InfectionIndex index) throws Exception {
        Artifact[] artifacts = this.enumerateUnusedArtifacts(installation, index);
        int num = artifacts.length;
        for (int i = 0; i < num; ++i) {
            Artifact a = artifacts[i];
            logger.info("Uninstalling artifact: " + a);
            try {
                boolean done = this.uninstallArtifact(installation, index, a);
                if (done) continue;
                logger.warning("Failed to uninstall artifact: " + a);
                continue;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to uninstall artifact: " + a, e);
            }
        }
        return artifacts;
    }

    public synchronized boolean uninstallArtifact(InfectionInstallation inst, InfectionIndex index, Artifact artifact) throws Exception {
        String factId;
        String legacyArtifactRelPathV2;
        String legacyArtifactRelPathV1;
        String name = artifact.getName();
        if (name == null) {
            return false;
        }
        String version = artifact.getVersion();
        if (version == null) {
            return false;
        }
        Artifact fact = index.getArtifact(name, version);
        if (fact == null) {
            return false;
        }
        File indexDir = inst.getIndexDirectory();
        String indexDirPath = indexDir.getAbsolutePath();
        File artifactsDir = indexDir;
        String artifactsPath = indexDirPath;
        String path = fact.getPath();
        File f = new File(path);
        if (f.isAbsolute()) {
            if (!path.startsWith(artifactsPath)) {
                return false;
            }
            path = path.substring(artifactsPath.length());
            path = this.trimFileSeparator(path);
        }
        String path2 = path;
        path2 = this.trimFileSeparator(path2);
        if ((path2 = path2.replace('\\', '/')).startsWith(legacyArtifactRelPathV1 = "../artifacts/")) {
            path2 = path2.substring(legacyArtifactRelPathV1.length());
            artifactsDir = new File(artifactsDir.getPath() + "/" + legacyArtifactRelPathV1);
        }
        if (path2.startsWith(legacyArtifactRelPathV2 = "../.infection/")) {
            path2 = path2.substring(legacyArtifactRelPathV2.length());
            artifactsDir = new File(artifactsDir.getPath() + "/" + legacyArtifactRelPathV2);
        }
        if (!path2.startsWith(factId = this.buildArtifactId(fact))) {
            logger.warning("DEBUG: invalid artifact id: '" + path2 + "', expected: '" + factId + "'");
            return false;
        }
        File dir = new File(artifactsDir, factId);
        logger.info(" -> Deleting directory: " + dir);
        if (dir.exists()) {
            if (!dir.isDirectory()) {
                return false;
            }
            this.removeDirRecursive(dir);
        }
        index.removeArtifact(fact);
        this.saveIndex(inst, index);
        File[] files = artifactsDir.listFiles();
        if (files != null && files.length == 0) {
            logger.info(" -> Deleting directory: " + artifactsDir);
            if (artifactsDir.delete()) {
                logger.warning("Removed empty artifacts directory: " + artifactsDir);
            } else {
                logger.warning("Failed to remove empty artifacts directory: " + artifactsDir);
            }
        }
        return true;
    }

    protected String buildArtifactId(Artifact fact) {
        String factName = fact.getName();
        String factVersion = fact.getVersion();
        String factId = "" + factName.trim();
        if (factVersion != null) {
            factId = factId + "-" + factVersion.trim();
        }
        return factId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveIndex(InfectionInstallation inst, InfectionIndex index) throws Exception {
        File indexFile = inst.getIndexFile();
        InfectionUtil util = InfectionUtil.getInstance();
        File dstFile = indexFile;
        File tmpFile = new File(dstFile.getPath() + ".tmp");
        InfectionXmlUtil xmlUtil = new InfectionXmlUtil(index);
        xmlUtil.saveIndex(tmpFile);
        try {
            util.backupAndReplaceFile(tmpFile, dstFile);
        }
        finally {
            boolean failOnError = false;
            util.deleteFile(tmpFile, failOnError);
        }
    }

    private String trimFileSeparator(String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.startsWith(File.separator)) {
            path = path.substring(File.separator.length());
        }
        if (path.endsWith(File.separator)) {
            path = path.substring(0, path.length() - File.separator.length());
        }
        return path;
    }

    public void registerInstance(InfectionInstallation installation, InfectionIndex index, String instancePath) throws Exception {
        if (index.getInstanceIndex(instancePath) >= 0) {
            return;
        }
        index.addInstancePath(instancePath);
        this.saveIndex(installation, index);
    }

    public void registerJavaVM(InfectionInstallation installation, InfectionIndex index, JavaVM jvm) throws Exception {
        index.addJavaVM(jvm);
        this.saveIndex(installation, index);
    }

    public JavaVM testJavaVM(InfectionInstallation installation, InfectionIndex index, InfectionInstance instance, File executable, String[] jvmOptions) throws Exception {
        logger.info("Testing java executable: " + executable);
        LinkedList<String> argumentList = new LinkedList<String>();
        if (jvmOptions != null) {
            for (int i = 0; i < jvmOptions.length; ++i) {
                argumentList.add(jvmOptions[i]);
            }
        }
        logger.info("Arguments: " + argumentList);
        String[] arguments = argumentList.toArray(new String[argumentList.size()]);
        String execPath = executable.getPath();
        JavaVMTester tester = new JavaVMTester();
        JavaVM jvm = tester.testJavaVM(execPath, arguments);
        File indexDir = installation.getIndexDirectory();
        String relExecPath = this.relativizeExecPath(execPath, indexDir);
        if (!relExecPath.equals(execPath)) {
            jvm.setExecutable(relExecPath);
        }
        return jvm;
    }

    protected String relativizeExecPath(String execPath, File indexDir) {
        execPath = Infection.getSlashPath(execPath);
        if (indexDir == null) {
            return execPath;
        }
        File installDir = indexDir.getParentFile();
        if (installDir == null) {
            return execPath;
        }
        String installDirPath = installDir.getAbsolutePath();
        if (!execPath.startsWith(installDirPath + "/")) {
            return execPath;
        }
        File execFile = new File(execPath);
        File relativeFile = InfectionUtil.getRelativeFile(execFile, indexDir);
        String slashExecPath = Infection.getSlashPath(relativeFile.getPath());
        return slashExecPath;
    }

    public JavaVM registerJavaVM(InfectionInstallation installation, InfectionIndex index, InfectionInstance instance, File executable, String[] jvmOptions) throws Exception {
        JavaVM jvm = this.testJavaVM(installation, index, instance, executable, jvmOptions);
        if (jvm == null) {
            return null;
        }
        this.registerJavaVM(installation, index, jvm);
        return jvm;
    }

    public JavaVM registerCurrentJavaVM(InfectionInstallation installation, InfectionIndex index, InfectionInstance instance, String[] jvmOptions) throws Exception {
        String relExecPath;
        if (index == null) {
            return null;
        }
        String javaHome = System.getProperty("java.home");
        File executable = InfectionUtil.getInstance().resolveJavaExecutable(javaHome);
        if (executable == null) {
            return null;
        }
        String execPath = executable.getPath();
        File indexDir = installation.getIndexDirectory();
        execPath = relExecPath = this.relativizeExecPath(execPath, indexDir);
        int num = index.getJavaVMCount();
        for (int i = 0; i < num; ++i) {
            JavaVM jvm = index.getJavaVMAt(i);
            if (!execPath.equals(jvm.getExecutable())) continue;
            return jvm;
        }
        JavaVM jvm = this.registerJavaVM(installation, index, instance, executable, jvmOptions);
        return jvm;
    }

    public JavaVM registerDefaultJavaVM(InfectionInstallation installation, InfectionIndex index, InfectionInstance instance, String[] jvmOptions) throws Exception {
        if (index == null) {
            return null;
        }
        String javaHome = System.getProperty("java.home");
        File javaHomeDir = new File(javaHome).getAbsoluteFile();
        String javaHomePath = javaHomeDir.getPath();
        String envPath = null;
        try {
            envPath = System.getenv("PATH");
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("System Path: " + envPath);
        }
        if (envPath == null) {
            return null;
        }
        StringTokenizer tok = new StringTokenizer(envPath, File.pathSeparator, false);
        while (tok.hasMoreTokens()) {
            File executable;
            File dir;
            File abs;
            String absPath;
            String s = tok.nextToken();
            if (s.length() < 1 || (absPath = (abs = (dir = new File(s)).getAbsoluteFile()).getPath()).startsWith(javaHomePath) || (executable = InfectionUtil.getInstance().resolveJavaExecutable(dir)) == null) continue;
            String execPath = executable.getPath();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Java executable: " + execPath);
            }
            execPath = Infection.getSlashPath(execPath);
            int num = index.getJavaVMCount();
            for (int i = 0; i < num; ++i) {
                JavaVM jvm = index.getJavaVMAt(i);
                if (jvm == null || !execPath.equals(jvm.getExecutable())) continue;
                if (defaultJavaVM == jvm) {
                    return jvm;
                }
                index.removeJavaVM(jvm);
                int newCount = index.getJavaVMCount();
                if (newCount >= num) continue;
                num = newCount;
                --i;
            }
            JavaVM jvm = this.registerJavaVM(installation, index, instance, executable, jvmOptions);
            if (jvm == null) continue;
            defaultJavaVM = jvm;
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Default java executable: " + execPath);
            }
            return jvm;
        }
        return null;
    }

    private String[] getInstanceJvmArgs(InfectionInstance instance) {
        ArrayList<String> options = new ArrayList<String>();
        int num = instance.getJavaOptionCount();
        for (int i = 0; i < num; ++i) {
            String option = instance.getJavaOptionAt(i);
            if (option == null || option.length() <= 0) continue;
            options.add(option);
        }
        return options.toArray(new String[options.size()]);
    }

    private String[] getInstanceMainArgs(InfectionInstance instance) {
        return new String[0];
    }

    public JavaProcess buildJavaProcess(InfectionInstallation installation, InfectionIndex index, InfectionInstance instance) throws Exception {
        File distributionArtifactFile;
        File infectionArtifactFile;
        boolean fine = logger.isLoggable(Level.FINE);
        JavaVM jvm = instance.getJavaVM();
        if (fine) {
            logger.fine("JavaVM: " + jvm);
        }
        if (jvm == null) {
            throw new Exception("No Java Runtime (JVM) specified.");
        }
        if (fine) {
            logger.fine("Executable: " + jvm.getExecutable());
        }
        File directory = instance.getWorkingDir();
        if (fine) {
            logger.fine("Directory: " + directory);
        }
        if (!(infectionArtifactFile = this.resolveInfectionArtifactFile(installation, index, instance)).exists() || !infectionArtifactFile.isFile()) {
            throw new FileNotFoundException(infectionArtifactFile.getPath());
        }
        File mainJarFile = infectionArtifactFile;
        if (fine) {
            logger.fine("Main Jar-File: " + mainJarFile);
        }
        if (!(distributionArtifactFile = this.resolveDistributionArtifactFile(installation, index, instance)).exists() || !distributionArtifactFile.isFile()) {
            throw new FileNotFoundException(distributionArtifactFile.getPath());
        }
        File distJarFile = InfectionUtil.getRelativeFile(distributionArtifactFile, directory);
        if (fine) {
            logger.fine("Dist Jar-File: " + distJarFile);
        }
        String[] jvmArgs = this.getInstanceJvmArgs(instance);
        if (distJarFile != null) {
            int num = jvmArgs == null ? 0 : jvmArgs.length;
            String[] arr = new String[num + 1];
            if (num > 0) {
                System.arraycopy(jvmArgs, 0, arr, 0, num);
            }
            arr[num] = "-Dinfection.dist=" + distJarFile.getPath();
            jvmArgs = arr;
        }
        String[] mainArgs = this.getInstanceMainArgs(instance);
        JavaProcess process = new JavaProcess();
        process.setJavaVM(jvm);
        process.setJvmArgs(jvmArgs);
        process.setDirectory(directory);
        process.setJarFile(mainJarFile);
        process.setMainArgs(mainArgs);
        return process;
    }

    public void verifyArtifact(InfectionInstallation installation, InfectionIndex index, Artifact artifact) throws Exception {
        String version;
        String name = artifact.getName();
        Artifact installedArtifact = index.getArtifact(name, version = artifact.getVersion());
        if (installedArtifact == null) {
            throw new Exception("Artifact is not installed: name=" + name + ", version=" + version);
        }
        String path = installedArtifact.getPath();
        if (path == null) {
            throw new Exception("Invalid artifact path: " + path);
        }
        File artFile = new File(path);
        File baseDir = installation.getIndexDirectory();
        if (!(artFile = InfectionUtil.getAbsoluteFile(artFile, baseDir)).exists()) {
            throw new Exception("Artifact file not found: " + artFile.getPath());
        }
    }

    public void saveInstance(InfectionInstallation installation, InfectionIndex index, InfectionInstance instance) throws Exception {
        File instanceDir;
        File instanceFile = instance.getInstanceFile();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Save instance: " + instanceFile);
        }
        if (!(instanceDir = instanceFile.getParentFile()).exists()) {
            instanceDir.mkdirs();
        }
        File indexFile = installation.getIndexFile();
        File relativeIndexFile = InfectionUtil.getRelativeFile(indexFile, instanceDir);
        String relativeIndexPath = relativeIndexFile.getPath();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Relative index path: " + relativeIndexPath);
        }
        instance.setIndexPath(relativeIndexPath);
        this.initInstanceDirectory(installation, index, instance);
        instance.saveInstanceConfig();
        File baseDir = installation.getIndexDirectory();
        File relativeInstanceFile = InfectionUtil.getRelativeFile(instanceFile, baseDir);
        String instancePath = relativeInstanceFile.getPath();
        instancePath = Infection.getSlashPath(instancePath);
        this.registerInstance(installation, index, instancePath);
    }

    public void deleteDirectory(File dir) throws IOException {
        if (!dir.exists()) {
            return;
        }
        if (!dir.isDirectory()) {
            throw new IOException("Not a directory: " + dir);
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Deleting directory: " + dir);
        }
        this.deleteDirectoryRecursive(dir);
    }

    protected void deleteDirectoryRecursive(File dir) throws IOException {
        File file;
        int i;
        File[] files = dir.listFiles();
        for (i = 0; i < files.length; ++i) {
            file = files[i];
            if (!file.isDirectory()) continue;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Deleting directory: " + dir);
            }
            this.deleteDirectoryRecursive(file);
        }
        for (i = 0; i < files.length; ++i) {
            file = files[i];
            if (!file.isFile()) continue;
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Deleting file: " + file);
            }
            if (file.delete()) continue;
            throw new IOException("Could not delete file: " + file);
        }
        if (!dir.delete()) {
            throw new IOException("Could not delete directory: " + dir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zipFilesNormal(FileEntry[] files, File destZipFile, byte[] buf) throws IOException {
        if (files == null) {
            throw new NullPointerException("files");
        }
        if (destZipFile == null) {
            throw new NullPointerException("destZipFile");
        }
        if (buf == null) {
            throw new NullPointerException("buf");
        }
        if (files.length < 1) {
            throw new IOException("No files specified");
        }
        logger.info("Creating zip file: " + destZipFile);
        boolean success = false;
        FileOutputStream fout = new FileOutputStream(destZipFile);
        try {
            ZipOutputStream zout = new ZipOutputStream(fout);
            for (int i = 0; i < files.length; ++i) {
                FileEntry fileEntry = files[i];
                String name = fileEntry.getName();
                logger.fine(" [add] " + name);
                InputStream fis = fileEntry.getInputStream();
                try {
                    int n;
                    ZipEntry zipEntry = new ZipEntry(name);
                    zout.putNextEntry(zipEntry);
                    while ((n = fis.read(buf)) >= 0) {
                        zout.write(buf, 0, n);
                    }
                    zout.closeEntry();
                    continue;
                }
                finally {
                    fis.close();
                }
            }
            zout.finish();
            zout.flush();
            zout.close();
            success = true;
            logger.info("Zip file created successfully.");
        }
        finally {
            fout.close();
            if (!success) {
                destZipFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zipFilesBene(FileEntry[] files, File destZipFile, byte[] buf) throws IOException {
        if (files == null) {
            throw new NullPointerException("files");
        }
        if (destZipFile == null) {
            throw new NullPointerException("destZipFile");
        }
        if (buf == null) {
            throw new NullPointerException("buf");
        }
        if (files.length < 1) {
            throw new IOException("No files specified");
        }
        logger.info("Creating zip file: " + destZipFile);
        boolean success = false;
        FileOutputStream fout = new FileOutputStream(destZipFile);
        try {
            ZipOutStream zout = new ZipOutStream(fout);
            for (int i = 0; i < files.length; ++i) {
                FileEntry fileEntry = files[i];
                String name = fileEntry.getName();
                logger.fine(" [add] " + name);
                InputStream fis = fileEntry.getInputStream();
                try {
                    int n;
                    ZipOutStream.ZipEntry zipEntry = new ZipOutStream.ZipEntry(name);
                    int unixMode = fileEntry.getUnixMode();
                    if (unixMode != -1) {
                        zipEntry.setUnixMode(unixMode);
                    }
                    zout.putNextEntry(zipEntry);
                    while ((n = fis.read(buf)) >= 0) {
                        zout.write(buf, 0, n);
                    }
                    zout.closeEntry();
                    continue;
                }
                finally {
                    fis.close();
                }
            }
            zout.finish();
            zout.flush();
            zout.close();
            success = true;
            logger.info("Zip file created successfully.");
        }
        finally {
            fout.close();
            if (!success) {
                destZipFile.delete();
            }
        }
    }

    public void bundleArtifacts(File destZipFile, String zipSubDir, InfectionInstallation installation, InfectionIndex index, Artifact[] artifacts, boolean includeUpdateSites, String mainJarFile, String distJarFile, String appTitle) throws Exception {
        InfectionIndex zipInfectionIndex = new InfectionIndex();
        String installSubDirPrefix = zipSubDir;
        if (!installSubDirPrefix.endsWith("/") && installSubDirPrefix.length() > 0) {
            installSubDirPrefix = installSubDirPrefix + "/";
        }
        String infectionDirName = ".artifacts";
        ArrayList<FileEntry> entries = new ArrayList<FileEntry>();
        for (Artifact art : artifacts) {
            File file = this.resolveArtifactFile(installation, index, art);
            if (file == null) {
                throw new Exception("Artifact file not found: " + art);
            }
            String artName = art.getName();
            String artVersion = art.getVersion();
            String relPath = artName + "-" + artVersion + "/" + file.getName();
            String zipPath = installSubDirPrefix + infectionDirName + "/" + relPath;
            int unixMode = -1;
            entries.add(new FileEntry.ForFile(file, zipPath, unixMode));
            Artifact fact = new Artifact(art);
            fact.setPath(relPath);
            zipInfectionIndex.addArtifact(fact);
        }
        if (entries.isEmpty()) {
            throw new Exception("No artifacts available to bundle.");
        }
        String infectionXmlZipPath = installSubDirPrefix + infectionDirName + "/" + "index.xml";
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        InfectionXmlUtil xmlUtil = new InfectionXmlUtil(zipInfectionIndex);
        xmlUtil.saveIndex(baos);
        baos.flush();
        byte[] infectionXmlData = baos.toByteArray();
        baos.close();
        int unixMode = -1;
        ByteArrayFileEntry infectionXmlEntry = new ByteArrayFileEntry(infectionXmlData, infectionXmlZipPath, unixMode);
        entries.add(infectionXmlEntry);
        if (mainJarFile != null) {
            String javaExec;
            String javawExec = javaExec = "java";
            String javaOpts = "";
            String mainArgs = "";
            InfectionUtil infectionUtil = InfectionUtil.getInstance();
            boolean startNewProcess = false;
            boolean commandLineSupport = true;
            if (infectionDirName != null) {
                if (mainJarFile != null) {
                    mainJarFile = infectionDirName + "/" + mainJarFile;
                }
                if (distJarFile != null) {
                    distJarFile = infectionDirName + "/" + distJarFile;
                }
            }
            boolean doNotEditNote = false;
            String configIniFile = "config.ini";
            String configIniZipPath = installSubDirPrefix + configIniFile;
            String configString = infectionUtil.generateConfigIni(javaExec, javawExec, javaOpts, mainJarFile, distJarFile, appTitle, doNotEditNote);
            unixMode = -1;
            entries.add(this.createTextFileEntry(configString, configIniZipPath, unixMode));
            doNotEditNote = true;
            String startupShellZipPath = installSubDirPrefix + "install.sh";
            String startupShellString = infectionUtil.generateStartupShellScript(configIniFile, mainArgs, startNewProcess, commandLineSupport, appTitle, doNotEditNote);
            unixMode = 493;
            entries.add(this.createTextFileEntry(startupShellString, startupShellZipPath, unixMode));
            doNotEditNote = true;
            String startupBatchZipPath = installSubDirPrefix + "install.bat";
            String startupBatchString = infectionUtil.generateStartupBatchScript(configIniFile, mainArgs, startNewProcess, commandLineSupport, appTitle, doNotEditNote);
            unixMode = -1;
            entries.add(this.createTextFileEntry(startupBatchString, startupBatchZipPath, unixMode));
        }
        FileEntry[] files = entries.toArray(new FileEntry[entries.size()]);
        boolean useBeneZip = true;
        byte[] buf = new byte[65536];
        if (useBeneZip) {
            this.zipFilesBene(files, destZipFile, buf);
        } else {
            this.zipFilesNormal(files, destZipFile, buf);
        }
    }

    private FileEntry createTextFileEntry(String string, String name, int unixMode) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        ps.print(string);
        ps.flush();
        baos.flush();
        byte[] buf = baos.toByteArray();
        baos.close();
        return new ByteArrayFileEntry(buf, name, unixMode);
    }

    public Artifact resolveArtifactDependency(InfectionInstallation installation, InfectionIndex index, ArtifactDependency dep) {
        String depName = dep.getArtifact();
        String depVer = dep.getVersion();
        Artifact match = null;
        int num = index.getArtifactCount();
        for (int i = 0; i < num; ++i) {
            String matchVer;
            String name;
            Artifact art = index.getArtifactAt(i);
            if (art == null || !depName.equals(name = art.getName())) continue;
            String ver = art.getVersion();
            if (depVer != null) {
                int cmp;
                if (ver == null || (cmp = depVer.compareTo(ver)) > 0) continue;
                if (cmp == 0) {
                    match = art;
                    break;
                }
            }
            if (match != null && (ver == null || ver.compareTo(matchVer = match.getVersion()) <= 0)) continue;
            match = art;
        }
        return match;
    }

    public static class RenamedFileEntry
    implements FileEntry {
        private final String name;
        private final FileEntry entry;
        private final int unixMode;

        public RenamedFileEntry(FileEntry entry, String name, int unixMode) {
            this.entry = entry;
            this.name = name;
            this.unixMode = unixMode;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.entry.getInputStream();
        }

        @Override
        public long lastModified() {
            return this.entry.lastModified();
        }

        @Override
        public int getUnixMode() {
            return this.unixMode;
        }
    }

    public static class ByteArrayFileEntry
    implements FileEntry {
        private final String name;
        private final byte[] buf;
        private final int ofs;
        private final int len;
        private final int unixMode;

        public ByteArrayFileEntry(byte[] buf, String name, int unixMode) {
            this.buf = buf;
            this.ofs = 0;
            this.len = buf.length;
            this.name = name;
            this.unixMode = unixMode;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.buf, this.ofs, this.len);
        }

        @Override
        public long lastModified() {
            return 0L;
        }

        @Override
        public int getUnixMode() {
            return this.unixMode;
        }
    }
}

