/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection;

import com.spacekiller.infection.Artifact;
import com.spacekiller.infection.InfectionSystemProperty;
import com.spacekiller.infection.InfectionUtil;
import com.spacekiller.infection.JavaVM;
import com.spacekiller.infection.util.InstanceXmlUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.logging.Logger;

public class InfectionInstance {
    public static final String DEFAULT_INSTANCE_FILENAME = "instance.xml";
    public static final String TAGNAME_INSTANCE = "instance";
    public static final String TAGNAME_ARTIFACT = "artifact";
    public static final String TAGNAME_CLASSPATH = "classpath";
    public static final String TAGNAME_LIBPATH = "libpath";
    public static final String TAGNAME_PROPERTY = "property";
    public static final String TAGNAME_JVMARG = "jvmarg";
    private static final Logger logger = Logger.getLogger(InfectionInstance.class.getName());
    private static LoggingPropertyComparator loggingPropertyComparator = new LoggingPropertyComparator();
    private File instanceFile;
    private File workingDir;
    private File dataDir;
    private File logDir;
    private File configDir;
    private File tempDir;
    private String indexPath;
    private List artifacts = new ArrayList();
    private List classPath = new ArrayList();
    private List libraryPath = new ArrayList();
    private List properties = new ArrayList();
    private Properties loggingProperties = new Properties();
    private JavaVM javaVM;
    private String distributionName;
    private List javaOptions = new ArrayList();

    public InfectionInstance() {
        this.initDefaultLoggingProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InfectionInstance(File configFile) throws Exception {
        this();
        String handlers;
        File loggingPropFile;
        this.setInstanceFile(configFile);
        File workDir = null;
        if (configFile != null) {
            workDir = configFile.getParentFile();
        }
        if (workDir != null) {
            this.setWorkingDir(workDir);
        }
        File dataDir = null;
        if (workDir != null) {
            dataDir = new File(workDir, "data");
            this.setDataDir(dataDir);
        }
        File logDir = null;
        if (workDir != null) {
            logDir = new File(workDir, "log");
            this.setLogDir(logDir);
        }
        File configDir = null;
        if (workDir != null) {
            configDir = new File(workDir, "config");
            this.setConfigDir(configDir);
        }
        File tempDir = null;
        if (workDir != null) {
            tempDir = new File(workDir, "temp");
            this.setTempDir(tempDir);
        }
        if (configFile.exists()) {
            FileInputStream fin = new FileInputStream(configFile);
            try {
                InstanceXmlUtil xmlUtil = new InstanceXmlUtil(this);
                xmlUtil.loadInstance(fin);
            }
            finally {
                fin.close();
            }
        }
        if (configDir != null && (loggingPropFile = new File(configDir, "logging.properties")).exists()) {
            FileInputStream fin = new FileInputStream(loggingPropFile);
            try {
                this.readLoggingProperties(fin);
            }
            finally {
                fin.close();
            }
        }
        if ((handlers = this.loggingProperties.getProperty("handlers")) == null || handlers.equals("com.spacekiller.infection.InfectionLogHandler")) {
            this.initDefaultLoggingProperties();
        }
    }

    public InfectionInstance(InfectionInstance instance) {
        this();
        this.setConfigDir(instance.getConfigDir());
        this.setDataDir(instance.getDataDir());
        this.setIndexPath(instance.getIndexPath());
        this.setInstanceFile(instance.getInstanceFile());
        this.setJavaVM(instance.getJavaVM());
        this.setLogDir(instance.getLogDir());
        this.setTempDir(instance.getTempDir());
        this.setWorkingDir(instance.getWorkingDir());
        this.properties.addAll(instance.properties);
        this.loggingProperties.putAll((Map<?, ?>)instance.loggingProperties);
        this.artifacts.addAll(instance.artifacts);
        this.classPath.addAll(instance.classPath);
        this.libraryPath.addAll(instance.libraryPath);
    }

    protected void initDefaultLoggingProperties() {
        this.loggingProperties.put("handlers", "com.spacekiller.infection.log.Log2FileAsyncHandler");
        this.loggingProperties.put(".level", "INFO");
    }

    public File getInstanceFile() {
        return this.instanceFile;
    }

    public void setInstanceFile(File instanceFile) {
        this.instanceFile = instanceFile;
    }

    public int getArtifactCount() {
        return this.artifacts.size();
    }

    public Artifact getArtifactAt(int i) {
        return (Artifact)this.artifacts.get(i);
    }

    public void addArtifact(Artifact art) {
        if (art != null && !this.artifacts.contains(art)) {
            this.artifacts.add(art);
        }
    }

    public void removeArtifact(Artifact art) {
        this.artifacts.remove(art);
    }

    public void clearArtifacts() {
        this.artifacts.clear();
    }

    public int getClassPathCount() {
        return this.classPath.size();
    }

    public String getClassPathAt(int i) {
        return String.valueOf(this.classPath.get(i));
    }

    public void addClassPath(String path) {
        if (path != null && !this.classPath.contains(path)) {
            this.classPath.add(path);
        }
    }

    public void removeClassPath(String path) {
        this.classPath.remove(path);
    }

    public void clearClassPath() {
        this.classPath.clear();
    }

    public int getLibraryPathCount() {
        return this.libraryPath.size();
    }

    public String getLibraryPathAt(int i) {
        return String.valueOf(this.libraryPath.get(i));
    }

    public void addLibraryPath(String path) {
        if (path != null && !this.libraryPath.contains(path)) {
            this.libraryPath.add(path);
        }
    }

    public void removeLibraryPath(String path) {
        this.libraryPath.remove(path);
    }

    public void clearLibraryPath() {
        this.libraryPath.clear();
    }

    public int getPropertyCount() {
        return this.properties.size();
    }

    public InfectionSystemProperty getPropertyAt(int i) {
        return (InfectionSystemProperty)this.properties.get(i);
    }

    public String getPropertyKeyAt(int i) {
        InfectionSystemProperty prop = this.getPropertyAt(i);
        return prop == null ? null : prop.getKey();
    }

    public String getPropertyValueAt(int i) {
        InfectionSystemProperty prop = this.getPropertyAt(i);
        return prop == null ? null : prop.getValue();
    }

    public void addProperty(String key, String value) {
        this.addProperty(new InfectionSystemProperty(key, value));
    }

    public void addProperty(InfectionSystemProperty property) {
        this.insertProperty(property, this.properties.size());
    }

    public void insertProperty(InfectionSystemProperty property, int index) {
        this.properties.add(index, property);
    }

    public void removePropertyAt(int i) {
        this.properties.remove(i);
    }

    public void removeProperty(String key) {
        Iterator i = this.properties.iterator();
        while (i.hasNext()) {
            InfectionSystemProperty prop = (InfectionSystemProperty)i.next();
            if (!key.equals(prop.getKey())) continue;
            i.remove();
            return;
        }
    }

    public InfectionSystemProperty getProperty(String key) {
        for (InfectionSystemProperty prop : this.properties) {
            if (!key.equals(prop.getKey())) continue;
            return prop;
        }
        return null;
    }

    public void setProperty(String key, String value) {
        InfectionSystemProperty prop = this.getProperty(key);
        if (prop == null) {
            this.addProperty(key, value);
        } else {
            prop.setKey(key);
            prop.setValue(value);
        }
    }

    public int getJavaOptionCount() {
        return this.javaOptions.size();
    }

    public String getJavaOptionAt(int index) {
        return (String)this.javaOptions.get(index);
    }

    public void addJavaOption(String option) {
        this.javaOptions.add(option);
    }

    public void insertJavaOptionAt(String option, int index) {
        this.javaOptions.add(index, option);
    }

    public void removeJavaOptionAt(int index) {
        this.javaOptions.remove(index);
    }

    public void clearJavaOptions() {
        this.javaOptions.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveInstanceConfig() throws Exception {
        boolean failOnError;
        File tmpFile;
        File dstFile;
        InfectionUtil util;
        if (this.instanceFile != null) {
            util = InfectionUtil.getInstance();
            dstFile = this.instanceFile;
            tmpFile = new File(dstFile.getPath() + ".tmp");
            InstanceXmlUtil xmlUtil = new InstanceXmlUtil(this);
            xmlUtil.saveInstance(tmpFile);
            try {
                util.backupAndReplaceFile(tmpFile, dstFile);
            }
            finally {
                failOnError = false;
                util.deleteFile(tmpFile, failOnError);
            }
        }
        if (this.configDir != null) {
            util = InfectionUtil.getInstance();
            if (!this.configDir.exists() && !this.configDir.mkdirs()) {
                logger.fine("WARNING: Unable to create config directory: " + this.configDir);
            }
            dstFile = new File(this.configDir, "logging.properties");
            tmpFile = new File(dstFile.getPath() + ".tmp");
            FileOutputStream fout = new FileOutputStream(tmpFile);
            try {
                this.writeLoggingProperties(fout);
            }
            finally {
                fout.close();
            }
            try {
                util.backupAndReplaceFile(tmpFile, dstFile);
            }
            finally {
                failOnError = false;
                util.deleteFile(tmpFile, failOnError);
            }
        }
    }

    public Artifact findArtifact(Artifact fact) {
        String name = fact.getName();
        String ver = fact.getVersion();
        int n = this.getArtifactCount();
        for (int c = 0; c < n; ++c) {
            Artifact art = this.getArtifactAt(c);
            if (!name.equals(art.getName()) || ver != null && !ver.equals(art.getVersion())) continue;
            return art;
        }
        return null;
    }

    public long getLastModifiedMillis() {
        if (this.instanceFile == null) {
            return 0L;
        }
        if (!this.instanceFile.exists()) {
            return 0L;
        }
        return this.instanceFile.lastModified();
    }

    public File getWorkingDir() {
        return this.workingDir;
    }

    public void setWorkingDir(File workingDir) {
        this.workingDir = workingDir;
    }

    public String getIndexPath() {
        return this.indexPath;
    }

    public void setIndexPath(String indexPath) {
        this.indexPath = indexPath;
    }

    public File getLogDir() {
        return this.logDir;
    }

    public void setLogDir(File logDir) {
        this.logDir = logDir;
    }

    public File getConfigDir() {
        return this.configDir;
    }

    public void setConfigDir(File configDir) {
        this.configDir = configDir;
    }

    public File getTempDir() {
        return this.tempDir;
    }

    public void setTempDir(File tempDir) {
        this.tempDir = tempDir;
    }

    public File getDataDir() {
        return this.dataDir;
    }

    public void setDataDir(File dataDir) {
        this.dataDir = dataDir;
    }

    public Properties getLoggingProperties() {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.loggingProperties);
        return props;
    }

    public String getLoggingProperty(String key) {
        return this.loggingProperties.getProperty(key);
    }

    public void setLoggingProperty(String key, String value) {
        if (key == null) {
            return;
        }
        if (value == null) {
            this.loggingProperties.remove(key);
        } else {
            this.loggingProperties.setProperty(key, value);
        }
    }

    public void setLoggingProperties(Properties loggingProps) {
        this.loggingProperties.clear();
        if (loggingProps != null) {
            this.loggingProperties.putAll((Map<?, ?>)loggingProps);
        }
    }

    public String getLoggerLevel(String logger) {
        if (logger == null) {
            return null;
        }
        String key = logger + ".level";
        return this.loggingProperties.getProperty(key);
    }

    public void setLoggerLevel(String logger, String level) {
        if (logger == null) {
            return;
        }
        String key = logger + ".level";
        if (level == null) {
            this.loggingProperties.remove(key);
        } else {
            this.loggingProperties.put(key, level);
        }
    }

    public void clearLoggerLevels() {
        Iterator<Object> i = this.loggingProperties.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            if (!key.endsWith(".level")) continue;
            i.remove();
        }
    }

    public Iterator getLoggers() {
        ArrayList<String> temp = new ArrayList<String>();
        for (String string : this.loggingProperties.keySet()) {
            if (!string.endsWith(".level")) continue;
            String logger = string.substring(0, string.length() - ".level".length());
            temp.add(logger);
        }
        return temp.iterator();
    }

    private void readLoggingProperties(InputStream in) throws Exception {
        Properties props;
        this.loggingProperties = props = new Properties();
        props.load(in);
    }

    private void writeLoggingProperties(OutputStream out) throws Exception {
        TreeMap<Object, Object> sorted = new TreeMap<Object, Object>(loggingPropertyComparator);
        Properties props = this.loggingProperties;
        if (props != null) {
            sorted.putAll(props);
        }
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out));
        writer.write("#Logging configuration properties");
        writer.newLine();
        writer.write("#" + new Date().toString());
        writer.newLine();
        for (Map.Entry me : sorted.entrySet()) {
            String key = (String)me.getKey();
            String value = (String)me.getValue();
            writer.write(key);
            if (value != null) {
                writer.write(" = ");
                writer.write(value);
            }
            writer.newLine();
        }
        writer.flush();
    }

    public JavaVM getJavaVM() {
        return this.javaVM;
    }

    public void setJavaVM(JavaVM javaVM) {
        this.javaVM = javaVM;
    }

    public String getDistributionName() {
        return this.distributionName;
    }

    public void setDistributionName(String distributionName) {
        this.distributionName = distributionName;
    }

    private static class LoggingPropertyComparator
    implements Comparator {
        private LoggingPropertyComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            String key0 = (String)arg0;
            String key1 = (String)arg1;
            int x0 = key0.indexOf(46);
            int x1 = key1.indexOf(46);
            if (x0 < 0) {
                if (x1 >= 0) {
                    return -1;
                }
            } else if (x1 < 0) {
                return 1;
            }
            return key0.compareTo(key1);
        }
    }
}

