/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection;

import com.spacekiller.infection.InfectionIndex;
import java.io.IOException;
import java.net.URL;

public class InfectionSite {
    private InfectionSite parent;
    private String url;
    private String name;
    private String path;
    private boolean recursive;
    private boolean active = true;
    private InfectionIndex index;
    private Throwable error;

    public InfectionSite(String url) {
        this.setURL(url);
    }

    protected void setURL(String url) {
        this.url = url;
    }

    public String getURL() {
        return this.url;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public InfectionSite getParent() {
        return this.parent;
    }

    public void setParent(InfectionSite parent) {
        this.parent = parent;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public InfectionIndex getIndex() {
        return this.index;
    }

    public void setIndex(InfectionIndex index) {
        this.index = index;
    }

    public String toString() {
        return super.toString() + "[" + this.url + "]";
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public Throwable getError() {
        return this.error;
    }

    public void setError(Throwable error) {
        this.error = error;
    }

    public boolean isSiteEqual(InfectionSite site) throws IOException {
        if (site == null) {
            return false;
        }
        String urlA = this.getURL();
        String urlB = site.getURL();
        if (urlA == null || urlB == null) {
            return false;
        }
        return urlA.equals(urlB);
    }

    public boolean isSiteFromSameHost(InfectionSite site) throws IOException {
        if (site == null) {
            return false;
        }
        String urlA = this.getURL();
        String urlB = site.getURL();
        if (urlA == null || urlB == null) {
            return false;
        }
        int ia = urlA.indexOf(":");
        int ib = urlB.indexOf(":");
        if (ia < 0 || ib < 0) {
            return false;
        }
        URL uA = new URL(urlA);
        URL uB = new URL(urlB);
        String hostA = uA.getHost();
        String hostB = uB.getHost();
        return hostA.equals(hostB);
    }
}

