/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InfectionUtilWin32 {
    public static final String RC_PATH_DESKTOP = "DESKTOP=";
    public static final String RC_PATH_STARTMENU = "STARTMENU=";
    public static final String RC_PATH_PROGRAMS = "PROGRAMS=";
    private static final int FLAG_SHELL_ITEM_LIST = 1;
    private static final int FLAG_HAS_DESCRIPTION = 4;
    private static final int FLAG_HAS_RELATIVE_PATH = 8;
    private static final int FLAG_HAS_WORKING_DIR = 16;
    private static final int FLAG_HAS_CMD_ARGS = 32;
    private static final int FLAG_HAS_CUSTOM_ICON = 64;
    public static final int SW_HIDE = 0;
    public static final int SW_NORMAL = 1;
    public static final int SW_SHOWMINIMIZED = 2;
    public static final int SW_SHOWMAXIMIZED = 3;
    public static final int SW_SHOWMINNOACTIVE = 7;
    public static final int HOTKEY_CTRL_ALT_BASE = 1536;
    private static final Logger logger = Logger.getLogger(InfectionUtilWin32.class.getName());

    protected static Class getClass_SpecialFolder() throws Exception {
        return Class.forName("com.ms.wfc.app.SpecialFolder");
    }

    protected static Class getClass_SystemInformation() throws Exception {
        return Class.forName("com.ms.wfc.app.SystemInformation");
    }

    public static int getCtrlAltHotKey(char ch) {
        return 1536 + ch;
    }

    protected byte[] lnk_formatFileLocationInfo(String basePath, String path) throws Exception {
        ByteArrayOutputStream structOut = new ByteArrayOutputStream();
        int pAfter = 28;
        int flags = 1;
        byte[] localVolumeTable = this.lnk_formatLocalVolumeTable();
        byte[] basePathBytes = this.lnk_writeASCIZ(basePath);
        byte[] pathBytes = this.lnk_writeASCIZ(path);
        int oVolumeInfo = 28;
        int oBasePath = oVolumeInfo + localVolumeTable.length;
        int oNetwork = 0;
        int oPath = oBasePath + basePathBytes.length;
        structOut.write(this.lnk_writeDWord(pAfter));
        structOut.write(this.lnk_writeDWord(flags));
        structOut.write(this.lnk_writeDWord(oVolumeInfo));
        structOut.write(this.lnk_writeDWord(oBasePath));
        structOut.write(this.lnk_writeDWord(oNetwork));
        structOut.write(this.lnk_writeDWord(oPath));
        structOut.write(localVolumeTable);
        structOut.write(basePathBytes);
        structOut.write(pathBytes);
        structOut.flush();
        byte[] struct = structOut.toByteArray();
        return this.lnk_formatStruct(struct);
    }

    protected byte[] lnk_formatHeader(String basePath, String path, int showWndValue, int fileLength, int hotKey, String descr, String relativePath, String workingDir, String cmdArgs, String iconPath) throws Exception {
        boolean hasShellItems;
        int flags = 255;
        int fileAttr = 7;
        long time1 = 0L;
        long time2 = 0L;
        long time3 = 0L;
        int iconNumber = 0;
        int dummy1 = 0;
        int dummy2 = 0;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(this.lnk_writeDWord(76));
        out.write(new byte[]{1, 20, 2, 0, 0, 0, 0, 0, -64, 0, 0, 0, 0, 0, 0, 70});
        out.write(this.lnk_writeDWord(flags));
        out.write(this.lnk_writeDWord(fileAttr));
        out.write(this.lnk_writeQWord(time1));
        out.write(this.lnk_writeQWord(time2));
        out.write(this.lnk_writeQWord(time3));
        out.write(this.lnk_writeDWord(fileLength));
        out.write(this.lnk_writeDWord(iconNumber));
        out.write(this.lnk_writeDWord(showWndValue));
        out.write(this.lnk_writeDWord(hotKey));
        out.write(this.lnk_writeDWord(dummy1));
        out.write(this.lnk_writeDWord(dummy2));
        boolean bl = hasShellItems = (flags & 1) != 0;
        if (hasShellItems) {
            byte[] shell = this.lnk_formatItemIdList(basePath);
            out.write(this.lnk_writeUShort(shell.length));
            out.write(shell);
        }
        out.write(this.lnk_formatFileLocationInfo(basePath, path));
        if ((flags & 4) != 0) {
            out.write(this.lnk_writeASCII(descr));
        }
        if ((flags & 8) != 0) {
            out.write(this.lnk_writeASCII(relativePath));
        }
        if ((flags & 0x10) != 0) {
            out.write(this.lnk_writeASCII(workingDir));
        }
        if ((flags & 0x20) != 0) {
            out.write(this.lnk_writeASCII(cmdArgs));
        }
        if ((flags & 0x40) != 0) {
            String s = iconPath;
            if (s == null) {
                s = "";
            }
            out.write(this.lnk_writeASCII(s));
        }
        out.flush();
        return out.toByteArray();
    }

    protected byte[] lnk_formatItemIdList(String path) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        File file = new File(path);
        Vector<File> dirTree = new Vector<File>();
        File volume = null;
        int pos = 0;
        while (pos < path.length()) {
            int i = path.indexOf(File.separator, pos);
            String str = "";
            str = i < 0 ? path : path.substring(0, i);
            if (volume == null) {
                volume = new File(str);
            } else {
                if (i < 0) break;
                dirTree.addElement(new File(str));
            }
            if (i < 0) break;
            pos = i + 1;
        }
        byte[] item = new byte[]{31, 80, -32, 79, -48, 32, -22, 58, 105, 16, -94, -40, 8, 0, 43, 48, 48, -99};
        out.write(this.lnk_writeUShort(item.length + 2));
        out.write(item);
        if (volume != null) {
            byte volChar = (byte)volume.getPath().toUpperCase().charAt(0);
            byte[] item2 = new byte[]{35, volChar, 58, 92, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -83, 35};
            out.write(this.lnk_writeUShort(item2.length + 2));
            out.write(item2);
        }
        for (int c = 0; c < dirTree.size(); ++c) {
            byte[] item2;
            File dir = (File)dirTree.elementAt(c);
            byte[] item1 = new byte[]{49, 0, 0, 0, 0, 0, 77, 43, -76, 76, 16, 0};
            String dirName = dir.getName();
            byte[] item3 = item2 = this.lnk_writeASCIZ(dirName);
            byte[] item4 = new byte[item1.length + item2.length + item3.length];
            System.arraycopy(item1, 0, item4, 0, item1.length);
            System.arraycopy(item2, 0, item4, item1.length, item2.length);
            System.arraycopy(item3, 0, item4, item1.length + item2.length, item3.length);
            out.write(this.lnk_writeUShort(item4.length + 2));
            out.write(item4);
        }
        byte[] item1 = new byte[]{50, 0, 0, 96, 0, 0, -127, 37, -78, 116, 32, 0};
        String fileName = file.getName();
        byte[] item2 = this.lnk_writeASCIZ(fileName);
        byte[] item3 = new byte[]{0};
        byte[] item5 = new byte[item1.length + item2.length + item3.length];
        System.arraycopy(item1, 0, item5, 0, item1.length);
        System.arraycopy(item2, 0, item5, item1.length, item2.length);
        System.arraycopy(item3, 0, item5, item1.length + item2.length, item3.length);
        out.write(this.lnk_writeUShort(item5.length + 2));
        out.write(item5);
        out.write(this.lnk_writeUShort(0));
        out.flush();
        return out.toByteArray();
    }

    protected byte[] lnk_formatLocalVolumeTable() throws Exception {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        int volumeType = 3;
        int volumeSerial = -1334492760;
        int oVolumeLabel = 16;
        String volName = "W2K";
        stream.write(this.lnk_writeDWord(volumeType));
        stream.write(this.lnk_writeDWord(volumeSerial));
        stream.write(this.lnk_writeDWord(oVolumeLabel));
        stream.write(this.lnk_writeASCIZ(volName));
        stream.flush();
        return this.lnk_formatStruct(stream.toByteArray());
    }

    protected byte[] lnk_formatStruct(byte[] struct) throws Exception {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        int structLen = struct.length + 4;
        stream.write(this.lnk_writeDWord(structLen));
        stream.write(struct);
        stream.flush();
        return stream.toByteArray();
    }

    protected ByteArrayInputStream lnk_getByteInput(byte[] struct, int ofs) {
        return new ByteArrayInputStream(struct, ofs, struct.length - ofs);
    }

    protected void lnk_parseFileLocationInfo(InputStream in) throws Exception {
        byte[] struct = this.lnk_parseStruct(in);
        this.logBytes("FileLocationInfo", struct);
        ByteArrayInputStream structIn = this.lnk_getByteInput(struct, 4);
        int pAfter = this.lnk_readDWord(structIn);
        int flags = this.lnk_readDWord(structIn);
        int oVolumeInfo = this.lnk_readDWord(structIn);
        int oBasePath = this.lnk_readDWord(structIn);
        int oNetwork = this.lnk_readDWord(structIn);
        int oPath = this.lnk_readDWord(structIn);
        logger.finer(" - After-Pointer: " + pAfter);
        logger.finer(" - Flags: " + flags);
        if (oVolumeInfo > 0) {
            this.lnk_parseLocalVolumeTable(this.lnk_getByteInput(struct, oVolumeInfo));
        }
        if (oNetwork > 0) {
            this.lnk_parseNetworkVolumeTable(this.lnk_getByteInput(struct, oNetwork));
        }
        if (oBasePath > 0) {
            String basePath = this.lnk_readASCIZ(this.lnk_getByteInput(struct, oBasePath));
            logger.finer("BASE PATH=" + basePath);
        }
        if (oPath > 0) {
            String path = this.lnk_readASCIZ(this.lnk_getByteInput(struct, oPath));
            logger.finer("PATH=" + path);
        }
    }

    protected void lnk_parseHeader(InputStream in) throws Exception {
        boolean hasShellItems;
        int fileId = this.lnk_readDWord(in);
        logger.finer("FileId: " + fileId);
        byte[] GUID = new byte[16];
        in.read(GUID);
        this.logBytes("GUID", GUID);
        int flags = this.lnk_readDWord(in);
        int fileAttr = this.lnk_readDWord(in);
        long time1 = this.lnk_readQWord(in);
        long time2 = this.lnk_readQWord(in);
        long time3 = this.lnk_readQWord(in);
        int fileLength = this.lnk_readDWord(in);
        int iconNumber = this.lnk_readDWord(in);
        int showWndValue = this.lnk_readDWord(in);
        int hotKey = this.lnk_readDWord(in);
        int dummy1 = this.lnk_readDWord(in);
        int dummy2 = this.lnk_readDWord(in);
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Flags: " + flags);
            logger.finer("File-Length: " + fileLength);
            logger.finer("File-Attr: " + fileAttr);
            logger.finer("Icon: " + iconNumber);
            logger.finer("Window: " + showWndValue);
            logger.finer("Hot-Key: " + hotKey);
            logger.finer("Dummy: " + dummy1 + ", " + dummy2);
            logger.finer("Time: " + time1 + ", " + time2 + ", " + time3);
        }
        boolean bl = hasShellItems = (flags & 1) != 0;
        if (hasShellItems) {
            logger.finer("Shell-Items: " + hasShellItems);
            int listLen = this.lnk_readUShort(in);
            logger.finer("Shell-Items length: " + listLen);
            byte[] shell = new byte[listLen];
            in.read(shell);
            this.lnk_parseItemIdList(new ByteArrayInputStream(shell));
        }
        this.lnk_parseFileLocationInfo(in);
        if ((flags & 4) != 0) {
            String descr = this.lnk_readASCII(in);
            logger.finer("Descr: " + descr);
        }
        if ((flags & 8) != 0) {
            String relPath = this.lnk_readASCII(in);
            logger.finer("RelativePath: " + relPath);
        }
        if ((flags & 0x10) != 0) {
            String workDir = this.lnk_readASCII(in);
            logger.finer("Working-Dir: " + workDir);
        }
        if ((flags & 0x20) != 0) {
            String args = this.lnk_readASCII(in);
            logger.finer("Command args: " + args);
        }
        if ((flags & 0x40) != 0) {
            String iconFile = this.lnk_readASCII(in);
            logger.finer("Icon: " + iconFile);
        }
    }

    protected void lnk_parseItemIdList(InputStream in) throws Exception {
        int itemLen;
        int itemCount = 0;
        while ((itemLen = this.lnk_readUShort(in)) != 0) {
            byte[] itemData = new byte[itemLen - 2];
            in.read(itemData);
            this.logBytes("Item #" + itemCount, itemData);
            ++itemCount;
        }
        logger.finer("Number of items: " + itemCount);
    }

    protected void lnk_parseLocalVolumeTable(InputStream in) throws Exception {
        logger.finer("reading local volume table");
        byte[] struct = this.lnk_parseStruct(in);
        ByteArrayInputStream structIn = this.lnk_getByteInput(struct, 4);
        int volumeType = this.lnk_readDWord(structIn);
        int volumeSerial = this.lnk_readDWord(structIn);
        int oVolumeLabel = this.lnk_readDWord(structIn);
        String volName = this.lnk_readASCIZ(structIn);
        logger.finer("Volume: " + volumeType + ", " + volumeSerial);
        logger.finer("Offs: " + oVolumeLabel);
        logger.finer("Volume name: " + volName);
    }

    protected void lnk_parseNetworkVolumeTable(InputStream in) throws Exception {
        logger.finer("reading network volume table");
        byte[] struct = this.lnk_parseStruct(in);
        ByteArrayInputStream structIn = this.lnk_getByteInput(struct, 4);
        int unknown1 = this.lnk_readDWord(structIn);
        int unknown2 = this.lnk_readDWord(structIn);
        int unknown3 = this.lnk_readDWord(structIn);
        int unknown4 = this.lnk_readDWord(structIn);
        String shareName = this.lnk_readASCIZ(structIn);
        logger.finer("Network-Share: " + shareName);
        logger.finer("Info: " + unknown1 + ", " + unknown2 + ", " + unknown3 + ", " + unknown4);
    }

    protected byte[] lnk_parseStruct(InputStream in) throws Exception {
        int structLen = this.lnk_readDWord(in);
        logger.finer("reading structure: " + structLen + " bytes");
        if (structLen < 4 || structLen > 10000) {
            throw new Exception("Invalid structure length " + structLen);
        }
        byte[] struct = new byte[structLen];
        int done = in.read(struct, 4, structLen - 4);
        if (done != structLen - 4) {
            throw new Exception("Structure is damaged. " + (done + 4) + " <> " + structLen);
        }
        return struct;
    }

    protected String lnk_readASCII(InputStream in) throws Exception {
        int len = this.lnk_readUShort(in);
        if (len > 1000) {
            throw new Exception("Invalid String length " + len);
        }
        String s = "";
        for (int c = 0; c < len; ++c) {
            int ch = in.read();
            s = s + (char)ch;
            int dummy = in.read();
            if (dummy == 0) continue;
            logger.fine("!!!!!!!!!! dummy is " + dummy);
        }
        return s;
    }

    protected String lnk_readASCIZ(InputStream in) throws Exception {
        int ch;
        String s = "";
        while ((ch = in.read()) != 0) {
            s = s + (char)ch;
        }
        return s;
    }

    protected int lnk_readDWord(InputStream in) throws Exception {
        int data = 0;
        for (int c = 0; c < 4; ++c) {
            int b = in.read();
            data += b << c * 8;
        }
        return data;
    }

    protected long lnk_readQWord(InputStream in) throws Exception {
        long data = 0L;
        for (int c = 0; c < 8; ++c) {
            int b = in.read();
            data += (long)b << c * 8;
        }
        return data;
    }

    protected int lnk_readUShort(InputStream in) throws Exception {
        int data = 0;
        for (int c = 0; c < 2; ++c) {
            int b = in.read();
            data += b << c * 8;
        }
        return data;
    }

    protected byte[] lnk_writeASCII(String s) throws Exception {
        byte[] bytes = new byte[2 + s.length() * 2];
        byte[] len = this.lnk_writeUShort(s.length());
        System.arraycopy(len, 0, bytes, 0, 2);
        int ofs = 2;
        for (int c = 0; c < s.length(); ++c) {
            bytes[ofs] = (byte)s.charAt(c);
            bytes[++ofs] = 0;
            ++ofs;
        }
        return bytes;
    }

    protected byte[] lnk_writeASCIZ(String s) throws Exception {
        byte[] bytes = new byte[1 + s.length()];
        for (int c = 0; c < s.length(); ++c) {
            bytes[c] = (byte)s.charAt(c);
        }
        bytes[s.length()] = 0;
        return bytes;
    }

    protected byte[] lnk_writeDWord(int data) throws Exception {
        byte[] bytes = new byte[4];
        for (int c = 0; c < 4; ++c) {
            int b = data >> c * 8 & 0xFF;
            bytes[c] = (byte)b;
        }
        return bytes;
    }

    protected byte[] lnk_writeQWord(long data) throws Exception {
        byte[] bytes = new byte[8];
        for (int c = 0; c < 8; ++c) {
            int b = (int)(data >> c * 8 & 0xFFL);
            bytes[c] = (byte)b;
        }
        return bytes;
    }

    protected byte[] lnk_writeUShort(int data) throws Exception {
        byte[] bytes = new byte[2];
        for (int c = 0; c < 2; ++c) {
            int b = data >> c * 8 & 0xFF;
            bytes[c] = (byte)b;
        }
        return bytes;
    }

    public void lnkFormat(OutputStream stream, String basePath, String path, int showWndValue, int fileLength, int hotKey, String descr, String relativePath, String workingDir, String cmdArgs, String iconPath) throws Exception {
        stream.write(this.lnk_formatHeader(basePath, path, showWndValue, fileLength, hotKey, descr, relativePath, workingDir, cmdArgs, iconPath));
        stream.flush();
    }

    public void lnkParse(InputStream stream) throws Exception {
        this.lnk_parseHeader(stream);
    }

    private void logBytes(String title, byte[] bytes) {
        String s = "";
        String b = "";
        if (bytes != null) {
            for (int c = 0; c < bytes.length; ++c) {
                if (c > 0) {
                    b = b + ",";
                }
                String x = "" + bytes[c];
                while (x.length() < 4) {
                    x = " " + x;
                }
                b = b + x;
                x = "" + (char)bytes[c];
                if (bytes[c] >= 0 && bytes[c] < 32) {
                    x = "?";
                }
                s = s + "" + x;
            }
        }
        logger.finer("Bytes '" + title + "': new byte[] {" + b + "}");
        logger.finer("Chars '" + title + "': new byte[] {" + s + "}");
    }

    public static void main(String[] args) {
        try {
            new InfectionUtilWin32().test();
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        System.exit(0);
    }

    protected int reflect_GetSpecialFolder_Desktop() throws Exception {
        return InfectionUtilWin32.getClass_SpecialFolder().getField("DESKTOP_DIRECTORY").getInt(null);
    }

    protected int reflect_GetSpecialFolder_Programs() throws Exception {
        return InfectionUtilWin32.getClass_SpecialFolder().getField("PROGRAMS").getInt(null);
    }

    protected int reflect_GetSpecialFolder_StartMenu() throws Exception {
        return InfectionUtilWin32.getClass_SpecialFolder().getField("START_MENU").getInt(null);
    }

    protected String reflect_GetSpecialFolderPath(int i) throws Exception {
        return (String)InfectionUtilWin32.getClass_SystemInformation().getMethod("getSpecialFolderPath", Integer.TYPE).invoke(null, new Integer(i));
    }

    public void test() throws Exception {
        logger.fine(RC_PATH_DESKTOP + this.reflect_GetSpecialFolderPath(this.reflect_GetSpecialFolder_Desktop()));
        logger.fine(RC_PATH_STARTMENU + this.reflect_GetSpecialFolderPath(this.reflect_GetSpecialFolder_StartMenu()));
        logger.fine(RC_PATH_PROGRAMS + this.reflect_GetSpecialFolderPath(this.reflect_GetSpecialFolder_Programs()));
    }

    public void testShortcut() throws Exception {
        logger.fine("Complete.");
        FileInputStream in = new FileInputStream("c:\\short.lnk");
        this.lnkParse(in);
    }
}

