/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JComponent;

public class StartupProgressBar
extends JComponent {
    private static final long serialVersionUID = 8285335893664156767L;
    private double minimum = 0.0;
    private double maximum = 1.0;
    private double value = 0.0;
    private int tickSize = 10;
    private int tickSpacing = 1;
    private Color lightColor;
    private Color darkColor;

    @Override
    protected void paintComponent(Graphics g) {
        int c;
        super.paintComponent(g);
        int width = this.getWidth();
        int height = this.getHeight();
        Color fore = this.getForeground();
        Color back = this.getBackground();
        int tickCount = (width - 1) / this.tickSize + 1;
        double v = (this.value - this.minimum) / (this.maximum - this.minimum);
        if (v < 0.0) {
            v = 0.0;
        }
        if (v > 1.0) {
            v = 1.0;
        }
        int ticks = (int)((double)tickCount * v);
        int x = 0;
        for (c = 0; c < ticks; ++c) {
            g.setColor(fore);
            g.fillRect(x, 0, this.tickSize - this.tickSpacing, height);
            if (this.lightColor != null) {
                g.setColor(this.lightColor);
                g.drawLine(x, 0, x + this.tickSize - this.tickSpacing - 1, 0);
                g.drawLine(x, 0, x, height - 1);
            }
            if (this.darkColor != null) {
                g.setColor(this.darkColor);
                int x2 = x + this.tickSize - this.tickSpacing - 1;
                g.drawLine(x, height - 1, x2, height - 1);
                g.drawLine(x2, 1, x2, height - 1);
            }
            x += this.tickSize;
        }
        g.setColor(back);
        for (c = ticks; c < tickCount; ++c) {
            g.fillRect(x, 0, this.tickSize - this.tickSpacing, height);
            x += this.tickSize;
        }
    }

    public double getMaximum() {
        return this.maximum;
    }

    public void setMaximum(double maximum) {
        this.maximum = maximum;
    }

    public double getMinimum() {
        return this.minimum;
    }

    public void setMinimum(double minimum) {
        this.minimum = minimum;
    }

    public int getTickSize() {
        return this.tickSize;
    }

    public void setTickSize(int tickSize) {
        this.tickSize = tickSize;
    }

    public int getTickSpacing() {
        return this.tickSpacing;
    }

    public void setTickSpacing(int tickSpacing) {
        this.tickSpacing = tickSpacing;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public Color getDarkColor() {
        return this.darkColor;
    }

    public void setDarkColor(Color darkColor) {
        this.darkColor = darkColor;
    }

    public Color getLightColor() {
        return this.lightColor;
    }

    public void setLightColor(Color lightColor) {
        this.lightColor = lightColor;
    }
}

