/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.install;

import com.spacekiller.infection.Artifact;
import com.spacekiller.infection.Infection;
import com.spacekiller.infection.InfectionIndex;
import com.spacekiller.infection.InfectionInstallation;
import com.spacekiller.infection.InfectionInstaller;
import com.spacekiller.infection.InfectionSite;
import com.spacekiller.infection.install.InstallerTask;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DownloadArtifactTask
implements InstallerTask {
    private static final Logger logger = Logger.getLogger(DownloadArtifactTask.class.getName());
    private InfectionInstaller installer;
    private InfectionInstallation installation;
    private InfectionIndex index;
    private String title;
    private Artifact art;
    private List mirrors;
    private File tempFile;
    private int status = 0;
    private String currentDownloadPath;
    private List errors;
    private boolean cancel;
    private boolean running;

    public DownloadArtifactTask(String title, InfectionInstaller installer, InfectionInstallation installation, InfectionIndex index, Artifact fact, File tempFile) {
        this.index = index;
        this.setInstaller(installer);
        this.setInstallation(installation);
        this.errors = new ArrayList();
        this.setTitle(title);
        this.mirrors = new ArrayList();
        this.art = fact;
        this.mirrors.add(fact);
        this.tempFile = tempFile;
    }

    @Override
    public void cancel() {
        this.cancel = true;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void execute() throws Exception {
        block26: {
            this.setStatus(1);
            boolean cancelled = false;
            byte[] buf = new byte[65536];
            try {
                boolean success = false;
                int mirrorCount = this.getMirrorArtifactCount();
                File tempFile = this.getTempFile();
                if (this.index == null) {
                    throw new NullPointerException("index==null");
                }
                for (int m = 0; m < mirrorCount; ++m) {
                    if (this.cancel) {
                        cancelled = true;
                        break;
                    }
                    Artifact fact = this.getMirrorArtifactAt(m);
                    if (fact == null) continue;
                    try {
                        String downloadPath = fact.getPath();
                        InfectionSite site = fact.getSite();
                        if (site != null && downloadPath.indexOf(":") < 0) {
                            String base = site.getURL();
                            int x = base.lastIndexOf("/");
                            if (x >= 0) {
                                base = base.substring(0, x + 1);
                            }
                            downloadPath = base + downloadPath;
                        }
                        logger.info("Download: " + downloadPath);
                        int factLen = fact.getLength();
                        String factLenInfo = factLen < 0 ? "unknown" : "" + factLen + " bytes";
                        logger.info("Artifact: " + fact + " (length=" + factLenInfo + ")");
                        this.setCurrentDownloadPath(downloadPath);
                        URL factURL = new URL(downloadPath);
                        URLConnection conn = factURL.openConnection();
                        if (conn.getUseCaches() && Infection.getInstance().isDisableURLCaches()) {
                            conn.setUseCaches(false);
                        }
                        InputStream in = conn.getInputStream();
                        FileOutputStream fout = new FileOutputStream(tempFile);
                        try {
                            int factLength;
                            int total = 0;
                            while (true) {
                                if (this.cancel) {
                                    cancelled = true;
                                    break;
                                }
                                int num = in.read(buf);
                                if (num < 0) break;
                                fout.write(buf, 0, num);
                                total += num;
                            }
                            fout.close();
                            logger.info("Downloaded: " + fact + " => " + total + " bytes.");
                            if (total == 0 && (factLength = fact.getLength()) == -1) {
                                throw new StreamCorruptedException("Invalid file length: " + total + " != UNKNOWN");
                            }
                            if (this.cancel) {
                                cancelled = true;
                            } else {
                                this.installer.installArtifact(this.installation, this.index, fact, tempFile);
                                success = true;
                                this.errors.clear();
                            }
                            break;
                        }
                        finally {
                            if (fout != null) {
                                fout.close();
                                fout = null;
                            }
                            if (!success) {
                                tempFile.delete();
                            }
                            in.close();
                        }
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, e.getMessage(), e);
                        this.addError(e);
                    }
                }
                if (cancelled) {
                    throw new Exception("Download cancelled: " + this.art);
                }
                if (success) {
                    this.setStatus(2);
                    break block26;
                }
                throw new Exception("Failed to download artifact: " + this.art);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                this.setStatus(3);
                this.addError(e);
            }
            finally {
                this.setCurrentDownloadPath(null);
            }
        }
    }

    protected void addError(Exception e) {
        this.errors.add(e);
    }

    public int getErrorCount() {
        return this.errors.size();
    }

    public Exception getErrorAt(int i) {
        return (Exception)this.errors.get(i);
    }

    protected void addMirrorArtifact(Artifact fact) throws Exception {
        String name2;
        String name1 = this.art.getName();
        if (!name1.equals(name2 = fact.getName())) {
            throw new Exception("Incompatible artifact: " + name2 + " != " + name1);
        }
        String ver1 = this.art.getVersion();
        String ver2 = fact.getVersion();
        if (ver1 != null && ver2 != null && !ver1.equals(ver2)) {
            throw new Exception("Incompatible artifact version: " + name2 + "-" + ver2 + " != " + name1 + "-" + ver1);
        }
        this.mirrors.add(fact);
    }

    protected void removeMirrorArtifact(Artifact fact) {
        this.mirrors.remove(fact);
    }

    public int getMirrorArtifactCount() {
        return this.mirrors.size();
    }

    public Artifact getMirrorArtifactAt(int i) {
        return (Artifact)this.mirrors.get(i);
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    protected void setStatus(int status) {
        this.status = status;
    }

    public String getCurrentDownloadPath() {
        return this.currentDownloadPath;
    }

    protected void setCurrentDownloadPath(String currentDownloadPath) {
        this.currentDownloadPath = currentDownloadPath;
    }

    public String getTitle() {
        return this.title;
    }

    protected void setTitle(String title) {
        this.title = title;
    }

    protected File getTempFile() {
        return this.tempFile;
    }

    protected void setTempFile(File tempFile) {
        this.tempFile = tempFile;
    }

    protected InfectionInstallation getInstallation() {
        return this.installation;
    }

    protected void setInstallation(InfectionInstallation installation) {
        this.installation = installation;
    }

    protected InfectionInstaller getInstaller() {
        return this.installer;
    }

    protected void setInstaller(InfectionInstaller installer) {
        this.installer = installer;
    }
}

