/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.install;

import com.spacekiller.infection.JavaVM;
import com.spacekiller.infection.JavaVMTester;
import com.spacekiller.infection.swing.InstanceCustomizer;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class JavaRuntimeWizard {
    private static final Logger logger = Logger.getLogger(JavaRuntimeWizard.class.getName());
    protected static final String OPTION_PREFIX = "-";
    protected static final String X_PREFIX = "-X";
    protected static final String XX_PREFIX = "-XX";
    protected static final String[] EMPTY_OPTIONS = new String[0];
    protected static final String[] JVM_MEMORY_1024M_OPTIONS = new String[]{"-Xmx1024m"};
    protected static final String[] JVM_MEMORY_1400M_OPTIONS = new String[]{"-Xmx1400m"};
    protected static final String[] JVM_MEMORY_2048M_OPTIONS = new String[]{"-Xmx2048m"};
    protected static final String[] JVM_GC_JDK6_OPTIONS = new String[]{"-Xnoclassgc"};
    protected static final String[] JVM_GC_JDK8_OPTIONS = new String[]{"-Xnoclassgc"};
    protected static final String[] JVM_GC_JROCKIT_OPTIONS = new String[]{"-jrockit", "-Xgc:singlecon", "-XgcPrio:deterministic", "-XpauseTarget=1ms", "-XXnoSystemGC", "-XX:-UseClassGC", "-XX:+UseFastTime", "-XXaggressive"};
    protected static final String[] JVM_GC_JDK14_ZGC_OPTIONS = new String[]{"-XX:+UnlockExperimentalVMOptions", "-XX:+UseZGC", "-Xnoclassgc"};
    protected static final String[] JVM_GC_JDK14_ZGC_OPTIONS_NO_ZUNCOMMIT = new String[]{"-XX:+UnlockExperimentalVMOptions", "-XX:+UseZGC", "-XX:-ZUncommit", "-Xnoclassgc"};
    protected static final String[][] BEST_JVM_GC_OPTIONS = new String[][]{EMPTY_OPTIONS, JVM_GC_JDK6_OPTIONS, JVM_GC_JDK8_OPTIONS, JVM_GC_JROCKIT_OPTIONS, JVM_GC_JDK14_ZGC_OPTIONS, JVM_GC_JDK14_ZGC_OPTIONS_NO_ZUNCOMMIT};
    protected static final String[][] BEST_JVM_MEMORY_OPTIONS = new String[][]{EMPTY_OPTIONS, JVM_MEMORY_1024M_OPTIONS, JVM_MEMORY_1400M_OPTIONS, JVM_MEMORY_2048M_OPTIONS};
    protected String[][] bestJvmGcOptions;
    protected String[][] bestJvmMemoryOptions;
    private String[] jvmGcOptions;
    private String[] jvmMemoryOptions;
    private SimpleAttributeSet attrNormal = new SimpleAttributeSet();
    private SimpleAttributeSet attrBold = new SimpleAttributeSet();
    private SimpleAttributeSet attrSuccess = new SimpleAttributeSet();
    private SimpleAttributeSet attrFailed = new SimpleAttributeSet();

    public JavaRuntimeWizard() {
        this.initJavaRuntimeWizard();
    }

    public String[][] getBestJvmGcOptions() {
        return this.bestJvmGcOptions;
    }

    public void setBestJvmGcOptions(String[][] bestJvmGcOptions) {
        this.bestJvmGcOptions = bestJvmGcOptions;
    }

    public String[][] getBestJvmMemoryOptions() {
        return this.bestJvmMemoryOptions;
    }

    public void setBestJvmMemoryOptions(String[][] bestJvmMemoryOptions) {
        this.bestJvmMemoryOptions = bestJvmMemoryOptions;
    }

    public String[] getJvmGcOptions() {
        return this.jvmGcOptions;
    }

    public void setJvmGcOptions(String[] jvmGcOptions) {
        this.jvmGcOptions = jvmGcOptions;
    }

    public String[] getJvmMemoryOptions() {
        return this.jvmMemoryOptions;
    }

    public void setJvmMemoryOptions(String[] jvmMemoryOptions) {
        this.jvmMemoryOptions = jvmMemoryOptions;
    }

    public void initJavaRuntimeWizard() {
        this.bestJvmGcOptions = this.cloneJvmOptionsArray(BEST_JVM_GC_OPTIONS);
        this.bestJvmMemoryOptions = this.cloneJvmOptionsArray(BEST_JVM_MEMORY_OPTIONS);
        this.attrNormal.addAttribute(StyleConstants.Foreground, Color.DARK_GRAY);
        this.attrNormal.addAttribute(StyleConstants.Bold, Boolean.FALSE);
        this.attrBold.addAttribute(StyleConstants.Foreground, Color.BLACK);
        this.attrBold.addAttribute(StyleConstants.Bold, Boolean.TRUE);
        this.attrSuccess.addAttribute(StyleConstants.Foreground, Color.GREEN.darker().darker());
        this.attrSuccess.addAttribute(StyleConstants.Bold, Boolean.TRUE);
        this.attrFailed.addAttribute(StyleConstants.Foreground, Color.RED.darker().darker());
        this.attrFailed.addAttribute(StyleConstants.Bold, Boolean.TRUE);
    }

    protected String[][] cloneJvmOptionsArray(String[][] array) {
        int num = array == null ? 0 : array.length;
        String[][] newArray = new String[num][];
        for (int i = 0; i < num; ++i) {
            newArray[i] = this.cloneJvmOptions(array[i]);
        }
        return newArray;
    }

    protected String[] cloneJvmOptions(String[] options) {
        int num = options == null ? 0 : options.length;
        String[] newOptions = new String[num];
        if (num > 0) {
            System.arraycopy(options, 0, newOptions, 0, num);
        }
        return newOptions;
    }

    public String formatJvmOptions(String[] jvmOptions) {
        StringBuffer sb = new StringBuffer();
        if (jvmOptions != null) {
            for (String option : jvmOptions) {
                if (option == null) continue;
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                sb.append(option);
            }
        }
        return sb.toString();
    }

    protected String[] parseJvmOptions(String jvmOptions) {
        if (jvmOptions == null) {
            jvmOptions = "";
        }
        LinkedList<String> list = new LinkedList<String>();
        StringTokenizer tok = new StringTokenizer(jvmOptions);
        while (tok.hasMoreTokens()) {
            String s = tok.nextToken();
            if (s == null || (s = s.trim()).length() <= 0) continue;
            list.add(s);
        }
        return list.toArray(new String[list.size()]);
    }

    protected boolean validateJvmOptions(String[] jvmOptions, JavaVM javaVM, String javaExecutable, String[] javaStandardOptions, String[] javaNonstandardXOptions, String[] javaNonstandardXXFlags, String[] javaNonstandardXXUnlockFlags) {
        int numOptions;
        int n = numOptions = jvmOptions == null ? 0 : jvmOptions.length;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("validateJvmOptions: " + this.formatJvmOptions(jvmOptions));
        }
        boolean valid = true;
        for (int i = 0; i < numOptions; ++i) {
            String availXOption;
            String optionPrefix;
            StringTokenizer tok;
            String delim;
            String option = jvmOptions[i];
            if (option == null) continue;
            if (!option.startsWith(X_PREFIX)) {
                if (option.startsWith(OPTION_PREFIX)) {
                    String availOption;
                    delim = " 0123456789<>(){}[]#$=:;";
                    tok = new StringTokenizer(option, delim, false);
                    String optionName = null;
                    if (tok.hasMoreTokens()) {
                        optionName = tok.nextToken();
                    }
                    if ((availOption = this.getJvmOptionIfAvailable(optionPrefix = optionName, javaStandardOptions)) != null) continue;
                    valid = false;
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.fine(" - unsupported JVM Option: " + option);
                    continue;
                }
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.fine(" - leaving unknown JVM Option: " + option);
                continue;
            }
            delim = " 0123456789<>(){}[]#$=:;";
            tok = new StringTokenizer(option, delim, false);
            String xOptionName = null;
            if (tok.hasMoreTokens()) {
                xOptionName = tok.nextToken();
            }
            if ((availXOption = this.getJvmXOptionIfAvailable(optionPrefix = xOptionName, javaNonstandardXOptions)) != null) continue;
            if (option.startsWith(XX_PREFIX)) {
                String flagPrefix = option;
                String availXXFlag = this.getJvmXXFlagIfAvailable(flagPrefix, javaNonstandardXOptions, javaNonstandardXXFlags, javaNonstandardXXUnlockFlags);
                if (availXXFlag != null) continue;
                String availXshowSettings = this.getJvmXOptionIfAvailable("-XshowSettings", javaNonstandardXOptions);
                if (availXshowSettings == null) {
                    boolean knownNewerThanJava7Argument;
                    String javaVersion = javaVM == null ? null : javaVM.getVersion();
                    boolean ignoreCheck = true;
                    if (javaVersion != null) {
                        ignoreCheck = false;
                        if (javaVersion.startsWith("1.")) {
                            ignoreCheck = true;
                            if (javaVersion.startsWith("1.8.")) {
                                ignoreCheck = false;
                            }
                            if (javaVersion.startsWith("1.9.")) {
                                ignoreCheck = false;
                            }
                        }
                    }
                    if (ignoreCheck && !(knownNewerThanJava7Argument = this.isKnownNewerThanJava7Argument(option))) {
                        if (!logger.isLoggable(Level.INFO)) continue;
                        logger.info(" - ignore unknown JVM-XX-Option: java version=" + javaVersion + ", option=" + option);
                        continue;
                    }
                }
            }
            valid = false;
            if (!logger.isLoggable(Level.FINE)) continue;
            logger.fine(" - unsupported JVM Option: " + option);
        }
        return valid;
    }

    protected boolean isKnownNewerThanJava7Argument(String option) {
        return this.equalsOption(option, "-XX:+Unlock");
    }

    protected boolean equalsOption(String option, String optionPrefix) {
        String lowerPrefix;
        if (option == null) {
            return false;
        }
        String lowerOption = option.toLowerCase();
        if (lowerOption.equals(lowerPrefix = optionPrefix.toLowerCase())) {
            return true;
        }
        return lowerOption.startsWith(lowerPrefix);
    }

    protected String getJvmOptionIfAvailable(String optionPrefix, String[] javaStandardOptions) {
        if (optionPrefix == null) {
            return null;
        }
        String optionName = this.parseOptionName(optionPrefix);
        if (optionName == null) {
            return null;
        }
        int num = javaStandardOptions == null ? 0 : javaStandardOptions.length;
        for (int i = 0; i < num; ++i) {
            String s = javaStandardOptions[i];
            if (s == null) continue;
            if (s.equals(optionName)) {
                return optionPrefix;
            }
            if (!s.equalsIgnoreCase(optionName)) continue;
            return optionPrefix;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Unsupported or invalid JVM-Option: " + optionPrefix);
        }
        return null;
    }

    protected String parseOptionName(String str) {
        if (str.startsWith(OPTION_PREFIX)) {
            String xSpec = str.substring(OPTION_PREFIX.length()).trim();
            String optionName = xSpec;
            int x = optionName.indexOf(58);
            if (x >= 0 && (optionName = optionName.substring(0, x)).length() < 1) {
                return null;
            }
            return optionName;
        }
        return null;
    }

    protected String getJvmXOptionIfAvailable(String optionPrefix, String[] javaNonstandardXOptions) {
        if (optionPrefix == null) {
            return null;
        }
        String optionName = this.parseXOptionName(optionPrefix);
        if (optionName == null) {
            return null;
        }
        int num = javaNonstandardXOptions == null ? 0 : javaNonstandardXOptions.length;
        for (int i = 0; i < num; ++i) {
            String s = javaNonstandardXOptions[i];
            if (s == null) continue;
            if (s.equals(optionName)) {
                return optionPrefix;
            }
            if (!s.equalsIgnoreCase(optionName)) continue;
            return optionPrefix;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Unsupported or invalid JVM-X-Option: " + optionPrefix);
        }
        return null;
    }

    protected String parseXOptionName(String str) {
        if (str.startsWith(XX_PREFIX)) {
            return null;
        }
        if (str.startsWith(X_PREFIX)) {
            String xSpec = str.substring(X_PREFIX.length()).trim();
            String optionName = xSpec;
            int x = optionName.indexOf(58);
            if (x >= 0 && (optionName = optionName.substring(0, x)) == null) {
                return null;
            }
            return optionName;
        }
        return null;
    }

    protected String getJvmXXFlagIfAvailable(String flagPrefix, String[] javaNonstandardXOptions, String[] javaNonstandardXXFlags, String[] javaNonstandardXXUnlockFlags) {
        String xxFlagName;
        int i;
        if (flagPrefix == null) {
            return null;
        }
        String flagName = this.parseXXFlagName(flagPrefix);
        if (flagName == null) {
            return null;
        }
        int num = javaNonstandardXXFlags == null ? 0 : javaNonstandardXXFlags.length;
        for (i = 0; i < num; ++i) {
            xxFlagName = javaNonstandardXXFlags[i];
            if (xxFlagName == null || xxFlagName == null || !xxFlagName.equalsIgnoreCase(flagName)) continue;
            return flagPrefix;
        }
        num = javaNonstandardXXUnlockFlags == null ? 0 : javaNonstandardXXUnlockFlags.length;
        for (i = 0; i < num; ++i) {
            xxFlagName = javaNonstandardXXUnlockFlags[i];
            if (xxFlagName == null || xxFlagName == null || !xxFlagName.equalsIgnoreCase(flagName)) continue;
            return flagPrefix;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Unsupported or invalid JVM-XX-Flag: " + flagPrefix + ", flagName=" + flagName);
        }
        return null;
    }

    protected String parseXXFlagName(String str) {
        if (str.startsWith(XX_PREFIX)) {
            int x;
            String xxSpec = str.substring(XX_PREFIX.length()).trim();
            String flagName = xxSpec;
            if (flagName.startsWith(":")) {
                flagName = flagName.substring(1);
            }
            if (flagName.startsWith("+")) {
                flagName = flagName.substring(1);
            }
            if (flagName.startsWith(OPTION_PREFIX)) {
                flagName = flagName.substring(1);
            }
            if ((x = flagName.indexOf(61)) >= 0) {
                flagName = flagName.substring(0, x).trim();
            }
            return flagName;
        }
        return null;
    }

    protected String parseXXFlagValue(String str) {
        if (str.startsWith(XX_PREFIX)) {
            String xxSpec = str.substring(XX_PREFIX.length()).trim();
            String flagName = xxSpec;
            if (flagName.startsWith("+")) {
                flagName = flagName.substring(1);
            }
            if (flagName.startsWith(OPTION_PREFIX)) {
                flagName = flagName.substring(1);
            }
            String flagValue = null;
            int x = flagName.indexOf(61);
            if (x >= 0) {
                flagValue = flagName.substring(x + 1).trim();
                flagName = flagName.substring(0, x).trim();
            }
            return flagValue;
        }
        return null;
    }

    public String[] computeOptimizedJvmOptions(InstanceCustomizer instanceCustomizer, JTextPane resultTextPane) {
        boolean removeInvalidOptions;
        String[] optimizedJvmOptions;
        boolean checkStandardOptions = true;
        boolean checkNonstandardXOptions = true;
        boolean checkNonstandardDefaultFlags = true;
        boolean checkNonstandardUnlockedFlags = true;
        String jvmOptions = instanceCustomizer.getJvmOptions();
        this.appendResultLine(resultTextPane, "Testing JVM...", this.attrNormal);
        JavaVM javaVM = null;
        String javaExecutable = null;
        try {
            javaVM = instanceCustomizer.testJavaOptions(new String[0]);
            if (javaVM == null) {
                this.appendResultLine(resultTextPane, "Test JVM failed!", this.attrFailed);
                throw new RuntimeException("Java runtime test failed!");
            }
            javaExecutable = javaVM.getExecutable();
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            this.appendResult(resultTextPane, "Test JVM failed: ", this.attrFailed);
            this.appendResultLine(resultTextPane, String.valueOf(e.getMessage()), this.attrFailed);
            return null;
        }
        this.appendResultLine(resultTextPane, "Java Executable: ", this.attrNormal);
        this.appendResultLine(resultTextPane, String.valueOf(javaExecutable), this.attrBold);
        this.appendResultLine(resultTextPane, "Querying standard JVM options...", this.attrNormal);
        String[] javaStandardOptions = null;
        if (javaExecutable != null && checkStandardOptions) {
            try {
                JavaVMTester tester = new JavaVMTester();
                javaStandardOptions = tester.queryJavaStandardOptions(javaExecutable);
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        int javaStandardOptionsCount = javaStandardOptions == null ? 0 : javaStandardOptions.length;
        logger.info("Number of standard options: " + javaStandardOptionsCount);
        this.appendResultLine(resultTextPane, "Number of standard options: " + javaStandardOptionsCount, this.attrNormal);
        if (logger.isLoggable(Level.FINER)) {
            for (int i = 0; i < javaStandardOptionsCount; ++i) {
                logger.finer(" -Option: " + javaStandardOptions[i]);
            }
        }
        this.appendResultLine(resultTextPane, "Querying non-standard \"-X\" JVM options...", this.attrNormal);
        String[] javaNonstandardXOptions = null;
        if (javaExecutable != null && checkNonstandardXOptions) {
            try {
                JavaVMTester tester = new JavaVMTester();
                javaNonstandardXOptions = tester.queryJavaNonstandardXOptions(javaExecutable);
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                checkNonstandardDefaultFlags = false;
                checkNonstandardUnlockedFlags = false;
            }
        }
        int javaNonstandardXOptionsCount = javaNonstandardXOptions == null ? 0 : javaNonstandardXOptions.length;
        logger.info("Number of nonstandard -X options: " + javaNonstandardXOptionsCount);
        this.appendResultLine(resultTextPane, "Number of nonstandard \"-X\" options: " + javaNonstandardXOptionsCount, this.attrNormal);
        if (logger.isLoggable(Level.FINER)) {
            for (int i = 0; i < javaNonstandardXOptionsCount; ++i) {
                logger.finer(" -X Option: " + javaNonstandardXOptions[i]);
            }
        }
        this.appendResultLine(resultTextPane, "Querying non-standard \"-XX\" JVM flags...", this.attrNormal);
        String[] javaNonstandardXXFlags = null;
        if (javaExecutable != null && checkNonstandardDefaultFlags) {
            try {
                JavaVMTester tester = new JavaVMTester();
                boolean unlockDiagnosticVMOptions = false;
                boolean unlockExperimentalVMOptions = false;
                javaNonstandardXXFlags = tester.queryJavaNonstandardXXFlags(javaExecutable, unlockDiagnosticVMOptions, unlockExperimentalVMOptions);
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                checkNonstandardUnlockedFlags = false;
            }
        }
        int javaNonstandardXXFlagsCount = javaNonstandardXXFlags == null ? 0 : javaNonstandardXXFlags.length;
        logger.info("Number of nonstandard -XX flags (defaults): " + javaNonstandardXXFlagsCount);
        this.appendResultLine(resultTextPane, "Number of nonstandard \"-XX\" flags (defaults): " + javaNonstandardXXFlagsCount, this.attrNormal);
        if (logger.isLoggable(Level.FINER)) {
            for (int i = 0; i < javaNonstandardXXFlagsCount; ++i) {
                logger.finer(" -XX Flag (default): " + javaNonstandardXXFlags[i]);
            }
        }
        this.appendResultLine(resultTextPane, "Querying non-standard \"-XX\" JVM flags (unlocked)...", this.attrNormal);
        String[] javaNonstandardXXUnlockFlags = null;
        if (javaExecutable != null && checkNonstandardUnlockedFlags) {
            try {
                JavaVMTester tester = new JavaVMTester();
                boolean unlockDiagnosticVMOptions = true;
                boolean unlockExperimentalVMOptions = true;
                javaNonstandardXXUnlockFlags = tester.queryJavaNonstandardXXFlags(javaExecutable, unlockDiagnosticVMOptions, unlockExperimentalVMOptions);
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        int javaNonstandardXXUnlockFlagsCount = javaNonstandardXXUnlockFlags == null ? 0 : javaNonstandardXXUnlockFlags.length;
        logger.info("Number of nonstandard -XX flags (unlocked): " + javaNonstandardXXUnlockFlagsCount);
        this.appendResultLine(resultTextPane, "Number of nonstandard \"-XX\" flags (unlocked): " + javaNonstandardXXUnlockFlagsCount, this.attrNormal);
        if (logger.isLoggable(Level.FINER)) {
            for (int i = 0; i < javaNonstandardXXUnlockFlagsCount; ++i) {
                logger.finer(" -XX Flag (unlocked): " + javaNonstandardXXUnlockFlags[i]);
            }
        }
        if ((optimizedJvmOptions = this.computeOptimizedJvmOptions(jvmOptions, javaVM, javaExecutable, javaStandardOptions, javaNonstandardXOptions, javaNonstandardXXFlags, javaNonstandardXXUnlockFlags, removeInvalidOptions = true, resultTextPane)) != null) {
            this.appendResultLine(resultTextPane, "Recommended JVM-Options: ", this.attrBold);
            this.appendResultLine(resultTextPane, this.formatJvmOptions(optimizedJvmOptions), this.attrSuccess);
        } else {
            this.appendResultLine(resultTextPane, "Failed to enumerate recommended JVM-Options!", this.attrFailed);
        }
        return optimizedJvmOptions;
    }

    protected String[] computeOptimizedJvmOptions(String currentJvmOptions, JavaVM javaVM, String javaExecutable, String[] javaStandardOptions, String[] javaNonstandardXOptions, String[] javaNonstandardXXFlags, String[] javaNonstandardXXUnlockFlags, boolean removeInvalidOptions, JTextPane resultTextPane) {
        String[] bestJvmOptions;
        String[][] bestJvmGcOptions;
        String[] bestJvmOptions2;
        String[] opts;
        ArrayList<String> jvmOptionList = new ArrayList<String>();
        if (currentJvmOptions != null && (opts = this.parseJvmOptions(currentJvmOptions)) != null) {
            for (String opt : opts) {
                if (opt == null || (opt = opt.trim()).length() <= 0) continue;
                jvmOptionList.add(opt);
            }
        }
        ArrayList<String> bestOptionList = new ArrayList<String>();
        String[][] bestJvmMemoryOptions = this.getBestJvmMemoryOptions();
        if (bestJvmMemoryOptions != null && (bestJvmOptions2 = this.computeOptimizedJvmOptions(bestJvmMemoryOptions, javaVM, javaExecutable, javaStandardOptions, javaNonstandardXOptions, javaNonstandardXXFlags, javaNonstandardXXUnlockFlags, removeInvalidOptions, resultTextPane)) != null) {
            for (int i = 0; i < bestJvmOptions2.length; ++i) {
                bestOptionList.add(bestJvmOptions2[i]);
            }
        }
        if ((bestJvmGcOptions = this.getBestJvmGcOptions()) != null && (bestJvmOptions = this.computeOptimizedJvmOptions(bestJvmGcOptions, javaVM, javaExecutable, javaStandardOptions, javaNonstandardXOptions, javaNonstandardXXFlags, javaNonstandardXXUnlockFlags, removeInvalidOptions, resultTextPane)) != null) {
            for (int i = 0; i < bestJvmOptions.length; ++i) {
                bestOptionList.add(bestJvmOptions[i]);
            }
        }
        if (removeInvalidOptions) {
            logger.info("TODO removeInvalidOptions!");
        }
        logger.info("TODO mergeJvmOptions: " + jvmOptionList + " <vs> " + bestOptionList);
        jvmOptionList.clear();
        jvmOptionList.addAll(bestOptionList);
        String[] optimizedJvmOptions = jvmOptionList.toArray(new String[jvmOptionList.size()]);
        return optimizedJvmOptions;
    }

    protected String[] computeOptimizedJvmOptions(String[][] bestJvmOptions, JavaVM javaVM, String javaExecutable, String[] javaStandardOptions, String[] javaNonstandardXOptions, String[] javaNonstandardXXFlags, String[] javaNonstandardXXUnlockFlags, boolean removeInvalidOptions, JTextPane resultTextPane) {
        int num = bestJvmOptions.length;
        for (int i = num - 1; i >= 0; --i) {
            String[] jvmOptions = bestJvmOptions[i];
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Validating JVM-Options: " + this.formatJvmOptions(jvmOptions));
            }
            this.appendResultLine(resultTextPane, "Validating JVM-Options: " + this.formatJvmOptions(jvmOptions), this.attrNormal);
            if (!this.validateJvmOptions(jvmOptions, javaVM, javaExecutable, javaStandardOptions, javaNonstandardXOptions, javaNonstandardXXFlags, javaNonstandardXXUnlockFlags)) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Invalid JVM-Options: " + this.formatJvmOptions(jvmOptions));
                }
                this.appendResultLine(resultTextPane, "Invalid JVM-Options: " + this.formatJvmOptions(jvmOptions), this.attrNormal);
                continue;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Validated JVM-Options: " + this.formatJvmOptions(jvmOptions));
            }
            this.appendResultLine(resultTextPane, "Validated JVM-Options: " + this.formatJvmOptions(jvmOptions), this.attrBold);
            try {
                JavaVMTester tester = new JavaVMTester();
                String[] arguments = jvmOptions;
                JavaVM result = tester.testJavaVM(javaExecutable, arguments);
                if (result == null) continue;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Verified JVM-Options: " + this.formatJvmOptions(jvmOptions));
                }
                this.appendResultLine(resultTextPane, "Verified JVM-Options: " + this.formatJvmOptions(jvmOptions), this.attrSuccess);
                return jvmOptions;
            }
            catch (Exception e) {
                logger.log(Level.INFO, e.getMessage(), e);
                continue;
            }
            catch (Throwable e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
        return null;
    }

    protected void appendResult(JTextPane resultTextPane, String text, AttributeSet attr) {
        if (resultTextPane == null) {
            return;
        }
        final JTextPane finalResultTextPane = resultTextPane;
        final String finalText = text;
        final AttributeSet finalAttr = attr;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    StyledDocument document = finalResultTextPane.getStyledDocument();
                    document.insertString(document.getLength(), finalText, finalAttr);
                    finalResultTextPane.setCaretPosition(document.getLength());
                }
                catch (BadLocationException e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        });
    }

    protected void appendResultLine(JTextPane resultTextPane, String text, AttributeSet attr) {
        this.appendResult(resultTextPane, text, attr);
        this.appendResult(resultTextPane, "\n", attr);
    }
}

