/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.log;

import java.io.UnsupportedEncodingException;
import java.util.logging.ErrorManager;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class InfectionLogHandler
extends Handler {
    protected volatile Handler[] handlers = new Handler[0];

    @Override
    public void publish(LogRecord record) {
        Handler[] arr = this.handlers;
        for (int i = 0; i < arr.length; ++i) {
            arr[i].publish(record);
        }
    }

    @Override
    public void flush() {
        Handler[] arr = this.handlers;
        for (int i = 0; i < arr.length; ++i) {
            arr[i].flush();
        }
    }

    @Override
    public void close() throws SecurityException {
        Handler[] arr = this.handlers;
        for (int i = 0; i < arr.length; ++i) {
            arr[i].close();
        }
    }

    @Override
    public void setFormatter(Formatter newFormatter) throws SecurityException {
    }

    @Override
    public void setEncoding(String encoding) throws SecurityException, UnsupportedEncodingException {
    }

    @Override
    public void setFilter(Filter newFilter) throws SecurityException {
    }

    @Override
    public void setErrorManager(ErrorManager em) {
    }

    @Override
    public void setLevel(Level newLevel) throws SecurityException {
    }

    public final synchronized boolean registerHandler(Handler handler) {
        if (handler == null) {
            return false;
        }
        int num = this.handlers.length;
        for (int i = 0; i < num; ++i) {
            if (this.handlers[i] != handler) continue;
            return false;
        }
        Handler[] arr = new Handler[num + 1];
        System.arraycopy(this.handlers, 0, arr, 0, num);
        arr[num] = handler;
        this.handlers = arr;
        return true;
    }

    public final synchronized boolean unregisterHandler(Handler handler) {
        if (handler == null) {
            return false;
        }
        int index = -1;
        int num = this.handlers.length;
        for (int i = 0; i < num; ++i) {
            if (this.handlers[i] != handler) continue;
            index = i;
            break;
        }
        if (index < 0) {
            return false;
        }
        Handler[] arr = new Handler[num - 1];
        if (index > 0) {
            System.arraycopy(this.handlers, 0, arr, 0, index);
        }
        if ((num = num - index - 1) > 0) {
            System.arraycopy(this.handlers, index + 1, arr, index, num);
        }
        this.handlers = arr;
        return true;
    }
}

