/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.log;

import com.spacekiller.infection.Infection;
import com.spacekiller.infection.log.LogDecorator;
import com.spacekiller.infection.log.LogStream;
import com.spacekiller.infection.log.LogTask;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

public final class Log2TraceHandler
extends Handler {
    private static final byte[] TRACE_FILE_MAGIC = new byte[]{124, -107, -98, 33};
    private static final int TRACE_FILE_VERSION = 1;
    private static final int MAX_SAFE_UTF_CHARS = 21845;
    private DataOutputStream out;
    private StringBuffer sbuf;

    public Log2TraceHandler() {
        this(true);
    }

    protected Log2TraceHandler(boolean register) {
        LogStream stream = Infection.getLog2TraceStream(this);
        this.out = new DataOutputStream(stream);
        this.sbuf = new StringBuffer();
        this.initDecorator(stream);
        if (register) {
            Infection.registerLogHandler(this);
        }
    }

    protected void initDecorator(LogStream stream) {
        stream.setDecorator(new Decorator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        try {
            this.out.writeLong(record.getSequenceNumber());
            this.out.writeLong(record.getMillis());
            this.out.writeInt(record.getLevel().intValue());
            this.out.writeInt(record.getThreadID());
            String logger = record.getLoggerName();
            this.out.writeUTF(logger == null ? "" : logger);
            String clazz = record.getSourceClassName();
            this.out.writeUTF(clazz == null ? "" : clazz);
            String meth = record.getSourceMethodName();
            this.out.writeUTF(meth == null ? "" : meth);
            String msg = record.getMessage();
            if (msg == null) {
                this.out.write(0);
            } else {
                int n = msg.length();
                if (n <= 21845) {
                    this.out.write(1);
                    this.out.writeUTF(msg);
                } else {
                    this.out.write(2);
                    this.out.writeInt(n);
                    this.out.writeChars(msg);
                }
            }
            Throwable error = record.getThrown();
            if (error == null) {
                this.out.write(0);
            } else {
                try {
                    LogTask.formatException(error, "\n", this.sbuf);
                    String trace = this.sbuf.toString();
                    int n = trace.length();
                    if (n <= 21845) {
                        this.out.write(1);
                        this.out.writeUTF(trace);
                    } else {
                        this.out.write(2);
                        this.out.writeInt(n);
                        this.out.writeChars(trace);
                    }
                }
                catch (Throwable x) {
                    this.out.write(0);
                }
                finally {
                    this.sbuf.delete(0, this.sbuf.length());
                }
            }
            this.out.flush();
        }
        catch (Exception ex) {
            this.reportError(null, ex, 1);
        }
    }

    @Override
    public synchronized void flush() {
        try {
            this.out.flush();
        }
        catch (Exception ex) {
            this.reportError(null, ex, 2);
        }
    }

    @Override
    public void close() throws SecurityException {
        this.flush();
    }

    protected class Decorator
    implements LogDecorator {
        protected Decorator() {
        }

        @Override
        public void writeHeader(OutputStream out) throws IOException {
            out.write(TRACE_FILE_MAGIC);
            out.write(1);
        }

        @Override
        public void writeFooter(OutputStream out) throws IOException {
        }
    }
}

