/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.log;

import com.spacekiller.infection.log.LogDecorator;
import com.spacekiller.infection.log.LogFileOptions;
import com.spacekiller.infection.log.LogStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class LogFileStream
extends LogStream {
    private final Rotate rotate;
    private LogFileOptions options;
    private LogFileOptions newOptions;
    private File file;
    private boolean rotating;
    private SimpleDateFormat dateFormat;
    private SimpleDateFormat dateFormat2;

    public LogFileStream(LogFileOptions options) {
        this.options = options;
        this.rotate = new Rotate();
        this.dateFormat = new SimpleDateFormat("yyyyMMdd-HHmmss");
        this.dateFormat2 = new SimpleDateFormat("yyyyMMdd-HHmmss-SSS");
    }

    public synchronized void applyOptions(LogFileOptions newOptions) {
        boolean forceRotate = false;
        this.newOptions = newOptions;
        if (forceRotate) {
            this.remain = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void rotate(int len) throws IOException {
        if (this.rotating) {
            return;
        }
        Object error = null;
        try {
            this.rotating = true;
            error = AccessController.doPrivileged(this.rotate);
        }
        finally {
            this.rotating = false;
        }
        if (error != null) {
            throw (IOException)error;
        }
    }

    protected synchronized void rotateImpl() throws IOException {
        int limit;
        OutputStream stream = this.out;
        if (this.newOptions != null) {
            this.options = this.newOptions;
            this.newOptions = null;
        }
        boolean append = this.options.isAppend();
        if (this.file != null) {
            append = false;
        }
        if ((limit = this.options.getLimit()) < 1) {
            limit = Integer.MAX_VALUE;
        }
        File dir = this.getDirectory();
        String namePrefix = this.options.getNamePrefix();
        String nameSuffix = this.options.getNameSuffix();
        this.file = new File(dir, namePrefix + nameSuffix);
        if (!(dir.exists() && dir.isDirectory() || dir.mkdirs())) {
            throw new FileNotFoundException(this.file.getPath());
        }
        LogDecorator decorator = this.getDecorator();
        if (stream != null) {
            if (decorator != null) {
                decorator.writeFooter(stream);
            }
            stream.close();
        }
        int appendLimit = 0;
        if (this.file.exists()) {
            File newFile;
            if (append) {
                long fileLen;
                append = false;
                if (this.file.isFile() && (fileLen = this.file.length()) < (long)limit && fileLen >= 0L) {
                    append = true;
                    appendLimit = (int)Math.min((long)limit - fileLen, Integer.MAX_VALUE);
                }
            }
            if (!append && !this.file.renameTo(newFile = this.generateFile(System.currentTimeMillis()))) {
                this.file = newFile;
            }
        } else {
            append = false;
        }
        try {
            stream = new FileOutputStream(this.file, append);
        }
        catch (IOException e) {
            this.file = this.generateFile(System.currentTimeMillis());
            append = false;
            stream = new FileOutputStream(this.file, append);
        }
        if (append) {
            limit = appendLimit;
        }
        this.out = stream;
        this.remain = limit;
        if (decorator != null) {
            decorator.writeHeader(stream);
        }
        this.deleteOldFiles();
    }

    protected File getDirectory() {
        String dirPath = this.options.getDirectory();
        if (dirPath == null) {
            dirPath = ".";
        }
        return new File(dirPath);
    }

    protected File generateFile(long time) {
        File dir = this.getDirectory();
        String namePrefix = this.options.getNamePrefix();
        String nameSuffix = this.options.getNameSuffix();
        Date date = new Date(time);
        String str = this.dateFormat.format(date);
        String name = namePrefix + "-" + str + nameSuffix;
        File f = new File(dir, name);
        if (!f.exists()) {
            return f;
        }
        str = this.dateFormat2.format(date);
        name = namePrefix + "-" + str + nameSuffix;
        return new File(dir, name);
    }

    protected void deleteOldFiles() {
        File dir = this.getDirectory();
        int count = this.options.getCount();
        final String namePrefix = this.options.getNamePrefix();
        final String nameSuffix = this.options.getNameSuffix();
        File[] files = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                String name = pathname.getName();
                if (!name.startsWith(namePrefix)) {
                    return false;
                }
                if (!name.endsWith(nameSuffix)) {
                    return false;
                }
                String timeString = name.substring(namePrefix.length());
                return (timeString = timeString.substring(0, timeString.length() - nameSuffix.length())).length() >= 15;
            }
        });
        TreeMap<Long, File> map = new TreeMap<Long, File>();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            long lastMod = file.lastModified();
            map.put(new Long(lastMod), file);
        }
        int num = map.size();
        if (num >= count) {
            int numDelete = num - count + 1;
            Iterator iter = map.entrySet().iterator();
            for (int i = 0; i < numDelete && iter.hasNext(); ++i) {
                Map.Entry me = iter.next();
                File file = (File)me.getValue();
                if (file.delete()) continue;
                file.deleteOnExit();
            }
        }
    }

    protected class Rotate
    implements PrivilegedAction {
        protected Rotate() {
        }

        public Object run() {
            try {
                LogFileStream.this.rotateImpl();
                return null;
            }
            catch (IOException e) {
                return e;
            }
        }
    }
}

