/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.log;

import com.spacekiller.infection.log.LogDecorator;
import java.io.IOException;
import java.io.OutputStream;

public abstract class LogStream
extends OutputStream {
    protected OutputStream out;
    protected int remain;
    protected LogDecorator decorator;

    protected LogStream() {
    }

    protected LogStream(OutputStream stream, int remaining) {
        this.out = stream;
        this.remain = remaining;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.remain < 1) {
            this.rotate(1);
        }
        this.out.write(b);
        --this.remain;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.remain < len) {
            this.rotate(len);
        }
        this.out.write(b, off, len);
        this.remain -= len;
    }

    protected void force(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.remain -= len;
    }

    @Override
    public void flush() throws IOException {
        OutputStream os = this.out;
        if (os != null) {
            os.flush();
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
    }

    protected synchronized void dispose() throws IOException {
        OutputStream os = this.out;
        if (os != null) {
            this.remain = 0;
            this.out = null;
            os.close();
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.dispose();
    }

    public LogDecorator getDecorator() {
        return this.decorator;
    }

    public void setDecorator(LogDecorator decorator) {
        this.decorator = decorator;
    }

    protected abstract void rotate(int var1) throws IOException;
}

