/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.swing;

import com.spacekiller.infection.Artifact;
import com.spacekiller.infection.ArtifactDependency;
import com.spacekiller.infection.Infection;
import com.spacekiller.infection.InfectionAccess;
import com.spacekiller.infection.InfectionIndex;
import com.spacekiller.infection.InfectionInstallation;
import com.spacekiller.infection.InfectionInstaller;
import com.spacekiller.infection.InfectionInstance;
import com.spacekiller.infection.InfectionRuntime;
import com.spacekiller.infection.InfectionRuntimeFacade;
import com.spacekiller.infection.InfectionUtil;
import com.spacekiller.infection.old.ErrorDialog;
import com.spacekiller.infection.swing.InstallerBanner;
import com.spacekiller.infection.swing.InstallerPagePanel;
import com.spacekiller.infection.swing.InstanceCustomizer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;

public class InstallationInstanceConfigPanel
extends InstallerPagePanel {
    private static final long serialVersionUID = -607468889573781768L;
    private static final Logger logger = Logger.getLogger(InstallationInstanceConfigPanel.class.getName());
    private InfectionRuntime access;
    private InfectionInstaller installer;
    private InfectionInstallation installation;
    private InfectionIndex installationIndex;
    private boolean promptUpgrade = true;
    private boolean autoSaveConfig = false;
    private boolean promptRestart = false;
    private DefaultComboBoxModel instanceComboModel;
    private InfectionInstance instance;
    private Object selectedInstanceItem;
    private Icon iconStart;
    private Icon iconRestart;
    private JPanel jPanel6 = null;
    private JPanel jPanel15 = null;
    private JPanel jPanel28 = null;
    private JPanel jPanel14 = null;
    private JPanel jPanel13 = null;
    private JPanel jPanel10 = null;
    private JLabel jLabel6 = null;
    private JComboBox jComboBoxInstance = null;
    private JButton jButtonInstanceBrowse = null;
    private JButton jButtonInstanceNew = null;
    private InstanceCustomizer infectionInstanceCustomizer = null;
    private JButton jButtonInstanceStartup = null;
    private JCheckBox jCheckBoxKeepOpen = null;
    private JButton jButtonInstanceTest = null;
    private JButton jButtonInstanceSave = null;
    private JButton jButtonInstanceSaveAs = null;
    private JButton jButtonInstanceReset = null;
    private JButton jButton2 = null;
    private InstallerBanner infectionBanner;

    public InstallationInstanceConfigPanel() {
        GridBagConstraints gridBagConstraints100 = new GridBagConstraints();
        gridBagConstraints100.fill = 2;
        gridBagConstraints100.gridwidth = 2;
        gridBagConstraints100.gridx = 0;
        gridBagConstraints100.gridy = 0;
        gridBagConstraints100.insets = new Insets(0, 0, 0, 0);
        GridBagConstraints gridBagConstraints105 = new GridBagConstraints();
        gridBagConstraints105.gridx = 0;
        gridBagConstraints105.weighty = 1.0;
        gridBagConstraints105.weightx = 1.0;
        gridBagConstraints105.fill = 1;
        gridBagConstraints105.insets = new Insets(0, 4, 0, 4);
        gridBagConstraints105.gridy = 2;
        GridBagConstraints gridBagConstraints46 = new GridBagConstraints();
        gridBagConstraints46.gridx = 0;
        gridBagConstraints46.fill = 2;
        gridBagConstraints46.insets = new Insets(4, 4, 5, 4);
        gridBagConstraints46.gridy = 1;
        GridBagConstraints gridBagConstraints37 = new GridBagConstraints();
        gridBagConstraints37.gridx = 0;
        gridBagConstraints37.fill = 1;
        gridBagConstraints37.insets = new Insets(4, 4, 0, 4);
        gridBagConstraints37.gridy = 3;
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(759, 532));
        GridBagConstraints gbc_infectionBanner = new GridBagConstraints();
        gbc_infectionBanner.fill = 2;
        gbc_infectionBanner.gridx = 0;
        gbc_infectionBanner.gridy = 0;
        this.add((Component)this.getInfectionBanner(), gbc_infectionBanner);
        this.add((Component)this.getJPanel6(), gridBagConstraints37);
        this.add((Component)this.getJPanel15(), gridBagConstraints46);
        this.add((Component)this.getJPanel28(), gridBagConstraints105);
        this.initInstallationInstancePanel();
    }

    protected void initInstallationInstancePanel() {
        this.instance = new InfectionInstance();
        this.instanceComboModel = new DefaultComboBoxModel();
        try {
            this.iconStart = new ImageIcon(this.getClass().getResource("/com/spacekiller/infection/icons/startup.gif"));
            this.iconRestart = new ImageIcon(this.getClass().getResource("/com/spacekiller/infection/icons/restart.gif"));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        String fontName = "dialog";
        int normalFontSize = 14;
        Font font = this.getJButton2().getFont();
        if (font != null) {
            fontName = font.getName();
            normalFontSize = font.getSize();
        }
        int largeFontSize = normalFontSize * 4 / 3;
        this.jLabel6.setFont(new Font(fontName, 1, largeFontSize));
        this.getJButtonInstanceStartup().setFont(new Font(fontName, 1, largeFontSize));
        this.getInfectionInstanceCustomizer().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                InstallationInstanceConfigPanel.this.checkEnableStartup();
            }
        });
        this.getJComboBoxInstance().setModel(this.instanceComboModel);
    }

    private JPanel getJPanel6() {
        if (this.jPanel6 == null) {
            GridBagConstraints gridBagConstraints44 = new GridBagConstraints();
            gridBagConstraints44.gridx = 1;
            gridBagConstraints44.weightx = 1.0;
            gridBagConstraints44.anchor = 15;
            gridBagConstraints44.gridy = 0;
            GridBagConstraints gridBagConstraints49 = new GridBagConstraints();
            gridBagConstraints49.gridx = 0;
            gridBagConstraints49.weightx = 0.0;
            gridBagConstraints49.anchor = 16;
            gridBagConstraints49.gridy = 0;
            GridBagConstraints gridBagConstraints39 = new GridBagConstraints();
            gridBagConstraints39.anchor = 17;
            gridBagConstraints39.gridx = 2;
            gridBagConstraints39.gridy = -1;
            gridBagConstraints39.insets = new Insets(0, 0, 0, 0);
            this.jPanel6 = new JPanel();
            this.jPanel6.setLayout(new GridBagLayout());
            this.jPanel6.add((Component)this.getJPanel14(), gridBagConstraints39);
            this.jPanel6.add((Component)this.getJPanel13(), gridBagConstraints49);
            this.jPanel6.add((Component)this.getJPanel10(), gridBagConstraints44);
        }
        return this.jPanel6;
    }

    private JPanel getJPanel15() {
        if (this.jPanel15 == null) {
            GridBagConstraints gridBagConstraints95 = new GridBagConstraints();
            gridBagConstraints95.gridx = 3;
            gridBagConstraints95.insets = new Insets(0, 4, 0, 0);
            gridBagConstraints95.gridy = 0;
            GridBagConstraints gridBagConstraints42 = new GridBagConstraints();
            gridBagConstraints42.insets = new Insets(0, 0, 0, 5);
            gridBagConstraints42.gridx = 0;
            gridBagConstraints42.gridy = 0;
            this.jLabel6 = new JLabel();
            this.jLabel6.setText("Instance:");
            GridBagConstraints gridBagConstraints54 = new GridBagConstraints();
            gridBagConstraints54.gridx = 2;
            gridBagConstraints54.insets = new Insets(0, 4, 0, 5);
            gridBagConstraints54.gridy = 0;
            GridBagConstraints gridBagConstraints51 = new GridBagConstraints();
            gridBagConstraints51.fill = 2;
            gridBagConstraints51.gridy = 0;
            gridBagConstraints51.weightx = 1.0;
            gridBagConstraints51.insets = new Insets(0, 8, 0, 5);
            gridBagConstraints51.gridx = 1;
            this.jPanel15 = new JPanel();
            this.jPanel15.setLayout(new GridBagLayout());
            this.jPanel15.add((Component)this.getJComboBoxInstance(), gridBagConstraints51);
            this.jPanel15.add((Component)this.getJButtonInstanceBrowse(), gridBagConstraints54);
            this.jPanel15.add((Component)this.jLabel6, gridBagConstraints42);
            this.jPanel15.add((Component)this.getJButtonInstanceNew(), gridBagConstraints95);
        }
        return this.jPanel15;
    }

    private JPanel getJPanel28() {
        if (this.jPanel28 == null) {
            GridBagConstraints gridBagConstraints41 = new GridBagConstraints();
            gridBagConstraints41.fill = 1;
            gridBagConstraints41.gridx = -1;
            gridBagConstraints41.gridy = -1;
            gridBagConstraints41.weightx = 1.0;
            gridBagConstraints41.weighty = 1.0;
            gridBagConstraints41.insets = new Insets(0, 0, 1, 1);
            this.jPanel28 = new JPanel();
            this.jPanel28.setLayout(new GridBagLayout());
            this.jPanel28.setBorder(BorderFactory.createEtchedBorder(1));
            this.jPanel28.add((Component)this.getInfectionInstanceCustomizer(), gridBagConstraints41);
        }
        return this.jPanel28;
    }

    private JPanel getJPanel14() {
        if (this.jPanel14 == null) {
            GridBagConstraints gridBagConstraints76 = new GridBagConstraints();
            gridBagConstraints76.gridx = 0;
            gridBagConstraints76.insets = new Insets(4, 4, 4, 10);
            gridBagConstraints76.anchor = 15;
            gridBagConstraints76.gridy = 0;
            GridBagConstraints gridBagConstraints45 = new GridBagConstraints();
            gridBagConstraints45.insets = new Insets(4, 4, 4, 0);
            gridBagConstraints45.gridy = 0;
            gridBagConstraints45.gridx = 1;
            this.jPanel14 = new JPanel();
            this.jPanel14.setLayout(new GridBagLayout());
            this.jPanel14.setOpaque(false);
            this.jPanel14.add((Component)this.getJButtonInstanceStartup(), gridBagConstraints45);
            this.jPanel14.add((Component)this.getJCheckBoxKeepOpen(), gridBagConstraints76);
        }
        return this.jPanel14;
    }

    private JPanel getJPanel13() {
        if (this.jPanel13 == null) {
            GridBagConstraints gridBagConstraints70 = new GridBagConstraints();
            gridBagConstraints70.gridx = 0;
            gridBagConstraints70.insets = new Insets(4, 0, 4, 24);
            gridBagConstraints70.gridy = 0;
            GridBagConstraints gridBagConstraints55 = new GridBagConstraints();
            gridBagConstraints55.gridx = 4;
            gridBagConstraints55.insets = new Insets(4, 0, 4, 4);
            gridBagConstraints55.gridy = 0;
            GridBagConstraints gridBagConstraints53 = new GridBagConstraints();
            gridBagConstraints53.gridx = 3;
            gridBagConstraints53.insets = new Insets(4, 0, 4, 5);
            gridBagConstraints53.gridy = 0;
            GridBagConstraints gridBagConstraints50 = new GridBagConstraints();
            gridBagConstraints50.gridx = 2;
            gridBagConstraints50.insets = new Insets(4, 0, 4, 5);
            gridBagConstraints50.gridy = 0;
            GridBagConstraints gridBagConstraints60 = new GridBagConstraints();
            gridBagConstraints60.gridx = 1;
            gridBagConstraints60.insets = new Insets(4, 0, 4, 5);
            gridBagConstraints60.gridy = 0;
            this.jPanel13 = new JPanel();
            this.jPanel13.setLayout(new GridBagLayout());
            this.jPanel13.setOpaque(false);
            this.jPanel13.add((Component)this.getJButtonInstanceTest(), gridBagConstraints60);
            this.jPanel13.add((Component)this.getJButtonInstanceSave(), gridBagConstraints50);
            this.jPanel13.add((Component)this.getJButtonInstanceSaveAs(), gridBagConstraints53);
            this.jPanel13.add((Component)this.getJButtonInstanceReset(), gridBagConstraints55);
            this.jPanel13.add((Component)this.getJButton2(), gridBagConstraints70);
        }
        return this.jPanel13;
    }

    private JPanel getJPanel10() {
        if (this.jPanel10 == null) {
            this.jPanel10 = new JPanel();
            this.jPanel10.setLayout(new GridBagLayout());
        }
        return this.jPanel10;
    }

    private JComboBox getJComboBoxInstance() {
        if (this.jComboBoxInstance == null) {
            this.jComboBoxInstance = new JComboBox();
            this.jComboBoxInstance.setOpaque(false);
            this.jComboBoxInstance.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    InstallationInstanceConfigPanel.this.handleInstanceSelected();
                }
            });
        }
        return this.jComboBoxInstance;
    }

    private JButton getJButtonInstanceBrowse() {
        if (this.jButtonInstanceBrowse == null) {
            this.jButtonInstanceBrowse = new JButton();
            this.jButtonInstanceBrowse.setText("");
            this.jButtonInstanceBrowse.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/infection/icons/search.gif")));
            this.jButtonInstanceBrowse.setToolTipText("Browse existing instance...");
            this.jButtonInstanceBrowse.setPreferredSize(new Dimension(25, 25));
            this.jButtonInstanceBrowse.setMargin(new Insets(2, 2, 2, 2));
            this.jButtonInstanceBrowse.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InstallationInstanceConfigPanel.this.actionInstanceBrowse();
                }
            });
        }
        return this.jButtonInstanceBrowse;
    }

    private JButton getJButtonInstanceNew() {
        if (this.jButtonInstanceNew == null) {
            this.jButtonInstanceNew = new JButton();
            this.jButtonInstanceNew.setToolTipText("Create new instance...");
            this.jButtonInstanceNew.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/infection/icons/source.gif")));
            this.jButtonInstanceNew.setMargin(new Insets(2, 2, 2, 2));
            this.jButtonInstanceNew.setText("");
            this.jButtonInstanceNew.setPreferredSize(new Dimension(25, 25));
            this.jButtonInstanceNew.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InstallationInstanceConfigPanel.this.actionInstanceNew();
                }
            });
        }
        return this.jButtonInstanceNew;
    }

    protected InstanceCustomizer getInfectionInstanceCustomizer() {
        if (this.infectionInstanceCustomizer == null) {
            this.infectionInstanceCustomizer = new InstanceCustomizer();
            this.infectionInstanceCustomizer.setOpaque(false);
        }
        return this.infectionInstanceCustomizer;
    }

    private JButton getJButtonInstanceStartup() {
        if (this.jButtonInstanceStartup == null) {
            this.jButtonInstanceStartup = new JButton();
            this.jButtonInstanceStartup.setMargin(new Insets(2, 4, 2, 12));
            this.jButtonInstanceStartup.setEnabled(true);
            this.jButtonInstanceStartup.setToolTipText("Startup platform instance..");
            this.jButtonInstanceStartup.setText(" Start");
            this.jButtonInstanceStartup.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InstallationInstanceConfigPanel.this.actionInstanceStartup();
                }
            });
        }
        return this.jButtonInstanceStartup;
    }

    private JCheckBox getJCheckBoxKeepOpen() {
        if (this.jCheckBoxKeepOpen == null) {
            this.jCheckBoxKeepOpen = new JCheckBox();
            this.jCheckBoxKeepOpen.setText("Keep dialog");
            this.jCheckBoxKeepOpen.setOpaque(false);
            this.jCheckBoxKeepOpen.setToolTipText("Keep dialog open ?");
        }
        return this.jCheckBoxKeepOpen;
    }

    private JButton getJButtonInstanceTest() {
        if (this.jButtonInstanceTest == null) {
            this.jButtonInstanceTest = new JButton();
            this.jButtonInstanceTest.setText("Test");
            this.jButtonInstanceTest.setToolTipText("Test instance configuration");
            this.jButtonInstanceTest.setMargin(new Insets(2, 4, 2, 4));
            this.jButtonInstanceTest.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InstallationInstanceConfigPanel.this.actionInstanceTest(true);
                }
            });
        }
        return this.jButtonInstanceTest;
    }

    private JButton getJButtonInstanceSave() {
        if (this.jButtonInstanceSave == null) {
            this.jButtonInstanceSave = new JButton();
            this.jButtonInstanceSave.setText("Save");
            this.jButtonInstanceSave.setToolTipText("Save instance configuration");
            this.jButtonInstanceSave.setMargin(new Insets(2, 4, 2, 4));
            this.jButtonInstanceSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InstallationInstanceConfigPanel.this.actionInstanceSave();
                }
            });
        }
        return this.jButtonInstanceSave;
    }

    private JButton getJButtonInstanceSaveAs() {
        if (this.jButtonInstanceSaveAs == null) {
            this.jButtonInstanceSaveAs = new JButton();
            this.jButtonInstanceSaveAs.setText("Save as..");
            this.jButtonInstanceSaveAs.setToolTipText("Save instance configuration as ..");
            this.jButtonInstanceSaveAs.setMargin(new Insets(2, 4, 2, 4));
            this.jButtonInstanceSaveAs.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InstallationInstanceConfigPanel.this.actionInstanceSaveAs();
                }
            });
        }
        return this.jButtonInstanceSaveAs;
    }

    private JButton getJButtonInstanceReset() {
        if (this.jButtonInstanceReset == null) {
            this.jButtonInstanceReset = new JButton();
            this.jButtonInstanceReset.setText("Reset");
            this.jButtonInstanceReset.setToolTipText("Reload instance configuration from file");
            this.jButtonInstanceReset.setMargin(new Insets(2, 4, 2, 4));
            this.jButtonInstanceReset.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InstallationInstanceConfigPanel.this.actionInstanceReset();
                }
            });
        }
        return this.jButtonInstanceReset;
    }

    private JButton getJButton2() {
        if (this.jButton2 == null) {
            this.jButton2 = new JButton();
            this.jButton2.setToolTipText("Back to main menu..");
            this.jButton2.setText("< Menu");
            this.jButton2.setMargin(new Insets(2, 4, 2, 4));
            this.jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InstallationInstanceConfigPanel.this.actionInstancePrev();
                }
            });
        }
        return this.jButton2;
    }

    public InstallerBanner getInfectionBanner() {
        if (this.infectionBanner == null) {
            this.infectionBanner = new InstallerBanner();
            this.infectionBanner.setTitle("Configuration");
            this.infectionBanner.setForeground(Color.WHITE);
        }
        return this.infectionBanner;
    }

    @Override
    protected void refresh() {
        this.decorateBanner(this.getInfectionBanner());
        this.refreshInstances();
    }

    protected void refreshInstances() {
        String currentInstancePath = null;
        if (this.access != null && this.access instanceof InfectionRuntimeFacade) {
            try {
                Infection infection = Infection.getInstance();
                File f = infection.getInfectionAccess().getInstanceConfigFile(this.access);
                if (f != null) {
                    currentInstancePath = f.getPath();
                }
            }
            catch (Exception e) {
                this.handleException(e, logger);
            }
        }
        this.instanceComboModel.removeAllElements();
        if (this.installer != null) {
            File selectedInstanceFile = null;
            try {
                logger.info("Refresh instances...");
                InfectionIndex index = this.installationIndex;
                int num = index.getInstanceCount();
                logger.info("Number of instances: " + num);
                for (int i = 0; i < num; ++i) {
                    String path = index.getInstancePathAt(i);
                    File instanceFile = new File(path);
                    logger.info(" - Instance: " + instanceFile);
                    this.instanceComboModel.addElement(instanceFile);
                    File absoluteInstanceFile = this.installer.resolveInstanceConfigFile(this.installation, path);
                    if (!absoluteInstanceFile.getPath().equals(currentInstancePath)) continue;
                    selectedInstanceFile = instanceFile;
                }
            }
            catch (Exception e) {
                this.handleException(e, logger);
            }
            if (this.instanceComboModel.getSize() == 0) {
                File indexDir = this.installation.getIndexDirectory();
                File installDir = indexDir.getParentFile();
                if (installDir == null) {
                    installDir = new File(".");
                }
                File instanceDir = new File(installDir, "instance");
                File instanceFile = new File(instanceDir, "instance.xml");
                File relativeFile = InfectionUtil.getRelativeFile(instanceFile, indexDir);
                this.instanceComboModel.addElement(relativeFile);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Default instance: " + relativeFile);
                }
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Current instance: " + selectedInstanceFile);
            }
            if (selectedInstanceFile != null) {
                this.instanceComboModel.setSelectedItem(selectedInstanceFile);
            }
        }
    }

    protected void loadInstanceConfig(File file) throws Exception {
        logger.info("Load instance: " + file);
        this.instance = new InfectionInstance(file);
        Infection infection = Infection.getInstance();
        String distArtifactName = this.instance.getDistributionName();
        if (distArtifactName == null) {
            distArtifactName = infection.getDistributionProperty("artifact");
            this.instance.setDistributionName(distArtifactName);
        }
        ArtifactDependency[] deps = this.installer.getDistributionArtifactDependencies(distArtifactName);
        InstanceCustomizer custom = this.getInfectionInstanceCustomizer();
        custom.setInstallation(this.installation);
        custom.setInstaller(this.installer);
        custom.setIndex(this.installationIndex);
        custom.setInstance(this.instance);
        custom.setDependencies(deps);
        custom.refresh();
    }

    protected void handleInstanceSelected() {
        try {
            Object item = this.getJComboBoxInstance().getSelectedItem();
            if (item == null) {
                return;
            }
            if (this.instance != null && this.selectedInstanceItem == item) {
                return;
            }
            this.selectedInstanceItem = item;
            File configFile = (File)item;
            configFile = this.installer.resolveInstanceConfigFile(this.installation, configFile.getPath());
            this.loadInstanceConfig(configFile);
            if (!configFile.exists()) {
                String distJvmArgs = Infection.getInstance().getDistributionProperty("jvmargs");
                if (distJvmArgs != null && (distJvmArgs = distJvmArgs.trim()).length() > 0) {
                    this.instance.addJavaOption(distJvmArgs);
                    this.getInfectionInstanceCustomizer().refreshJvmOptions();
                }
                this.getInfectionInstanceCustomizer().selectAllArtifacts(true);
            }
            logger.info("Checking for new artifacts...");
            Artifact[] newArtifacts = this.getInfectionInstanceCustomizer().checkNewArtifacts();
            if (newArtifacts != null && newArtifacts.length > 0) {
                int num = newArtifacts.length;
                logger.fine("Number of new artifacts: " + num);
                HashMap<String, Artifact> latestVersions = new HashMap<String, Artifact>();
                for (int c = 0; c < num; ++c) {
                    Artifact art = newArtifacts[c];
                    String artName = art.getName();
                    Artifact a1 = (Artifact)latestVersions.get(artName);
                    if (a1 != null) {
                        String artVersion = art.getVersion();
                        String v1 = a1.getVersion();
                        if (artVersion != null && artVersion.compareTo(v1) <= 0) continue;
                    }
                    latestVersions.put(artName, art);
                }
                num = latestVersions.size();
                if (num > 0) {
                    TreeMap<String, Artifact> sortedArtifacts = new TreeMap<String, Artifact>();
                    for (Artifact art : latestVersions.values()) {
                        String name = art.getName();
                        sortedArtifacts.put(name, art);
                    }
                    boolean doUpgrade = true;
                    if (this.promptUpgrade) {
                        this.getInfectionInstanceCustomizer().showTabArtifacts();
                        String title = "Upgrade instance ?";
                        String message = "New artifacts are available: " + num;
                        message = message + "\n\nDo you want to upgrade the configuration ?";
                        int optionType = 2;
                        int messageType = 3;
                        Component parentComponent = null;
                        int rc = JOptionPane.showConfirmDialog(parentComponent, message, title, optionType, messageType);
                        boolean bl = doUpgrade = rc == 0;
                    }
                    if (doUpgrade) {
                        for (Artifact art : sortedArtifacts.values()) {
                            String name = art.getName();
                            String version = art.getVersion();
                            logger.finer("Resolve artifact: " + name + " (" + version + ")");
                            ArtifactDependency dep = new ArtifactDependency(name, version);
                            ArrayList queue = new ArrayList();
                            boolean autoDeselect = true;
                            this.getInfectionInstanceCustomizer().resolveDependency(dep, queue, autoDeselect);
                        }
                        if (this.isAutoSaveConfig()) {
                            int errorCount = this.getInfectionInstanceCustomizer().getErrorCount();
                            if (errorCount <= 0) {
                                Infection infection;
                                InfectionAccess access;
                                InfectionRuntime runtime;
                                this.actionInstanceSave();
                                if (this.isPromptRestart() && (runtime = (access = (infection = Infection.getInstance()).getInfectionAccess()).getRuntimeInstance(this.instance)) != null) {
                                    int messageType;
                                    int optionType;
                                    String title = "Restart ?";
                                    String message = "New software updates were applied to the configuration.";
                                    int rc = JOptionPane.showConfirmDialog(this, message = message + "\nDo you want to restart the application now ?", title, optionType = 0, messageType = 3);
                                    if (rc == 0) {
                                        this.actionInstanceStartup();
                                        return;
                                    }
                                }
                            } else {
                                this.getPageContext().showConfigPage();
                            }
                        }
                    }
                }
            }
            this.checkEnableStartup();
            List missingArtifacts = this.getInfectionInstanceCustomizer().getMissingArtifacts();
            int missingArtifactCount = missingArtifacts.size();
            if (missingArtifactCount > 0) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Missing artifacts: " + missingArtifactCount);
                }
                this.getInfectionInstanceCustomizer().showTabArtifacts();
                String title = "Configuration Problem";
                String message = "Missing " + missingArtifactCount + " artifact(s).";
                message = message + "\n\nDo you want to open the installation dialog ?";
                int optionType = 0;
                int messageType = 2;
                int rc = JOptionPane.showConfirmDialog(this, message, title, optionType, messageType);
                if (rc == 0) {
                    this.getPageContext().showUpdatePage();
                    return;
                }
            }
        }
        catch (Exception e) {
            this.handleException(e, logger);
        }
    }

    protected void actionInstanceBrowse() {
        try {
            int index;
            File configFile;
            int rc;
            File installDir;
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setDialogTitle("Browse Instance");
            fileChooser.setDialogType(0);
            fileChooser.setFileSelectionMode(2);
            fileChooser.setMultiSelectionEnabled(false);
            fileChooser.setFileFilter(new InstanceConfigFileFilter());
            File indexDir = this.installation.getIndexDirectory();
            File currentDir = installDir = indexDir == null ? null : indexDir.getParentFile();
            if (currentDir != null) {
                fileChooser.setCurrentDirectory(currentDir);
            }
            if ((rc = fileChooser.showOpenDialog(this)) != 0) {
                return;
            }
            File file = fileChooser.getSelectedFile();
            if (file == null) {
                return;
            }
            if (file.exists() && file.isDirectory() && (configFile = new File(file, "instance.xml")).exists()) {
                file = configFile;
            }
            if ((index = this.instanceComboModel.getIndexOf(file = InfectionUtil.getRelativeFile(file, indexDir))) >= 0) {
                this.getJComboBoxInstance().setSelectedIndex(index);
            } else {
                this.instanceComboModel.addElement(file);
                this.getJComboBoxInstance().setSelectedItem(file);
            }
        }
        catch (Exception e) {
            this.handleException(e, logger);
        }
    }

    protected void actionInstanceNew() {
        try {
            File relativeFile;
            int x;
            int rc;
            File installDir;
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setDialogTitle("Create Instance");
            fileChooser.setDialogType(1);
            fileChooser.setFileSelectionMode(2);
            fileChooser.setMultiSelectionEnabled(false);
            fileChooser.setFileFilter(new InstanceConfigFileFilter());
            File indexDir = this.installation.getIndexDirectory();
            File currentDir = installDir = indexDir == null ? null : indexDir.getParentFile();
            if (currentDir != null) {
                fileChooser.setCurrentDirectory(currentDir);
            }
            String availName = this.nextAvailableInstanceName();
            logger.fine("nextAvailableInstanceName: " + availName);
            if (availName != null) {
                fileChooser.setSelectedFile(new File(availName));
            }
            if ((rc = fileChooser.showSaveDialog(this)) != 0) {
                return;
            }
            File file = fileChooser.getSelectedFile();
            if (file == null) {
                return;
            }
            String instanceName = file.getName();
            File absoluteDir = InfectionUtil.getAbsoluteFile(file, installDir);
            if (absoluteDir.exists()) {
                throw new Exception("The instance directory already exists: " + absoluteDir);
            }
            File relativeDir = InfectionUtil.getRelativeFile(absoluteDir, indexDir);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("createInstance: name=" + instanceName + ", relativeDir=" + relativeDir + ", absoluteDir=" + absoluteDir);
            }
            if ((x = this.instanceComboModel.getIndexOf(relativeFile = new File(relativeDir, "instance.xml"))) >= 0) {
                this.getJComboBoxInstance().setSelectedIndex(x);
            } else {
                this.instanceComboModel.addElement(relativeFile);
                this.getJComboBoxInstance().setSelectedItem(relativeFile);
            }
        }
        catch (Exception e) {
            this.handleException(e, logger);
        }
    }

    protected String nextAvailableInstanceName() {
        File indexDir = this.installation.getIndexDirectory();
        File installDir = indexDir.getParentFile();
        String prefix = "instance";
        for (int i = 2; i <= 1000; ++i) {
            File dir = new File(installDir, prefix + i);
            if (dir.exists()) continue;
            return dir.getName();
        }
        return prefix;
    }

    protected void actionInstanceReset() {
        this.instance = null;
        this.handleInstanceSelected();
    }

    protected boolean actionInstanceSave() {
        try {
            boolean success;
            InstanceCustomizer custom = this.getInfectionInstanceCustomizer();
            if (custom.isTestRequired() && !(success = this.actionInstanceTest(false))) {
                return false;
            }
            File instanceFile = (File)this.getJComboBoxInstance().getSelectedItem();
            instanceFile = this.installer.resolveInstanceConfigFile(this.installation, instanceFile.getPath());
            this.instance.setInstanceFile(instanceFile);
            this.saveInstanceConfig();
            return true;
        }
        catch (Exception e) {
            this.handleException(e, logger);
            return false;
        }
    }

    protected void actionInstanceSaveAs() {
        File installDir;
        File origInstanceFile = (File)this.getJComboBoxInstance().getSelectedItem();
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle("Save instance as...");
        fileChooser.setDialogType(1);
        fileChooser.setFileSelectionMode(0);
        fileChooser.setMultiSelectionEnabled(false);
        File indexDir = this.installation.getIndexDirectory();
        File currentDir = installDir = indexDir.getParentFile();
        if (currentDir != null) {
            fileChooser.setCurrentDirectory(currentDir);
        }
        fileChooser.setSelectedFile(origInstanceFile);
        int rc = fileChooser.showSaveDialog(null);
        if (rc != 0) {
            return;
        }
        try {
            File file = fileChooser.getSelectedFile();
            if (file == null) {
                return;
            }
            if (file.exists() && file.isDirectory()) {
                return;
            }
            this.instance.setInstanceFile(file);
            this.saveInstanceConfig();
            this.getJComboBoxInstance().addItem(file);
            this.getJComboBoxInstance().setSelectedItem(file);
        }
        catch (Exception e) {
            this.handleException(e, logger);
        }
    }

    private void saveInstanceConfig() throws Exception {
        this.installer.saveInstance(this.installation, this.installationIndex, this.instance);
    }

    protected boolean actionInstanceTest(boolean successMessage) {
        InstanceCustomizer custom = this.getInfectionInstanceCustomizer();
        try {
            custom.testJavaOptions();
            if (successMessage) {
                String title = "Java Runtime Test Successful";
                String message = "Java Options tested successfully.";
                int messageType = 1;
                JOptionPane.showMessageDialog(custom, message, title, messageType);
            }
            return true;
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            String title = "Java Runtime Test Failed !";
            String message = "Java Runtime test failed with the following error:\n\n" + e.getMessage() + "\n\n";
            message = message + "(The log file may contain more details.) \n";
            message = message + "Please correct the Java Runtime and Java Options settings!\n";
            int messageType = 0;
            JOptionPane.showMessageDialog(custom, message, title, messageType);
            return false;
        }
    }

    protected void checkEnableStartup() {
        int errorCount;
        int num;
        boolean enable = false;
        if (this.instance != null && (num = this.instance.getArtifactCount()) > 0 && (errorCount = this.getInfectionInstanceCustomizer().getErrorCount()) < 1) {
            enable = true;
        }
        boolean instanceRunning = false;
        try {
            Infection infection = Infection.getInstance();
            InfectionAccess access = infection.getInfectionAccess();
            InfectionRuntime runtime = access.getRuntimeInstance(this.instance);
            if (runtime != null) {
                instanceRunning = true;
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        this.getJButtonInstanceSave().setEnabled(enable);
        this.getJButtonInstanceStartup().setEnabled(enable);
        if (instanceRunning) {
            this.getJButtonInstanceStartup().setIcon(this.iconRestart);
            this.getJButtonInstanceStartup().setText("Restart");
            this.getJCheckBoxKeepOpen().setEnabled(false);
            this.getJCheckBoxKeepOpen().setSelected(false);
        } else {
            this.getJButtonInstanceStartup().setIcon(this.iconStart);
            this.getJButtonInstanceStartup().setText("Start");
            this.getJCheckBoxKeepOpen().setEnabled(true);
        }
        this.validate();
        this.repaint();
    }

    protected void actionInstanceStartup() {
        block7: {
            try {
                if (!this.actionInstanceSave()) {
                    return;
                }
                final HashMap props = new HashMap();
                Infection infection = Infection.getInstance();
                final InfectionAccess access = infection.getInfectionAccess();
                final InfectionRuntime runtime = access.getRuntimeInstance(this.instance);
                if (runtime == null) {
                    logger.info("Starting instance runtime: " + this.instance);
                    try {
                        access.startInfectionRuntime(this.installation, this.installationIndex, this.instance, props);
                    }
                    catch (Throwable e) {
                        logger.log(Level.SEVERE, e.getMessage(), e);
                        ErrorDialog.showErrorDialog(e);
                        return;
                    }
                    if (!this.getJCheckBoxKeepOpen().isSelected()) {
                        this.getPageContext().actionCancel();
                    }
                    break block7;
                }
                logger.info("Restarting instance runtime: " + this.instance);
                Runnable target = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            access.restartInfectionRuntime(runtime, InstallationInstanceConfigPanel.this.installation, InstallationInstanceConfigPanel.this.installationIndex, InstallationInstanceConfigPanel.this.instance, props);
                        }
                        catch (Throwable e) {
                            logger.log(Level.SEVERE, e.getMessage(), e);
                            ErrorDialog.showErrorDialog(e);
                            return;
                        }
                    }
                };
                String title = "InfectionRestart";
                new Thread(target, title).start();
            }
            catch (Throwable e) {
                this.handleException(e, logger);
            }
        }
    }

    protected void actionInstancePrev() {
        this.getPageContext().actionBack();
    }

    protected InfectionRuntime getAccess() {
        return this.access;
    }

    protected void setAccess(InfectionRuntime access) {
        this.access = access;
    }

    protected InfectionInstaller getInstaller() {
        return this.installer;
    }

    protected void setInstaller(InfectionInstaller installer) {
        this.installer = installer;
    }

    protected InfectionInstallation getInstallation() {
        return this.installation;
    }

    protected void setInstallation(InfectionInstallation installation) {
        this.installation = installation;
    }

    protected InfectionIndex getInstallationIndex() {
        return this.installationIndex;
    }

    protected void setInstallationIndex(InfectionIndex installationIndex) {
        this.installationIndex = installationIndex;
    }

    protected boolean isPromptUpgrade() {
        return this.promptUpgrade;
    }

    protected void setPromptUpgrade(boolean promptUpgrade) {
        this.promptUpgrade = promptUpgrade;
    }

    protected boolean isPromptRestart() {
        return this.promptRestart;
    }

    protected void setPromptRestart(boolean promptRestart) {
        this.promptRestart = promptRestart;
    }

    protected boolean isAutoSaveConfig() {
        return this.autoSaveConfig;
    }

    protected void setAutoSaveConfig(boolean autoSaveConfig) {
        this.autoSaveConfig = autoSaveConfig;
    }

    public static class InstanceConfigFileFilter
    extends FileFilter {
        @Override
        public String getDescription() {
            return "Instance Config Files (instance.xml)";
        }

        @Override
        public boolean accept(File f) {
            if ("instance.xml".equals(f.getName())) {
                return true;
            }
            return f.isDirectory();
        }
    }
}

