/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.swing;

import com.spacekiller.infection.install.InstallerPageContext;
import com.spacekiller.infection.swing.InstallerBanner;
import com.spacekiller.infection.swing.InstallerPagePanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class InstallationLicenseAcceptPanel
extends InstallerPagePanel {
    private static final long serialVersionUID = 9137969351740815825L;
    private static final Logger logger = Logger.getLogger(InstallationLicenseAcceptPanel.class.getName());
    private boolean licenseAccepted;
    private boolean refreshing;
    private JPanel jPanelLicense = null;
    private JPanel jPanel2 = null;
    private JScrollPane jScrollPane1 = null;
    private JTextArea jTextAreaLicense = null;
    private JCheckBox jCheckBoxAcceptLicense = null;
    private InstallerBanner infectionBanner;
    private JButton buttonNext;

    public InstallationLicenseAcceptPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{450, 0};
        gridBagLayout.rowHeights = new int[]{300, 0};
        gridBagLayout.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        GridBagConstraints gbc_jPanelLicense = new GridBagConstraints();
        gbc_jPanelLicense.weighty = 1.0;
        gbc_jPanelLicense.weightx = 1.0;
        gbc_jPanelLicense.fill = 1;
        gbc_jPanelLicense.gridx = 0;
        gbc_jPanelLicense.gridy = 0;
        this.add((Component)this.getJPanelLicense(), gbc_jPanelLicense);
        this.initLicenseAcceptPanel();
    }

    private JPanel getJPanelLicense() {
        if (this.jPanelLicense == null) {
            GridBagConstraints gridBagConstraints22 = new GridBagConstraints();
            gridBagConstraints22.gridx = 0;
            gridBagConstraints22.gridwidth = 2;
            gridBagConstraints22.fill = 2;
            gridBagConstraints22.insets = new Insets(0, 0, 5, 0);
            gridBagConstraints22.gridy = 0;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.fill = 1;
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.anchor = 17;
            gridBagConstraints6.gridy = 2;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.fill = 1;
            gridBagConstraints4.gridy = 1;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.weighty = 1.0;
            gridBagConstraints4.insets = new Insets(4, 4, 5, 4);
            gridBagConstraints4.gridx = 0;
            this.jPanelLicense = new JPanel();
            this.jPanelLicense.setLayout(new GridBagLayout());
            this.jPanelLicense.setSize(new Dimension(452, 304));
            GridBagConstraints gbc_infectionBanner = new GridBagConstraints();
            gbc_infectionBanner.fill = 2;
            gbc_infectionBanner.gridx = 0;
            gbc_infectionBanner.gridy = 0;
            this.jPanelLicense.add((Component)this.getInfectionBanner(), gbc_infectionBanner);
            this.jPanelLicense.add((Component)this.getJScrollPane1(), gridBagConstraints4);
            this.jPanelLicense.add((Component)this.getJPanel2(), gridBagConstraints6);
        }
        return this.jPanelLicense;
    }

    private JScrollPane getJScrollPane1() {
        if (this.jScrollPane1 == null) {
            this.jScrollPane1 = new JScrollPane();
            this.jScrollPane1.setViewportView(this.getJTextAreaLicense());
        }
        return this.jScrollPane1;
    }

    private JTextArea getJTextAreaLicense() {
        if (this.jTextAreaLicense == null) {
            this.jTextAreaLicense = new JTextArea();
            this.jTextAreaLicense.setEditable(false);
        }
        return this.jTextAreaLicense;
    }

    private JPanel getJPanel2() {
        if (this.jPanel2 == null) {
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 0;
            this.jPanel2 = new JPanel();
            this.jPanel2.setLayout(new GridBagLayout());
            this.jPanel2.add((Component)this.getJCheckBoxAcceptLicense(), gridBagConstraints3);
            GridBagConstraints gbc_buttonNext = new GridBagConstraints();
            gbc_buttonNext.insets = new Insets(4, 4, 4, 4);
            gbc_buttonNext.weightx = 1.0;
            gbc_buttonNext.anchor = 13;
            gbc_buttonNext.gridx = 1;
            gbc_buttonNext.gridy = 0;
            this.jPanel2.add((Component)this.getButtonNext(), gbc_buttonNext);
        }
        return this.jPanel2;
    }

    private JCheckBox getJCheckBoxAcceptLicense() {
        if (this.jCheckBoxAcceptLicense == null) {
            this.jCheckBoxAcceptLicense = new JCheckBox();
            this.jCheckBoxAcceptLicense.setText("I accept the terms of use");
            this.jCheckBoxAcceptLicense.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    InstallationLicenseAcceptPanel.this.handleAcceptLicenseChanged();
                }
            });
        }
        return this.jCheckBoxAcceptLicense;
    }

    private InstallerBanner getInfectionBanner() {
        if (this.infectionBanner == null) {
            this.infectionBanner = new InstallerBanner();
            this.infectionBanner.setTitle("License");
            this.infectionBanner.setForeground(Color.WHITE);
        }
        return this.infectionBanner;
    }

    protected void initLicenseAcceptPanel() {
        int normalFontSize = 14;
        Font font = this.getJTextAreaLicense().getFont();
        if (font != null) {
            normalFontSize = font.getSize();
        }
        this.getJTextAreaLicense().setFont(new Font("Monospaced", 0, normalFontSize));
        this.refresh();
    }

    protected final synchronized boolean isLicenseAccepted() {
        return this.licenseAccepted;
    }

    final synchronized boolean isLicenseAcceptedProtected() {
        return this.licenseAccepted;
    }

    private final synchronized void setLicenseAccepted(boolean licenseAccepted) {
        if (this.licenseAccepted == licenseAccepted) {
            return;
        }
        this.licenseAccepted = licenseAccepted;
        this.checkEnable();
    }

    protected void checkEnable() {
        boolean licenseAccepted = this.isLicenseAccepted();
        this.getJCheckBoxAcceptLicense().setSelected(licenseAccepted);
        this.getButtonNext().setEnabled(licenseAccepted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void refresh() {
        block6: {
            try {
                this.refreshing = true;
                this.decorateBanner(this.getInfectionBanner());
                InstallerPageContext context = this.getPageContext();
                if (context == null) break block6;
                String licenseText = null;
                try {
                    licenseText = context.getDistributionLicenseText();
                }
                catch (Exception e) {
                    this.handleException(e, logger);
                }
                if (licenseText == null) {
                    licenseText = "N/A";
                }
                this.getJTextAreaLicense().setText(licenseText);
                this.getJTextAreaLicense().setCaretPosition(0);
            }
            finally {
                this.refreshing = false;
            }
        }
        this.checkEnable();
    }

    protected void handleAcceptLicenseChanged() {
        if (this.refreshing) {
            return;
        }
        boolean accepted = this.getJCheckBoxAcceptLicense().isSelected();
        this.setLicenseAccepted(accepted);
    }

    private JButton getButtonNext() {
        if (this.buttonNext == null) {
            this.buttonNext = new JButton();
            this.buttonNext.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InstallationLicenseAcceptPanel.this.actionNext();
                }
            });
            this.buttonNext.setText("Next >");
            this.buttonNext.setMargin(new Insets(2, 4, 2, 4));
        }
        return this.buttonNext;
    }

    protected void actionNext() {
        InstallerPageContext context = this.getPageContext();
        if (context == null) {
            return;
        }
        if (!this.isLicenseAcceptedProtected()) {
            return;
        }
        context.actionNext();
    }
}

