/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.swing;

import com.spacekiller.infection.Artifact;
import com.spacekiller.infection.ArtifactDependency;
import com.spacekiller.infection.Infection;
import com.spacekiller.infection.InfectionIndex;
import com.spacekiller.infection.InfectionInstallation;
import com.spacekiller.infection.InfectionInstaller;
import com.spacekiller.infection.InfectionInstance;
import com.spacekiller.infection.InfectionRuntimeImpl;
import com.spacekiller.infection.InfectionSystemProperty;
import com.spacekiller.infection.JavaVM;
import com.spacekiller.infection.install.InstallationArtifactTableModel;
import com.spacekiller.infection.install.JavaRuntimeWizard;
import com.spacekiller.infection.log.LoggingConfig;
import com.spacekiller.infection.old.ErrorDialog;
import com.spacekiller.infection.swing.InstallationArtifactTable;
import com.spacekiller.infection.swing.InstanceLoggingEditor;
import com.spacekiller.infection.swing.InstancePropertiesEditor;
import com.spacekiller.infection.swing.JavaRuntimeWizardPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.Customizer;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class InstanceCustomizer
extends JPanel
implements Customizer {
    private static final long serialVersionUID = 8913722261085657193L;
    protected static final String CLASSLOADER_SINGLE = "Single Class-Loader for all artifacts";
    protected static final String CLASSLOADER_MULTI = "Multiple Class-Loaders (one for each artifact)";
    protected static final String CLASSLOADER_SYSTEM = "System Class-Loader (only use system classpath)";
    protected static final String SECURITY_ENABLED = "Enabled";
    protected static final String SECURITY_DISABLED = "Disabled";
    private static final Logger logger = Logger.getLogger(InstanceCustomizer.class.getName());
    private InfectionInstallation installation;
    private InfectionInstaller installer;
    private InfectionIndex index;
    private InfectionInstance instance;
    private ArtifactDependency[] dependencies;
    private InstallationArtifactTableModel artifacts;
    private ArtifactSelectionListener artifactSelectionListener = new ArtifactSelectionListener();
    private boolean adjusting = false;
    private boolean refreshing = false;
    private boolean testRequired = false;
    private List listErrors;
    private List listWarnings;
    private List missingArtifacts;
    private LoggingConfig loggingConfig;
    private JPanel jPanel1 = null;
    private JPanel jPanelArtifacts = null;
    private JScrollPane jScrollPane = null;
    private InstallationArtifactTable artifactTable = null;
    private JCheckBox jCheckBoxLatestOnly = null;
    private JScrollPane jScrollPane1 = null;
    private JList jListProblems = null;
    private JButton jButton = null;
    private JPanel jPanelProblems = null;
    private JLabel jLabelProblems = null;
    private JCheckBox jCheckBoxResolve = null;
    private JPanel jPanel = null;
    private JCheckBox jCheckBoxDeselect = null;
    private JPanel jPanel3 = null;
    private JTabbedPane jTabbedPane = null;
    private JPanel jPanelClassPath = null;
    private JScrollPane jScrollPane2 = null;
    private JList jListClassPath = null;
    private JScrollPane jScrollPane3 = null;
    private JList jListNative = null;
    private JPanel jPanel4 = null;
    private JButton jButtonClassPathAdd = null;
    private JButton jButtonClassPathRemove = null;
    private JPanel jPanel5 = null;
    private JButton jButtonNativeAdd = null;
    private JButton jButtonNativeRemove = null;
    private JPanel jPanelProperties = null;
    private JPanel jPanelAdvanced = null;
    private JLabel jLabel3 = null;
    private JComboBox jComboBoxClassLoaderPolicy = null;
    private JPanel jPanel7 = null;
    private InstancePropertiesEditor systemPropertyEditor = null;
    private JLabel jLabel4 = null;
    private JPanel jPanelLogging = null;
    private JPanel jPanel8 = null;
    private InstanceLoggingEditor infectionInstanceLoggingEditor = null;
    private JPanel jPanelMain = null;
    private JPanel jPanel2 = null;
    private JTextField jTextFieldCustomMainClass = null;
    private JPanel jPanel9 = null;
    private JPanel jPanel10 = null;
    private JScrollPane jScrollPane4 = null;
    private JTextArea jTextAreaJvmOptions = null;
    private JComboBox jComboBoxJVM = null;
    private JButton jButtonChooseJVM = null;
    private JPanel jPanel12 = null;
    private JCheckBox jCheckBoxCustomMainClass = null;
    private JPanel jPanel13 = null;
    private JPanel jPanel14 = null;
    private JPanel jPanel15 = null;
    private JScrollPane scrollPane;
    private JTextArea textAreaMainArgs;
    private JButton buttonJavaOptionsWizard;

    public InstanceCustomizer() {
        this.initialize();
        this.initInfectionInstanceCustomizer();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.fill = 1;
        gridBagConstraints5.weighty = 1.0;
        gridBagConstraints5.weightx = 1.0;
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(727, 453));
        this.add((Component)this.getJTabbedPane(), gridBagConstraints5);
    }

    @Override
    public void setObject(Object bean) {
        this.setInstance((InfectionInstance)bean);
    }

    public InfectionInstance getInstance() {
        return this.instance;
    }

    public void setInstance(InfectionInstance inst) {
        if (inst == this.instance) {
            return;
        }
        this.instance = inst;
        this.testRequired = false;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.anchor = 11;
            gridBagConstraints11.gridy = 0;
            gridBagConstraints11.insets = new Insets(0, 0, 0, 4);
            gridBagConstraints11.gridx = 3;
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.insets = new Insets(0, 0, 0, 5);
            gridBagConstraints12.gridx = 0;
            gridBagConstraints12.fill = 0;
            gridBagConstraints12.weightx = 1.0;
            gridBagConstraints12.anchor = 18;
            gridBagConstraints12.gridy = 0;
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.gridx = 2;
            gridBagConstraints10.insets = new Insets(0, 0, 0, 5);
            gridBagConstraints10.gridy = 0;
            this.jPanel1 = new JPanel();
            this.jPanel1.setLayout(new GridBagLayout());
            this.jPanel1.add((Component)this.getJPanel(), gridBagConstraints10);
            this.jPanel1.add((Component)this.getJPanel3(), gridBagConstraints12);
            this.jPanel1.add((Component)this.getJCheckBoxDeselect(), gridBagConstraints11);
        }
        return this.jPanel1;
    }

    private JPanel getJPanel2() {
        if (this.jPanelArtifacts == null) {
            GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
            gridBagConstraints21.weightx = 1.0;
            gridBagConstraints21.gridx = 0;
            gridBagConstraints21.fill = 1;
            gridBagConstraints21.gridy = 2;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.insets = new Insets(0, 0, 5, 0);
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.weightx = 0.0;
            gridBagConstraints2.fill = 2;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.fill = 1;
            gridBagConstraints6.gridy = 0;
            gridBagConstraints6.weightx = 1.0;
            gridBagConstraints6.weighty = 1.0;
            gridBagConstraints6.insets = new Insets(4, 4, 5, 4);
            gridBagConstraints6.gridx = 0;
            this.jPanelArtifacts = new JPanel();
            this.jPanelArtifacts.setLayout(new GridBagLayout());
            this.jPanelArtifacts.add((Component)this.getJScrollPane(), gridBagConstraints6);
            this.jPanelArtifacts.add((Component)this.getJPanel1(), gridBagConstraints2);
            this.jPanelArtifacts.add((Component)this.getJPanelProblems(), gridBagConstraints21);
        }
        return this.jPanelArtifacts;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getArtifactTable());
        }
        return this.jScrollPane;
    }

    private InstallationArtifactTable getArtifactTable() {
        if (this.artifactTable == null) {
            this.artifactTable = new InstallationArtifactTable();
        }
        return this.artifactTable;
    }

    private JCheckBox getJCheckBoxLatestOnly() {
        if (this.jCheckBoxLatestOnly == null) {
            this.jCheckBoxLatestOnly = new JCheckBox();
            this.jCheckBoxLatestOnly.setText("show latest versions only");
            this.jCheckBoxLatestOnly.setSelected(true);
            this.jCheckBoxLatestOnly.setMargin(new Insets(0, 0, 0, 0));
            this.jCheckBoxLatestOnly.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    InstanceCustomizer.this.refresh();
                }
            });
        }
        return this.jCheckBoxLatestOnly;
    }

    private JScrollPane getJScrollPane1() {
        if (this.jScrollPane1 == null) {
            this.jScrollPane1 = new JScrollPane();
            this.jScrollPane1.setViewportView(this.getJListProblems());
        }
        return this.jScrollPane1;
    }

    private JList getJListProblems() {
        if (this.jListProblems == null) {
            this.jListProblems = new JList();
            this.jListProblems.setVisibleRowCount(5);
        }
        return this.jListProblems;
    }

    private JButton getJButton() {
        if (this.jButton == null) {
            this.jButton = new JButton();
            this.jButton.setText("Deselect All");
            this.jButton.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/infection/icons/deselect_all.gif")));
            this.jButton.setMargin(new Insets(0, 4, 0, 4));
            this.jButton.addActionListener(new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        InstanceCustomizer.this.adjusting = true;
                        int num = InstanceCustomizer.this.artifacts.getRowCount();
                        for (int c = 0; c < num; ++c) {
                            if (!InstanceCustomizer.this.artifacts.isArtifactEnabled(c)) continue;
                            InstanceCustomizer.this.artifacts.selectArtifact(c, false, false);
                        }
                        InstanceCustomizer.this.getArtifactTable().editingStopped(new ChangeEvent(InstanceCustomizer.this.artifacts));
                        InstanceCustomizer.this.applyArtifactChanges();
                        InstanceCustomizer.this.refreshProblems();
                        InstanceCustomizer.this.firePropertyChange(null, null, null);
                    }
                    finally {
                        InstanceCustomizer.this.adjusting = false;
                        InstanceCustomizer.this.getArtifactTable().repaint();
                    }
                }
            });
        }
        return this.jButton;
    }

    private JPanel getJPanelProblems() {
        if (this.jPanelProblems == null) {
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.insets = new Insets(0, 4, 0, 4);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(4, 4, 4, 4);
            this.jLabelProblems = new JLabel();
            this.jLabelProblems.setText("Problems:");
            this.jLabelProblems.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/infection/icons/warn.gif")));
            this.jPanelProblems = new JPanel();
            this.jPanelProblems.setLayout(new GridBagLayout());
            this.jPanelProblems.add((Component)this.jLabelProblems, gridBagConstraints4);
            this.jPanelProblems.add((Component)this.getJScrollPane1(), gridBagConstraints);
        }
        return this.jPanelProblems;
    }

    public InfectionIndex getIndex() {
        return this.index;
    }

    public void setIndex(InfectionIndex index) {
        this.index = index;
    }

    public void refresh() {
        this.refreshArtifacts();
        this.refreshJavaVMs();
        this.refreshJvmOptions();
        this.refreshMainArgs();
        this.refreshProblems();
        this.refreshClassPath();
        this.refreshLibraryPath();
        this.refreshAdvancedOptions();
        this.refreshCustomProperties();
        if (this.getJTabbedPane().getSelectedComponent() == this.getJPanelLogging()) {
            this.refreshLoggingConfig();
        }
    }

    public void refreshArtifacts() {
        boolean latestOnly = this.getJCheckBoxLatestOnly().isSelected();
        this.artifacts = new InstallationArtifactTableModel();
        List<Artifact> list = new ArrayList();
        if (this.index != null) {
            int num = this.index.getArtifactCount();
            for (int c = 0; c < num; ++c) {
                Artifact fact = this.index.getArtifactAt(c);
                if (fact == null) continue;
                list.add(fact);
            }
        }
        list = InstallationArtifactTable.createArtifactList(list);
        int row = 0;
        String lastName = null;
        for (Artifact fact : list) {
            Artifact art;
            String name = fact.getName();
            boolean enabled = true;
            boolean selected = false;
            boolean manual = false;
            if (this.instance != null && (art = this.instance.findArtifact(fact)) != null) {
                selected = true;
                boolean bl = manual = art.getInstallMode() == 1;
            }
            if (latestOnly && !selected && lastName != null && name != null && name.equals(lastName)) continue;
            boolean missing = false;
            try {
                this.installer.verifyArtifact(this.installation, this.index, fact);
            }
            catch (Exception e) {
                missing = true;
            }
            this.artifacts.addArtifact(fact);
            this.artifacts.enableArtifact(row, enabled);
            this.artifacts.selectArtifact(row, selected, manual);
            this.artifacts.setArtifactMissing(row, missing);
            ++row;
            lastName = name;
        }
        this.getArtifactTable().setModel(this.artifacts);
        this.artifacts.getCheckModel().removeListSelectionListener(this.artifactSelectionListener);
        this.artifacts.getCheckModel().addListSelectionListener(this.artifactSelectionListener);
    }

    public boolean acceptArtifacts(ArtifactDependency dependency, Artifact[] artifacts) {
        int num = artifacts == null ? 0 : artifacts.length;
        for (int i = 0; i < num; ++i) {
            Artifact art = artifacts[i];
            if (!dependency.acceptArtifact(art)) continue;
            return true;
        }
        return false;
    }

    public void refreshProblems() {
        int c;
        Artifact art;
        this.listErrors = new ArrayList();
        this.listWarnings = new ArrayList();
        this.missingArtifacts = new ArrayList();
        ArrayList<Artifact> configArtifacts = new ArrayList<Artifact>();
        ArrayList<Artifact> indexArtifacts = new ArrayList<Artifact>();
        ArrayList<Artifact> artList = new ArrayList<Artifact>();
        int artCount = this.instance.getArtifactCount();
        for (int c2 = 0; c2 < artCount; ++c2) {
            Artifact fact = this.instance.getArtifactAt(c2);
            if (fact == null) continue;
            String artName = fact.getName();
            String artVersion = fact.getVersion();
            art = this.index.getArtifact(artName, artVersion);
            configArtifacts.add(fact);
            indexArtifacts.add(art);
            if (art == null) {
                artList.add(fact);
                this.missingArtifacts.add(fact);
                this.listErrors.add("Artifact not found: name=" + artName + ", version=" + artVersion);
                continue;
            }
            artList.add(art);
            try {
                this.installer.verifyArtifact(this.installation, this.index, fact);
                continue;
            }
            catch (Exception e) {
                this.missingArtifacts.add(fact);
                this.listWarnings.add(String.valueOf(e.getMessage()));
            }
        }
        Artifact[] arts = new Artifact[artList.size()];
        arts = artList.toArray(arts);
        if (this.dependencies != null) {
            int depCount = this.dependencies.length;
            for (int c3 = 0; c3 < depCount; ++c3) {
                try {
                    ArtifactDependency dep = this.dependencies[c3];
                    if (dep == null || this.acceptArtifacts(dep, arts)) continue;
                    String depInfo = "" + dep.getArtifact();
                    String depVer = dep.getVersion();
                    if (depVer != null) {
                        depInfo = depInfo + " (" + depVer + ")";
                    }
                    this.listErrors.add("Missing platform dependency: " + depInfo);
                    continue;
                }
                catch (Exception e) {
                    this.listErrors.add(e);
                }
            }
        }
        HashSet<String> artNames = new HashSet<String>();
        HashSet<String> dupNames = new HashSet<String>();
        for (int k = 0; k < arts.length; ++k) {
            art = arts[k];
            String artName = art.getName();
            if (artNames.add(artName) || !dupNames.add(artName)) continue;
            this.listErrors.add("Duplicate artifact selected: " + artName);
        }
        artCount = indexArtifacts.size();
        for (int c4 = 0; c4 < artCount; ++c4) {
            art = (Artifact)indexArtifacts.get(c4);
            if (art == null) continue;
            int depCount = art.getDependencyCount();
            for (int d = 0; d < depCount; ++d) {
                try {
                    ArtifactDependency dep = art.getDependencyAt(d);
                    if (dep == null || dep.isOptional() || this.acceptArtifacts(dep, arts)) continue;
                    String artName = art.getName();
                    String artVer = art.getVersion();
                    String artInfo = "" + artName;
                    if (artVer != null) {
                        artInfo = artInfo + " (" + artVer + ")";
                    }
                    String depName = dep.getArtifact();
                    String depVer = dep.getVersion();
                    String depInfo = "" + depName;
                    if (depVer != null) {
                        depInfo = depInfo + " (" + depVer + ")";
                    }
                    boolean newerAvailable = false;
                    for (int k = 0; k < arts.length; ++k) {
                        Artifact kart = arts[k];
                        String kartName = kart.getName();
                        String kartVer = kart.getVersion();
                        if (!depName.equals(kartName) || depVer != null && depVer.compareTo(kartVer) > 0) continue;
                        newerAvailable = true;
                        break;
                    }
                    if (newerAvailable) continue;
                    this.listWarnings.add("Artifact " + artInfo + " requires " + depInfo);
                    continue;
                }
                catch (Exception e) {
                    this.listErrors.add(e);
                }
            }
        }
        int errorCount = this.listErrors.size();
        int warningCount = this.listWarnings.size();
        DefaultListModel problems = new DefaultListModel();
        int n = this.listErrors.size();
        for (c = 0; c < n; ++c) {
            problems.addElement(this.listErrors.get(c));
        }
        n = this.listWarnings.size();
        for (c = 0; c < n; ++c) {
            problems.addElement(this.listWarnings.get(c));
        }
        int problemCount = problems.size();
        if (this.jLabelProblems != null) {
            String problemInfo = "";
            if (errorCount > 0) {
                problemInfo = problemInfo + "" + errorCount + " Problem(s)";
            }
            if (warningCount > 0) {
                if (problemInfo.length() > 0) {
                    problemInfo = problemInfo + ", ";
                }
                problemInfo = problemInfo + "" + warningCount + " Warning(s)";
            }
            if (problemInfo.length() < 1) {
                problemInfo = " ";
            }
            this.jLabelProblems.setText(problemInfo);
        }
        this.getJListProblems().setModel(problems);
        if (problemCount < 1) {
            this.getJPanelProblems().setVisible(false);
            this.getJPanelProblems().setMinimumSize(new Dimension(0, 0));
            this.validate();
            this.repaint();
        } else {
            this.getJPanelProblems().setVisible(true);
            Dimension pref = this.getJPanelProblems().getPreferredSize();
            int h = pref == null ? 0 : pref.height;
            h = Math.min(h, 100);
            this.getJPanelProblems().setMinimumSize(new Dimension(100, h));
            this.validate();
            this.repaint();
        }
    }

    public void refreshClassPath() {
        this.getJButtonClassPathRemove().setEnabled(false);
        DefaultListModel<String> classPathModel = new DefaultListModel<String>();
        if (this.instance != null) {
            int n = this.instance.getClassPathCount();
            for (int c = 0; c < n; ++c) {
                classPathModel.addElement(this.instance.getClassPathAt(c));
            }
        }
        this.getJListClassPath().setModel(classPathModel);
    }

    public void refreshLibraryPath() {
        this.getJButtonNativeRemove().setEnabled(false);
        DefaultListModel<String> model = new DefaultListModel<String>();
        if (this.instance != null) {
            int n = this.instance.getLibraryPathCount();
            for (int c = 0; c < n; ++c) {
                model.addElement(this.instance.getLibraryPathAt(c));
            }
        }
        this.getJListNative().setModel(model);
    }

    public void refreshLoggingConfig() {
        this.getInfectionInstanceLoggingEditor().setInstallation(this.installation);
        this.getInfectionInstanceLoggingEditor().setIndex(this.index);
        this.getInfectionInstanceLoggingEditor().setInstance(this.instance);
        this.getInfectionInstanceLoggingEditor().refreshAsync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshJavaVMs() {
        this.getJComboBoxJVM().removeAllItems();
        if (this.index == null) {
            return;
        }
        JavaVM currentVM = null;
        String[] jvmOptions = null;
        try {
            InfectionInstaller installer = new InfectionInstaller();
            currentVM = installer.registerCurrentJavaVM(this.installation, this.index, this.instance, jvmOptions);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            ErrorDialog.showErrorDialog(e);
        }
        JavaVM defaultVM = null;
        try {
            InfectionInstaller installer = new InfectionInstaller();
            defaultVM = installer.registerDefaultJavaVM(this.installation, this.index, this.instance, jvmOptions);
            if (defaultVM != null) {
                if (currentVM == null) {
                    currentVM = defaultVM;
                } else {
                    String currentVersion = currentVM.getVersion();
                    String defaultVersion = defaultVM.getVersion();
                    if (defaultVersion != null && defaultVersion.equals(currentVersion)) {
                        currentVM = defaultVM;
                    }
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            ErrorDialog.showErrorDialog(e);
        }
        try {
            this.refreshing = true;
            int num = this.index.getJavaVMCount();
            for (int i = 0; i < num; ++i) {
                JavaVM jvm = this.index.getJavaVMAt(i);
                if (jvm == null) continue;
                this.getJComboBoxJVM().addItem(jvm);
            }
            if (currentVM != null) {
                this.getJComboBoxJVM().setSelectedItem(currentVM);
            }
        }
        finally {
            this.refreshing = false;
        }
    }

    private JCheckBox getJCheckBoxResolve() {
        if (this.jCheckBoxResolve == null) {
            this.jCheckBoxResolve = new JCheckBox();
            this.jCheckBoxResolve.setSelected(true);
            this.jCheckBoxResolve.setText("resolve dependencies");
            this.jCheckBoxResolve.setMargin(new Insets(0, 0, 0, 0));
            this.jCheckBoxResolve.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    logger.fine("itemStateChanged()");
                }
            });
        }
        return this.jCheckBoxResolve;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 0;
            gridBagConstraints8.anchor = 17;
            gridBagConstraints8.gridy = 1;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.gridx = -1;
            gridBagConstraints3.gridy = -1;
            gridBagConstraints3.insets = new Insets(0, 0, 0, 0);
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            this.jPanel.add((Component)this.getJCheckBoxLatestOnly(), gridBagConstraints3);
            this.jPanel.add((Component)this.getJCheckBoxResolve(), gridBagConstraints8);
        }
        return this.jPanel;
    }

    private JCheckBox getJCheckBoxDeselect() {
        if (this.jCheckBoxDeselect == null) {
            this.jCheckBoxDeselect = new JCheckBox();
            this.jCheckBoxDeselect.setSelected(true);
            this.jCheckBoxDeselect.setText("deselect other versions");
            this.jCheckBoxDeselect.setMargin(new Insets(0, 0, 0, 0));
            this.jCheckBoxDeselect.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    logger.fine("itemStateChanged()");
                }
            });
        }
        return this.jCheckBoxDeselect;
    }

    private JPanel getJPanel3() {
        if (this.jPanel3 == null) {
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.anchor = 17;
            gridBagConstraints9.gridx = 0;
            gridBagConstraints9.gridy = -1;
            gridBagConstraints9.weightx = 1.0;
            gridBagConstraints9.insets = new Insets(4, 4, 4, 0);
            this.jPanel3 = new JPanel();
            this.jPanel3.setLayout(new GridBagLayout());
            this.jPanel3.add((Component)this.getJButton(), gridBagConstraints9);
        }
        return this.jPanel3;
    }

    public void resolveDependency(ArtifactDependency dep, Collection queue, boolean autoDeselect) {
        Artifact art;
        String depName = dep.getArtifact();
        String depVersion = dep.getVersion();
        int num = this.artifacts.getRowCount();
        int selectIndex = -1;
        Artifact selectedArt = null;
        for (int c = 0; c < num; ++c) {
            String artArch;
            String artOs;
            String artName;
            art = this.artifacts.getArtifactAt(c);
            if (art == null || (artName = art.getName()) == null || !artName.equals(depName) || (artOs = art.getOsPrefix()) != null && artOs.length() > 0 && !InfectionRuntimeImpl.matchesLocalOsName(artOs) || (artArch = art.getOsArch()) != null && artArch.length() > 0 && !InfectionRuntimeImpl.matchesLocalOsArch(artArch)) continue;
            String artVer = art.getVersion();
            if (depVersion != null) {
                if (artVer == null) continue;
                if (!artVer.equals(depVersion)) {
                    if (artVer.compareTo(depVersion) <= 0) continue;
                    if (this.artifacts.isArtifactChecked(c)) {
                        selectIndex = -1;
                        selectedArt = art;
                        break;
                    }
                    selectIndex = c;
                    break;
                }
            }
            if (this.artifacts.isArtifactChecked(c)) {
                selectedArt = art;
                break;
            }
            selectIndex = c;
            break;
        }
        boolean wasManual = false;
        if (autoDeselect && selectedArt != null) {
            for (int x = 0; x < num; ++x) {
                String fName;
                Artifact f = this.artifacts.getArtifactAt(x);
                if (f == null || (fName = f.getName()) == null || !fName.equals(depName) || f == selectedArt || !this.artifacts.isArtifactChecked(x)) continue;
                wasManual = f.getInstallMode() == 1;
                this.artifacts.selectArtifact(x, false, false);
            }
        }
        if (selectIndex >= 0) {
            art = this.artifacts.getArtifactAt(selectIndex);
            art.setInstallMode(0);
            this.artifacts.selectArtifact(selectIndex, true, wasManual);
            queue.add(art);
        }
    }

    protected void applyArtifactChanges() {
        if (this.instance == null) {
            return;
        }
        this.instance.clearArtifacts();
        int num = this.artifacts.getRowCount();
        for (int c = 0; c < num; ++c) {
            Artifact art;
            if (!this.artifacts.isArtifactChecked(c) || (art = this.artifacts.getArtifactAt(c)) == null) continue;
            this.instance.addArtifact(art);
        }
    }

    public ArtifactDependency[] getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(ArtifactDependency[] dependencies) {
        this.dependencies = dependencies;
    }

    public int getErrorCount() {
        return this.listErrors == null ? 0 : this.listErrors.size();
    }

    public int getWarningCount() {
        return this.listWarnings == null ? 0 : this.listWarnings.size();
    }

    public List getMissingArtifacts() {
        ArrayList list = new ArrayList();
        list.addAll(this.missingArtifacts);
        return list;
    }

    private JTabbedPane getJTabbedPane() {
        if (this.jTabbedPane == null) {
            this.jTabbedPane = new JTabbedPane();
            this.jTabbedPane.setTabPlacement(2);
            this.jTabbedPane.addTab("Main           ", new ImageIcon(this.getClass().getResource("/com/spacekiller/infection/icons/javavm.gif")), this.getJPanelMain(), null);
            this.jTabbedPane.addTab("Artifacts    ", new ImageIcon(this.getClass().getResource("/com/spacekiller/infection/icons/artifacts.gif")), this.getJPanel2(), "Artifacts");
            this.jTabbedPane.addTab("Libraries   ", new ImageIcon(this.getClass().getResource("/com/spacekiller/infection/icons/libraries.png")), this.getJPanelClassPath(), "Classpath and libraries");
            this.jTabbedPane.addTab("Properties", new ImageIcon(this.getClass().getResource("/com/spacekiller/infection/icons/properties.gif")), this.getJPanelProperties(), "System properties");
            this.jTabbedPane.addTab("Logging     ", new ImageIcon(this.getClass().getResource("/com/spacekiller/infection/icons/logging.png")), this.getJPanelLogging(), "Logging configuration");
            this.jTabbedPane.addTab("Advanced  ", new ImageIcon(this.getClass().getResource("/com/spacekiller/infection/icons/config_16.gif")), this.getJPanelAdvanced(), "Advanced options");
            this.jTabbedPane.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    InstanceCustomizer.this.handleTabSelected();
                }
            });
        }
        return this.jTabbedPane;
    }

    private JPanel getJPanelClassPath() {
        if (this.jPanelClassPath == null) {
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            gridBagConstraints13.gridx = 0;
            gridBagConstraints13.weightx = 1.0;
            gridBagConstraints13.weighty = 1.0;
            gridBagConstraints13.fill = 1;
            gridBagConstraints13.insets = new Insets(0, 4, 4, 4);
            gridBagConstraints13.gridy = 1;
            GridBagConstraints gridBagConstraints34 = new GridBagConstraints();
            gridBagConstraints34.gridx = 0;
            gridBagConstraints34.weightx = 1.0;
            gridBagConstraints34.weighty = 1.0;
            gridBagConstraints34.fill = 1;
            gridBagConstraints34.insets = new Insets(0, 4, 5, 4);
            gridBagConstraints34.gridy = 0;
            this.jPanelClassPath = new JPanel();
            this.jPanelClassPath.setLayout(new GridBagLayout());
            this.jPanelClassPath.add((Component)this.getJPanel13(), gridBagConstraints34);
            this.jPanelClassPath.add((Component)this.getJPanel14(), gridBagConstraints13);
        }
        return this.jPanelClassPath;
    }

    private JScrollPane getJScrollPane2() {
        if (this.jScrollPane2 == null) {
            this.jScrollPane2 = new JScrollPane();
            this.jScrollPane2.setViewportView(this.getJListClassPath());
        }
        return this.jScrollPane2;
    }

    private JList getJListClassPath() {
        if (this.jListClassPath == null) {
            this.jListClassPath = new JList();
            this.jListClassPath.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    InstanceCustomizer.this.getJButtonClassPathRemove().setEnabled(InstanceCustomizer.this.getJListClassPath().getSelectedIndex() >= 0);
                }
            });
        }
        return this.jListClassPath;
    }

    private JScrollPane getJScrollPane3() {
        if (this.jScrollPane3 == null) {
            this.jScrollPane3 = new JScrollPane();
            this.jScrollPane3.setViewportView(this.getJListNative());
        }
        return this.jScrollPane3;
    }

    private JList getJListNative() {
        if (this.jListNative == null) {
            this.jListNative = new JList();
            this.jListNative.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    InstanceCustomizer.this.getJButtonNativeRemove().setEnabled(InstanceCustomizer.this.getJListNative().getSelectedIndex() >= 0);
                }
            });
        }
        return this.jListNative;
    }

    private JPanel getJPanel4() {
        if (this.jPanel4 == null) {
            GridBagConstraints gridBagConstraints18 = new GridBagConstraints();
            gridBagConstraints18.insets = new Insets(0, 4, 4, 4);
            gridBagConstraints18.fill = 2;
            GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
            gridBagConstraints17.gridx = 0;
            gridBagConstraints17.insets = new Insets(0, 4, 4, 4);
            gridBagConstraints17.fill = 2;
            gridBagConstraints17.gridy = 1;
            this.jPanel4 = new JPanel();
            this.jPanel4.setLayout(new GridBagLayout());
            this.jPanel4.add((Component)this.getJButtonClassPathAdd(), gridBagConstraints18);
            this.jPanel4.add((Component)this.getJButtonClassPathRemove(), gridBagConstraints17);
        }
        return this.jPanel4;
    }

    private JButton getJButtonClassPathAdd() {
        if (this.jButtonClassPathAdd == null) {
            this.jButtonClassPathAdd = new JButton();
            this.jButtonClassPathAdd.setText("Add..");
            this.jButtonClassPathAdd.setMargin(new Insets(2, 4, 2, 4));
            this.jButtonClassPathAdd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InstanceCustomizer.this.actionClassPathAdd();
                }
            });
        }
        return this.jButtonClassPathAdd;
    }

    private JButton getJButtonClassPathRemove() {
        if (this.jButtonClassPathRemove == null) {
            this.jButtonClassPathRemove = new JButton();
            this.jButtonClassPathRemove.setText("Remove");
            this.jButtonClassPathRemove.setMargin(new Insets(2, 4, 2, 4));
            this.jButtonClassPathRemove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InstanceCustomizer.this.actionClassPathRemove();
                }
            });
        }
        return this.jButtonClassPathRemove;
    }

    private JPanel getJPanel5() {
        if (this.jPanel5 == null) {
            GridBagConstraints gridBagConstraints20 = new GridBagConstraints();
            gridBagConstraints20.fill = 2;
            gridBagConstraints20.gridx = 0;
            gridBagConstraints20.gridy = 1;
            gridBagConstraints20.insets = new Insets(0, 4, 4, 4);
            GridBagConstraints gridBagConstraints19 = new GridBagConstraints();
            gridBagConstraints19.fill = 2;
            gridBagConstraints19.insets = new Insets(0, 4, 4, 4);
            this.jPanel5 = new JPanel();
            this.jPanel5.setLayout(new GridBagLayout());
            this.jPanel5.add((Component)this.getJButtonNativeAdd(), gridBagConstraints19);
            this.jPanel5.add((Component)this.getJButtonNativeRemove(), gridBagConstraints20);
        }
        return this.jPanel5;
    }

    private JButton getJButtonNativeAdd() {
        if (this.jButtonNativeAdd == null) {
            this.jButtonNativeAdd = new JButton();
            this.jButtonNativeAdd.setMargin(new Insets(2, 4, 2, 4));
            this.jButtonNativeAdd.setText("Add..");
            this.jButtonNativeAdd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InstanceCustomizer.this.actionLibPathAdd();
                }
            });
        }
        return this.jButtonNativeAdd;
    }

    private JButton getJButtonNativeRemove() {
        if (this.jButtonNativeRemove == null) {
            this.jButtonNativeRemove = new JButton();
            this.jButtonNativeRemove.setText("Remove");
            this.jButtonNativeRemove.setMargin(new Insets(2, 4, 2, 4));
            this.jButtonNativeRemove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InstanceCustomizer.this.actionLibPathRemove();
                }
            });
        }
        return this.jButtonNativeRemove;
    }

    protected void actionClassPathAdd() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle("Add java archive");
        fileChooser.setDialogType(0);
        fileChooser.setFileSelectionMode(2);
        fileChooser.setMultiSelectionEnabled(false);
        int rc = fileChooser.showOpenDialog(null);
        if (rc == 0) {
            File file = fileChooser.getSelectedFile();
            if (file.isDirectory()) {
                logger.fine("TODO add classpath directory: " + file);
            } else {
                this.instance.addClassPath(file.getAbsolutePath());
            }
            this.refreshClassPath();
        }
    }

    protected void actionClassPathRemove() {
        int[] sel = this.getJListClassPath().getSelectedIndices();
        for (int c = 0; c < sel.length; ++c) {
            String path = (String)this.getJListClassPath().getModel().getElementAt(sel[c]);
            this.instance.removeClassPath(path);
        }
        this.refreshClassPath();
    }

    protected void actionLibPathAdd() {
        File file;
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle("Add native library directory");
        fileChooser.setDialogType(0);
        fileChooser.setFileSelectionMode(1);
        fileChooser.setMultiSelectionEnabled(false);
        int rc = fileChooser.showOpenDialog(null);
        if (rc == 0 && (file = fileChooser.getSelectedFile()).isDirectory()) {
            this.instance.addLibraryPath(file.getAbsolutePath());
            this.refreshLibraryPath();
        }
    }

    protected void actionLibPathRemove() {
        int[] sel = this.getJListNative().getSelectedIndices();
        for (int c = 0; c < sel.length; ++c) {
            String path = (String)this.getJListNative().getModel().getElementAt(sel[c]);
            this.instance.removeLibraryPath(path);
        }
        this.refreshLibraryPath();
    }

    private JPanel getJPanelProperties() {
        if (this.jPanelProperties == null) {
            GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
            gridBagConstraints14.gridx = 0;
            gridBagConstraints14.weightx = 1.0;
            gridBagConstraints14.weighty = 1.0;
            gridBagConstraints14.fill = 1;
            gridBagConstraints14.insets = new Insets(0, 4, 4, 4);
            gridBagConstraints14.gridy = 0;
            this.jPanelProperties = new JPanel();
            this.jPanelProperties.setLayout(new GridBagLayout());
            this.jPanelProperties.add((Component)this.getJPanel15(), gridBagConstraints14);
        }
        return this.jPanelProperties;
    }

    private JPanel getJPanelAdvanced() {
        if (this.jPanelAdvanced == null) {
            GridBagConstraints gridBagConstraints26 = new GridBagConstraints();
            gridBagConstraints26.gridx = 1;
            gridBagConstraints26.weighty = 1.0;
            gridBagConstraints26.fill = 1;
            gridBagConstraints26.gridy = 1;
            GridBagConstraints gridBagConstraints25 = new GridBagConstraints();
            gridBagConstraints25.fill = 2;
            gridBagConstraints25.gridy = 0;
            gridBagConstraints25.weightx = 1.0;
            gridBagConstraints25.insets = new Insets(4, 4, 5, 4);
            gridBagConstraints25.gridx = 1;
            GridBagConstraints gridBagConstraints24 = new GridBagConstraints();
            gridBagConstraints24.gridx = 0;
            gridBagConstraints24.insets = new Insets(4, 4, 5, 5);
            gridBagConstraints24.anchor = 17;
            gridBagConstraints24.gridy = 0;
            this.jLabel3 = new JLabel();
            this.jLabel3.setText("Class loader policy:");
            this.jPanelAdvanced = new JPanel();
            this.jPanelAdvanced.setLayout(new GridBagLayout());
            this.jPanelAdvanced.add((Component)this.jLabel3, gridBagConstraints24);
            this.jPanelAdvanced.add((Component)this.getJComboBoxClassLoaderPolicy(), gridBagConstraints25);
            this.jPanelAdvanced.add((Component)this.getJPanel7(), gridBagConstraints26);
        }
        return this.jPanelAdvanced;
    }

    private JComboBox getJComboBoxClassLoaderPolicy() {
        if (this.jComboBoxClassLoaderPolicy == null) {
            this.jComboBoxClassLoaderPolicy = new JComboBox();
            this.jComboBoxClassLoaderPolicy.setOpaque(false);
            this.jComboBoxClassLoaderPolicy.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    Object item = InstanceCustomizer.this.jComboBoxClassLoaderPolicy.getSelectedItem();
                    String newPolicy = null;
                    if (item == InstanceCustomizer.CLASSLOADER_SINGLE) {
                        newPolicy = "single";
                    }
                    if (item == InstanceCustomizer.CLASSLOADER_MULTI) {
                        newPolicy = "multi";
                    }
                    if (item == InstanceCustomizer.CLASSLOADER_SYSTEM) {
                        newPolicy = "system";
                    }
                    if (newPolicy != null) {
                        if (InstanceCustomizer.this.instance != null) {
                            InstanceCustomizer.this.instance.setProperty("infection.classloader", newPolicy);
                        }
                        InstanceCustomizer.this.refreshCustomProperties();
                    } else {
                        logger.warning("Error: unknown classloader policy: " + item);
                    }
                }
            });
        }
        return this.jComboBoxClassLoaderPolicy;
    }

    private JPanel getJPanel7() {
        if (this.jPanel7 == null) {
            this.jPanel7 = new JPanel();
            this.jPanel7.setOpaque(false);
        }
        return this.jPanel7;
    }

    protected void initInfectionInstanceCustomizer() {
        this.getJComboBoxClassLoaderPolicy().addItem(CLASSLOADER_SINGLE);
        this.getJComboBoxClassLoaderPolicy().addItem(CLASSLOADER_MULTI);
        this.getJComboBoxClassLoaderPolicy().addItem(CLASSLOADER_SYSTEM);
        this.getJTextAreaJvmOptions().getDocument().addDocumentListener(new DocumentAdapter(){

            @Override
            protected void handle(DocumentEvent arg0) {
                InstanceCustomizer.this.handleJvmOptionsChanged();
            }
        });
        this.getJCheckBoxCustomMainClass().setSelected(false);
        this.getJTextFieldCustomMainClass().getDocument().addDocumentListener(new DocumentAdapter(){

            @Override
            protected void handle(DocumentEvent arg0) {
                InstanceCustomizer.this.handleMainClassChanged();
            }
        });
        this.getTextAreaMainArgs().getDocument().addDocumentListener(new DocumentAdapter(){

            @Override
            protected void handle(DocumentEvent arg0) {
                InstanceCustomizer.this.handleMainArgsChanged();
            }
        });
        this.setPreferredSize(new Dimension(800, 500));
    }

    private InstancePropertiesEditor getSystemPropertyEditor() {
        if (this.systemPropertyEditor == null) {
            this.systemPropertyEditor = new InstancePropertiesEditor();
        }
        return this.systemPropertyEditor;
    }

    public void refreshCustomProperties() {
        this.getSystemPropertyEditor().setInstance(this.instance);
    }

    public void refreshAdvancedOptions() {
        String clazz;
        String valueClassLoaderPolicy;
        InfectionSystemProperty prop = this.instance == null ? null : this.instance.getProperty("infection.classloader");
        String string = valueClassLoaderPolicy = prop == null ? null : prop.getValue();
        if (valueClassLoaderPolicy == null) {
            try {
                String s = Infection.getInstance().getDistributionProperty("classloader");
                if (s != null) {
                    valueClassLoaderPolicy = s.trim().toLowerCase();
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            if (valueClassLoaderPolicy == null) {
                valueClassLoaderPolicy = "single";
            }
        }
        String clp = valueClassLoaderPolicy;
        if (valueClassLoaderPolicy.equals("single")) {
            clp = CLASSLOADER_SINGLE;
        }
        if (valueClassLoaderPolicy.equals("multi")) {
            clp = CLASSLOADER_MULTI;
        }
        if (valueClassLoaderPolicy.equals("system")) {
            clp = CLASSLOADER_SYSTEM;
        }
        this.getJComboBoxClassLoaderPolicy().setSelectedItem(clp);
        boolean customMain = false;
        if (this.instance != null && (prop = this.instance.getProperty("infection.mainclass")) != null && (clazz = prop.getValue()) != null && !clazz.equals("com.spacekiller.infection.platform.InfectionPlatform")) {
            customMain = true;
            this.getJTextFieldCustomMainClass().setText(clazz);
        }
        this.getJCheckBoxCustomMainClass().setSelected(customMain);
    }

    public Artifact[] checkNewArtifacts() {
        long instanceLastModified;
        ArrayList<Artifact> newArtifacts = new ArrayList<Artifact>();
        if (this.instance != null && (instanceLastModified = this.instance.getLastModifiedMillis()) != 0L && this.index != null) {
            int count = this.index.getArtifactCount();
            for (int c = 0; c < count; ++c) {
                Artifact art = this.index.getArtifactAt(c);
                if (art.getInstallTime() <= instanceLastModified) continue;
                newArtifacts.add(art);
            }
        }
        Artifact[] rc = new Artifact[newArtifacts.size()];
        rc = newArtifacts.toArray(rc);
        return rc;
    }

    public void selectAllArtifacts(boolean checkOsArch) {
        boolean autoDeselect = this.getJCheckBoxDeselect().isSelected();
        int num = this.artifacts.getRowCount();
        String lastName = null;
        for (int c = 0; c < num; ++c) {
            String artArch;
            String artOs;
            Artifact fact;
            String name;
            if (!this.artifacts.isArtifactEnabled(c) || (name = (fact = this.artifacts.getArtifactAt(c)).getName()) != null && lastName != null && name.equals(lastName) && autoDeselect || checkOsArch && ((artOs = fact.getOsPrefix()) != null && artOs.length() > 0 && !InfectionRuntimeImpl.matchesLocalOsName(artOs) || (artArch = fact.getOsArch()) != null && artArch.length() > 0 && !InfectionRuntimeImpl.matchesLocalOsArch(artArch))) continue;
            this.artifacts.selectArtifact(c, true, false);
            lastName = name;
        }
        this.firePropertyChange(null, null, null);
    }

    public void dumpSelectedArtifacts(PrintStream out) {
        int num = this.artifacts.getRowCount();
        out.println("Selected Artifacts:");
        int sel = 0;
        for (int c = 0; c < num; ++c) {
            if (!this.artifacts.isArtifactChecked(c)) continue;
            Artifact art = this.artifacts.getArtifactAt(c);
            out.println(" - #" + c + ": " + art);
            ++sel;
        }
        out.println(" -> Number of selected artifacts: " + sel);
    }

    private JPanel getJPanelLogging() {
        if (this.jPanelLogging == null) {
            GridBagConstraints gridBagConstraints35 = new GridBagConstraints();
            gridBagConstraints35.gridx = 0;
            gridBagConstraints35.gridwidth = 2;
            gridBagConstraints35.fill = 1;
            gridBagConstraints35.weightx = 1.0;
            gridBagConstraints35.weighty = 1.0;
            gridBagConstraints35.insets = new Insets(0, 4, 4, 4);
            gridBagConstraints35.gridy = 0;
            this.jPanelLogging = new JPanel();
            this.jPanelLogging.setLayout(new GridBagLayout());
            this.jPanelLogging.add((Component)this.getJPanel8(), gridBagConstraints35);
        }
        return this.jPanelLogging;
    }

    private JPanel getJPanel8() {
        if (this.jPanel8 == null) {
            GridLayout gridLayout = new GridLayout();
            gridLayout.setRows(1);
            this.jPanel8 = new JPanel();
            this.jPanel8.setLayout(gridLayout);
            this.jPanel8.setOpaque(false);
            this.jPanel8.add((Component)this.getInfectionInstanceLoggingEditor(), null);
        }
        return this.jPanel8;
    }

    public LoggingConfig getLoggingConfig() {
        return this.loggingConfig;
    }

    public void setLoggingConfig(LoggingConfig loggingConfig) {
        this.loggingConfig = loggingConfig;
    }

    private InstanceLoggingEditor getInfectionInstanceLoggingEditor() {
        if (this.infectionInstanceLoggingEditor == null) {
            this.infectionInstanceLoggingEditor = new InstanceLoggingEditor();
            this.infectionInstanceLoggingEditor.setOpaque(false);
        }
        return this.infectionInstanceLoggingEditor;
    }

    protected void handleTabSelected() {
        Component comp = this.getJTabbedPane().getSelectedComponent();
        if (comp == this.getJPanelLogging()) {
            this.refreshLoggingConfig();
        }
    }

    public InfectionInstallation getInstallation() {
        return this.installation;
    }

    public void setInstallation(InfectionInstallation installation) {
        this.installation = installation;
    }

    private JPanel getJPanelMain() {
        if (this.jPanelMain == null) {
            GridBagConstraints gridBagConstraints48 = new GridBagConstraints();
            gridBagConstraints48.weightx = 1.0;
            gridBagConstraints48.gridx = 0;
            gridBagConstraints48.fill = 1;
            gridBagConstraints48.insets = new Insets(0, 4, 4, 4);
            gridBagConstraints48.weighty = 1.0;
            gridBagConstraints48.gridy = 3;
            GridBagConstraints gridBagConstraints36 = new GridBagConstraints();
            gridBagConstraints36.weighty = 1.0;
            gridBagConstraints36.gridx = 0;
            gridBagConstraints36.weightx = 1.0;
            gridBagConstraints36.fill = 1;
            gridBagConstraints36.insets = new Insets(0, 4, 5, 4);
            gridBagConstraints36.gridy = 1;
            GridBagConstraints gridBagConstraints31 = new GridBagConstraints();
            gridBagConstraints31.gridx = 0;
            gridBagConstraints31.weightx = 1.0;
            gridBagConstraints31.weighty = 0.0;
            gridBagConstraints31.fill = 1;
            gridBagConstraints31.insets = new Insets(0, 4, 5, 4);
            gridBagConstraints31.gridy = 0;
            GridBagConstraints gridBagConstraints32 = new GridBagConstraints();
            gridBagConstraints32.gridx = 0;
            gridBagConstraints32.weightx = 1.0;
            gridBagConstraints32.weighty = 0.0;
            gridBagConstraints32.fill = 2;
            gridBagConstraints32.anchor = 11;
            gridBagConstraints32.insets = new Insets(0, 4, 5, 4);
            gridBagConstraints32.gridy = 2;
            this.jPanelMain = new JPanel();
            this.jPanelMain.setLayout(new GridBagLayout());
            this.jPanelMain.add((Component)this.getJPanel22(), gridBagConstraints32);
            this.jPanelMain.add((Component)this.getJPanel9(), gridBagConstraints31);
            this.jPanelMain.add((Component)this.getJPanel10(), gridBagConstraints36);
            this.jPanelMain.add((Component)this.getJPanel12(), gridBagConstraints48);
        }
        return this.jPanelMain;
    }

    private JPanel getJPanel22() {
        if (this.jPanel2 == null) {
            GridBagConstraints gridBagConstraints33 = new GridBagConstraints();
            gridBagConstraints33.gridx = 0;
            gridBagConstraints33.insets = new Insets(0, 4, 0, 5);
            gridBagConstraints33.gridy = 0;
            GridBagConstraints gridBagConstraints30 = new GridBagConstraints();
            gridBagConstraints30.fill = 2;
            gridBagConstraints30.gridy = 0;
            gridBagConstraints30.weightx = 1.0;
            gridBagConstraints30.insets = new Insets(4, 0, 4, 4);
            gridBagConstraints30.gridx = 1;
            this.jPanel2 = new JPanel();
            this.jPanel2.setLayout(new GridBagLayout());
            this.jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Main Class", 0, 0, null, null));
            this.jPanel2.add((Component)this.getJTextFieldCustomMainClass(), gridBagConstraints30);
            this.jPanel2.add((Component)this.getJCheckBoxCustomMainClass(), gridBagConstraints33);
        }
        return this.jPanel2;
    }

    private JTextField getJTextFieldCustomMainClass() {
        if (this.jTextFieldCustomMainClass == null) {
            this.jTextFieldCustomMainClass = new JTextField();
        }
        return this.jTextFieldCustomMainClass;
    }

    protected void handleMainClassChanged() {
        if (this.instance == null) {
            return;
        }
        String clazz = null;
        if (this.getJCheckBoxCustomMainClass().isSelected()) {
            clazz = this.getJTextFieldCustomMainClass().getText().trim();
        }
        if (clazz != null && clazz.length() > 0) {
            this.instance.setProperty("infection.mainclass", clazz);
        } else {
            this.instance.removeProperty("infection.mainclass");
        }
    }

    public void refreshMainArgs() {
        StringBuffer sbuf = new StringBuffer();
        if (this.instance != null) {
            // empty if block
        }
        this.getTextAreaMainArgs().setText(sbuf.toString());
    }

    protected void handleMainArgsChanged() {
        if (this.instance == null) {
            return;
        }
        String text = this.getTextAreaMainArgs().getText().trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshJvmOptions() {
        StringBuffer sbuf = new StringBuffer();
        if (this.instance != null) {
            int num = this.instance.getJavaOptionCount();
            for (int i = 0; i < num; ++i) {
                String option = this.instance.getJavaOptionAt(i);
                if (option == null) continue;
                if (sbuf.length() > 0) {
                    sbuf.append(' ');
                }
                sbuf.append(option);
            }
        }
        try {
            this.refreshing = true;
            this.getJTextAreaJvmOptions().setText(sbuf.toString());
            this.getJTextAreaJvmOptions().setCaretPosition(0);
        }
        finally {
            this.refreshing = false;
        }
    }

    protected void handleJvmOptionsChanged() {
        if (this.instance == null) {
            return;
        }
        String text = this.getJTextAreaJvmOptions().getText().trim();
        this.instance.clearJavaOptions();
        StringTokenizer tok = new StringTokenizer(text, " \t\n\r\f", false);
        while (tok.hasMoreTokens()) {
            String option = tok.nextToken();
            if (option.length() <= 0) continue;
            this.instance.addJavaOption(option);
        }
        if (!this.refreshing) {
            this.testRequired = true;
        }
    }

    private JPanel getJPanel9() {
        if (this.jPanel9 == null) {
            GridBagConstraints gridBagConstraints46 = new GridBagConstraints();
            gridBagConstraints46.gridx = 1;
            gridBagConstraints46.insets = new Insets(0, 0, 4, 4);
            gridBagConstraints46.fill = 1;
            gridBagConstraints46.gridy = 0;
            GridBagConstraints gridBagConstraints45 = new GridBagConstraints();
            gridBagConstraints45.fill = 1;
            gridBagConstraints45.gridy = 0;
            gridBagConstraints45.weightx = 1.0;
            gridBagConstraints45.insets = new Insets(0, 4, 4, 4);
            gridBagConstraints45.gridx = 0;
            this.jPanel9 = new JPanel();
            this.jPanel9.setLayout(new GridBagLayout());
            this.jPanel9.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Java Runtime", 0, 0, null, null));
            this.jPanel9.add((Component)this.getJComboBoxJVM(), gridBagConstraints45);
            this.jPanel9.add((Component)this.getJButtonChooseJVM(), gridBagConstraints46);
        }
        return this.jPanel9;
    }

    private JPanel getJPanel10() {
        if (this.jPanel10 == null) {
            GridBagConstraints gridBagConstraints44 = new GridBagConstraints();
            gridBagConstraints44.insets = new Insets(4, 4, 5, 4);
            gridBagConstraints44.fill = 1;
            gridBagConstraints44.gridy = 0;
            gridBagConstraints44.weightx = 1.0;
            gridBagConstraints44.weighty = 1.0;
            gridBagConstraints44.gridx = 0;
            this.jPanel10 = new JPanel();
            this.jPanel10.setLayout(new GridBagLayout());
            this.jPanel10.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Java Options", 0, 0, null, null));
            this.jPanel10.add((Component)this.getJScrollPane4(), gridBagConstraints44);
            GridBagConstraints gbc_buttonJavaOptionsWizard = new GridBagConstraints();
            gbc_buttonJavaOptionsWizard.insets = new Insets(4, 0, 4, 4);
            gbc_buttonJavaOptionsWizard.anchor = 11;
            gbc_buttonJavaOptionsWizard.gridx = 1;
            gbc_buttonJavaOptionsWizard.gridy = 0;
            this.jPanel10.add((Component)this.getButtonJavaOptionsWizard(), gbc_buttonJavaOptionsWizard);
        }
        return this.jPanel10;
    }

    private JScrollPane getJScrollPane4() {
        if (this.jScrollPane4 == null) {
            this.jScrollPane4 = new JScrollPane();
            this.jScrollPane4.setPreferredSize(new Dimension(100, 60));
            this.jScrollPane4.setOpaque(true);
            this.jScrollPane4.setViewportView(this.getJTextAreaJvmOptions());
        }
        return this.jScrollPane4;
    }

    private JTextArea getJTextAreaJvmOptions() {
        if (this.jTextAreaJvmOptions == null) {
            this.jTextAreaJvmOptions = new JTextArea();
            this.jTextAreaJvmOptions.setLineWrap(true);
            this.jTextAreaJvmOptions.setWrapStyleWord(true);
            this.jTextAreaJvmOptions.setRows(2);
            this.jTextAreaJvmOptions.setOpaque(false);
        }
        return this.jTextAreaJvmOptions;
    }

    private JComboBox getJComboBoxJVM() {
        if (this.jComboBoxJVM == null) {
            this.jComboBoxJVM = new JComboBox();
            this.jComboBoxJVM.setOpaque(false);
            this.jComboBoxJVM.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    InstanceCustomizer.this.handleJavaVMChanged();
                }
            });
        }
        return this.jComboBoxJVM;
    }

    private JButton getJButtonChooseJVM() {
        if (this.jButtonChooseJVM == null) {
            this.jButtonChooseJVM = new JButton();
            this.jButtonChooseJVM.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/infection/icons/javavm.gif")));
            this.jButtonChooseJVM.setMargin(new Insets(2, 2, 2, 2));
            this.jButtonChooseJVM.setToolTipText("Browse...");
            this.jButtonChooseJVM.setOpaque(false);
            this.jButtonChooseJVM.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InstanceCustomizer.this.actionBrowseJavaRuntime();
                }
            });
        }
        return this.jButtonChooseJVM;
    }

    private JPanel getJPanel12() {
        if (this.jPanel12 == null) {
            this.jPanel12 = new JPanel();
            GridBagLayout gbl_jPanel12 = new GridBagLayout();
            gbl_jPanel12.rowWeights = new double[]{1.0};
            gbl_jPanel12.columnWeights = new double[]{1.0};
            this.jPanel12.setLayout(gbl_jPanel12);
            this.jPanel12.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Main Arguments", 0, 0, null, null));
            GridBagConstraints gbc_scrollPane = new GridBagConstraints();
            gbc_scrollPane.insets = new Insets(4, 4, 4, 4);
            gbc_scrollPane.fill = 1;
            gbc_scrollPane.gridx = 0;
            gbc_scrollPane.gridy = 0;
            this.jPanel12.add((Component)this.getScrollPane(), gbc_scrollPane);
        }
        return this.jPanel12;
    }

    private JCheckBox getJCheckBoxCustomMainClass() {
        if (this.jCheckBoxCustomMainClass == null) {
            this.jCheckBoxCustomMainClass = new JCheckBox();
            this.jCheckBoxCustomMainClass.setText("Custom:");
            this.jCheckBoxCustomMainClass.setSelected(true);
            this.jCheckBoxCustomMainClass.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    InstanceCustomizer.this.getJTextFieldCustomMainClass().setEnabled(InstanceCustomizer.this.jCheckBoxCustomMainClass.isSelected());
                    InstanceCustomizer.this.handleMainClassChanged();
                }
            });
        }
        return this.jCheckBoxCustomMainClass;
    }

    protected void handleJavaVMChanged() {
        if (this.instance == null) {
            return;
        }
        Object item = this.getJComboBoxJVM().getSelectedItem();
        if (item == null) {
            return;
        }
        if (item instanceof JavaVM) {
            JavaVM jvm = (JavaVM)item;
            this.instance.setJavaVM(jvm);
            if (!this.refreshing) {
                this.testRequired = true;
            }
        }
    }

    protected void actionBrowseJavaRuntime() {
        if (this.index == null) {
            return;
        }
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Choose Java Runtime");
        int rc = chooser.showDialog(this, "Select");
        if (rc != 0) {
            return;
        }
        try {
            File file = chooser.getSelectedFile();
            if (file == null) {
                return;
            }
            InfectionInstaller installer = new InfectionInstaller();
            String[] jvmOptions = null;
            JavaVM jvm = installer.registerJavaVM(this.installation, this.index, this.instance, file, jvmOptions);
            if (jvm == null) {
                return;
            }
            this.refreshJavaVMs();
            this.getJComboBoxJVM().setSelectedItem(jvm);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            ErrorDialog.showErrorDialog(e);
        }
    }

    public InfectionInstaller getInstaller() {
        return this.installer;
    }

    public void setInstaller(InfectionInstaller installer) {
        this.installer = installer;
    }

    public void showTabMain() {
        this.getJTabbedPane().setSelectedComponent(this.jPanelMain);
    }

    public void showTabArtifacts() {
        this.getJTabbedPane().setSelectedComponent(this.jPanelArtifacts);
    }

    public void showTabLibraries() {
        this.getJTabbedPane().setSelectedComponent(this.jPanelClassPath);
    }

    public void showTabProperties() {
        this.getJTabbedPane().setSelectedComponent(this.jPanelProperties);
    }

    public void showTabLogging() {
        this.getJTabbedPane().setSelectedComponent(this.jPanelLogging);
    }

    public void showTabAdvanced() {
        this.getJTabbedPane().setSelectedComponent(this.jPanelAdvanced);
    }

    private JPanel getJPanel13() {
        if (this.jPanel13 == null) {
            GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
            gridBagConstraints16.anchor = 11;
            gridBagConstraints16.insets = new Insets(4, 0, 4, 4);
            gridBagConstraints16.gridx = 1;
            gridBagConstraints16.gridy = 0;
            gridBagConstraints16.fill = 0;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.fill = 1;
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 0;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.weighty = 1.0;
            gridBagConstraints1.insets = new Insets(4, 4, 4, 4);
            this.jPanel13 = new JPanel();
            this.jPanel13.setLayout(new GridBagLayout());
            this.jPanel13.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Java Class Path", 0, 0, null, null));
            this.jPanel13.setOpaque(false);
            this.jPanel13.add((Component)this.getJScrollPane2(), gridBagConstraints1);
            this.jPanel13.add((Component)this.getJPanel4(), gridBagConstraints16);
        }
        return this.jPanel13;
    }

    private JPanel getJPanel14() {
        if (this.jPanel14 == null) {
            GridBagConstraints gridBagConstraints22 = new GridBagConstraints();
            gridBagConstraints22.anchor = 11;
            gridBagConstraints22.gridx = 1;
            gridBagConstraints22.gridy = 0;
            gridBagConstraints22.insets = new Insets(4, 0, 4, 4);
            GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
            gridBagConstraints15.fill = 1;
            gridBagConstraints15.gridx = 0;
            gridBagConstraints15.gridy = 0;
            gridBagConstraints15.weightx = 1.0;
            gridBagConstraints15.weighty = 1.0;
            gridBagConstraints15.insets = new Insets(4, 4, 4, 4);
            this.jPanel14 = new JPanel();
            this.jPanel14.setLayout(new GridBagLayout());
            this.jPanel14.setOpaque(false);
            this.jPanel14.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Native Library Path", 0, 0, null, null));
            this.jPanel14.add((Component)this.getJScrollPane3(), gridBagConstraints15);
            this.jPanel14.add((Component)this.getJPanel5(), gridBagConstraints22);
        }
        return this.jPanel14;
    }

    private JPanel getJPanel15() {
        if (this.jPanel15 == null) {
            GridBagConstraints gridBagConstraints27 = new GridBagConstraints();
            gridBagConstraints27.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints27.gridy = 0;
            gridBagConstraints27.weightx = 1.0;
            gridBagConstraints27.weighty = 1.0;
            gridBagConstraints27.fill = 1;
            gridBagConstraints27.gridx = 0;
            this.jPanel15 = new JPanel();
            this.jPanel15.setLayout(new GridBagLayout());
            this.jPanel15.setOpaque(false);
            this.jPanel15.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "System Properties", 0, 0, null, null));
            this.jPanel15.add((Component)this.getSystemPropertyEditor(), gridBagConstraints27);
        }
        return this.jPanel15;
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane();
            this.scrollPane.setViewportView(this.getTextAreaMainArgs());
        }
        return this.scrollPane;
    }

    private JTextArea getTextAreaMainArgs() {
        if (this.textAreaMainArgs == null) {
            this.textAreaMainArgs = new JTextArea();
            this.textAreaMainArgs.setOpaque(false);
        }
        return this.textAreaMainArgs;
    }

    public boolean isTestRequired() {
        return this.testRequired;
    }

    public JavaVM testJavaOptions() throws Exception {
        int optionCount = this.instance.getJavaOptionCount();
        String[] jvmOptions = new String[optionCount];
        for (int i = 0; i < optionCount; ++i) {
            jvmOptions[i] = this.instance.getJavaOptionAt(i);
        }
        return this.testJavaOptions(jvmOptions);
    }

    public JavaVM testJavaOptions(String[] jvmOptions) throws Exception {
        JavaVM jvm = this.instance.getJavaVM();
        this.testJavaOptions(jvm, jvmOptions);
        return jvm;
    }

    public JavaVM testJavaOptions(JavaVM jvm, String[] jvmOptions) throws Exception {
        if (jvm == null) {
            throw new RuntimeException("No Java Runtime selected!");
        }
        InfectionInstaller installer = new InfectionInstaller();
        String exec = jvm.getExecutable();
        File executable = new File(exec);
        JavaVM tested = installer.testJavaVM(this.installation, this.index, this.instance, executable, jvmOptions);
        if (tested == null) {
            throw new RuntimeException("Test failed! See log file for more information.");
        }
        this.testRequired = false;
        return tested;
    }

    private JButton getButtonJavaOptionsWizard() {
        if (this.buttonJavaOptionsWizard == null) {
            this.buttonJavaOptionsWizard = new JButton();
            this.buttonJavaOptionsWizard.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/infection/icons/config_16.gif")));
            this.buttonJavaOptionsWizard.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InstanceCustomizer.this.actionShowJavaOptionsWizard();
                }
            });
            this.buttonJavaOptionsWizard.setToolTipText("Wizard...");
            this.buttonJavaOptionsWizard.setOpaque(false);
            this.buttonJavaOptionsWizard.setMargin(new Insets(2, 2, 2, 2));
        }
        return this.buttonJavaOptionsWizard;
    }

    public void clickShowJavaOptionsWizard() {
        int pressTimeMillis = 0;
        this.getButtonJavaOptionsWizard().doClick(pressTimeMillis);
    }

    protected void actionShowJavaOptionsWizard() {
        this.getButtonJavaOptionsWizard().requestFocus();
        JavaRuntimeWizard javaRuntimeWizard = new JavaRuntimeWizard();
        JavaRuntimeWizardPanel javaRuntimeWizardPanel = new JavaRuntimeWizardPanel();
        javaRuntimeWizardPanel.setInfectionInstanceCustomizer(this);
        javaRuntimeWizardPanel.setJavaRuntimeWizard(javaRuntimeWizard);
        String[] newJvmOptionArray = javaRuntimeWizardPanel.showJavaRuntimeWizardDialog(this);
        if (newJvmOptionArray == null) {
            return;
        }
        logger.info("Testing JVM-Options: " + javaRuntimeWizard.formatJvmOptions(newJvmOptionArray));
        try {
            this.testJavaOptions(newJvmOptionArray);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < newJvmOptionArray.length; ++i) {
            if (i > 0) {
                sb.append(' ');
            }
            sb.append(newJvmOptionArray[i]);
        }
        String newJvmOptions = sb.toString();
        this.setJvmOptions(newJvmOptions);
    }

    public String getJvmOptions() {
        String jvmOptions = this.getJTextAreaJvmOptions().getText();
        return jvmOptions;
    }

    protected void setJvmOptions(String jvmOptions) {
        if (jvmOptions == null) {
            jvmOptions = "";
        }
        this.getJTextAreaJvmOptions().setText(jvmOptions);
    }

    protected static abstract class DocumentAdapter
    implements DocumentListener {
        protected DocumentAdapter() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.handle(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.handle(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.handle(e);
        }

        protected abstract void handle(DocumentEvent var1);
    }

    protected class ArtifactSelectionListener
    implements ListSelectionListener {
        protected ArtifactSelectionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void valueChanged(ListSelectionEvent ev) {
            if (InstanceCustomizer.this.adjusting) {
                return;
            }
            if (ev.getValueIsAdjusting()) {
                return;
            }
            InstanceCustomizer.this.adjusting = true;
            try {
                int first = ev.getFirstIndex();
                int last = ev.getLastIndex();
                int selCount = 0;
                for (int i = first; i <= last; ++i) {
                    if (!InstanceCustomizer.this.artifacts.isArtifactChecked(i)) continue;
                    ++selCount;
                }
                logger.fine("selected: first=" + first + ", last=" + last + ", selCount=" + selCount);
                if (selCount > 0) {
                    boolean autoResolve;
                    boolean autoDeselect = InstanceCustomizer.this.getJCheckBoxDeselect().isSelected();
                    if (autoDeselect) {
                        for (int i = first; i <= last; ++i) {
                            Artifact art;
                            String artName;
                            int j;
                            Artifact art2;
                            String artName2;
                            if (!InstanceCustomizer.this.artifacts.isArtifactEnabled(i) || !InstanceCustomizer.this.artifacts.isArtifactChecked(i)) continue;
                            Artifact a = InstanceCustomizer.this.artifacts.getArtifactAt(i);
                            String name = a.getName();
                            for (int k = i - 1; k >= 0 && (artName2 = (art2 = InstanceCustomizer.this.artifacts.getArtifactAt(k)).getName()) != null && artName2.equals(name); --k) {
                                InstanceCustomizer.this.artifacts.selectArtifact(k, false, false);
                            }
                            int rows = InstanceCustomizer.this.artifacts.getRowCount();
                            for (j = i + 1; j < rows && (artName = (art = InstanceCustomizer.this.artifacts.getArtifactAt(j)).getName()) != null && artName.equals(name); ++j) {
                                InstanceCustomizer.this.artifacts.selectArtifact(j, false, false);
                            }
                            i = j - 1;
                        }
                    }
                    if (autoResolve = InstanceCustomizer.this.getJCheckBoxResolve().isSelected()) {
                        ArrayList<Artifact> arts = new ArrayList<Artifact>();
                        for (int i = first; i <= last; ++i) {
                            if (!InstanceCustomizer.this.artifacts.isArtifactChecked(i)) continue;
                            Artifact art = InstanceCustomizer.this.artifacts.getArtifactAt(i);
                            arts.add(art);
                        }
                        while (!arts.isEmpty()) {
                            Artifact fact = (Artifact)arts.remove(0);
                            int deps = fact.getDependencyCount();
                            for (int k = 0; k < deps; ++k) {
                                ArtifactDependency dep = fact.getDependencyAt(k);
                                if (dep == null) continue;
                                boolean autoDesel = false;
                                InstanceCustomizer.this.resolveDependency(dep, arts, autoDesel);
                            }
                        }
                    }
                }
                InstanceCustomizer.this.applyArtifactChanges();
                InstanceCustomizer.this.refreshProblems();
                InstanceCustomizer.this.firePropertyChange(null, null, null);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            finally {
                InstanceCustomizer.this.adjusting = false;
            }
        }
    }
}

