/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.swing;

import com.spacekiller.infection.log.LogFileOptions;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class LogFileOptionsPanel
extends JPanel {
    private static final long serialVersionUID = -4533489589048493078L;
    private static final int MB = 0x100000;
    private LogFileOptions logFileOptions;
    private String defaultLogDirectory;
    private boolean refreshing;
    private JLabel lblDirectory;
    private JTextField textFieldDir;
    private JButton btnBrowsedir;
    private JPanel panel;
    private JLabel lblFilePrefix;
    private JLabel lblFileSuffix;
    private JTextField textFieldPrefix;
    private JTextField textFieldSuffix;
    private JLabel lblMaxSize;
    private JLabel lblMaxFiles;
    private JPanel panel_1;
    private JPanel panel_2;
    private JTextField textFieldMaxSize;
    private JTextField textFieldMaxFiles;
    private JLabel lblMb;
    private JCheckBox chckbxAppend;
    private JCheckBox chckbxSynchronize;

    public LogFileOptionsPanel() {
        this.initialize();
        this.initLogFileOptionsPanel();
    }

    private void initialize() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0, 0, 0, 0, 0};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        gridBagLayout.columnWeights = new double[]{0.0, 0.0};
        this.setLayout(gridBagLayout);
        this.setSize(new Dimension(538, 207));
        GridBagConstraints gbc_lblDirectory = new GridBagConstraints();
        gbc_lblDirectory.anchor = 17;
        gbc_lblDirectory.insets = new Insets(0, 0, 5, 5);
        gbc_lblDirectory.gridx = 0;
        gbc_lblDirectory.gridy = 0;
        this.add((Component)this.getLblDirectory(), gbc_lblDirectory);
        GridBagConstraints gbc_panel = new GridBagConstraints();
        gbc_panel.weightx = 1.0;
        gbc_panel.insets = new Insets(0, 0, 5, 0);
        gbc_panel.fill = 1;
        gbc_panel.gridx = 1;
        gbc_panel.gridy = 0;
        this.add((Component)this.getPanel(), gbc_panel);
        GridBagConstraints gbc_lblFilePrefix = new GridBagConstraints();
        gbc_lblFilePrefix.anchor = 17;
        gbc_lblFilePrefix.insets = new Insets(0, 0, 5, 5);
        gbc_lblFilePrefix.gridx = 0;
        gbc_lblFilePrefix.gridy = 1;
        this.add((Component)this.getLblFilePrefix(), gbc_lblFilePrefix);
        GridBagConstraints gbc_textFieldPrefix = new GridBagConstraints();
        gbc_textFieldPrefix.insets = new Insets(0, 0, 5, 0);
        gbc_textFieldPrefix.fill = 2;
        gbc_textFieldPrefix.gridx = 1;
        gbc_textFieldPrefix.gridy = 1;
        this.add((Component)this.getTextFieldPrefix(), gbc_textFieldPrefix);
        GridBagConstraints gbc_lblFileSuffix = new GridBagConstraints();
        gbc_lblFileSuffix.anchor = 17;
        gbc_lblFileSuffix.insets = new Insets(0, 0, 5, 5);
        gbc_lblFileSuffix.gridx = 0;
        gbc_lblFileSuffix.gridy = 2;
        this.add((Component)this.getLabel_1(), gbc_lblFileSuffix);
        GridBagConstraints gbc_textFieldSuffix = new GridBagConstraints();
        gbc_textFieldSuffix.insets = new Insets(0, 0, 5, 0);
        gbc_textFieldSuffix.fill = 2;
        gbc_textFieldSuffix.gridx = 1;
        gbc_textFieldSuffix.gridy = 2;
        this.add((Component)this.getTextFieldSuffix(), gbc_textFieldSuffix);
        GridBagConstraints gbc_lblMaxSize = new GridBagConstraints();
        gbc_lblMaxSize.anchor = 17;
        gbc_lblMaxSize.insets = new Insets(0, 0, 5, 5);
        gbc_lblMaxSize.gridx = 0;
        gbc_lblMaxSize.gridy = 3;
        this.add((Component)this.getLabel_2(), gbc_lblMaxSize);
        GridBagConstraints gbc_panel_1 = new GridBagConstraints();
        gbc_panel_1.insets = new Insets(0, 0, 5, 0);
        gbc_panel_1.fill = 1;
        gbc_panel_1.gridx = 1;
        gbc_panel_1.gridy = 3;
        this.add((Component)this.getPanel_1(), gbc_panel_1);
        GridBagConstraints gbc_lblMaxFiles = new GridBagConstraints();
        gbc_lblMaxFiles.anchor = 17;
        gbc_lblMaxFiles.insets = new Insets(0, 0, 5, 5);
        gbc_lblMaxFiles.gridx = 0;
        gbc_lblMaxFiles.gridy = 4;
        this.add((Component)this.getLabel_3(), gbc_lblMaxFiles);
        GridBagConstraints gbc_panel_2 = new GridBagConstraints();
        gbc_panel_2.insets = new Insets(0, 0, 5, 0);
        gbc_panel_2.fill = 1;
        gbc_panel_2.gridx = 1;
        gbc_panel_2.gridy = 4;
        this.add((Component)this.getPanel_2(), gbc_panel_2);
        GridBagConstraints gbc_chckbxAppend = new GridBagConstraints();
        gbc_chckbxAppend.anchor = 17;
        gbc_chckbxAppend.gridwidth = 2;
        gbc_chckbxAppend.gridx = 0;
        gbc_chckbxAppend.gridy = 5;
        this.add((Component)this.getChckbxAppend(), gbc_chckbxAppend);
        GridBagConstraints gbc_chckbxSynchronize = new GridBagConstraints();
        gbc_chckbxSynchronize.anchor = 17;
        gbc_chckbxSynchronize.gridwidth = 2;
        gbc_chckbxSynchronize.insets = new Insets(0, 0, 0, 5);
        gbc_chckbxSynchronize.gridx = 0;
        gbc_chckbxSynchronize.gridy = 6;
        this.add((Component)this.getChckbxSynchronize(), gbc_chckbxSynchronize);
    }

    protected void initLogFileOptionsPanel() {
        DocumentListener listener = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (!LogFileOptionsPanel.this.refreshing) {
                    LogFileOptionsPanel.this.apply();
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (!LogFileOptionsPanel.this.refreshing) {
                    LogFileOptionsPanel.this.apply();
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                if (!LogFileOptionsPanel.this.refreshing) {
                    LogFileOptionsPanel.this.apply();
                }
            }
        };
        this.textFieldDir.getDocument().addDocumentListener(listener);
        this.textFieldPrefix.getDocument().addDocumentListener(listener);
        this.textFieldSuffix.getDocument().addDocumentListener(listener);
        this.textFieldMaxSize.getDocument().addDocumentListener(listener);
        this.textFieldMaxFiles.getDocument().addDocumentListener(listener);
    }

    public LogFileOptions getLogFileOptions() {
        return this.logFileOptions;
    }

    public void setLogFileOptions(LogFileOptions logFileOptions) {
        this.logFileOptions = logFileOptions;
        this.refresh();
    }

    private JLabel getLblDirectory() {
        if (this.lblDirectory == null) {
            this.lblDirectory = new JLabel("Directory:");
        }
        return this.lblDirectory;
    }

    private JTextField getTextFieldDir() {
        if (this.textFieldDir == null) {
            this.textFieldDir = new JTextField();
            this.textFieldDir.setToolTipText("Target log directory");
            this.textFieldDir.setOpaque(false);
            this.textFieldDir.setColumns(10);
        }
        return this.textFieldDir;
    }

    private JButton getBtnBrowsedir() {
        if (this.btnBrowsedir == null) {
            this.btnBrowsedir = new JButton("");
            this.btnBrowsedir.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LogFileOptionsPanel.this.actionBrowseDir();
                }
            });
            this.btnBrowsedir.setMargin(new Insets(0, 0, 0, 0));
            this.btnBrowsedir.setToolTipText("Browse...");
            this.btnBrowsedir.setIcon(new ImageIcon(LogFileOptionsPanel.class.getResource("/com/spacekiller/infection/icons/search.gif")));
        }
        return this.btnBrowsedir;
    }

    private JPanel getPanel() {
        if (this.panel == null) {
            this.panel = new JPanel();
            GridBagLayout gbl_panel = new GridBagLayout();
            gbl_panel.columnWidths = new int[]{0, 0, 0};
            gbl_panel.rowHeights = new int[]{0, 0};
            gbl_panel.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
            gbl_panel.rowWeights = new double[]{0.0, Double.MIN_VALUE};
            this.panel.setLayout(gbl_panel);
            GridBagConstraints gbc_textFieldDir = new GridBagConstraints();
            gbc_textFieldDir.weightx = 1.0;
            gbc_textFieldDir.fill = 1;
            gbc_textFieldDir.insets = new Insets(0, 0, 0, 5);
            gbc_textFieldDir.gridx = 0;
            gbc_textFieldDir.gridy = 0;
            this.panel.add((Component)this.getTextFieldDir(), gbc_textFieldDir);
            GridBagConstraints gbc_btnBrowsedir = new GridBagConstraints();
            gbc_btnBrowsedir.gridx = 1;
            gbc_btnBrowsedir.gridy = 0;
            this.panel.add((Component)this.getBtnBrowsedir(), gbc_btnBrowsedir);
        }
        return this.panel;
    }

    private JLabel getLblFilePrefix() {
        if (this.lblFilePrefix == null) {
            this.lblFilePrefix = new JLabel("File Prefix:");
        }
        return this.lblFilePrefix;
    }

    private JLabel getLabel_1() {
        if (this.lblFileSuffix == null) {
            this.lblFileSuffix = new JLabel("File Suffix:");
        }
        return this.lblFileSuffix;
    }

    private JTextField getTextFieldPrefix() {
        if (this.textFieldPrefix == null) {
            this.textFieldPrefix = new JTextField();
            this.textFieldPrefix.setToolTipText("Log file name prefix");
            this.textFieldPrefix.setOpaque(false);
            this.textFieldPrefix.setColumns(10);
        }
        return this.textFieldPrefix;
    }

    private JTextField getTextFieldSuffix() {
        if (this.textFieldSuffix == null) {
            this.textFieldSuffix = new JTextField();
            this.textFieldSuffix.setToolTipText("Log file name suffix");
            this.textFieldSuffix.setOpaque(false);
            this.textFieldSuffix.setColumns(10);
        }
        return this.textFieldSuffix;
    }

    private JLabel getLabel_2() {
        if (this.lblMaxSize == null) {
            this.lblMaxSize = new JLabel("Max. Size:");
        }
        return this.lblMaxSize;
    }

    private JLabel getLabel_3() {
        if (this.lblMaxFiles == null) {
            this.lblMaxFiles = new JLabel("Max. Files:");
        }
        return this.lblMaxFiles;
    }

    private JPanel getPanel_1() {
        if (this.panel_1 == null) {
            this.panel_1 = new JPanel();
            GridBagLayout gbl_panel_1 = new GridBagLayout();
            gbl_panel_1.columnWidths = new int[]{0, 0, 0};
            gbl_panel_1.rowHeights = new int[]{0, 0};
            gbl_panel_1.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
            gbl_panel_1.rowWeights = new double[]{0.0, Double.MIN_VALUE};
            this.panel_1.setLayout(gbl_panel_1);
            GridBagConstraints gbc_textFieldMaxSize = new GridBagConstraints();
            gbc_textFieldMaxSize.insets = new Insets(0, 0, 0, 5);
            gbc_textFieldMaxSize.gridx = 0;
            gbc_textFieldMaxSize.gridy = 0;
            this.panel_1.add((Component)this.getTextFieldMaxSize(), gbc_textFieldMaxSize);
            GridBagConstraints gbc_lblMb = new GridBagConstraints();
            gbc_lblMb.gridx = 1;
            gbc_lblMb.gridy = 0;
            this.panel_1.add((Component)this.getLblMb(), gbc_lblMb);
        }
        return this.panel_1;
    }

    private JPanel getPanel_2() {
        if (this.panel_2 == null) {
            this.panel_2 = new JPanel();
            GridBagLayout gbl_panel_2 = new GridBagLayout();
            gbl_panel_2.columnWidths = new int[]{0, 0};
            gbl_panel_2.rowHeights = new int[]{0, 0};
            gbl_panel_2.columnWeights = new double[]{0.0, Double.MIN_VALUE};
            gbl_panel_2.rowWeights = new double[]{0.0, Double.MIN_VALUE};
            this.panel_2.setLayout(gbl_panel_2);
            GridBagConstraints gbc_textFieldMaxFiles = new GridBagConstraints();
            gbc_textFieldMaxFiles.gridx = 0;
            gbc_textFieldMaxFiles.gridy = 0;
            this.panel_2.add((Component)this.getTextFieldMaxFiles(), gbc_textFieldMaxFiles);
        }
        return this.panel_2;
    }

    private JTextField getTextFieldMaxSize() {
        if (this.textFieldMaxSize == null) {
            this.textFieldMaxSize = new JTextField();
            this.textFieldMaxSize.setText("1");
            this.textFieldMaxSize.setHorizontalAlignment(4);
            this.textFieldMaxSize.setToolTipText("Maximum log file size in MB");
            this.textFieldMaxSize.setOpaque(false);
            this.textFieldMaxSize.setColumns(12);
        }
        return this.textFieldMaxSize;
    }

    private JTextField getTextFieldMaxFiles() {
        if (this.textFieldMaxFiles == null) {
            this.textFieldMaxFiles = new JTextField();
            this.textFieldMaxFiles.setHorizontalAlignment(4);
            this.textFieldMaxFiles.setText("1");
            this.textFieldMaxFiles.setToolTipText("Maximum number of log files to keep");
            this.textFieldMaxFiles.setOpaque(false);
            this.textFieldMaxFiles.setColumns(12);
        }
        return this.textFieldMaxFiles;
    }

    private JLabel getLblMb() {
        if (this.lblMb == null) {
            this.lblMb = new JLabel("MB");
        }
        return this.lblMb;
    }

    protected void actionBrowseDir() {
        int rc;
        String dir;
        String currentDir = this.defaultLogDirectory;
        if (this.logFileOptions != null && (dir = this.logFileOptions.getDirectory()) != null && dir.length() > 0) {
            currentDir = dir;
        }
        File oldDir = null;
        if (currentDir != null) {
            oldDir = new File(currentDir);
        }
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Select Log Directory");
        chooser.setFileSelectionMode(1);
        if (oldDir != null) {
            chooser.setSelectedFile(oldDir);
        }
        if ((rc = chooser.showDialog(this, "Select")) != 0) {
            return;
        }
        File file = chooser.getSelectedFile();
        if (file == null) {
            return;
        }
        this.getTextFieldDir().setText(file.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refresh() {
        try {
            double limitMB;
            String limitStr;
            this.refreshing = true;
            String dir = null;
            String prefix = null;
            String suffix = null;
            int limit = 0;
            int count = 0;
            boolean append = false;
            boolean async = true;
            if (this.logFileOptions != null) {
                dir = this.logFileOptions.getDirectory();
                prefix = this.logFileOptions.getNamePrefix();
                suffix = this.logFileOptions.getNameSuffix();
                limit = this.logFileOptions.getLimit();
                count = this.logFileOptions.getCount();
                append = this.logFileOptions.isAppend();
                async = this.logFileOptions.isAsync();
            }
            if (dir == null) {
                dir = "";
            }
            this.textFieldDir.setText(dir);
            if (prefix == null) {
                prefix = "";
            }
            this.textFieldPrefix.setText(prefix);
            if (suffix == null) {
                suffix = "";
            }
            this.textFieldSuffix.setText(suffix);
            if (limit < 0x100000) {
                limit = 0x100000;
            }
            if ((limitStr = String.valueOf(limitMB = (double)limit / 1048576.0)).endsWith(".0")) {
                limitStr = limitStr.substring(0, limitStr.length() - 2);
            }
            this.textFieldMaxSize.setText(limitStr);
            if (count < 1) {
                count = 1;
            }
            this.textFieldMaxFiles.setText(String.valueOf(count));
            this.chckbxAppend.setSelected(append);
            this.chckbxSynchronize.setSelected(!async);
        }
        finally {
            this.refreshing = false;
        }
    }

    protected void apply() {
        String maxFiles;
        if (this.logFileOptions == null) {
            return;
        }
        this.logFileOptions.setDirectory(this.textFieldDir.getText().trim());
        this.logFileOptions.setNamePrefix(this.textFieldPrefix.getText().trim());
        this.logFileOptions.setNameSuffix(this.textFieldSuffix.getText().trim());
        this.logFileOptions.setAppend(this.chckbxAppend.isSelected());
        this.logFileOptions.setAsync(!this.chckbxSynchronize.isSelected());
        String maxSize = this.textFieldMaxSize.getText().trim();
        if (maxSize.length() > 0) {
            try {
                double value = Double.parseDouble(maxSize);
                long limit = (long)(value * 1048576.0);
                if (limit > Integer.MAX_VALUE) {
                    limit = Integer.MAX_VALUE;
                }
                if (limit < 0x100000L) {
                    limit = 0x100000L;
                }
                this.logFileOptions.setLimit((int)limit);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((maxFiles = this.textFieldMaxFiles.getText().trim()).length() > 0) {
            try {
                long value = Long.parseLong(maxFiles);
                if (value > Integer.MAX_VALUE) {
                    value = Integer.MAX_VALUE;
                }
                if (value < 1L) {
                    value = 1L;
                }
                this.logFileOptions.setCount((int)value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private JCheckBox getChckbxAppend() {
        if (this.chckbxAppend == null) {
            this.chckbxAppend = new JCheckBox("Append");
            this.chckbxAppend.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (!LogFileOptionsPanel.this.refreshing) {
                        LogFileOptionsPanel.this.apply();
                    }
                }
            });
            this.chckbxAppend.setToolTipText("Append to existin log file ?");
        }
        return this.chckbxAppend;
    }

    private JCheckBox getChckbxSynchronize() {
        if (this.chckbxSynchronize == null) {
            this.chckbxSynchronize = new JCheckBox("Synchronize");
            this.chckbxSynchronize.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (!LogFileOptionsPanel.this.refreshing) {
                        LogFileOptionsPanel.this.apply();
                    }
                }
            });
            this.chckbxSynchronize.setToolTipText("Synchronized logging ?");
        }
        return this.chckbxSynchronize;
    }

    public String getDefaultLogDirectory() {
        return this.defaultLogDirectory;
    }

    public void setDefaultLogDirectory(String defaultLogDirectory) {
        this.defaultLogDirectory = defaultLogDirectory;
    }
}

