/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public interface FileEntry {
    public String getName();

    public InputStream getInputStream() throws IOException;

    public long lastModified();

    public int getUnixMode();

    public static class ForName
    implements FileEntry {
        private final String name;
        private final FileEntry entry;
        private final int unixMode;

        public ForName(FileEntry entry, String name, int unixMode) {
            this.entry = entry;
            this.name = name;
            this.unixMode = unixMode;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.entry.getInputStream();
        }

        @Override
        public long lastModified() {
            return this.entry.lastModified();
        }

        @Override
        public int getUnixMode() {
            return this.unixMode;
        }
    }

    public static class ForData
    implements FileEntry {
        private final String name;
        private final byte[] buf;
        private final int ofs;
        private final int len;
        private final int unixMode;

        public ForData(byte[] buf, String name, int unixMode) {
            this.buf = buf;
            this.ofs = 0;
            this.len = buf.length;
            this.name = name;
            this.unixMode = unixMode;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.buf, this.ofs, this.len);
        }

        @Override
        public long lastModified() {
            return 0L;
        }

        @Override
        public int getUnixMode() {
            return this.unixMode;
        }
    }

    public static class ForURL
    implements FileEntry {
        private final String name;
        private final URL url;
        private final int unixMode;

        public ForURL(URL url, String name, int unixMode) {
            this.url = url;
            this.name = name;
            this.unixMode = unixMode;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.url.openStream();
        }

        @Override
        public long lastModified() {
            return 0L;
        }

        @Override
        public int getUnixMode() {
            return this.unixMode;
        }
    }

    public static class ForFile
    implements FileEntry {
        private final String name;
        private final File file;
        private final int unixMode;

        public ForFile(File file, String name, int unixMode) {
            this.file = file;
            this.name = name;
            this.unixMode = unixMode;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return new FileInputStream(this.file);
        }

        @Override
        public long lastModified() {
            return this.file.lastModified();
        }

        @Override
        public int getUnixMode() {
            return this.unixMode;
        }
    }
}

