/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.util;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.Date;
import java.util.HashSet;
import java.util.Vector;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipException;

public class ZipOutStream
extends DeflaterOutputStream {
    private static final Charset ISO_8859_1 = Charset.forName("ISO-8859-1");
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static long LOCSIG = 67324752L;
    private static long EXTSIG = 134695760L;
    private static long CENSIG = 33639248L;
    private static long ENDSIG = 101010256L;
    private static final long ZIP64_ENDSIG = 101075792L;
    private static final long ZIP64_LOCSIG = 117853008L;
    private static final int ZIP64_ENDHDR = 56;
    private static final int ZIP64_EXTID = 1;
    private static final int ZIP64_MAGICCOUNT = 65535;
    private static final long ZIP64_MAGICVAL = 0xFFFFFFFFL;
    private static final int EFS = 2048;
    private static final int EXTID_ZIP64 = 1;
    private static final int EXTID_NTFS = 10;
    private static final int EXTID_EXTT = 21589;
    private static final int EXTT_FLAG_LMT = 1;
    private static final int EXTT_FLAG_LAT = 2;
    private static final int EXTT_FLAT_CT = 4;
    private static final boolean inhibitZip64 = false;
    private static final int PLATFORM_UNIX = 3;
    private static final int PLATFORM_FAT = 0;
    private XEntry current;
    private Vector xentries = new Vector();
    private HashSet names = new HashSet();
    private CRC32 crc = new CRC32();
    private long written = 0L;
    private long locoff = 0L;
    private byte[] comment;
    private int method = 8;
    private boolean finished;
    private boolean closed = false;
    private final ZipCoder zc;
    private static final int STORED = 0;
    private static final int DEFLATED = 8;
    private static final long WINDOWS_EPOCH_IN_MICROSECONDS = -11644473600000000L;

    private static int version(ZipEntry e) throws ZipException {
        switch (e.getMethod()) {
            case 8: {
                return 20;
            }
            case 0: {
                return 10;
            }
        }
        throw new ZipException("unsupported compression method");
    }

    protected static final int get16(byte[] b, int off) {
        return ZipOutStream.byteToUnsignedInt(b[off]) | ZipOutStream.byteToUnsignedInt(b[off + 1]) << 8;
    }

    protected static int byteToUnsignedInt(byte x) {
        return x & 0xFF;
    }

    protected static final long get32(byte[] b, int off) {
        return ((long)ZipOutStream.get16(b, off) | (long)ZipOutStream.get16(b, off + 2) << 16) & 0xFFFFFFFFL;
    }

    protected static final long get64(byte[] b, int off) {
        return ZipOutStream.get32(b, off) | ZipOutStream.get32(b, off + 4) << 32;
    }

    protected static final long fileTimeToUnixTime(FileTime ftime) {
        return ftime.toSeconds();
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
    }

    public ZipOutStream(OutputStream out) {
        this(out, ISO_8859_1);
    }

    public ZipOutStream(OutputStream out, Charset charset) {
        super(out, new Deflater(-1, true));
        if (charset == null) {
            throw new NullPointerException("charset is null");
        }
        this.zc = ZipCoder.get(charset);
    }

    public void setComment(String comment) {
        if (comment != null) {
            this.comment = this.zc.getBytes(comment);
            if (this.comment.length > 65535) {
                throw new IllegalArgumentException("ZIP file comment too long.");
            }
        }
    }

    public void setMethod(int method) {
        if (method != 8 && method != 0) {
            throw new IllegalArgumentException("invalid compression method");
        }
        this.method = method;
    }

    public void setLevel(int level) {
        this.def.setLevel(level);
    }

    public void putNextEntry(ZipEntry e) throws IOException {
        this.ensureOpen();
        if (this.current != null) {
            this.closeEntry();
        }
        if (e.xdostime == -1L) {
            e.setTime(System.currentTimeMillis());
        }
        if (e.method == -1) {
            e.method = this.method;
        }
        e.flag = 0;
        switch (e.method) {
            case 8: {
                if (e.size != -1L && e.csize != -1L && e.crc != -1L) break;
                e.flag = 8;
                break;
            }
            case 0: {
                if (e.size == -1L) {
                    e.size = e.csize;
                } else if (e.csize == -1L) {
                    e.csize = e.size;
                } else if (e.size != e.csize) {
                    throw new ZipException("STORED entry where compressed != uncompressed size");
                }
                if (e.size != -1L && e.crc != -1L) break;
                throw new ZipException("STORED entry missing size, compressed size, or crc-32");
            }
            default: {
                throw new ZipException("unsupported compression method");
            }
        }
        if (!this.names.add(e.name)) {
            throw new ZipException("duplicate entry: " + e.name);
        }
        if (this.zc.isUTF8()) {
            e.flag |= 0x800;
        }
        this.current = new XEntry(e, this.written);
        this.xentries.add(this.current);
        this.writeLOC(this.current);
    }

    public void closeEntry() throws IOException {
        this.ensureOpen();
        if (this.current != null) {
            ZipEntry e = this.current.entry;
            switch (e.method) {
                case 8: {
                    this.def.finish();
                    while (!this.def.finished()) {
                        this.deflate();
                    }
                    if ((e.flag & 8) == 0) {
                        if (e.size != this.getBytesRead(this.def)) {
                            throw new ZipException("invalid entry size (expected " + e.size + " but got " + this.getBytesRead(this.def) + " bytes)");
                        }
                        if (e.csize != this.getBytesWritten(this.def)) {
                            throw new ZipException("invalid entry compressed size (expected " + e.csize + " but got " + this.getBytesWritten(this.def) + " bytes)");
                        }
                        if (e.crc != this.crc.getValue()) {
                            throw new ZipException("invalid entry CRC-32 (expected 0x" + Long.toHexString(e.crc) + " but got 0x" + Long.toHexString(this.crc.getValue()) + ")");
                        }
                    } else {
                        e.size = this.getBytesRead(this.def);
                        e.csize = this.getBytesWritten(this.def);
                        e.crc = this.crc.getValue();
                        this.writeEXT(e);
                    }
                    this.def.reset();
                    this.written += e.csize;
                    break;
                }
                case 0: {
                    if (e.size != this.written - this.locoff) {
                        throw new ZipException("invalid entry size (expected " + e.size + " but got " + (this.written - this.locoff) + " bytes)");
                    }
                    if (e.crc == this.crc.getValue()) break;
                    throw new ZipException("invalid entry crc-32 (expected 0x" + Long.toHexString(e.crc) + " but got 0x" + Long.toHexString(this.crc.getValue()) + ")");
                }
                default: {
                    throw new ZipException("invalid compression method");
                }
            }
            this.crc.reset();
            this.current = null;
        }
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        this.ensureOpen();
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        if (this.current == null) {
            throw new ZipException("no current ZIP entry");
        }
        ZipEntry entry = this.current.entry;
        switch (entry.method) {
            case 8: {
                super.write(b, off, len);
                break;
            }
            case 0: {
                this.written += (long)len;
                if (this.written - this.locoff > entry.size) {
                    throw new ZipException("attempt to write past end of STORED entry");
                }
                this.out.write(b, off, len);
                break;
            }
            default: {
                throw new ZipException("invalid compression method");
            }
        }
        this.crc.update(b, off, len);
    }

    @Override
    public void finish() throws IOException {
        this.ensureOpen();
        if (this.finished) {
            return;
        }
        if (this.current != null) {
            this.closeEntry();
        }
        long off = this.written;
        for (XEntry xentry : this.xentries) {
            this.writeCEN(xentry);
        }
        this.writeEND(off, this.written - off);
        this.finished = true;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            super.close();
            this.closed = true;
        }
    }

    private void writeLOC(XEntry xentry) throws IOException {
        ZipEntry e = xentry.entry;
        int flag = e.flag;
        boolean hasZip64 = false;
        int elen = this.getExtraLen(e.extra);
        this.writeInt(LOCSIG);
        if ((flag & 8) == 8) {
            this.writeShort(ZipOutStream.version(e));
            this.writeShort(flag);
            this.writeShort(e.method);
            this.writeInt(e.xdostime);
            this.writeInt(0L);
            this.writeInt(0L);
            this.writeInt(0L);
        } else {
            if (e.csize >= 0xFFFFFFFFL || e.size >= 0xFFFFFFFFL) {
                hasZip64 = true;
                this.writeShort(45);
            } else {
                this.writeShort(ZipOutStream.version(e));
            }
            this.writeShort(flag);
            this.writeShort(e.method);
            this.writeInt(e.xdostime);
            this.writeInt(e.crc);
            if (hasZip64) {
                this.writeInt(0xFFFFFFFFL);
                this.writeInt(0xFFFFFFFFL);
                elen += 20;
            } else {
                this.writeInt(e.csize);
                this.writeInt(e.size);
            }
        }
        byte[] nameBytes = this.zc.getBytes(e.name);
        this.writeShort(nameBytes.length);
        int elenEXTT = 0;
        int flagEXTT = 0;
        if (e.mtime != null) {
            elenEXTT += 4;
            flagEXTT |= 1;
        }
        if (e.atime != null) {
            elenEXTT += 4;
            flagEXTT |= 2;
        }
        if (e.ctime != null) {
            elenEXTT += 4;
            flagEXTT |= 4;
        }
        if (flagEXTT != 0) {
            elen += elenEXTT + 5;
        }
        this.writeShort(elen);
        this.writeBytes(nameBytes, 0, nameBytes.length);
        if (hasZip64) {
            this.writeShort(1);
            this.writeShort(16);
            this.writeLong(e.size);
            this.writeLong(e.csize);
        }
        if (flagEXTT != 0) {
            this.writeShort(21589);
            this.writeShort(elenEXTT + 1);
            this.writeByte(flagEXTT);
            if (e.mtime != null) {
                this.writeInt(ZipOutStream.fileTimeToUnixTime(e.mtime));
            }
            if (e.atime != null) {
                this.writeInt(ZipOutStream.fileTimeToUnixTime(e.atime));
            }
            if (e.ctime != null) {
                this.writeInt(ZipOutStream.fileTimeToUnixTime(e.ctime));
            }
        }
        this.writeExtra(e.extra);
        this.locoff = this.written;
    }

    private void writeEXT(ZipEntry e) throws IOException {
        this.writeInt(EXTSIG);
        this.writeInt(e.crc);
        if (e.csize >= 0xFFFFFFFFL || e.size >= 0xFFFFFFFFL) {
            this.writeLong(e.csize);
            this.writeLong(e.size);
        } else {
            this.writeInt(e.csize);
            this.writeInt(e.size);
        }
    }

    private void writeCEN(XEntry xentry) throws IOException {
        byte[] commentBytes;
        ZipEntry e = xentry.entry;
        int flag = e.flag;
        int version = ZipOutStream.version(e);
        long csize = e.csize;
        long size = e.size;
        long offset = xentry.offset;
        int elenZIP64 = 0;
        boolean hasZip64 = false;
        if (e.csize >= 0xFFFFFFFFL) {
            csize = 0xFFFFFFFFL;
            elenZIP64 += 8;
            hasZip64 = true;
        }
        if (e.size >= 0xFFFFFFFFL) {
            size = 0xFFFFFFFFL;
            elenZIP64 += 8;
            hasZip64 = true;
        }
        if (xentry.offset >= 0xFFFFFFFFL) {
            offset = 0xFFFFFFFFL;
            elenZIP64 += 8;
            hasZip64 = true;
        }
        this.writeInt(CENSIG);
        if (hasZip64) {
            version = 45;
        }
        int platform = e.getPlatform();
        int versionMadeBy = platform << 8 | version;
        int versionNeeded = version;
        this.writeShort(versionMadeBy);
        this.writeShort(versionNeeded);
        this.writeShort(flag);
        this.writeShort(e.method);
        this.writeInt(e.xdostime);
        this.writeInt(e.crc);
        this.writeInt(csize);
        this.writeInt(size);
        byte[] nameBytes = this.zc.getBytes(e.name);
        this.writeShort(nameBytes.length);
        int elen = this.getExtraLen(e.extra);
        if (hasZip64) {
            elen += elenZIP64 + 4;
        }
        int flagEXTT = 0;
        if (e.mtime != null) {
            elen += 4;
            flagEXTT |= 1;
        }
        if (e.atime != null) {
            flagEXTT |= 2;
        }
        if (e.ctime != null) {
            flagEXTT |= 4;
        }
        if (flagEXTT != 0) {
            elen += 5;
        }
        this.writeShort(elen);
        if (e.comment != null) {
            commentBytes = this.zc.getBytes(e.comment);
            this.writeShort(Math.min(commentBytes.length, 65535));
        } else {
            commentBytes = null;
            this.writeShort(0);
        }
        this.writeShort(0);
        this.writeShort(e.getInternalAttributes());
        this.writeInt(e.getExternalAttributes());
        this.writeInt(offset);
        this.writeBytes(nameBytes, 0, nameBytes.length);
        if (hasZip64) {
            this.writeShort(1);
            this.writeShort(elenZIP64);
            if (size == 0xFFFFFFFFL) {
                this.writeLong(e.size);
            }
            if (csize == 0xFFFFFFFFL) {
                this.writeLong(e.csize);
            }
            if (offset == 0xFFFFFFFFL) {
                this.writeLong(xentry.offset);
            }
        }
        if (flagEXTT != 0) {
            this.writeShort(21589);
            if (e.mtime != null) {
                this.writeShort(5);
                this.writeByte(flagEXTT);
                this.writeInt(ZipOutStream.fileTimeToUnixTime(e.mtime));
            } else {
                this.writeShort(1);
                this.writeByte(flagEXTT);
            }
        }
        this.writeExtra(e.extra);
        if (commentBytes != null) {
            this.writeBytes(commentBytes, 0, Math.min(commentBytes.length, 65535));
        }
    }

    private void writeEND(long off, long len) throws IOException {
        int count;
        boolean hasZip64 = false;
        long xlen = len;
        long xoff = off;
        if (xlen >= 0xFFFFFFFFL) {
            xlen = 0xFFFFFFFFL;
            hasZip64 = true;
        }
        if (xoff >= 0xFFFFFFFFL) {
            xoff = 0xFFFFFFFFL;
            hasZip64 = true;
        }
        if ((count = this.xentries.size()) >= 65535 && (hasZip64 |= true)) {
            count = 65535;
        }
        if (hasZip64) {
            long off64 = this.written;
            this.writeInt(101075792L);
            this.writeLong(44L);
            this.writeShort(45);
            this.writeShort(45);
            this.writeInt(0L);
            this.writeInt(0L);
            this.writeLong(this.xentries.size());
            this.writeLong(this.xentries.size());
            this.writeLong(len);
            this.writeLong(off);
            this.writeInt(117853008L);
            this.writeInt(0L);
            this.writeLong(off64);
            this.writeInt(1L);
        }
        this.writeInt(ENDSIG);
        this.writeShort(0);
        this.writeShort(0);
        this.writeShort(count);
        this.writeShort(count);
        this.writeInt(xlen);
        this.writeInt(xoff);
        if (this.comment != null) {
            this.writeShort(this.comment.length);
            this.writeBytes(this.comment, 0, this.comment.length);
        } else {
            this.writeShort(0);
        }
    }

    private int getExtraLen(byte[] extra) {
        if (extra == null) {
            return 0;
        }
        int skipped = 0;
        int len = extra.length;
        int off = 0;
        while (off + 4 <= len) {
            int tag = ZipOutStream.get16(extra, off);
            int sz = ZipOutStream.get16(extra, off + 2);
            if (sz < 0 || off + 4 + sz > len) break;
            if (tag == 21589 || tag == 1) {
                skipped += sz + 4;
            }
            off += sz + 4;
        }
        return len - skipped;
    }

    private void writeExtra(byte[] extra) throws IOException {
        if (extra != null) {
            int len = extra.length;
            int off = 0;
            while (off + 4 <= len) {
                int tag = ZipOutStream.get16(extra, off);
                int sz = ZipOutStream.get16(extra, off + 2);
                if (sz < 0 || off + 4 + sz > len) {
                    this.writeBytes(extra, off, len - off);
                    return;
                }
                if (tag != 21589 && tag != 1) {
                    this.writeBytes(extra, off, sz + 4);
                }
                off += sz + 4;
            }
            if (off < len) {
                this.writeBytes(extra, off, len - off);
            }
        }
    }

    protected void writeByte(int v) throws IOException {
        OutputStream out = this.out;
        out.write(v & 0xFF);
        ++this.written;
    }

    protected void writeShort(int v) throws IOException {
        OutputStream out = this.out;
        out.write(v >>> 0 & 0xFF);
        out.write(v >>> 8 & 0xFF);
        this.written += 2L;
    }

    protected void writeInt(long v) throws IOException {
        OutputStream out = this.out;
        out.write((int)(v >>> 0 & 0xFFL));
        out.write((int)(v >>> 8 & 0xFFL));
        out.write((int)(v >>> 16 & 0xFFL));
        out.write((int)(v >>> 24 & 0xFFL));
        this.written += 4L;
    }

    protected void writeLong(long v) throws IOException {
        OutputStream out = this.out;
        out.write((int)(v >>> 0 & 0xFFL));
        out.write((int)(v >>> 8 & 0xFFL));
        out.write((int)(v >>> 16 & 0xFFL));
        out.write((int)(v >>> 24 & 0xFFL));
        out.write((int)(v >>> 32 & 0xFFL));
        out.write((int)(v >>> 40 & 0xFFL));
        out.write((int)(v >>> 48 & 0xFFL));
        out.write((int)(v >>> 56 & 0xFFL));
        this.written += 8L;
    }

    protected void writeBytes(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.written += (long)len;
    }

    private static byte[] arrayCopyOf(byte[] original, int newLength) {
        byte[] copy = new byte[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    private static final FileTime unixTimeToFileTime(long utime) {
        return FileTime.fromSeconds(utime);
    }

    private static final FileTime winTimeToFileTime(long wtime) {
        return FileTime.fromMicros(wtime / 10L + -11644473600000000L);
    }

    private static long javaToDosTime(long time) {
        Date d = new Date(time);
        int year = d.getYear() + 1900;
        if (year < 1980) {
            return 0x210000L;
        }
        return year - 1980 << 25 | d.getMonth() + 1 << 21 | d.getDate() << 16 | d.getHours() << 11 | d.getMinutes() << 5 | d.getSeconds() >> 1;
    }

    private static long javaToExtendedDosTime(long time) {
        if (time < 0L) {
            return 0x210000L;
        }
        long dostime = ZipOutStream.javaToDosTime(time);
        return dostime != 0x210000L ? dostime + (time % 2000L << 32) : 0x210000L;
    }

    private static long dosToJavaTime(long dtime) {
        Date d = new Date((int)((dtime >> 25 & 0x7FL) + 80L), (int)((dtime >> 21 & 0xFL) - 1L), (int)(dtime >> 16 & 0x1FL), (int)(dtime >> 11 & 0x1FL), (int)(dtime >> 5 & 0x3FL), (int)(dtime << 1 & 0x3EL));
        return d.getTime();
    }

    private static long extendedDosToJavaTime(long xdostime) {
        long time = ZipOutStream.dosToJavaTime(xdostime);
        return time + (xdostime >> 32);
    }

    private long getBytesWritten(Deflater def) {
        return def.getTotalOut();
    }

    private long getBytesRead(Deflater def) {
        return def.getTotalIn();
    }

    protected static class FileTime {
        private long ms;

        private FileTime(long ms) {
            this.ms = ms;
        }

        public static FileTime fromMillis(long millis) {
            return new FileTime(millis);
        }

        public static FileTime fromSeconds(long seconds) {
            long millis = seconds * 1000L;
            return new FileTime(millis);
        }

        public static FileTime fromMicros(long micros) {
            long millis = micros / 1000L;
            return new FileTime(millis);
        }

        public long toMillis() {
            return this.ms;
        }

        public long toSeconds() {
            return this.ms / 1000L;
        }
    }

    public static class ZipEntry
    implements Cloneable {
        private static final int SHORT_MASK = 65535;
        private static final int SHORT_SHIFT = 16;
        String name;
        long xdostime = -1L;
        FileTime mtime;
        FileTime atime;
        FileTime ctime;
        long crc = -1L;
        long size = -1L;
        long csize = -1L;
        int method = -1;
        int flag = 0;
        byte[] extra;
        String comment;
        private int platform = 0;
        private long externalAttributes = 0L;
        private int internalAttributes = 0;
        public static final int STORED = 0;
        public static final int DEFLATED = 8;
        static final long DOSTIME_BEFORE_1980 = 0x210000L;
        private static final long UPPER_DOSTIME_BOUND = 4036608000000L;

        public ZipEntry(String name) {
            if (name == null) {
                throw new NullPointerException("name");
            }
            if (name.length() > 65535) {
                throw new IllegalArgumentException("entry name too long");
            }
            this.name = name;
        }

        public ZipEntry(ZipEntry e) {
            if (e == null) {
                throw new NullPointerException("entry");
            }
            this.name = e.name;
            this.xdostime = e.xdostime;
            this.mtime = e.mtime;
            this.atime = e.atime;
            this.ctime = e.ctime;
            this.crc = e.crc;
            this.size = e.size;
            this.csize = e.csize;
            this.method = e.method;
            this.flag = e.flag;
            this.extra = e.extra;
            this.comment = e.comment;
        }

        ZipEntry() {
        }

        public String getName() {
            return this.name;
        }

        public void setTime(long time) {
            this.xdostime = ZipOutStream.javaToExtendedDosTime(time);
            this.mtime = this.xdostime != 0x210000L && time <= 4036608000000L ? null : FileTime.fromMillis(time);
        }

        public long getTime() {
            if (this.mtime != null) {
                return this.mtime.toMillis();
            }
            return this.xdostime != -1L ? ZipOutStream.extendedDosToJavaTime(this.xdostime) : -1L;
        }

        public ZipEntry setLastModifiedTime(FileTime time) {
            if (time == null) {
                throw new NullPointerException("lastModifiedTime");
            }
            this.mtime = time;
            this.xdostime = ZipOutStream.javaToExtendedDosTime(time.toMillis());
            return this;
        }

        public FileTime getLastModifiedTime() {
            if (this.mtime != null) {
                return this.mtime;
            }
            if (this.xdostime == -1L) {
                return null;
            }
            return FileTime.fromMillis(this.getTime());
        }

        public ZipEntry setLastAccessTime(FileTime time) {
            if (time == null) {
                throw new NullPointerException("lastAccessTime");
            }
            this.atime = time;
            return this;
        }

        public FileTime getLastAccessTime() {
            return this.atime;
        }

        public ZipEntry setCreationTime(FileTime time) {
            if (time == null) {
                throw new NullPointerException("creationTime");
            }
            this.ctime = time;
            return this;
        }

        public FileTime getCreationTime() {
            return this.ctime;
        }

        public void setSize(long size) {
            if (size < 0L) {
                throw new IllegalArgumentException("invalid entry size");
            }
            this.size = size;
        }

        public long getSize() {
            return this.size;
        }

        public long getCompressedSize() {
            return this.csize;
        }

        public void setCompressedSize(long csize) {
            this.csize = csize;
        }

        public void setCrc(long crc) {
            if (crc < 0L || crc > 0xFFFFFFFFL) {
                throw new IllegalArgumentException("invalid entry crc-32");
            }
            this.crc = crc;
        }

        public long getCrc() {
            return this.crc;
        }

        public void setMethod(int method) {
            if (method != 0 && method != 8) {
                throw new IllegalArgumentException("invalid compression method");
            }
            this.method = method;
        }

        public int getMethod() {
            return this.method;
        }

        public void setExtra(byte[] extra) {
            this.setExtra0(extra, false);
        }

        void setExtra0(byte[] extra, boolean doZIP64) {
            if (extra != null) {
                if (extra.length > 65535) {
                    throw new IllegalArgumentException("invalid extra field length");
                }
                int off = 0;
                int len = extra.length;
                while (off + 4 < len) {
                    int sz;
                    int tag = ZipOutStream.get16(extra, off);
                    if ((off += 4) + (sz = ZipOutStream.get16(extra, off + 2)) > len) break;
                    switch (tag) {
                        case 1: {
                            if (!doZIP64 || sz < 16) break;
                            this.size = ZipOutStream.get64(extra, off);
                            this.csize = ZipOutStream.get64(extra, off + 8);
                            break;
                        }
                        case 10: {
                            int pos;
                            if (sz < 32 || ZipOutStream.get16(extra, pos = off + 4) != 1 || ZipOutStream.get16(extra, pos + 2) != 24) break;
                            this.mtime = ZipOutStream.winTimeToFileTime(ZipOutStream.get64(extra, pos + 4));
                            this.atime = ZipOutStream.winTimeToFileTime(ZipOutStream.get64(extra, pos + 12));
                            this.ctime = ZipOutStream.winTimeToFileTime(ZipOutStream.get64(extra, pos + 20));
                            break;
                        }
                        case 21589: {
                            int flag = ZipOutStream.byteToUnsignedInt(extra[off]);
                            int sz0 = 1;
                            if ((flag & 1) != 0 && sz0 + 4 <= sz) {
                                this.mtime = ZipOutStream.unixTimeToFileTime(ZipOutStream.get32(extra, off + sz0));
                                sz0 += 4;
                            }
                            if ((flag & 2) != 0 && sz0 + 4 <= sz) {
                                this.atime = ZipOutStream.unixTimeToFileTime(ZipOutStream.get32(extra, off + sz0));
                                sz0 += 4;
                            }
                            if ((flag & 4) == 0 || sz0 + 4 > sz) break;
                            this.ctime = ZipOutStream.unixTimeToFileTime(ZipOutStream.get32(extra, off + sz0));
                            sz0 += 4;
                            break;
                        }
                    }
                    off += sz;
                }
            }
            this.extra = extra;
        }

        public byte[] getExtra() {
            return this.extra;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        public String getComment() {
            return this.comment;
        }

        public boolean isDirectory() {
            return this.name.endsWith("/");
        }

        public String toString() {
            return this.getName();
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public Object clone() {
            try {
                ZipEntry e = (ZipEntry)super.clone();
                e.extra = this.extra == null ? null : (byte[])this.extra.clone();
                return e;
            }
            catch (CloneNotSupportedException e) {
                throw new Error(e);
            }
        }

        public long getExternalAttributes() {
            return this.externalAttributes;
        }

        public void setExternalAttributes(long value) {
            this.externalAttributes = value;
        }

        public void setUnixMode(int mode) {
            this.setExternalAttributes(mode << 16 | ((mode & 0x80) == 0 ? 1 : 0) | (this.isDirectory() ? 16 : 0));
            this.platform = 3;
        }

        public int getUnixMode() {
            return this.platform != 3 ? 0 : (int)(this.getExternalAttributes() >> 16 & 0xFFFFL);
        }

        public int getPlatform() {
            return this.platform;
        }

        protected void setPlatform(int platform) {
            this.platform = platform;
        }

        public int getInternalAttributes() {
            return this.internalAttributes;
        }

        public void setInternalAttributes(int internalAttributes) {
            this.internalAttributes = internalAttributes;
        }
    }

    protected static class ZipCoder {
        private Charset cs;
        private CharsetDecoder dec;
        private CharsetEncoder enc;
        private boolean isUTF8;
        private ZipCoder utf8;

        byte[] getBytes(String s) {
            CharsetEncoder ce = this.encoder().reset();
            char[] ca = s.toCharArray();
            int len = (int)((float)ca.length * ce.maxBytesPerChar());
            byte[] ba = new byte[len];
            if (len == 0) {
                return ba;
            }
            if (this.isUTF8) {
                throw new UnsupportedOperationException("TODO isUTF8=" + this.isUTF8 + ", encoder=" + ce);
            }
            ByteBuffer bb = ByteBuffer.wrap(ba);
            CharBuffer cb = CharBuffer.wrap(ca);
            CoderResult cr = ce.encode(cb, bb, true);
            if (!cr.isUnderflow()) {
                throw new IllegalArgumentException(cr.toString());
            }
            cr = ce.flush(bb);
            if (!cr.isUnderflow()) {
                throw new IllegalArgumentException(cr.toString());
            }
            if (bb.position() == ba.length) {
                return ba;
            }
            return ZipOutStream.arrayCopyOf(ba, bb.position());
        }

        boolean isUTF8() {
            return this.isUTF8;
        }

        private ZipCoder(Charset cs) {
            this.cs = cs;
            this.isUTF8 = cs.name().equals(UTF_8.name());
        }

        static ZipCoder get(Charset charset) {
            return new ZipCoder(charset);
        }

        private CharsetDecoder decoder() {
            if (this.dec == null) {
                this.dec = this.cs.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
            }
            return this.dec;
        }

        private CharsetEncoder encoder() {
            if (this.enc == null) {
                this.enc = this.cs.newEncoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
            }
            return this.enc;
        }
    }

    private static class XEntry {
        final ZipEntry entry;
        final long offset;

        public XEntry(ZipEntry entry, long offset) {
            this.entry = entry;
            this.offset = offset;
        }
    }
}

