/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.project.common;

import com.spacekiller.project.ProjectScope;
import com.spacekiller.project.ProjectType;
import com.spacekiller.project.common.AbstractProjectScope;
import java.util.Collection;
import java.util.Map;

public abstract class AbstractProjectType
implements ProjectType {
    protected final String name;
    protected Map<String, AbstractProjectScope> scopeMap;

    public AbstractProjectType(String name) {
        this.name = name;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public ProjectScope getScope(String scope) {
        return this.scopeMap.get(scope);
    }

    @Override
    public int getScopes(Collection<ProjectScope> dst) {
        int num = 0;
        for (AbstractProjectScope scope : this.scopeMap.values()) {
            dst.add(scope);
            ++num;
        }
        return num;
    }

    protected AbstractProjectScope addScope(AbstractProjectScope scope) {
        return this.scopeMap.put(scope.getName(), scope);
    }

    protected boolean removeScope(AbstractProjectScope scope) {
        String key = scope.getName();
        AbstractProjectScope old = this.scopeMap.get(key);
        if (old == scope) {
            return this.scopeMap.remove(key) != null;
        }
        return false;
    }
}

