/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.project.common;

import com.spacekiller.project.Checksum;
import java.util.Arrays;

public class DefaultChecksum
implements Checksum {
    private final String type;
    private final byte[] data;
    private final int hash;

    public DefaultChecksum(String type, byte[] data) {
        this.type = type;
        this.data = data;
        this.hash = this.hashCode(type, data);
    }

    public String toString() {
        return super.toString() + "[type=" + this.type + ", hash=" + Integer.toHexString(this.hash) + "]";
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public int getSize() {
        byte[] arr = this.data;
        return arr == null ? 0 : this.data.length;
    }

    @Override
    public int getBytes(byte[] dst, int off, int len) {
        byte[] arr = this.data;
        if (arr == null) {
            return 0;
        }
        int num = Math.min(arr.length, len);
        System.arraycopy(arr, 0, dst, off, num);
        return num;
    }

    protected int hashCode(String type, byte[] data) {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(data);
        result = 31 * result + (type == null ? 0 : type.hashCode());
        return result;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultChecksum other = (DefaultChecksum)obj;
        if (this.hash != other.hash) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        return Arrays.equals(this.data, other.data);
    }
}

