/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.status;

import com.spacekiller.util.Data;
import com.spacekiller.util.Execution;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class ExecutionTableModel
implements TableModel {
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_PROGRESS = 1;
    public static final int COLUMN_TIME_ELAPSED = 2;
    public static final int COLUMN_TIME_LEFT = 3;
    public static final int COLUMNS = 4;
    private List records = new ArrayList();
    private int columnCount = 4;
    private transient List tableModelListeners;

    public Class getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Double.class;
            }
            case 2: {
                return Long.class;
            }
            case 3: {
                return Long.class;
            }
        }
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Action";
            }
            case 1: {
                return "Progress";
            }
            case 2: {
                return "Elapsed";
            }
            case 3: {
                return "Remaining";
            }
        }
        return "Column" + columnIndex;
    }

    @Override
    public int getRowCount() {
        return this.records.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Execution exec = this.getExecutionAt(rowIndex);
        if (exec == null) {
            return null;
        }
        switch (columnIndex) {
            case 0: {
                return exec.getName();
            }
            case 1: {
                return Data.toDouble((double)exec.getProgress());
            }
            case 2: {
                return Data.toLong((long)exec.getElapsedMillis());
            }
            case 3: {
                return Data.toLong((long)(exec.getEstimatedMillis() - exec.getElapsedMillis()));
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    protected Execution getExecutionAt(int i) {
        return (Execution)this.records.get(i);
    }

    public synchronized void addExecution(Execution rec) {
        int row = this.records.size();
        this.records.add(rec);
        this.fireTableRowsInserted(row, row);
    }

    public synchronized void removeExecutionAt(int i) {
        this.records.remove(i);
        this.fireTableRowsDeleted(i, i);
    }

    public synchronized void removeExecution(Execution x) {
        int i = this.records.indexOf(x);
        if (i >= 0) {
            this.records.remove(i);
            this.fireTableRowsDeleted(i, i);
        }
    }

    protected void fireTableChanged(TableModelEvent e) {
        if (this.tableModelListeners == null) {
            return;
        }
        int currentSize = this.tableModelListeners.size();
        for (int index = 0; index < currentSize; ++index) {
            TableModelListener ls = (TableModelListener)this.tableModelListeners.get(index);
            if (ls == null) continue;
            ls.tableChanged(e);
        }
    }

    public void fireTableRowsInserted(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, 1));
    }

    public void fireTableRowsDeleted(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, -1));
    }

    @Override
    public void addTableModelListener(TableModelListener listener) {
        if (this.tableModelListeners == null) {
            this.tableModelListeners = new LinkedList();
        }
        this.tableModelListeners.add(listener);
    }

    @Override
    public void removeTableModelListener(TableModelListener listener) {
        if (this.tableModelListeners != null) {
            this.tableModelListeners.remove(listener);
        }
    }

    public TableModelListener[] getTableModelListeners() {
        if (this.tableModelListeners == null) {
            return new TableModelListener[0];
        }
        return this.tableModelListeners.toArray(new TableModelListener[this.tableModelListeners.size()]);
    }

    public synchronized void clear() {
        if (this.records.isEmpty()) {
            return;
        }
        int num = this.records.size();
        this.records.clear();
        this.fireTableRowsDeleted(0, num - 1);
    }
}

