/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.status;

import com.spacekiller.util.Filter;
import com.spacekiller.util.status.LogRecordTableModel;
import com.spacekiller.util.tooling.ToolContext;
import com.spacekiller.util.tooling.ToolGroup;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;

public class LogRecordTableViewer
extends JPanel {
    private static final long serialVersionUID = -7308141878580047926L;
    private static final Logger logger = Logger.getLogger(LogRecordTableViewer.class.getName());
    private LogRecordTableModel model;
    private Filter filter;
    private LogHandler logHandler = new LogHandler();
    private Publisher publisher = new Publisher();
    private ToolContext toolContext;
    private ToolGroup toolbarGroup;
    private JScrollPane jScrollPane = null;
    private JTable jTableLog = null;
    private boolean autoScroll = true;
    private JPanel jPanelToolbar = null;
    private JLabel jLabel = null;

    public LogRecordTableViewer() {
        this.initialize();
        this.initLogRecordTableViewer();
    }

    protected void initLogRecordTableViewer() {
        FontMetrics fm;
        this.model = new LogRecordTableModel();
        this.getJTableLog().setAutoResizeMode(0);
        this.getJTableLog().setColumnSelectionAllowed(false);
        this.getJTableLog().setRowSelectionAllowed(true);
        this.getJTableLog().setModel(this.model);
        DefaultTableColumnModel columnModel = new DefaultTableColumnModel();
        LogRecordCellRenderer renderer = new LogRecordCellRenderer();
        TableColumn col = new TableColumn(0, 70, renderer, null);
        col.setHeaderValue("Level");
        columnModel.addColumn(col);
        col = new TableColumn(1, 400, renderer, null);
        col.setHeaderValue("Message");
        columnModel.addColumn(col);
        col = new TableColumn(2, 45, renderer, null);
        col.setHeaderValue("Thread");
        columnModel.addColumn(col);
        col = new TableColumn(3, 80, renderer, null);
        col.setHeaderValue("Log");
        columnModel.addColumn(col);
        col = new TableColumn(4, 300, renderer, null);
        col.setHeaderValue("Class");
        columnModel.addColumn(col);
        col = new TableColumn(5, 100, renderer, null);
        col.setHeaderValue("Method");
        columnModel.addColumn(col);
        col = new TableColumn(6, 150, renderer, null);
        col.setHeaderValue("Time");
        columnModel.addColumn(col);
        this.getJTableLog().setColumnModel(columnModel);
        Font font = renderer.getFont();
        if (font != null && (fm = this.getFontMetrics(font)) != null) {
            int rowHeight = fm.getHeight() + this.getJTableLog().getRowMargin();
            this.getJTableLog().setRowHeight(rowHeight);
        }
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.gridx = 0;
        gridBagConstraints11.fill = 2;
        gridBagConstraints11.gridy = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(337, 262));
        this.add((Component)this.getJScrollPane(), gridBagConstraints);
        this.add((Component)this.getJPanelToolbar(), gridBagConstraints11);
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public LogHandler getLogHandler() {
        return this.logHandler;
    }

    protected void setLogHandler(LogHandler logHandler) {
        this.logHandler = logHandler;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJTableLog());
        }
        return this.jScrollPane;
    }

    private JTable getJTableLog() {
        if (this.jTableLog == null) {
            this.jTableLog = new JTable();
        }
        return this.jTableLog;
    }

    public boolean isAutoScroll() {
        return this.autoScroll;
    }

    public void setAutoScroll(boolean autoScroll) {
        this.autoScroll = autoScroll;
    }

    public void clear() {
        this.model.clear();
    }

    public ToolGroup getToolbarGroup() {
        return this.toolbarGroup;
    }

    public void setToolbarGroup(ToolGroup toolbarGroup) {
        Object instance;
        this.toolbarGroup = toolbarGroup;
        this.getJPanelToolbar().removeAll();
        if (toolbarGroup != null && (instance = toolbarGroup.createInstance(this.toolContext)) != null && instance instanceof Component) {
            this.getJPanelToolbar().add((Component)instance);
        }
        this.getJPanelToolbar().validate();
        this.getJPanelToolbar().repaint();
    }

    public ToolContext getToolContext() {
        return this.toolContext;
    }

    public void setToolContext(ToolContext toolContext) {
        this.toolContext = toolContext;
    }

    private JPanel getJPanelToolbar() {
        if (this.jPanelToolbar == null) {
            this.jLabel = new JLabel();
            this.jLabel.setText("Toolbar");
            GridLayout gridLayout = new GridLayout();
            gridLayout.setRows(1);
            this.jPanelToolbar = new JPanel();
            this.jPanelToolbar.setLayout(gridLayout);
            this.jPanelToolbar.setOpaque(false);
            this.jPanelToolbar.add((Component)this.jLabel, null);
        }
        return this.jPanelToolbar;
    }

    protected class LogRecordCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -7617080887792582096L;
        private Map levelIconMap = new HashMap();

        public LogRecordCellRenderer() {
            this.initLogRecordCellRenderer();
        }

        protected void initLogRecordCellRenderer() {
            try {
                ImageIcon iconInfo = new ImageIcon(this.getClass().getResource("/com/spacekiller/util/status/icons/info4.gif"));
                this.levelIconMap.put(Level.ALL, iconInfo);
                this.levelIconMap.put(Level.FINEST, iconInfo);
                this.levelIconMap.put(Level.FINER, iconInfo);
                this.levelIconMap.put(Level.FINE, iconInfo);
                this.levelIconMap.put(Level.INFO, iconInfo);
                this.levelIconMap.put(Level.CONFIG, iconInfo);
                ImageIcon iconWarn = new ImageIcon(this.getClass().getResource("/com/spacekiller/util/status/icons/warn.gif"));
                this.levelIconMap.put(Level.WARNING, iconWarn);
                ImageIcon iconErr = new ImageIcon(this.getClass().getResource("/com/spacekiller/util/status/icons/picError.gif"));
                this.levelIconMap.put(Level.SEVERE, iconErr);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            Icon icon = null;
            TableColumn col = table.getColumnModel().getColumn(column);
            int colIndex = col.getModelIndex();
            if (colIndex == 0) {
                icon = (Icon)this.levelIconMap.get(value);
            }
            this.setIcon(icon);
            return this;
        }
    }

    protected class Publisher
    implements Runnable {
        private LinkedList list = new LinkedList();
        private LinkedList list2 = new LinkedList();
        private boolean todo = false;

        protected Publisher() {
        }

        public synchronized void add(LogRecord rec) {
            this.list.add(rec);
            if (!this.todo) {
                SwingUtilities.invokeLater(this);
                this.todo = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LinkedList l = this.list;
            Publisher publisher = this;
            synchronized (publisher) {
                this.list = this.list2;
                this.list2 = l;
                this.todo = false;
            }
            int row = -1;
            Iterator i = l.iterator();
            while (i.hasNext()) {
                LogRecord rec = (LogRecord)i.next();
                i.remove();
                row = LogRecordTableViewer.this.model.getRowCount();
                LogRecordTableViewer.this.model.addRecord(rec);
            }
            if (row >= 0 && LogRecordTableViewer.this.autoScroll) {
                Rectangle rect = LogRecordTableViewer.this.getJTableLog().getCellRect(row, 0, true);
                LogRecordTableViewer.this.getJTableLog().scrollRectToVisible(rect);
            }
        }
    }

    protected class LogHandler
    extends Handler {
        protected LogHandler() {
        }

        @Override
        public void close() throws SecurityException {
        }

        @Override
        public void flush() {
        }

        @Override
        public void publish(LogRecord record) {
            Filter f = LogRecordTableViewer.this.filter;
            if (f != null && !f.accept((Object)record)) {
                return;
            }
            LogRecordTableViewer.this.publisher.add(record);
        }
    }
}

