/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.status;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;

public class StatusLayout
implements LayoutManager {
    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void layoutContainer(Container parent) {
        Component[] comps = parent.getComponents();
        int[] minWidth = new int[comps.length];
        int[] extraWidth = new int[comps.length];
        int totalMinWidth = 0;
        int totalExtraWidth = 0;
        for (int c = 0; c < comps.length; ++c) {
            Component comp = comps[c];
            Dimension min = comp == null ? null : comp.getMinimumSize();
            Dimension pref = comp == null ? null : comp.getPreferredSize();
            Dimension max = comp == null ? null : comp.getMaximumSize();
            minWidth[c] = min == null ? 0 : Math.max(0, min.width);
            int n = extraWidth[c] = pref == null ? 0 : Math.max(0, pref.width);
            if (max != null && extraWidth[c] > max.width) {
                extraWidth[c] = max.width;
            }
            extraWidth[c] = extraWidth[c] - minWidth[c];
            if (extraWidth[c] < 0) {
                extraWidth[c] = 0;
            }
            totalMinWidth += minWidth[c];
            totalExtraWidth += extraWidth[c];
        }
        Dimension size = parent.getSize();
        if (size.width < totalMinWidth) {
            double factor = totalMinWidth == 0 ? 1.0 : (double)size.width / (double)totalMinWidth;
            for (int c = 0; c < minWidth.length; ++c) {
                extraWidth[c] = 0;
                minWidth[c] = (int)((double)minWidth[c] * factor);
            }
        } else if (size.width <= totalMinWidth + totalExtraWidth) {
            int delta = size.width - totalMinWidth;
            double factor = totalExtraWidth == 0 ? 1.0 : (double)delta / (double)totalExtraWidth;
            for (int c = 0; c < minWidth.length; ++c) {
                extraWidth[c] = (int)((double)extraWidth[c] * factor);
            }
        }
        int x = 0;
        int y = 0;
        int w = 0;
        int h = size.height;
        for (int c = 0; c < comps.length; ++c) {
            Component comp = comps[c];
            if (comp == null) continue;
            w = minWidth[c] + extraWidth[c];
            comp.setBounds(x, y, w, h);
            x += w;
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        int w = 0;
        int h = 0;
        Component[] comps = parent.getComponents();
        for (int c = 0; c < comps.length; ++c) {
            Dimension dim;
            Component comp = comps[c];
            if (comp == null || (dim = comp.getMinimumSize()) == null) continue;
            w += dim.width;
            if (dim.height <= h) continue;
            h = dim.height;
        }
        return new Dimension(w, h);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        int w = 0;
        int h = 0;
        Component[] comps = parent.getComponents();
        for (int c = 0; c < comps.length; ++c) {
            Dimension dim;
            Component comp = comps[c];
            if (comp == null || (dim = comp.getPreferredSize()) == null) continue;
            w += dim.width;
            if (dim.height <= h) continue;
            h = dim.height;
        }
        return new Dimension(w, h);
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }
}

