/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.status;

import com.spacekiller.util.status.StatusBar;
import com.spacekiller.util.tooling.AbstractToolGroup;
import com.spacekiller.util.tooling.Tool;
import com.spacekiller.util.tooling.ToolContext;
import com.spacekiller.util.tooling.ToolEvent;
import java.awt.Component;
import java.awt.Container;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class TMonitorTray
extends AbstractToolGroup {
    private static final Logger logger = Logger.getLogger(TMonitorTray.class.getName());

    public Object createInstance(ToolContext context, Class type) {
        StatusBar rc = new StatusBar();
        rc.setOpaque(false);
        this.addInstance(rc, context);
        this.refreshInstance(rc);
        this.installContainerChildren(rc, null);
        return rc;
    }

    protected void handleChildrenAdded(ToolEvent ev) {
        this.handleStatusChildrenAdded(ev, null);
    }

    protected void handleChildrenRemoved(ToolEvent ev) {
        this.handleStatusChildrenRemoved(ev);
    }

    protected void handleStatusChildrenAdded(ToolEvent ev, Class childType) {
        Iterator i = this.getInstances();
        while (i.hasNext()) {
            Container cont = (Container)i.next();
            if (cont == null) continue;
            ToolContext ctx = this.getToolContext(cont);
            int count = ev.getChildCount();
            if (count <= 0) continue;
            for (int j = 0; j < count; ++j) {
                Component cc = (Component)ev.getChild(j).createInstance(ctx, childType);
                if (cc == null) {
                    logger.fine("OOPS, no component available for tool!");
                    logger.fine(" - Tool=" + ev.getChild(j));
                    logger.fine(" - Type=" + childType);
                    continue;
                }
                cont.add(cc, ev.getChildIndex(j));
            }
            cont.validate();
            cont.repaint();
        }
    }

    protected void handleStatusChildrenRemoved(ToolEvent ev) {
        Iterator i = this.getInstances();
        while (i.hasNext()) {
            int count;
            Container cont = (Container)i.next();
            if (cont == null || (count = ev.getChildCount()) <= 0) continue;
            for (int j = count - 1; j >= 0; --j) {
                cont.remove(ev.getChildIndex(j));
            }
            cont.validate();
            cont.repaint();
        }
    }

    protected void refreshInstance(Object o) {
        JComponent m = (JComponent)o;
        try {
            m.setName(this.getName());
            m.setToolTipText(this.getTooltip());
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected void installContainerChildren(Container container, Class childType) {
        int count = this.getChildCount();
        ToolContext ctx = this.getToolContext(container);
        for (int c = 0; c < count; ++c) {
            Tool tool = this.getChildAt(c);
            Object obj = tool.createInstance(ctx, childType);
            Component comp = null;
            if (obj instanceof Component) {
                comp = (Component)obj;
            }
            if (comp != null) {
                Component cc = comp;
                container.add(cc, c);
                continue;
            }
            logger.fine("Warning: No component available: tool=" + this.getChildAt(c) + ", type=" + childType);
            JPanel dummy = new JPanel();
            dummy.setOpaque(false);
            container.add((Component)dummy, c);
        }
    }
}

