/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.file;

import com.spacekiller.util.file.FileAccess;
import java.io.IOException;
import java.io.RandomAccessFile;

public final class DefaultFileAccess
implements FileAccess {
    private RandomAccessFile raf;

    public DefaultFileAccess(RandomAccessFile raf) throws IOException {
        this.raf = raf;
    }

    @Override
    public boolean isClosed() {
        return this.raf == null;
    }

    @Override
    public synchronized void close() throws IOException {
        RandomAccessFile r = this.raf;
        if (r == null) {
            return;
        }
        this.raf = null;
        r.close();
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public synchronized long length() throws IOException {
        return this.raf.length();
    }

    @Override
    public synchronized void read(long pos, byte[] b, int off, int len) throws IOException {
        this.raf.seek(pos);
        this.raf.readFully(b, off, len);
    }

    @Override
    public synchronized void write(long pos, byte[] b, int off, int len) throws IOException {
        this.raf.seek(pos);
        this.raf.write(b, off, len);
    }
}

