/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.service;

import com.spacekiller.util.ListenerList;
import com.spacekiller.util.service.Service;
import com.spacekiller.util.service.ServiceListener;

public abstract class AbstractService
implements Service {
    private String name = this.getClass().getName();
    private String description;
    private String tooltip;
    private int startupMode = 0;
    private volatile int status = 0;
    private ListenerList<ServiceListener> serviceListeners = new ListenerList(ServiceListener.class);

    public String toString() {
        return super.toString() + "[name=" + this.name + "]";
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    protected synchronized void setStatus(int newStatus) {
        if (this.status == newStatus) {
            return;
        }
        this.status = newStatus;
        switch (this.status) {
            case 1: {
                this.fireServiceStarted();
                break;
            }
            case 0: {
                this.fireServiceStopped();
                break;
            }
            case 2: {
                this.fireServiceStarting();
                break;
            }
            case 3: {
                this.fireServiceStopping();
            }
        }
    }

    @Override
    public String getTooltip() {
        return this.tooltip;
    }

    public synchronized void setTooltip(String tooltip) {
        this.tooltip = tooltip;
        this.fireServiceUpdated();
    }

    @Override
    public void addServiceListener(ServiceListener l) {
        if (l == null) {
            return;
        }
        this.serviceListeners.add((Object)l);
    }

    @Override
    public void removeServiceListener(ServiceListener l) {
        if (l == null) {
            return;
        }
        this.serviceListeners.remove((Object)l);
    }

    protected synchronized void fireServiceStarted() {
        for (ServiceListener l : (ServiceListener[])this.serviceListeners.array()) {
            l.serviceStarted(this);
        }
    }

    protected synchronized void fireServiceStopped() {
        for (ServiceListener l : (ServiceListener[])this.serviceListeners.array()) {
            l.serviceStopped(this);
        }
    }

    protected synchronized void fireServiceStarting() {
        for (ServiceListener l : (ServiceListener[])this.serviceListeners.array()) {
            l.serviceStarting(this);
        }
    }

    protected synchronized void fireServiceStopping() {
        for (ServiceListener l : (ServiceListener[])this.serviceListeners.array()) {
            l.serviceStopping(this);
        }
    }

    protected synchronized void fireServiceUpdated() {
        for (ServiceListener l : (ServiceListener[])this.serviceListeners.array()) {
            l.serviceUpdated(this);
        }
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public synchronized void setDescription(String description) {
        this.description = description;
        this.fireServiceUpdated();
    }

    @Override
    public void restart() throws Exception {
        this.stop();
        this.start();
    }

    @Override
    public int getStartupMode() {
        return this.startupMode;
    }

    @Override
    public synchronized void setStartupMode(int newStartupMode) {
        if (this.startupMode == newStartupMode) {
            return;
        }
        this.startupMode = newStartupMode;
        this.fireServiceUpdated();
    }

    protected synchronized void save() {
        this.fireServiceUpdated();
    }
}

