/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.service;

import com.spacekiller.util.ListenerList;
import com.spacekiller.util.Platform;
import com.spacekiller.util.Preferences;
import com.spacekiller.util.PreferencesRegistry;
import com.spacekiller.util.service.AbstractService;
import com.spacekiller.util.service.Service;
import com.spacekiller.util.service.ServiceListener;
import com.spacekiller.util.service.ServiceProvider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractServiceProvider
implements ServiceProvider {
    public static final String KEY_PREFIX = "service.";
    private List services;
    private ListenerList<ServiceListener> serviceListeners;
    private ServiceHandler serviceHandler = new ServiceHandler();
    private static final Logger logger = Logger.getLogger(AbstractServiceProvider.class.getName());

    public AbstractServiceProvider() {
        this.services = new ArrayList();
        this.serviceListeners = new ListenerList(ServiceListener.class);
    }

    @Override
    public Iterator getServices() {
        return this.services.iterator();
    }

    protected void addService(Service service) {
        if (service == null) {
            return;
        }
        if (this.services.contains(service)) {
            return;
        }
        if (this.services.add(service)) {
            service.addServiceListener(this.serviceHandler);
            this.fireServiceAdded(service);
        }
    }

    protected void removeService(Service service) {
        if (this.services.remove(service)) {
            service.removeServiceListener(this.serviceHandler);
            this.fireServiceRemoved(service);
        }
    }

    @Override
    public void addServiceListener(ServiceListener l) {
        if (l == null) {
            return;
        }
        this.serviceListeners.add((Object)l);
    }

    @Override
    public void removeServiceListener(ServiceListener l) {
        if (l == null) {
            return;
        }
        this.serviceListeners.remove((Object)l);
    }

    protected synchronized void fireServiceAdded(Service s) {
        for (ServiceListener l : (ServiceListener[])this.serviceListeners.array()) {
            l.serviceAdded(s);
        }
    }

    protected synchronized void fireServiceRemoved(Service s) {
        for (ServiceListener l : (ServiceListener[])this.serviceListeners.array()) {
            l.serviceRemoved(s);
        }
    }

    protected void handleServiceUpdated(Service service) {
        if (service == null) {
            return;
        }
        if (!this.services.contains(service)) {
            return;
        }
        try {
            this.saveServicePreferences(service);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected Preferences getServicePreferences(String serviceName) throws Exception {
        Platform plat = Platform.getInstance();
        PreferencesRegistry reg = plat.getPreferencesRegistry();
        String key = KEY_PREFIX + serviceName;
        return reg.getPreferences(key);
    }

    protected Preferences createServicePreferences(String serviceName) throws Exception {
        Platform plat = Platform.getInstance();
        PreferencesRegistry reg = plat.getPreferencesRegistry();
        String key = KEY_PREFIX + serviceName;
        return reg.createPreferences(key);
    }

    protected void saveServicePreferences(Service service) throws Exception {
        String name = service.getName();
        Preferences prefs = this.getServicePreferences(name);
        if (prefs == null) {
            prefs = this.createServicePreferences(name);
        }
        this.saveServicePreferences(service, prefs);
        Platform plat = Platform.getInstance();
        PreferencesRegistry reg = plat.getPreferencesRegistry();
        reg.savePreferences(prefs);
    }

    protected void saveServicePreferences(Service service, Preferences prefs) throws Exception {
        String name = service.getName();
        String descr = service.getDescription();
        String tip = service.getTooltip();
        int startupMode = service.getStartupMode();
        prefs.setObject("name", (Object)name);
        prefs.setObject("description", (Object)descr);
        prefs.setObject("tooltip", (Object)tip);
        prefs.setInt("startupMode", startupMode);
    }

    protected void loadServicePreferences(Service service) throws Exception {
        try {
            String name = service.getName();
            Preferences prefs = this.getServicePreferences(name);
            if (prefs == null) {
                return;
            }
            this.loadServicePreferences(service, prefs);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void loadServicePreferences(Service service, Preferences prefs) throws Exception {
        AbstractService as = (AbstractService)service;
        String name = (String)prefs.getObject("name");
        if (name == null) {
            return;
        }
        if (!name.equals(service.getName())) {
            return;
        }
        String descr = (String)prefs.getObject("description");
        String tip = (String)prefs.getObject("tooltip");
        int startupMode = prefs.getInt("startupMode");
        as.setDescription(descr);
        as.setTooltip(tip);
        as.setStartupMode(startupMode);
    }

    protected class ServiceHandler
    implements ServiceListener {
        protected ServiceHandler() {
        }

        @Override
        public void serviceAdded(Service service) {
        }

        @Override
        public void serviceRemoved(Service service) {
        }

        @Override
        public void serviceStarted(Service service) {
        }

        @Override
        public void serviceStarting(Service service) {
        }

        @Override
        public void serviceStopped(Service service) {
        }

        @Override
        public void serviceStopping(Service service) {
        }

        @Override
        public void serviceUpdated(Service service) {
            AbstractServiceProvider.this.handleServiceUpdated(service);
        }
    }
}

