/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.login;

import com.spacekiller.util.login.DefaultLoginIcons;
import com.spacekiller.util.login.LoginIconProvider;
import com.spacekiller.util.login.LoginRegistry;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DefaultLoginPanel
extends JPanel {
    private static final long serialVersionUID = 9217401071845840309L;
    private static final Logger logger = Logger.getLogger(DefaultLoginPanel.class.getName());
    private String loginRealm;
    private LoginIconProvider loginIconProvider;
    private LoginRegistry loginRegistry;
    private List callbackWrappers = new ArrayList();
    private NameCallbackWrapper userNameWrapper;
    private PasswordCallbackWrapper userPassWrapper;
    private Object inputFocus;
    private Icon nameIcon;
    private Icon passIcon;
    private Icon textIcon;
    private Icon infoIcon;
    private Icon warnIcon;
    private Icon errorIcon;
    private JLabel labelLoginIcon;
    private JPanel panelCallbacks;
    private JPanel panelOptions;
    private JCheckBox chckbxRememberPasswordRegistry;

    public DefaultLoginPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0};
        gridBagLayout.columnWeights = new double[]{1.0, 0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JPanel panelLoginIcon = new JPanel();
        GridBagConstraints gbc_panelLoginIcon = new GridBagConstraints();
        gbc_panelLoginIcon.insets = new Insets(4, 0, 5, 0);
        gbc_panelLoginIcon.fill = 1;
        gbc_panelLoginIcon.gridx = 1;
        gbc_panelLoginIcon.gridy = 0;
        this.add((Component)panelLoginIcon, gbc_panelLoginIcon);
        panelLoginIcon.setLayout(new BorderLayout(0, 0));
        this.labelLoginIcon = new JLabel("Icon");
        this.labelLoginIcon.setToolTipText("Hashcode Icon");
        panelLoginIcon.add((Component)this.labelLoginIcon, "North");
        this.panelCallbacks = new JPanel();
        GridBagConstraints gbc_panelCallbacks = new GridBagConstraints();
        gbc_panelCallbacks.insets = new Insets(0, 0, 5, 5);
        gbc_panelCallbacks.weighty = 1.0;
        gbc_panelCallbacks.weightx = 1.0;
        gbc_panelCallbacks.fill = 1;
        gbc_panelCallbacks.gridx = 0;
        gbc_panelCallbacks.gridy = 0;
        this.add((Component)this.panelCallbacks, gbc_panelCallbacks);
        GridBagLayout gbl_panelCallbacks = new GridBagLayout();
        gbl_panelCallbacks.columnWidths = new int[]{0};
        gbl_panelCallbacks.rowHeights = new int[]{0};
        gbl_panelCallbacks.columnWeights = new double[]{Double.MIN_VALUE};
        gbl_panelCallbacks.rowWeights = new double[]{Double.MIN_VALUE};
        this.panelCallbacks.setLayout(gbl_panelCallbacks);
        this.panelOptions = new JPanel();
        GridBagConstraints gbc_panelOptions = new GridBagConstraints();
        gbc_panelOptions.insets = new Insets(0, 0, 0, 5);
        gbc_panelOptions.fill = 1;
        gbc_panelOptions.gridx = 0;
        gbc_panelOptions.gridy = 1;
        this.add((Component)this.panelOptions, gbc_panelOptions);
        GridBagLayout gbl_panelOptions = new GridBagLayout();
        gbl_panelOptions.columnWidths = new int[]{0, 0};
        gbl_panelOptions.rowHeights = new int[]{0, 0};
        gbl_panelOptions.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panelOptions.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.panelOptions.setLayout(gbl_panelOptions);
        this.chckbxRememberPasswordRegistry = new JCheckBox("Remember password");
        GridBagConstraints gbc_chckbxRememberPasswordRegistry = new GridBagConstraints();
        gbc_chckbxRememberPasswordRegistry.gridx = 0;
        gbc_chckbxRememberPasswordRegistry.gridy = 0;
        this.panelOptions.add((Component)this.chckbxRememberPasswordRegistry, gbc_chckbxRememberPasswordRegistry);
        this.initDefaultLoginPanel();
    }

    protected void initDefaultLoginPanel() {
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                this.requestFocus();
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
                this.requestFocus();
            }

            @Override
            public void ancestorAdded(AncestorEvent event) {
                this.requestFocus();
            }

            protected void requestFocus() {
                Object obj = DefaultLoginPanel.this.inputFocus;
                if (obj != null && obj instanceof Component) {
                    Component comp = (Component)obj;
                    comp.requestFocus();
                }
            }
        });
        DefaultLoginIcons icons = DefaultLoginIcons.getInstance();
        if (icons != null) {
            this.nameIcon = icons.getLoginIcon("nameIcon");
            this.passIcon = icons.getLoginIcon("passIcon");
            this.textIcon = icons.getLoginIcon("textIcon");
            this.infoIcon = icons.getLoginIcon("infoIcon");
            this.warnIcon = icons.getLoginIcon("warnIcon");
            this.errorIcon = icons.getLoginIcon("errorIcon");
        }
    }

    protected JLabel getLabelLoginIcon() {
        return this.labelLoginIcon;
    }

    protected JPanel getPanelCallbacks() {
        return this.panelCallbacks;
    }

    protected LoginIconProvider getLoginIconProvider() {
        return this.loginIconProvider;
    }

    public void setLoginIconProvider(LoginIconProvider loginIconProvider) {
        this.loginIconProvider = loginIconProvider;
        this.updateLoginIcon();
    }

    protected LoginRegistry getLoginRegistry() {
        return this.loginRegistry;
    }

    public void setLoginRegistry(LoginRegistry loginRegistry) {
        this.loginRegistry = loginRegistry;
    }

    public String getLoginRealm() {
        return this.loginRealm;
    }

    public void setLoginRealm(String loginRealm) {
        this.loginRealm = loginRealm;
    }

    public synchronized void setupLoginPanel(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        this.resetLoginPanel();
        int nameCount = 0;
        int passCount = 0;
        CallbackWrapper focusWrapper = null;
        for (Callback callback : callbacks) {
            CallbackWrapper wrapper;
            if (callback == null) continue;
            if (callback instanceof NameCallback) {
                NameCallback nameCallback = (NameCallback)callback;
                wrapper = new NameCallbackWrapper(nameCallback);
                this.callbackWrappers.add(wrapper);
                if (focusWrapper == null) {
                    String name = nameCallback.getName();
                    String defaultName = nameCallback.getDefaultName();
                    if (!(name != null && name.length() >= 1 || defaultName != null && defaultName.length() >= 1)) {
                        focusWrapper = wrapper;
                    }
                }
                if (this.userNameWrapper == null) {
                    this.userNameWrapper = wrapper;
                }
                ++nameCount;
                continue;
            }
            if (callback instanceof PasswordCallback) {
                PasswordCallback passwordCallback = (PasswordCallback)callback;
                wrapper = new PasswordCallbackWrapper(passwordCallback);
                this.callbackWrappers.add(wrapper);
                if (focusWrapper == null) {
                    focusWrapper = wrapper;
                }
                if (this.userPassWrapper == null) {
                    this.userPassWrapper = wrapper;
                }
                ++passCount;
                continue;
            }
            if (callback instanceof TextInputCallback) {
                TextInputCallback textInputCallback = (TextInputCallback)callback;
                wrapper = new TextInputCallbackWrapper(textInputCallback);
                this.callbackWrappers.add(wrapper);
                if (focusWrapper != null) continue;
                focusWrapper = wrapper;
                continue;
            }
            if (callback instanceof TextOutputCallback) {
                TextOutputCallback textOutputCallback = (TextOutputCallback)callback;
                wrapper = new TextOutputCallbackWrapper(textOutputCallback);
                this.callbackWrappers.add(wrapper);
                continue;
            }
            throw new UnsupportedCallbackException(callback);
        }
        if (nameCount != 1 || passCount != 1) {
            this.userNameWrapper = null;
            this.userPassWrapper = null;
        }
        Component focus = null;
        int num = this.callbackWrappers.size();
        for (int i = 0; i < num; ++i) {
            GridBagConstraints gbc;
            CallbackWrapper wrapper = (CallbackWrapper)this.callbackWrappers.get(i);
            Component prompt = wrapper.getPromptComponent();
            Component input = wrapper.getInputComponent();
            if (prompt != null) {
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = i;
                gbc.anchor = 17;
                gbc.insets = new Insets(4, 4, 4, 4);
                if (input == null) {
                    gbc.gridwidth = 2;
                }
                this.panelCallbacks.add(prompt, gbc);
            }
            if (input != null) {
                gbc = new GridBagConstraints();
                gbc.gridx = 1;
                gbc.gridy = i;
                gbc.fill = 1;
                gbc.weightx = 1.0;
                gbc.anchor = 17;
                gbc.insets = new Insets(4, 4, 4, 4);
                this.panelCallbacks.add(input, gbc);
            }
            if (wrapper != focusWrapper) continue;
            focus = input;
        }
        this.inputFocus = focus;
        if (this.userNameWrapper != null) {
            this.inputChanged(this.userNameWrapper);
        }
        this.updateLoginIcon();
    }

    public synchronized void handleCallbacks() throws IOException, UnsupportedCallbackException {
        int num = this.callbackWrappers.size();
        for (int i = 0; i < num; ++i) {
            CallbackWrapper wrapper = (CallbackWrapper)this.callbackWrappers.get(i);
            wrapper.applyCallback();
        }
    }

    public synchronized void resetLoginPanel() {
        this.inputFocus = null;
        this.panelCallbacks.removeAll();
        int num = this.callbackWrappers.size();
        for (int i = 0; i < num; ++i) {
            CallbackWrapper wrapper = (CallbackWrapper)this.callbackWrappers.get(i);
            wrapper.resetCallback();
        }
        this.callbackWrappers.clear();
        this.userNameWrapper = null;
        this.updateLoginIcon();
    }

    protected synchronized int computeLoginHashcode() {
        int hash = 0;
        int num = this.callbackWrappers.size();
        for (int i = 0; i < num; ++i) {
            CallbackWrapper wrapper = (CallbackWrapper)this.callbackWrappers.get(i);
            if (!wrapper.isInputWrapper()) continue;
            hash = 31 * hash + wrapper.computeInputHashcode();
        }
        return hash;
    }

    protected void updateLoginIcon() {
        Icon icon = null;
        LoginIconProvider provider = this.getLoginIconProvider();
        if (provider != null) {
            int hash = this.computeLoginHashcode();
            icon = provider.getLoginIcon(hash);
        }
        this.labelLoginIcon.setIcon(icon);
        this.labelLoginIcon.setText("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void inputChanged(CallbackWrapper wrapper) {
        LoginRegistry registry;
        String userName;
        this.updateLoginIcon();
        if (wrapper != null && wrapper == this.userNameWrapper && this.loginRealm != null && this.userPassWrapper != null && (userName = this.userNameWrapper.getName()).length() > 0 && (registry = this.getLoginRegistry()) != null) {
            char[] userPass = null;
            try {
                userPass = registry.getStoredPassword(this.loginRealm, userName);
                if (userPass != null) {
                    this.userPassWrapper.setRememberedPassword(userPass);
                    this.chckbxRememberPasswordRegistry.setSelected(true);
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            finally {
                if (userPass != null) {
                    Arrays.fill(userPass, '\u0000');
                }
            }
        }
    }

    public Icon getNameIcon() {
        return this.nameIcon;
    }

    public void setNameIcon(Icon nameIcon) {
        this.nameIcon = nameIcon;
    }

    public Icon getPassIcon() {
        return this.passIcon;
    }

    public void setPassIcon(Icon passIcon) {
        this.passIcon = passIcon;
    }

    public Icon getTextIcon() {
        return this.textIcon;
    }

    public void setTextIcon(Icon textIcon) {
        this.textIcon = textIcon;
    }

    public Icon getInfoIcon() {
        return this.infoIcon;
    }

    public void setInfoIcon(Icon infoIcon) {
        this.infoIcon = infoIcon;
    }

    public Icon getWarnIcon() {
        return this.warnIcon;
    }

    public void setWarnIcon(Icon warnIcon) {
        this.warnIcon = warnIcon;
    }

    public Icon getErrorIcon() {
        return this.errorIcon;
    }

    public void setErrorIcon(Icon errorIcon) {
        this.errorIcon = errorIcon;
    }

    protected JCheckBox getChckbxRememberPasswordRegistry() {
        return this.chckbxRememberPasswordRegistry;
    }

    public boolean isRememberPasswordRegistry() {
        return this.chckbxRememberPasswordRegistry.isSelected();
    }

    public void setRememberPasswordRegistry(boolean remember) {
        this.chckbxRememberPasswordRegistry.setSelected(remember);
    }

    protected class TextOutputCallbackWrapper
    extends CallbackWrapper {
        private JPanel panel;
        private JLabel label;

        public TextOutputCallbackWrapper(TextOutputCallback callback) {
            this.label = new JLabel();
            String msg = callback.getMessage();
            if (msg == null) {
                msg = "";
            }
            Icon icon = null;
            String tooltip = null;
            int type = callback.getMessageType();
            switch (type) {
                case 2: {
                    icon = DefaultLoginPanel.this.errorIcon;
                    tooltip = "Error Message";
                    break;
                }
                case 1: {
                    icon = DefaultLoginPanel.this.warnIcon;
                    tooltip = "Warning Message";
                    break;
                }
                default: {
                    icon = DefaultLoginPanel.this.infoIcon;
                    tooltip = "Information Message";
                }
            }
            this.label.setText(msg);
            this.label.setToolTipText(tooltip);
            this.label.setIcon(icon);
            this.panel = new JPanel();
            this.panel.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.weightx = 1.0;
            gbc.fill = 2;
            gbc.insets = new Insets(4, 0, 4, 0);
            this.panel.add((Component)this.label, gbc);
        }

        @Override
        protected Component getPromptComponent() {
            return this.panel;
        }

        @Override
        protected Component getInputComponent() {
            return null;
        }

        @Override
        protected boolean isInputWrapper() {
            return false;
        }

        @Override
        protected int computeInputHashcode() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void applyCallback() throws UnsupportedCallbackException {
        }

        @Override
        protected void resetCallback() {
            this.label.setIcon(null);
            this.label.setText("");
            this.label.setToolTipText(null);
        }
    }

    protected class TextInputCallbackWrapper
    extends CallbackWrapper {
        private TextInputCallback callback;
        private JLabel label;
        private JTextField textField;

        public TextInputCallbackWrapper(TextInputCallback callback) {
            this.callback = callback;
            this.label = new JLabel();
            this.textField = new JTextField();
            this.textField.setColumns(16);
            String prompt = callback.getPrompt();
            if (prompt == null) {
                prompt = "Text";
            }
            this.label.setText(prompt);
            this.label.setIcon(DefaultLoginPanel.this.textIcon);
            this.label.setToolTipText(prompt);
            String value = callback.getText();
            if (value == null && (value = callback.getDefaultText()) == null) {
                value = "";
            }
            this.textField.setText(value);
            this.textField.setToolTipText(prompt);
            this.textField.getDocument().addDocumentListener(new DocumentHandler(this));
        }

        @Override
        protected Component getPromptComponent() {
            return this.label;
        }

        @Override
        protected Component getInputComponent() {
            return this.textField;
        }

        @Override
        protected boolean isInputWrapper() {
            return true;
        }

        @Override
        protected int computeInputHashcode() {
            int hash = 1934447841;
            return hash += this.textField.getText().hashCode();
        }

        @Override
        protected void applyCallback() throws UnsupportedCallbackException {
            this.callback.setText(this.textField.getText());
        }

        @Override
        protected void resetCallback() {
            this.callback = null;
            this.textField.setText("");
            this.textField.setToolTipText(null);
            this.label.setText("");
            this.label.setIcon(null);
            this.label.setToolTipText(null);
        }
    }

    protected class PasswordCallbackWrapper
    extends CallbackWrapper {
        private PasswordCallback callback;
        private JLabel label;
        private JPasswordField passField;

        public PasswordCallbackWrapper(PasswordCallback callback) {
            this.callback = callback;
            this.label = new JLabel();
            this.passField = new JPasswordField();
            this.passField.setColumns(16);
            String prompt = callback.getPrompt();
            if (prompt == null) {
                prompt = "Password";
            }
            this.label.setText(prompt);
            this.label.setIcon(DefaultLoginPanel.this.passIcon);
            this.label.setToolTipText(prompt);
            this.passField.setToolTipText(prompt);
            this.passField.getDocument().addDocumentListener(new DocumentHandler(this));
        }

        @Override
        protected Component getPromptComponent() {
            return this.label;
        }

        @Override
        protected Component getInputComponent() {
            return this.passField;
        }

        @Override
        protected boolean isInputWrapper() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected int computeInputHashcode() {
            char[] pass = this.passField.getPassword();
            try {
                int hash = 600280625;
                if (pass != null) {
                    int len = pass.length;
                    for (int i = 0; i < len; ++i) {
                        hash = 31 * hash + pass[i];
                    }
                }
                int n = hash;
                return n;
            }
            finally {
                Arrays.fill(pass, '\u0000');
            }
        }

        @Override
        protected void applyCallback() throws UnsupportedCallbackException {
            this.callback.setPassword(this.passField.getPassword());
        }

        @Override
        protected void resetCallback() {
            this.callback = null;
            this.passField.setText("");
            this.passField.setToolTipText(null);
            this.label.setText("");
            this.label.setIcon(null);
            this.label.setToolTipText(null);
        }

        protected void setRememberedPassword(char[] pass) {
            this.passField.setText(new String(pass));
        }
    }

    protected class NameCallbackWrapper
    extends CallbackWrapper {
        private NameCallback callback;
        private JLabel label;
        private JTextField textField;

        public NameCallbackWrapper(NameCallback callback) {
            this.callback = callback;
            this.label = new JLabel();
            this.textField = new JTextField();
            this.textField.setColumns(16);
            String prompt = callback.getPrompt();
            if (prompt == null) {
                prompt = "Name";
            }
            this.label.setText(prompt);
            this.label.setIcon(DefaultLoginPanel.this.nameIcon);
            this.label.setToolTipText(prompt);
            String value = callback.getName();
            if (value == null && (value = callback.getDefaultName()) == null) {
                value = "";
            }
            this.textField.setText(value);
            this.textField.setToolTipText(prompt);
            this.textField.getDocument().addDocumentListener(new DocumentHandler(this));
        }

        @Override
        protected Component getPromptComponent() {
            return this.label;
        }

        @Override
        protected Component getInputComponent() {
            return this.textField;
        }

        @Override
        protected boolean isInputWrapper() {
            return true;
        }

        @Override
        protected int computeInputHashcode() {
            int hash = 918846007;
            return hash += this.textField.getText().hashCode();
        }

        @Override
        protected void applyCallback() throws UnsupportedCallbackException {
            this.callback.setName(this.textField.getText());
        }

        @Override
        protected void resetCallback() {
            this.callback = null;
            this.textField.setText("");
            this.textField.setToolTipText(null);
            this.label.setText("");
            this.label.setIcon(null);
            this.label.setToolTipText(null);
        }

        protected String getName() {
            return this.textField.getText();
        }
    }

    protected abstract class CallbackWrapper {
        protected abstract Component getPromptComponent();

        protected abstract Component getInputComponent();

        protected abstract boolean isInputWrapper();

        protected abstract int computeInputHashcode();

        protected abstract void applyCallback() throws UnsupportedCallbackException;

        protected abstract void resetCallback();
    }

    protected class DocumentHandler
    implements DocumentListener {
        private final CallbackWrapper wrapper;

        public DocumentHandler(CallbackWrapper wrapper) {
            this.wrapper = wrapper;
        }

        protected final CallbackWrapper getWrapper() {
            return this.wrapper;
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            DefaultLoginPanel.this.inputChanged(this.wrapper);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            DefaultLoginPanel.this.inputChanged(this.wrapper);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            DefaultLoginPanel.this.inputChanged(this.wrapper);
        }
    }
}

