/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.plugin;

import com.spacekiller.infection.platform.InfectionPlatform;
import com.spacekiller.infection.plugin.cmd.CommandLineView;
import com.spacekiller.infection.plugin.help.AboutPanel;
import com.spacekiller.infection.plugin.help.HelpContentsView;
import com.spacekiller.infection.plugin.log.LogView;
import com.spacekiller.infection.plugin.log.LogViewToolContext;
import com.spacekiller.infection.plugin.web.WebBrowserView;
import com.spacekiller.util.ExecutionManager;
import com.spacekiller.util.Platform;
import com.spacekiller.util.Tools;
import com.spacekiller.util.status.ErrorMonitorPanel;
import com.spacekiller.util.status.ExecutionProgressPanel;
import com.spacekiller.util.status.MemoryMonitor;
import com.spacekiller.util.swing.LookAndFeelDialog;
import com.spacekiller.util.tooling.AbstractTool;
import com.spacekiller.util.tooling.TAction;
import com.spacekiller.util.tooling.TToggleAction;
import com.spacekiller.util.tooling.Tool;
import com.spacekiller.util.tooling.ToolContext;
import com.spacekiller.util.workbench.Perspective;
import com.spacekiller.util.workbench.View;
import com.spacekiller.util.workbench.ViewProvider;
import com.spacekiller.util.workbench.Workbench;
import com.spacekiller.util.workbench.WorkbenchAction;
import com.spacekiller.util.workbench.WorkbenchUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.Enumeration;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class InfectionExtensions {
    private static final Logger logger = Logger.getLogger(InfectionExtensions.class.getName());
    public static final String FILE_EXPLORER_VIEW_PROVIDER = "FileExplorerViewProvider";
    public static final String TASK_VIEW_PROVIDER = "TaskViewProvider";
    public static final String LOG_VIEW_PROVIDER = "LogViewProvider";
    public static final String DEFAULT_HOME_URL = "https://waxmonster.com";

    private InfectionExtensions() {
    }

    private static void handleError(Throwable e) {
        logger.log(Level.WARNING, e.getMessage(), e);
    }

    public static void openUpdateManager() throws Exception {
        InfectionPlatform plat = (InfectionPlatform)Platform.getInstance();
        plat.openUpdateManager();
    }

    public static void openCommandLineView(Workbench wb, Tool tool) throws Exception {
        CommandLineView view = new CommandLineView();
        view.setIcon(tool.getIcon());
        view.setTitle(tool.getText());
        view.setTooltip(tool.getTooltip());
        wb.getPerspective().addView((View)view);
    }

    public static void openWebBrowserView(Workbench wb, Tool tool) throws Exception {
        WebBrowserView view = new WebBrowserView();
        view.setIcon(tool.getIcon());
        view.setTitle(tool.getText());
        view.setTooltip(tool.getTooltip());
        view.setHomeURL(DEFAULT_HOME_URL);
        wb.getPerspective().addView((View)view);
    }

    public static void openFileExplorerView(Workbench wb, Tool tool) throws Exception {
        ViewProvider provider = wb.getViewProvider(FILE_EXPLORER_VIEW_PROVIDER);
        View view = provider.createView();
        if (view != null) {
            wb.getPerspective().addView(view);
        }
    }

    public static void openLoggingConfigView() throws Exception {
        InfectionPlatform plat = (InfectionPlatform)Platform.getInstance();
        plat.openLoggingConfigPanel();
    }

    protected static void showExecutionProgressPopupMenu(Component comp, int x, int y) {
        final Workbench wb = WorkbenchUtilities.getWorkbench((Component)comp);
        JPopupMenu popup = new JPopupMenu();
        JMenuItem itemTasks = new JMenuItem("Tasks");
        if (wb != null) {
            itemTasks.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InfectionExtensions.showTaskView(wb);
                }
            });
        }
        itemTasks.setToolTipText("Show task details...");
        itemTasks.setIcon(Tools.getIcon(InfectionExtensions.class, (String)"/com/spacekiller/infection/plugin/icons/server_started.gif"));
        popup.add(itemTasks);
        popup.show(comp, x, y);
    }

    public static void showTaskView(Workbench wb) {
        if (wb == null) {
            return;
        }
        try {
            WorkbenchUtilities.openView((Workbench)wb, (String)TASK_VIEW_PROVIDER, (boolean)false);
        }
        catch (Exception e) {
            InfectionExtensions.handleError(e);
        }
    }

    protected static void showErrorMonitorPopupMenu(final ErrorMonitorPanel panel, int x, int y) {
        final Workbench wb = WorkbenchUtilities.getWorkbench((Component)panel);
        JPopupMenu popup = new JPopupMenu();
        JMenuItem itemLogView = new JMenuItem("Show Log");
        if (wb != null) {
            itemLogView.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InfectionExtensions.showLogView(wb);
                }
            });
        }
        itemLogView.setToolTipText("Show log...");
        itemLogView.setIcon(Tools.getIcon(InfectionExtensions.class, (String)"/com/spacekiller/infection/plugin/icons/logging.png"));
        popup.add(itemLogView);
        JMenuItem itemClearErrors = new JMenuItem("Clear Errors");
        itemClearErrors.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                panel.clearErrors();
            }
        });
        itemClearErrors.setToolTipText("Clear errors");
        itemClearErrors.setIcon(Tools.getIcon(InfectionExtensions.class, (String)"/com/spacekiller/infection/plugin/icons/clear_errors.gif"));
        itemClearErrors.setEnabled(panel.getCurrentLogRecord() != null);
        popup.add(itemClearErrors);
        popup.show((Component)panel, x, y);
    }

    public static void showLogView(Workbench wb) {
        if (wb == null) {
            return;
        }
        try {
            WorkbenchUtilities.openView((Workbench)wb, (String)LOG_VIEW_PROVIDER, (boolean)false);
        }
        catch (Exception e) {
            InfectionExtensions.handleError(e);
        }
    }

    public static class MemoryMonitorTool
    extends AbstractTool {
        private int refreshDelay = 10000;

        public Object createInstance(ToolContext context, Class type) {
            MemoryMonitor mm = new MemoryMonitor();
            mm.setRefreshDelay(this.refreshDelay);
            mm.setOpaque(false);
            mm.setPreferredSize(new Dimension(20, 16));
            return mm;
        }

        protected void refreshInstance(Object instance) {
            MemoryMonitor mm = (MemoryMonitor)instance;
            mm.refresh();
        }

        public int getRefreshDelay() {
            return this.refreshDelay;
        }

        public void setRefreshDelay(int refreshDelay) {
            this.refreshDelay = refreshDelay;
        }
    }

    public static class ExecutionProgressTool
    extends AbstractTool {
        public Object createInstance(ToolContext context, Class type) {
            ExecutionProgressPanel panel = new ExecutionProgressPanel();
            panel.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    super.mousePressed(e);
                    if (e.isPopupTrigger()) {
                        InfectionExtensions.showExecutionProgressPopupMenu(e.getComponent(), e.getX(), e.getY());
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    super.mouseReleased(e);
                    if (e.isPopupTrigger()) {
                        InfectionExtensions.showExecutionProgressPopupMenu(e.getComponent(), e.getX(), e.getY());
                    }
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    super.mouseClicked(e);
                    if (e.getClickCount() == 2 && e.getButton() == 1) {
                        Workbench wb = WorkbenchUtilities.getWorkbench((Component)e.getComponent());
                        InfectionExtensions.showTaskView(wb);
                    }
                }
            });
            ExecutionManager execManager = Platform.getInstance().getExecutionManager();
            panel.setManager(execManager);
            return panel;
        }

        protected void refreshInstance(Object instance) {
        }
    }

    public static class ErrorMonitorTool
    extends AbstractTool {
        public Object createInstance(ToolContext context, Class type) {
            ErrorMonitorPanel mm = new ErrorMonitorPanel();
            mm.setOpaque(false);
            mm.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    super.mousePressed(e);
                    if (e.isPopupTrigger()) {
                        InfectionExtensions.showErrorMonitorPopupMenu((ErrorMonitorPanel)e.getComponent(), e.getX(), e.getY());
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    super.mouseReleased(e);
                    if (e.isPopupTrigger()) {
                        InfectionExtensions.showErrorMonitorPopupMenu((ErrorMonitorPanel)e.getComponent(), e.getX(), e.getY());
                    }
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    super.mouseClicked(e);
                    if (e.getClickCount() == 2 && e.getButton() == 1) {
                        InfectionExtensions.showLogView(WorkbenchUtilities.getWorkbench((Component)e.getComponent()));
                    }
                }
            });
            ErrorMonitorPanel.LogHandler handler = mm.getLogHandler();
            Platform.getInstance().debugReference((Object)handler);
            LogManager logMan = LogManager.getLogManager();
            if (logMan != null) {
                Logger rootLogger = logMan.getLogger("");
                if (rootLogger != null) {
                    rootLogger.addHandler((Handler)handler);
                }
                Enumeration<String> en = logMan.getLoggerNames();
                while (en.hasMoreElements()) {
                    String name = en.nextElement();
                    Logger logger = logMan.getLogger(name);
                    if (logger == null || logger.getUseParentHandlers()) continue;
                    logger.addHandler((Handler)handler);
                }
            }
            return mm;
        }

        protected void refreshInstance(Object instance) {
            ErrorMonitorPanel mm = (ErrorMonitorPanel)instance;
            mm.refresh();
        }
    }

    public static class LogViewOptionsAction
    extends TAction {
        public void invoke(Object instance) {
            try {
                InfectionExtensions.openLoggingConfigView();
            }
            catch (Exception e) {
                InfectionExtensions.handleError(e);
            }
        }
    }

    public static class LogViewLockPositionAction
    extends TToggleAction {
        public void invoke(Object instance) {
            LogViewToolContext c;
            LogView logView;
            ToolContext context = this.getToolContext(instance);
            if (context != null && context instanceof LogViewToolContext && (logView = (c = (LogViewToolContext)context).getLogView()) != null) {
                boolean selected = this.isSelected(instance);
                logView.setAutoScroll(!selected);
            }
        }
    }

    public static class LogViewClearAction
    extends TAction {
        public void invoke(Object instance) {
            LogViewToolContext c;
            LogView logView;
            ToolContext context = this.getToolContext(instance);
            if (context != null && context instanceof LogViewToolContext && (logView = (c = (LogViewToolContext)context).getLogView()) != null) {
                logView.clear();
            }
        }
    }

    public static class HelpRegisterAction
    extends WorkbenchAction {
        public void invoke(Object instance) {
            try {
                Platform plat = Platform.getInstance();
                if (plat instanceof InfectionPlatform) {
                    InfectionPlatform ip = (InfectionPlatform)plat;
                    ip.openRegistrationPanel();
                }
            }
            catch (Exception e) {
                InfectionExtensions.handleError(e);
            }
        }
    }

    public static class HelpLicenseAction
    extends WorkbenchAction {
        public void invoke(Object instance) {
            try {
                logger.fine("Opening license page..");
                Workbench wb = this.getWorkbench(instance);
                if (wb == null) {
                    return;
                }
                Perspective pers = wb.getPerspective();
                if (pers == null) {
                    return;
                }
                byte[] data = Platform.getInstance().getDistributionResourceData("license");
                if (data == null) {
                    return;
                }
                String text = new String(data);
                JTextArea textField = new JTextArea(text);
                textField.setEditable(false);
                Font font = Tools.getDefaultFont();
                if (font != null) {
                    textField.setFont(new Font("Monospaced", 0, font.getSize()));
                }
                JScrollPane scrollPane = new JScrollPane(textField);
                String title = "License";
                int msgType = -1;
                JOptionPane.showMessageDialog(pers.getComponent(), scrollPane, title, msgType);
            }
            catch (Exception e) {
                InfectionExtensions.handleError(e);
            }
        }
    }

    public static class HelpWelcomeAction
    extends WorkbenchAction {
        public void invoke(Object instance) {
            try {
                logger.fine("Open welcome page..");
                Workbench wb = this.getWorkbench(instance);
                if (wb == null) {
                    return;
                }
                Perspective pers = wb.getPerspective();
                if (pers == null) {
                    return;
                }
                HelpContentsView help = new HelpContentsView();
                InfectionPlatform plat = InfectionPlatform.getInfectionPlatform();
                Icon icon = plat.getDistributionResourceIcon("icon16");
                String welcomeTitle = plat.getDistributionProperty("welcome.title");
                String welcomePage = plat.getDistributionProperty("welcome.page");
                if (welcomeTitle == null) {
                    welcomeTitle = "Welcome";
                }
                if (welcomePage == null) {
                    welcomePage = "/infection_help/welcome.html";
                }
                if (icon == null) {
                    icon = new ImageIcon(((Object)((Object)this)).getClass().getResource("/com/spacekiller/infection/plugin/icons/infection_icon16.jpg"));
                }
                URL url = ((Object)((Object)this)).getClass().getResource(welcomePage);
                help.setTitle(welcomeTitle);
                help.setIcon(icon);
                help.setHomeURL(url);
                pers.addView((View)help);
            }
            catch (Exception e) {
                InfectionExtensions.handleError(e);
            }
        }
    }

    public static class HelpContentsAction
    extends WorkbenchAction {
        public void invoke(Object instance) {
            try {
                logger.fine("Open help contents..");
                Workbench wb = this.getWorkbench(instance);
                if (wb == null) {
                    return;
                }
                Perspective pers = wb.getPerspective();
                if (pers == null) {
                    return;
                }
                HelpContentsView help = new HelpContentsView();
                InfectionPlatform plat = InfectionPlatform.getInfectionPlatform();
                String helpPage = plat.getDistributionProperty("help.page");
                if (helpPage == null) {
                    helpPage = "/infection_help/contents.html";
                }
                help.setTitle("Help Contents");
                help.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/com/spacekiller/infection/plugin/icons/help_contents.gif")));
                URL url = ((Object)((Object)this)).getClass().getResource(helpPage);
                help.setHomeURL(url);
                pers.addView((View)help);
            }
            catch (Exception e) {
                InfectionExtensions.handleError(e);
            }
        }
    }

    public static class HelpAboutAction
    extends TAction {
        public void invoke(Object instance) {
            try {
                InfectionPlatform plat = InfectionPlatform.getInfectionPlatform();
                Icon splashIcon = plat.getDistributionResourceIcon("splash");
                AboutPanel panel = new AboutPanel();
                panel.setSplashIcon(splashIcon);
                panel.showDialog();
            }
            catch (Exception e) {
                InfectionExtensions.handleError(e);
            }
        }
    }

    public static class WebBrowserAction
    extends WorkbenchAction {
        public void invoke(Object instance) {
            try {
                InfectionExtensions.openWebBrowserView(this.getWorkbench(instance), (Tool)this);
            }
            catch (Exception e) {
                InfectionExtensions.handleError(e);
            }
        }
    }

    public static class CommandLineAction
    extends WorkbenchAction {
        public void invoke(Object instance) {
            try {
                InfectionExtensions.openCommandLineView(this.getWorkbench(instance), (Tool)this);
            }
            catch (Exception e) {
                InfectionExtensions.handleError(e);
            }
        }
    }

    public static class FileExplorerAction
    extends WorkbenchAction {
        public void invoke(Object instance) {
            try {
                InfectionExtensions.openFileExplorerView(this.getWorkbench(instance), (Tool)this);
            }
            catch (Exception e) {
                InfectionExtensions.handleError(e);
            }
        }
    }

    public static class ExitAction
    extends TAction {
        public void invoke(Object instance) {
            logger.warning("TODO exit!");
        }
    }

    public static class UpdateManagerAction
    extends TAction {
        public void invoke(Object instance) {
            try {
                InfectionExtensions.openUpdateManager();
            }
            catch (Exception e) {
                InfectionExtensions.handleError(e);
            }
        }
    }

    public static class LookAndFeelChooserAction
    extends TAction {
        public void invoke(Object instance) {
            LookAndFeelDialog.getInstance().showLookAndFeelDialog();
        }
    }
}

