/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.plugin;

import com.spacekiller.util.tooling.TAction;
import com.spacekiller.util.tooling.ToolContext;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class StartMenu
extends TAction {
    private Color startForeground = Color.WHITE;
    private Font startFont = new Font("dialog", 3, 16);

    public Object createInstance(ToolContext context, Class type) {
        final JButton button = new JButton();
        button.setBorderPainted(false);
        button.setContentAreaFilled(false);
        button.setOpaque(false);
        button.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                super.mousePressed(e);
                StartMenu.this.showStartMenu(button);
            }
        });
        this.refreshInstance(button);
        return button;
    }

    protected void refreshInstance(Object c) {
        super.refreshInstance(c);
        AbstractButton button = (AbstractButton)c;
        button.setHorizontalTextPosition(0);
        button.setText("Start  ");
        button.setFont(this.startFont);
        button.setForeground(this.startForeground);
        Icon icon = button.getIcon();
        if (icon != null) {
            int iconWidth = icon.getIconWidth();
            int iconHeight = icon.getIconHeight();
            button.setPreferredSize(new Dimension(iconWidth, iconHeight));
            button.setMinimumSize(button.getPreferredSize());
        }
    }

    public void invoke(Object instance) {
    }

    protected void showStartMenu(final JButton button) {
        JPopupMenu popup = new JPopupMenu();
        popup.add(new JMenuItem("Test"));
        popup.validate();
        int popupHeight = popup.getPreferredSize().height;
        popup.show(button, 0, -popupHeight);
        button.setIcon(this.getPressedIcon());
        button.setRolloverIcon(this.getPressedIcon());
        popup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                StartMenu.this.refreshInstance(button);
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                StartMenu.this.refreshInstance(button);
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }
        });
    }
}

