/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.plugin.cmd;

import com.spacekiller.infection.plugin.cmd.CommandLine;
import com.spacekiller.infection.plugin.cmd.CommandLineTextPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class CommandLinePanel
extends JPanel {
    private static final long serialVersionUID = 750402578010448639L;
    private CommandLine commandLine;
    private StreamReader inputReader;
    private StreamReader errorReader;
    private AbstractDocument document;
    private String lineFeed = "\n";
    private AttributeSet insertAttr;
    private AttributeSet errorAttr;
    private JScrollPane jScrollPane = null;
    private JPanel jPanelOutput = null;
    private CommandLineTextPane jTextPane = null;
    private static final Logger logger = Logger.getLogger(CommandLinePanel.class.getName());

    public CommandLinePanel() {
        this.initialize();
    }

    public CommandLinePanel(CommandLine commandLine) throws Exception {
        this();
        this.setCommandLine(commandLine);
        this.initCommandLinePanel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initCommandLinePanel() throws Exception {
        this.document = new DefaultStyledDocument();
        this.getJTextPane().setDocument(this.document);
        SimpleAttributeSet attr = new SimpleAttributeSet();
        attr.addAttribute(StyleConstants.Foreground, Color.black);
        attr.addAttribute(StyleConstants.Bold, Boolean.TRUE);
        this.insertAttr = attr;
        attr = new SimpleAttributeSet();
        attr.addAttribute(StyleConstants.Foreground, Color.red.darker());
        attr.addAttribute(StyleConstants.Bold, Boolean.TRUE);
        this.errorAttr = attr;
        InputStream input = this.commandLine.getInputStream();
        this.inputReader = new StreamReader(input, this.insertAttr);
        new Thread(this.inputReader).start();
        InputStream error = this.commandLine.getErrorStream();
        this.errorReader = new StreamReader(error, this.errorAttr);
        new Thread(this.errorReader).start();
        this.getJTextPane().setEditable(true);
        String lf = System.getProperty("line.separator");
        if (lf != null) {
            this.lineFeed = lf;
        }
        StreamReader streamReader = this.inputReader;
        synchronized (streamReader) {
            this.inputReader.notify();
        }
        streamReader = this.errorReader;
        synchronized (streamReader) {
            this.errorReader.notify();
        }
        this.getJTextPane().requestFocus();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(470, 303));
        this.add((Component)this.getJScrollPane(), gridBagConstraints);
    }

    protected CommandLine getCommandLine() {
        return this.commandLine;
    }

    protected void setCommandLine(CommandLine commandLine) {
        this.commandLine = commandLine;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setOpaque(false);
            this.jScrollPane.setViewportView(this.getJPanelOutput());
        }
        return this.jScrollPane;
    }

    private JPanel getJPanelOutput() {
        if (this.jPanelOutput == null) {
            GridLayout gridLayout = new GridLayout();
            gridLayout.setRows(1);
            this.jPanelOutput = new JPanel();
            this.jPanelOutput.setOpaque(false);
            this.jPanelOutput.setLayout(gridLayout);
            this.jPanelOutput.add((Component)this.getJTextPane(), null);
        }
        return this.jPanelOutput;
    }

    private CommandLineTextPane getJTextPane() {
        if (this.jTextPane == null) {
            this.jTextPane = new CommandLineTextPane();
            this.jTextPane.setOpaque(false);
            this.jTextPane.setFont(new Font("Monospaced", 1, 12));
            this.jTextPane.setEditable(true);
            this.jTextPane.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CommandLinePanel.this.exec(e.getActionCommand());
                }
            });
        }
        return this.jTextPane;
    }

    void actionTerminate() {
        try {
            CommandLine cl = this.getCommandLine();
            cl.terminate();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected void print(String text, AttributeSet attr) {
        this.getJTextPane().insert(text, attr);
    }

    protected void exec(String command) {
        logger.fine("Exec: '" + command + "'");
        try {
            command = command + this.lineFeed;
            CommandLine cl = this.getCommandLine();
            OutputStream out = cl.getOutputStream();
            out.write(command.getBytes());
            out.flush();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.getJTextPane().setEditable(enabled);
    }

    protected class StreamReader
    implements Runnable {
        private InputStream in;
        private boolean stop;
        private AttributeSet attr;

        public StreamReader(InputStream in, AttributeSet attr) {
            this.in = in;
            this.attr = attr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            try {
                while (!this.stop) {
                    Object buf;
                    try {
                        int num;
                        buf = new byte[1024];
                        while ((num = this.in.read((byte[])buf)) >= 0) {
                            CommandLinePanel.this.print(new String((byte[])buf, 0, num), this.attr);
                        }
                    }
                    finally {
                        this.in.close();
                    }
                    logger.fine("StreamReader wait..");
                    StreamReader streamReader = this;
                    buf = streamReader;
                    // MONITORENTER : streamReader
                    this.wait();
                    // MONITOREXIT : buf
                    logger.fine("StreamReader continue..");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            logger.fine("StreamReader completed: " + this.in);
        }
    }
}

