/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.plugin.cmd;

import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.EventListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class CommandLineTextPane
extends JTextPane {
    private static final long serialVersionUID = 7901808169535547615L;
    private int insertPosition = 0;
    private int promptPosition = 0;
    private AttributeSet promptAttr;
    private transient ActionListener actionListeners;
    private static final Logger logger = Logger.getLogger(CommandLineTextPane.class.getName());

    public CommandLineTextPane() {
        this.initCommandLineTextPane();
    }

    public CommandLineTextPane(StyledDocument doc) {
        super(doc);
        this.initCommandLineTextPane();
    }

    protected void initCommandLineTextPane() {
        SimpleAttributeSet attr = new SimpleAttributeSet();
        attr.addAttribute(StyleConstants.Foreground, Color.blue);
        attr.addAttribute(StyleConstants.Bold, Boolean.TRUE);
        this.promptAttr = attr;
    }

    @Override
    public void paste() {
        logger.fine("" + this + ".paste..");
        super.paste();
    }

    @Override
    public void setCaretPosition(int position) {
        if (position < this.insertPosition) {
            position = this.insertPosition;
        }
        this.promptPosition = position - this.insertPosition;
        super.setCaretPosition(position);
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (pressed) {
            int code = ks.getKeyCode();
            switch (code) {
                case 10: {
                    try {
                        int len = this.getDocument().getLength();
                        String command = this.getDocument().getText(this.insertPosition, len - this.insertPosition);
                        this.getDocument().remove(this.insertPosition, len - this.insertPosition);
                        this.promptPosition = 0;
                        this.moveCaret(this.insertPosition);
                        this.fireActionPerformed(new ActionEvent(this, 1001, command));
                    }
                    catch (BadLocationException ex) {
                        logger.log(Level.SEVERE, ex.getMessage(), ex);
                    }
                    return true;
                }
                case 37: {
                    this.moveCaret(this.getCaretPosition() - 1);
                    return true;
                }
                case 39: {
                    this.moveCaret(this.getCaretPosition() + 1);
                    return true;
                }
                case 38: {
                    return true;
                }
                case 40: {
                    return true;
                }
                case 8: {
                    if (this.getCaretPosition() > this.insertPosition) break;
                    return true;
                }
                case 127: {
                    if (this.getCaretPosition() >= this.insertPosition) break;
                    return true;
                }
            }
        }
        InputMap map = this.getInputMap(condition);
        ActionMap am = this.getActionMap();
        if (map != null && am != null && this.isEnabled()) {
            Action action;
            Object binding = map.get(ks);
            Action action2 = action = binding == null ? null : am.get(binding);
            if (action != null) {
                ActionWrapper wrapper = new ActionWrapper(action);
                return SwingUtilities.notifyAction(wrapper, ks, e, this, e.getModifiers());
            }
        }
        return false;
    }

    protected synchronized void write(String text) {
        try {
            int ofs = this.insertPosition + this.promptPosition;
            this.getDocument().insertString(ofs, text, null);
            this.moveCaret(ofs + text.length());
        }
        catch (BadLocationException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected synchronized void moveCaret(int pos) {
        if (pos < this.insertPosition) {
            return;
        }
        if (pos > this.getDocument().getLength()) {
            return;
        }
        this.setCaretPosition(pos);
        this.promptPosition = pos - this.insertPosition;
    }

    public synchronized void insert(String text, AttributeSet attr) {
        try {
            int ofs = this.insertPosition;
            int len = text.length();
            this.getDocument().insertString(ofs, text, attr);
            this.insertPosition += len;
            this.moveCaret(this.insertPosition + this.promptPosition);
        }
        catch (BadLocationException e) {
            logger.fine("OOPS: pos=" + this.insertPosition + ", len=" + this.getDocument().getLength());
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected void fireActionPerformed(ActionEvent e) {
        if (this.actionListeners == null) {
            return;
        }
        this.actionListeners.actionPerformed(e);
    }

    public void addActionListener(ActionListener listener) {
        this.actionListeners = AWTEventMulticaster.add(this.actionListeners, listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.actionListeners = AWTEventMulticaster.remove(this.actionListeners, listener);
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])AWTEventMulticaster.getListeners((EventListener)this.actionListeners, ActionListener.class);
    }

    protected class ActionWrapper
    extends AbstractAction {
        private static final long serialVersionUID = 4310815374474647592L;
        private Action action;

        public ActionWrapper(Action action) {
            this.action = action;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.action != null) {
                CommandLineTextPane.this.moveCaret(CommandLineTextPane.this.insertPosition + CommandLineTextPane.this.promptPosition);
                this.action.actionPerformed(e);
                CommandLineTextPane.this.moveCaret(CommandLineTextPane.this.getCaretPosition());
                StyledDocument doc = (StyledDocument)CommandLineTextPane.this.getDocument();
                int ofs = CommandLineTextPane.this.insertPosition;
                int len = doc.getLength() - ofs;
                doc.setCharacterAttributes(ofs, len, CommandLineTextPane.this.promptAttr, true);
            }
        }
    }
}

