/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.plugin.cmd;

import com.spacekiller.infection.plugin.cmd.CommandLinePanel;
import com.spacekiller.infection.plugin.cmd.RuntimeCommandLine;
import com.spacekiller.util.workbench.View;
import java.awt.Component;
import java.awt.Dimension;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CommandLineView
extends View {
    private RuntimeCommandLine commandLine;
    private CommandLinePanel commandLinePanel;
    private static final Logger logger = Logger.getLogger(CommandLineView.class.getName());

    protected Component createComponent() {
        return this.getCommandLinePanel();
    }

    protected void installChildComponent(View child, Component childComponent) {
    }

    protected void uninstallChildComponent(View child, Component childComponent) {
    }

    protected CommandLinePanel createCommandLinePanel() {
        CommandLinePanel de = null;
        try {
            de = new CommandLinePanel(this.getCommandLine());
            de.setPreferredSize(new Dimension(600, 400));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        return de;
    }

    protected CommandLinePanel getCommandLinePanel() {
        if (this.commandLinePanel == null) {
            this.setCommandLinePanel(this.createCommandLinePanel());
        }
        return this.commandLinePanel;
    }

    protected void setCommandLinePanel(CommandLinePanel commandLinePanel) {
        this.commandLinePanel = commandLinePanel;
    }

    protected RuntimeCommandLine createCommandLine() throws Exception {
        RuntimeCommandLine cmd = new RuntimeCommandLine();
        String[] command = this.getShellCommand();
        new Thread(new CommandInvoker(command)).start();
        return cmd;
    }

    protected RuntimeCommandLine getCommandLine() throws Exception {
        if (this.commandLine == null) {
            this.setCommandLine(this.createCommandLine());
        }
        return this.commandLine;
    }

    protected void setCommandLine(RuntimeCommandLine commandLine) {
        this.commandLine = commandLine;
    }

    private void execute(String[] command) {
        try {
            RuntimeCommandLine cl = this.getCommandLine();
            cl.execute(command);
            int rc = cl.getReturnCode();
            if (rc != 0) {
                throw new RuntimeException("Return code: " + rc);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected String[] getShellCommand() {
        String osName = System.getProperty("os.name");
        logger.fine("os.name: " + osName);
        if (osName == null) {
            return null;
        }
        if (osName.toLowerCase().startsWith("windows")) {
            return new String[]{"cmd.exe"};
        }
        return new String[]{"xterm"};
    }

    protected class CommandInvoker
    implements Runnable {
        private String[] command;

        public CommandInvoker(String[] command) {
            this.command = command;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                CommandLineView.this.execute(this.command);
            }
            finally {
                CommandLineView.this.getCommandLinePanel().setEnabled(false);
            }
        }
    }
}

