/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.plugin.run;

import com.spacekiller.infection.plugin.run.RunConfig;
import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.Platform;
import com.spacekiller.util.Preferences;
import com.spacekiller.util.PreferencesRegistry;
import java.awt.AWTEventMulticaster;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;

public class RunConfigManager {
    public static final String PREFERENCES_KEY = RunConfigManager.class.getName();
    private static final String KEY_CONFIG = "config";
    private PreferencesRegistry preferencesRegistry;
    private BeansToolkit beansToolkit;
    private List configList = new ArrayList();
    private transient ActionListener actionListeners;
    private static final Logger logger = Logger.getLogger(RunConfigManager.class.getName());

    public RunConfigManager() {
        this.beansToolkit = Platform.getInstance().getBeansToolkit();
        this.preferencesRegistry = Platform.getInstance().getPreferencesRegistry();
        this.load();
    }

    public int getRunConfigCount() {
        return this.configList.size();
    }

    public RunConfig getRunConfigAt(int i) {
        return (RunConfig)this.configList.get(i);
    }

    public void addRunConfig(RunConfig config) {
        if (config == null) {
            return;
        }
        if (!this.configList.contains(config)) {
            this.configList.add(config);
        }
        this.save();
        this.fireActionPerformed();
    }

    public void removeRunConfig(RunConfig config) {
        int i = this.configList.indexOf(config);
        if (i < 0) {
            return;
        }
        this.configList.remove(i);
        this.save();
        this.fireActionPerformed();
    }

    protected void fireActionPerformed() {
        this.fireActionPerformed(new ActionEvent(this, 1001, "action"));
    }

    protected void fireActionPerformed(ActionEvent e) {
        if (this.actionListeners == null) {
            return;
        }
        this.actionListeners.actionPerformed(e);
    }

    public void addActionListener(ActionListener listener) {
        this.actionListeners = AWTEventMulticaster.add(this.actionListeners, listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.actionListeners = AWTEventMulticaster.remove(this.actionListeners, listener);
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])AWTEventMulticaster.getListeners((EventListener)this.actionListeners, ActionListener.class);
    }

    public Icon getRunConfigIcon(RunConfig config) {
        if (this.beansToolkit != null) {
            return this.beansToolkit.getIcon((Object)config);
        }
        return null;
    }

    public BeansToolkit getBeansToolkit() {
        return this.beansToolkit;
    }

    public void setBeansToolkit(BeansToolkit beansToolkit) {
        this.beansToolkit = beansToolkit;
    }

    public PreferencesRegistry getPreferencesRegistry() {
        return this.preferencesRegistry;
    }

    public void setPreferencesRegistry(PreferencesRegistry preferencesRegistry) {
        this.preferencesRegistry = preferencesRegistry;
    }

    protected void load() {
        try {
            Object obj;
            PreferencesRegistry reg = this.getPreferencesRegistry();
            if (reg == null) {
                return;
            }
            Preferences prefs = reg.getPreferences(PREFERENCES_KEY);
            if (prefs != null && (obj = prefs.getObject(KEY_CONFIG)) != null && obj instanceof List) {
                List list = (List)obj;
                for (Object cfg : list) {
                    if (cfg == null || !(cfg instanceof RunConfig)) continue;
                    RunConfig config = (RunConfig)cfg;
                    this.configList.add(config);
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected void save() {
        try {
            PreferencesRegistry reg = this.getPreferencesRegistry();
            if (reg == null) {
                return;
            }
            Preferences prefs = reg.getPreferences(PREFERENCES_KEY);
            if (prefs == null) {
                prefs = reg.createPreferences(PREFERENCES_KEY);
            }
            prefs.setObject(KEY_CONFIG, (Object)this.configList);
            reg.savePreferences(prefs);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }
}

