/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.plugin.run;

import com.spacekiller.infection.plugin.run.RunConfig;
import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.ClassRegistry;
import com.spacekiller.util.Filter;
import com.spacekiller.util.beans.components.ClassChooser;
import com.spacekiller.util.beans.components.ClassChooserField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class RunConfigPanel
extends JPanel {
    private static final long serialVersionUID = 2194233528056704411L;
    private BeansToolkit beansToolkit;
    private ClassRegistry classRegistry;
    private Filter classFilter;
    private RunConfig runConfig;
    private JPanel jPanelParams = null;
    private JPanel jPanelMainClass = null;
    private JLabel jLabel1 = null;
    private ClassChooserField classChooserField = null;
    private JScrollPane jScrollPane = null;
    private JTextPane jTextPaneArguments = null;
    private JTabbedPane jTabbedPane = null;
    private JPanel jPanelPageMain = null;
    private static final Logger logger = Logger.getLogger(RunConfigPanel.class.getName());

    public RunConfigPanel() {
        this.initialize();
        this.initRunMainClassPanel();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.weightx = 1.0;
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(330, 255));
        this.add((Component)this.getJTabbedPane(), gridBagConstraints2);
    }

    public BeansToolkit getBeansToolkit() {
        return this.beansToolkit;
    }

    public void setBeansToolkit(BeansToolkit beansToolkit) {
        this.beansToolkit = beansToolkit;
        this.getClassChooserField().setBeansToolkit(beansToolkit);
    }

    public Filter getClassFilter() {
        return this.classFilter;
    }

    public void setClassFilter(Filter classFilter) {
        this.classFilter = classFilter;
        this.getClassChooserField().setClassFilter(classFilter);
    }

    public ClassRegistry getClassRegistry() {
        return this.classRegistry;
    }

    public void setClassRegistry(ClassRegistry classRegistry) {
        this.classRegistry = classRegistry;
        this.getClassChooserField().setClassRegistry(classRegistry);
    }

    protected void initRunMainClassPanel() {
        EtchedBorder border = new EtchedBorder(0);
        TitledBorder titled = new TitledBorder(border, "Arguments:");
        this.getJPanelParams().setBorder(titled);
        EtchedBorder border2 = new EtchedBorder(0);
        TitledBorder titled2 = new TitledBorder(border2, "Main class:");
        this.getJPanelMainClass().setBorder(titled2);
        ClassChooser.MainClassFilter filter = new ClassChooser.MainClassFilter();
        this.setClassFilter((Filter)filter);
        this.getClassChooserField().setEnabled(false);
        this.getJTextPaneArguments().setEnabled(false);
    }

    protected void actionClassSelected() {
    }

    protected void handleException(Throwable e) {
        logger.log(Level.SEVERE, e.getMessage(), e);
    }

    private JPanel getJPanelParams() {
        if (this.jPanelParams == null) {
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.fill = 1;
            gridBagConstraints4.gridy = 1;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.weighty = 1.0;
            gridBagConstraints4.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints4.gridx = 0;
            this.jPanelParams = new JPanel();
            this.jPanelParams.setLayout(new GridBagLayout());
            this.jPanelParams.setOpaque(false);
            this.jPanelParams.setPreferredSize(new Dimension(100, 120));
            this.jPanelParams.setMinimumSize(new Dimension(100, 120));
            this.jPanelParams.add((Component)this.getJScrollPane(), gridBagConstraints4);
        }
        return this.jPanelParams;
    }

    private JPanel getJPanelMainClass() {
        if (this.jPanelMainClass == null) {
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 1;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.insets = new Insets(4, 0, 4, 4);
            gridBagConstraints3.gridy = 0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.insets = new Insets(4, 4, 4, 4);
            this.jLabel1 = new JLabel();
            this.jLabel1.setText("Class:");
            this.jPanelMainClass = new JPanel();
            this.jPanelMainClass.setLayout(new GridBagLayout());
            this.jPanelMainClass.setOpaque(false);
            this.jPanelMainClass.add((Component)this.jLabel1, gridBagConstraints);
            this.jPanelMainClass.add((Component)this.getClassChooserField(), gridBagConstraints3);
        }
        return this.jPanelMainClass;
    }

    private ClassChooserField getClassChooserField() {
        if (this.classChooserField == null) {
            this.classChooserField = new ClassChooserField();
            this.classChooserField.setOpaque(false);
            this.classChooserField.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    RunConfigPanel.this.actionClassSelected();
                }
            });
        }
        return this.classChooserField;
    }

    public RunConfig getRunConfig() {
        return this.runConfig;
    }

    public void setRunConfig(RunConfig runConfig) {
        this.runConfig = runConfig;
        this.refresh();
    }

    protected void refresh() {
        String className = null;
        String args = null;
        if (this.runConfig != null) {
            className = this.runConfig.getClassName();
            args = this.runConfig.getArguments();
        }
        if (className == null) {
            className = "";
        }
        if (args == null) {
            args = "";
        }
        boolean enable = this.runConfig != null;
        this.getClassChooserField().setEnabled(enable);
        this.getClassChooserField().setSelectedClassName(className);
        this.getJTextPaneArguments().setEnabled(enable);
        this.getJTextPaneArguments().setText(args);
    }

    public void apply() {
        if (this.runConfig == null) {
            return;
        }
        String className = this.getClassChooserField().getSelectedClassName();
        this.runConfig.setClassName(className);
        this.runConfig.setArguments(this.getJTextPaneArguments().getText());
        this.runConfig.setTooltip(className);
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setOpaque(false);
            this.jScrollPane.setViewportView(this.getJTextPaneArguments());
        }
        return this.jScrollPane;
    }

    private JTextPane getJTextPaneArguments() {
        if (this.jTextPaneArguments == null) {
            this.jTextPaneArguments = new JTextPane();
            this.jTextPaneArguments.setOpaque(false);
        }
        return this.jTextPaneArguments;
    }

    private JTabbedPane getJTabbedPane() {
        if (this.jTabbedPane == null) {
            this.jTabbedPane = new JTabbedPane();
            this.jTabbedPane.addTab("Main", new ImageIcon(this.getClass().getResource("/com/spacekiller/infection/plugin/icons/class2.gif")), this.getJPanelPageMain(), null);
        }
        return this.jTabbedPane;
    }

    private JPanel getJPanelPageMain() {
        if (this.jPanelPageMain == null) {
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.anchor = 11;
            gridBagConstraints5.insets = new Insets(0, 4, 4, 4);
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.gridy = 1;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.weighty = 1.0;
            gridBagConstraints5.fill = 2;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.fill = 1;
            gridBagConstraints1.gridx = -1;
            gridBagConstraints1.gridy = -1;
            gridBagConstraints1.insets = new Insets(4, 4, 4, 4);
            this.jPanelPageMain = new JPanel();
            this.jPanelPageMain.setLayout(new GridBagLayout());
            this.jPanelPageMain.setOpaque(false);
            this.jPanelPageMain.add((Component)this.getJPanelMainClass(), gridBagConstraints1);
            this.jPanelPageMain.add((Component)this.getJPanelParams(), gridBagConstraints5);
        }
        return this.jPanelPageMain;
    }
}

