/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.swing;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import javax.swing.JComponent;

public abstract class AbstractCellRenderer
extends JComponent {
    private static final long serialVersionUID = -4020641611303483866L;
    private boolean selected = false;
    private boolean focus = false;
    private Paint cellBackground = null;
    private Paint cellSelectionBackground = new Color(0.4f, 0.7f, 1.0f, 0.7f);
    private Color cellFocusColor = Color.black;

    public Paint getCellBackground() {
        return this.cellBackground;
    }

    public Color getCellFocusColor() {
        return this.cellFocusColor;
    }

    public Paint getCellSelectionBackground() {
        return this.cellSelectionBackground;
    }

    public static boolean isBooleanType(Class type) {
        return type == Boolean.class || type == Boolean.TYPE;
    }

    public static boolean isCharacterType(Class type) {
        return type == Character.class || type == Character.TYPE;
    }

    public boolean isFocus() {
        return this.focus;
    }

    public static boolean isNumberType(Class type) {
        return type == Byte.class || type == Byte.TYPE || type == Short.class || type == Short.TYPE || type == Integer.class || type == Integer.TYPE || type == Long.class || type == Long.TYPE || type == Double.class || type == Double.TYPE || type == Float.class || type == Float.TYPE;
    }

    public boolean isSelected() {
        return this.selected;
    }

    protected void paintCellBackground(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        int w = this.getWidth();
        int h = this.getHeight();
        Paint paint = this.getCellBackground();
        if (this.isSelected()) {
            paint = this.getCellSelectionBackground();
        }
        if (paint != null) {
            g2d.setPaint(paint);
            g2d.fillRect(0, 0, w, h);
        }
        if (this.isFocus() && (paint = this.getCellFocusColor()) != null) {
            g2d.setPaint(paint);
            g2d.drawRect(0, 0, w - 1, h - 1);
        }
    }

    protected void paintCellFocus(Graphics g) {
        if (this.isFocus()) {
            Graphics2D g2d = (Graphics2D)g;
            int w = this.getWidth();
            int h = this.getHeight();
            Color paint = this.getCellFocusColor();
            if (paint != null) {
                g2d.setPaint(paint);
                g2d.drawRect(0, 0, w - 1, h - 1);
            }
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.paintCellBackground(g);
        super.paintComponent(g);
        this.paintCellFocus(g);
    }

    public void setCellBackground(Paint newCellBackground) {
        this.cellBackground = newCellBackground;
    }

    public void setCellFocusColor(Color newCellFocusColor) {
        this.cellFocusColor = newCellFocusColor;
    }

    public void setCellSelectionBackground(Paint newCellSelectionBackground) {
        this.cellSelectionBackground = newCellSelectionBackground;
    }

    public void setFocus(boolean newFocus) {
        this.focus = newFocus;
    }

    public void setSelected(boolean newSelected) {
        this.selected = newSelected;
    }
}

