/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.swing;

import com.spacekiller.util.swing.FadeUtil;
import com.spacekiller.util.swing.Fadeable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Polygon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JComponent;
import javax.swing.Timer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class Balloon
extends JComponent
implements Fadeable {
    private static final long serialVersionUID = -6449824473812316451L;
    private int anchorHeight = 15;
    private int arcWidth = 16;
    private int arcHeight = 16;
    private Insets insets = new Insets(0, 0, 0, 0);
    private float alpha;
    private boolean moveable;
    private PopupMenuListener popupMenuListener;
    private int autoDisposeDelay = 0;

    public Balloon() {
        this.setOpaque(false);
        this.setLayout(new BalloonLayout());
        this.addMouseListener(new MouseHandler());
        this.addMouseMotionListener(new MouseMotionHandler());
        this.validate();
    }

    @Override
    public void validate() {
        super.validate();
        this.insets.top = this.arcHeight / 2;
        this.insets.left = this.arcWidth / 2;
        this.insets.bottom = this.arcHeight / 2 + this.anchorHeight;
        this.insets.right = this.arcWidth / 2;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintBalloon(g);
    }

    protected void paintBalloon(Graphics g) {
        int width = this.getWidth();
        int height = this.getHeight();
        int balloonHeight = height - this.anchorHeight - 1;
        Color back = this.getBackground();
        Color fore = this.getForeground();
        back = FadeUtil.getFadeColor(back, this.alpha);
        fore = FadeUtil.getFadeColor(fore, this.alpha);
        g.setColor(back);
        g.fillRoundRect(0, 0, width - 1, balloonHeight, this.arcWidth, this.arcHeight);
        g.setColor(fore);
        g.drawRoundRect(0, 0, width - 1, balloonHeight, this.arcWidth, this.arcHeight);
        Polygon poly = new Polygon();
        int ww = this.arcWidth * 3 / 4;
        poly.addPoint(width - ww / 2, height - 1);
        poly.addPoint(width - ww, height - this.anchorHeight - 1);
        poly.addPoint(width - ww - this.anchorHeight, height - this.anchorHeight - 1);
        poly.addPoint(width - ww / 2, height - 1);
        g.setColor(back);
        g.fillPolygon(poly);
        g.setColor(fore);
        g.drawLine(poly.xpoints[0], poly.ypoints[0], poly.xpoints[1], poly.ypoints[1]);
        g.drawLine(poly.xpoints[0], poly.ypoints[0], poly.xpoints[2], poly.ypoints[2]);
    }

    public void dispose() {
        Container parent = this.getParent();
        if (parent == null) {
            return;
        }
        if (this.popupMenuListener != null) {
            PopupMenuEvent ev = new PopupMenuEvent(this);
            this.popupMenuListener.popupMenuWillBecomeInvisible(ev);
        }
        FadeUtil.fadeOutAndRemove(this, 20, 10);
    }

    @Override
    public float getAlpha() {
        return this.alpha;
    }

    @Override
    public void setAlpha(float alpha) {
        if (alpha < 0.0f) {
            alpha = 0.0f;
        }
        if (alpha > 1.0f) {
            alpha = 1.0f;
        }
        this.alpha = alpha;
        Component[] comps = this.getComponents();
        for (int c = 0; c < comps.length; ++c) {
            Component comp = comps[c];
            if (!(comp instanceof Fadeable)) continue;
            ((Fadeable)((Object)comp)).setAlpha(alpha);
        }
    }

    public boolean isMoveable() {
        return this.moveable;
    }

    public void setMoveable(boolean moveable) {
        this.moveable = moveable;
    }

    public PopupMenuListener getPopupMenuListener() {
        return this.popupMenuListener;
    }

    public void setPopupMenuListener(PopupMenuListener popupMenuListener) {
        this.popupMenuListener = popupMenuListener;
    }

    public void fadeIn() {
        FadeUtil.fadeIn(this, 20, 10);
        if (this.autoDisposeDelay > 0) {
            Timer disposeTimer = new Timer(this.autoDisposeDelay, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Balloon.this.dispose();
                }
            });
            disposeTimer.setRepeats(false);
            disposeTimer.start();
        }
    }

    public int getAutoDisposeDelay() {
        return this.autoDisposeDelay;
    }

    public void setAutoDisposeDelay(int autoDisposeDelay) {
        this.autoDisposeDelay = autoDisposeDelay;
    }

    protected class MouseMotionHandler
    extends MouseMotionAdapter {
        private int lastX = 0;
        private int lastY = 0;

        protected MouseMotionHandler() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            super.mouseMoved(e);
            int x = e.getX();
            int y = e.getY();
            this.lastX = x;
            this.lastY = y;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            super.mouseDragged(e);
            if (!Balloon.this.moveable) {
                return;
            }
            int newX = e.getX();
            int newY = e.getY();
            int deltaX = newX - this.lastX;
            int deltaY = newY - this.lastY;
            Balloon balloon = Balloon.this;
            balloon.setLocation(balloon.getX() + deltaX, balloon.getY() + deltaY);
        }
    }

    protected class MouseHandler
    extends MouseAdapter {
        protected MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            super.mouseClicked(e);
            Balloon.this.dispose();
        }
    }

    public static class BalloonLayout
    implements LayoutManager {
        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            Balloon balloon = (Balloon)parent;
            Component[] comps = parent.getComponents();
            int w = 0;
            int h = 0;
            for (int c = 0; c < comps.length; ++c) {
                Dimension dim = comps[c].getMinimumSize();
                if (dim.width > w) {
                    w = dim.width;
                }
                if (dim.height <= h) continue;
                h = dim.height;
            }
            return new Dimension(w += ((Balloon)balloon).insets.left + ((Balloon)balloon).insets.right, h += ((Balloon)balloon).insets.top + ((Balloon)balloon).insets.bottom);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Balloon balloon = (Balloon)parent;
            Component[] comps = parent.getComponents();
            int w = 0;
            int h = 0;
            for (int c = 0; c < comps.length; ++c) {
                Dimension dim = comps[c].getPreferredSize();
                if (dim.width > w) {
                    w = dim.width;
                }
                if (dim.height <= h) continue;
                h = dim.height;
            }
            return new Dimension(w += ((Balloon)balloon).insets.left + ((Balloon)balloon).insets.right, h += ((Balloon)balloon).insets.top + ((Balloon)balloon).insets.bottom);
        }

        @Override
        public void layoutContainer(Container parent) {
            Balloon balloon = (Balloon)parent;
            Insets ins = balloon.insets;
            int x = ins.left;
            int y = ins.top;
            int w = balloon.getWidth() - x - ins.right;
            int h = balloon.getHeight() - y - ins.bottom;
            Component[] comps = parent.getComponents();
            for (int c = 0; c < comps.length; ++c) {
                comps[c].setBounds(x, y, w, h);
            }
        }
    }
}

