/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.swing;

import com.spacekiller.util.swing.Balloon;
import com.spacekiller.util.swing.FadeUtil;
import com.spacekiller.util.swing.Fadeable;
import com.spacekiller.util.swing.FadeablePanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class BalloonManager {
    private static BalloonManager sharedInstance;
    private static final Logger logger;

    protected BalloonManager() {
    }

    public static BalloonManager getSharedInstance() {
        if (sharedInstance == null) {
            sharedInstance = new BalloonManager();
        }
        return sharedInstance;
    }

    public void showBalloon(Component owner, Balloon balloon, int x, int y) {
        this.showBalloon(owner, balloon, x, y, null);
    }

    public void showBalloon(Component owner, Balloon balloon, int x, int y, PopupMenuListener listener) {
        Window win = this.getWindow(owner);
        if (win == null) {
            return;
        }
        JLayeredPane layeredPane = null;
        if (win instanceof JFrame) {
            JFrame frame = (JFrame)win;
            layeredPane = frame.getLayeredPane();
        }
        if (win instanceof JDialog) {
            JDialog dialog = (JDialog)win;
            layeredPane = dialog.getLayeredPane();
        }
        if (layeredPane == null) {
            return;
        }
        Balloon content = balloon;
        balloon.setPopupMenuListener(listener);
        Point location = this.getLocation(owner);
        location.x += x - balloon.getWidth();
        location.y += y - balloon.getHeight();
        content.setLocation(location);
        Fadeable fadeable = null;
        if (balloon != null) {
            balloon.setAlpha(0.0f);
        } else if (content instanceof Fadeable) {
            fadeable = content;
            fadeable.setAlpha(0.0f);
        }
        if (listener != null) {
            PopupMenuEvent ev = new PopupMenuEvent(content);
            listener.popupMenuWillBecomeVisible(ev);
        }
        layeredPane.add((Component)content, JLayeredPane.POPUP_LAYER);
        if (balloon != null) {
            balloon.fadeIn();
        } else if (fadeable != null) {
            FadeUtil.fadeIn(fadeable, 20, 10);
        }
    }

    protected Window getWindow(Component comp) {
        while (comp != null) {
            if (comp instanceof Window) {
                return (Window)comp;
            }
            comp = comp.getParent();
        }
        return null;
    }

    protected Point getLocation(Component comp) {
        Container parent;
        int x = 0;
        int y = 0;
        while (!(comp == null || comp instanceof Window || (parent = comp.getParent()) != null && parent instanceof Window)) {
            x += comp.getX();
            y += comp.getY();
            comp = parent;
        }
        return new Point(x, y);
    }

    public static void main(String[] args) {
        try {
            JFrame frame = new JFrame("Balloon");
            JPanel panel = new JPanel();
            panel.setLayout(new GridLayout(1, 1));
            JFileChooser chooser = new JFileChooser();
            panel.add(chooser);
            JPanel panel2 = new JPanel();
            panel2.setLayout(new FlowLayout());
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Balloon balloon = new Balloon();
                    balloon.setBackground(Color.yellow);
                    balloon.setForeground(Color.black);
                    FadeablePanel fp = new FadeablePanel();
                    fp.setBackground(null);
                    fp.setLayout(new GridLayout(1, 1));
                    fp.add(new JLabel("Hello World!"));
                    balloon.add(fp);
                    Dimension pref = balloon.getPreferredSize();
                    balloon.setBounds(0, 0, pref.width, pref.height);
                    BalloonManager.getSharedInstance().showBalloon((Component)e.getSource(), balloon, 0, 0);
                }
            };
            for (int c = 0; c < 5; ++c) {
                JButton button1 = new JButton("Test " + c);
                button1.addActionListener(actionListener);
                panel2.add(button1);
            }
            panel.add(panel2);
            frame.setContentPane(panel);
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    super.windowClosing(e);
                    System.exit(0);
                }
            });
            frame.setBounds(100, 100, 500, 500);
            frame.setVisible(true);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            System.exit(0);
        }
    }

    static {
        logger = Logger.getLogger(BalloonManager.class.getName());
    }
}

