/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.help;

import com.spacekiller.util.help.ContextHelp;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Vector;

public class ContextHelpIndex
implements Externalizable {
    private Vector help = new Vector();
    private Hashtable hashByName = new Hashtable();
    private Hashtable hashByType = new Hashtable();

    public void addContextHelp(ContextHelp h) {
        this.insertContextHelpAt(h, this.getContextHelpCount());
    }

    public ContextHelp getContextHelpAt(int index) {
        return (ContextHelp)this.help.get(index);
    }

    public int getContextHelpCount() {
        return this.help.size();
    }

    public void getContextHelpsByName(String name, Collection dstContextHelps) {
        if (name == null) {
            return;
        }
        Vector v = this.getNameVector(name);
        if (v != null) {
            dstContextHelps.addAll(v);
        }
    }

    public void getContextHelpsByType(String type, Collection dstContextHelps) {
        if (type == null) {
            return;
        }
        Vector v = this.getTypeVector(type);
        if (v != null) {
            dstContextHelps.addAll(v);
        }
    }

    protected Vector getNameVector(String name) {
        return (Vector)this.hashByName.get(name);
    }

    protected Vector getTypeVector(String type) {
        return (Vector)this.hashByType.get(type);
    }

    public synchronized void insertContextHelpAt(ContextHelp h, int index) {
        if (h != null) {
            this.help.insertElementAt(h, index);
            int count = h.getContextCount();
            for (int c = 0; c < count; ++c) {
                String type;
                Vector<ContextHelp> v;
                String name = h.getContextName(c);
                if (name != null && name.length() > 0) {
                    v = this.getNameVector(name);
                    if (v == null) {
                        v = new Vector<ContextHelp>();
                        this.hashByName.put(name, v);
                    }
                    v.addElement(h);
                }
                if ((type = h.getContextType(c)) == null || type.length() <= 0) continue;
                v = this.getTypeVector(type);
                if (v == null) {
                    v = new Vector<ContextHelp>();
                    this.hashByType.put(type, v);
                }
                v.addElement(h);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    public synchronized void removeContextHelp(ContextHelp h) {
        if (h != null) {
            this.help.removeElement(h);
            int count = h.getContextCount();
            for (int c = 0; c < count; ++c) {
                String type;
                Vector v;
                String name = h.getContextName(c);
                if (name != null && name.length() > 0 && (v = this.getNameVector(name)) != null) {
                    v.removeElement(h);
                    if (v.isEmpty()) {
                        this.hashByName.remove(name);
                    }
                }
                if ((type = h.getContextType(c)) == null || type.length() <= 0 || (v = this.getTypeVector(type)) == null) continue;
                v.removeElement(h);
                if (!v.isEmpty()) continue;
                this.hashByType.remove(type);
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
    }
}

