/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.help;

import com.spacekiller.util.help.ContextHelpIndex;
import com.spacekiller.util.help.ContextHelpManager;
import com.spacekiller.util.help.LayerLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;

public class ContextHelpPane
extends JComponent
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = -397160481307990091L;
    private Rectangle markRect;
    private ContextHelpManager manager;
    private boolean designTime;
    private ContextHelpIndex contextHelpIndex;

    public ContextHelpPane() {
        this.initContextHelpPane();
    }

    public void closeContextHelp() {
        Container parent = this.getParent();
        if (parent != null) {
            parent.remove(this);
            parent.validate();
            parent.repaint();
        }
    }

    public Component getContextComponentAt(int x, int y) {
        Container parent = this.getParent();
        if (parent == null) {
            return null;
        }
        Component[] comps = parent.getComponents();
        if (comps != null) {
            for (int c = 0; c < comps.length; ++c) {
                Component comp = comps[c];
                if (comp == this || !comp.contains(x, y)) continue;
                Component rc;
                while ((rc = comp.getComponentAt(x -= comp.getX(), y -= comp.getY())) != null && rc != comp) {
                    comp = rc;
                }
                return comp;
            }
        }
        return null;
    }

    public Point getContextComponentLocation(Component c) {
        int x = c.getX();
        int y = c.getY();
        Container thisParent = this.getParent();
        for (Container p = c.getParent(); p != null && p != thisParent; p = p.getParent()) {
            x += p.getX();
            y += p.getY();
        }
        return new Point(x, y);
    }

    public ContextHelpIndex getContextHelpIndex() {
        return this.contextHelpIndex;
    }

    public ContextHelpManager getManager() {
        return this.manager;
    }

    public Rectangle getMarkRect() {
        return this.markRect;
    }

    protected void initContextHelpPane() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    public boolean isDesignTime() {
        return this.designTime;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Component comp = this.getContextComponentAt(e.getX(), e.getY());
        ContextHelpManager man = this.getManager();
        if (man != null) {
            man.contextHelpStopped(comp);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Component comp = this.getContextComponentAt(e.getX(), e.getY());
        Rectangle rect = null;
        if (comp != null) {
            Point p = this.getContextComponentLocation(comp);
            rect = new Rectangle(p.x, p.y, comp.getWidth(), comp.getHeight());
        }
        this.setMarkRect(rect);
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        ContextHelpManager man;
        if (e.isPopupTrigger() && (man = this.getManager()) != null) {
            man.contextHelpStopped(null);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Rectangle rect = this.getMarkRect();
        if (rect != null) {
            g.setColor(Color.black);
            g.drawRect(rect.x, rect.y, rect.width, rect.height);
        }
    }

    protected void repaintMarkRect(Rectangle rect) {
        if (rect == null) {
            return;
        }
        this.repaint(rect.x, rect.y, rect.width, rect.height);
    }

    public void setContextHelpIndex(ContextHelpIndex newContextHelpIndex) {
        this.contextHelpIndex = newContextHelpIndex;
    }

    public void setDesignTime(boolean newDesignTime) {
        this.designTime = newDesignTime;
    }

    public void setManager(ContextHelpManager newManager) {
        this.manager = newManager;
    }

    public void setMarkRect(Rectangle newMarkRect) {
        if (this.markRect != null) {
            this.repaintMarkRect(this.markRect);
        }
        this.markRect = newMarkRect;
        if (this.markRect != null) {
            this.repaintMarkRect(this.markRect);
        }
    }

    public void showContextHelp(JLayeredPane layeredPane) {
        int layer = 1000;
        LayerLayout.installLayeredComponent(layeredPane, layer, this);
        layeredPane.validate();
        layeredPane.repaint();
    }
}

