/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.beans;

import com.spacekiller.infection.beans.JavaArchive;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class DefaultJavaArchive
implements JavaArchive,
Serializable {
    private static final long serialVersionUID = -7012169450801960344L;
    public static final String PROPERTY_PACKAGE_NAMES = "packageNames";
    private String path = "";
    private int type = 0;
    private long size = -1L;
    private long checksum = -1L;
    private boolean desinfectable = false;
    private int classCount = 0;
    protected transient PropertyChangeSupport propertyChange;
    private String[] fieldPackageNames = null;

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChange().addPropertyChangeListener(listener);
    }

    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.getPropertyChange().addPropertyChangeListener(propertyName, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration enumerateClasses() throws Exception {
        if (this.getType() != 0) {
            return null;
        }
        Vector<String> classNames = new Vector<String>();
        ZipFile zipFile = new ZipFile(this.getPath());
        try {
            Enumeration<? extends ZipEntry> en = zipFile.entries();
            while (en.hasMoreElements()) {
                ZipEntry entry = en.nextElement();
                String name = entry.getName();
                if (!name.endsWith(".class")) continue;
                name = name.substring(0, name.length() - 6).replace('/', '.');
                classNames.addElement(name);
            }
        }
        finally {
            zipFile.close();
        }
        return classNames.elements();
    }

    @Override
    public Enumeration enumeratePackages(Enumeration classNames) {
        Vector<String> packages = new Vector<String>();
        while (classNames.hasMoreElements()) {
            String className = String.valueOf(classNames.nextElement());
            String pkgName = DefaultJavaArchive.getPackageName(className);
            if (packages.indexOf(pkgName) >= 0) continue;
            packages.addElement(pkgName);
        }
        return packages.elements();
    }

    public void firePropertyChange(PropertyChangeEvent evt) {
        this.getPropertyChange().firePropertyChange(evt);
    }

    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
        this.getPropertyChange().firePropertyChange(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.getPropertyChange().firePropertyChange(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        this.getPropertyChange().firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public long getChecksum() {
        return this.checksum;
    }

    @Override
    public int getClassCount() {
        return this.classCount;
    }

    @Override
    public int getPackageCount() {
        String[] names = this.getPackageNames();
        return names == null ? 0 : names.length;
    }

    public static String getPackageName(String className) {
        int i = className.lastIndexOf(".");
        if (i < 0) {
            return "";
        }
        return className.substring(0, i);
    }

    @Override
    public String[] getPackageNames() {
        return this.fieldPackageNames;
    }

    @Override
    public String getPackageNames(int index) {
        return this.getPackageNames()[index];
    }

    @Override
    public String getPath() {
        return this.path;
    }

    protected PropertyChangeSupport getPropertyChange() {
        if (this.propertyChange == null) {
            this.propertyChange = new PropertyChangeSupport(this);
        }
        return this.propertyChange;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public URL getURL() throws Exception {
        String cp = this.getPath();
        File file = new File(cp);
        if (file.exists()) {
            return file.toURI().toURL();
        }
        return new URL(cp);
    }

    public synchronized boolean hasListeners(String propertyName) {
        return this.getPropertyChange().hasListeners(propertyName);
    }

    @Override
    public boolean isDesinfectable() {
        return this.desinfectable;
    }

    @Override
    public boolean isDirectory() {
        return this.type == 1;
    }

    @Override
    public boolean isJarFile() {
        return this.type == 0;
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChange().removePropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.getPropertyChange().removePropertyChangeListener(propertyName, listener);
    }

    public void setChecksum(long newChecksum) {
        this.checksum = newChecksum;
    }

    public void setClassCount(int newClassCount) {
        this.classCount = newClassCount;
    }

    public void setDesinfectable(boolean newDesinfectable) {
        this.desinfectable = newDesinfectable;
    }

    @Override
    public void setPackageNames(String[] packageNames) {
        String[] oldValue = this.fieldPackageNames;
        this.fieldPackageNames = packageNames;
        this.firePropertyChange(PROPERTY_PACKAGE_NAMES, oldValue, packageNames);
    }

    @Override
    public void setPackageNames(int index, String packageNames) {
        String oldValue = this.fieldPackageNames[index];
        this.fieldPackageNames[index] = packageNames;
        if (oldValue != null && !oldValue.equals(packageNames)) {
            this.firePropertyChange(PROPERTY_PACKAGE_NAMES, null, this.fieldPackageNames);
        }
    }

    public void setPath(String newPath) {
        this.path = newPath;
    }

    public void setSize(long newSize) {
        this.size = newSize;
    }

    public void setType(int newType) {
        this.type = newType;
    }

    public String toString() {
        return String.valueOf(this.getPath());
    }
}

