/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.beans;

import com.spacekiller.infection.beans.Manifest;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class DefaultManifest
implements Manifest,
Serializable {
    private static final long serialVersionUID = 1115792474315893661L;
    private Vector manifest = new Vector();

    public void addAll(DefaultManifest source) {
        this.manifest.addAll(source.manifest);
    }

    public void addEntry(String entry) {
        this.insertEntryAt(entry, this.manifest.size());
    }

    public void addValue(String key, String value) {
        this.insertValueAt(key, value, this.manifest.size());
    }

    public String buildEntry(String key, String value) {
        return "" + key + ": " + value;
    }

    public void dump(PrintStream out) {
        out.println("Manifest");
        out.println("--------");
        int count = this.size();
        for (int c = 0; c < count; ++c) {
            out.println("" + this.manifest.elementAt(c));
        }
    }

    @Override
    public String getEntryAt(int index) {
        return String.valueOf(this.manifest.elementAt(index));
    }

    @Override
    public int getIndex(String key) {
        return this.getIndex(key, 0);
    }

    @Override
    public int getIndex(String key, int fromIndex) {
        String search = "" + key + ":";
        int count = this.manifest.size();
        for (int c = fromIndex; c < count; ++c) {
            String s = String.valueOf(this.manifest.elementAt(c));
            if (!s.startsWith(search)) continue;
            return c;
        }
        return -1;
    }

    @Override
    public String getKeyAt(int index) {
        String s = String.valueOf(this.manifest.elementAt(index));
        int i = s.indexOf(":");
        if (i < 0) {
            return null;
        }
        s = s.substring(0, i);
        while (s.startsWith(" ")) {
            s = s.substring(1);
        }
        return s;
    }

    @Override
    public String getValue(String key) {
        int i = this.getIndex(key);
        if (i < 0) {
            return null;
        }
        return this.getValueAt(i);
    }

    @Override
    public String getValueAt(int index) {
        String s = String.valueOf(this.manifest.elementAt(index));
        int i = s.indexOf(":");
        if (i < 0) {
            return "";
        }
        s = s.substring(i + 1);
        while (s.startsWith(" ")) {
            s = s.substring(1);
        }
        return s;
    }

    public void insertEntryAt(String entry, int index) {
        this.manifest.insertElementAt(entry, index);
    }

    public void insertValueAt(String key, String value, int index) {
        this.insertEntryAt(this.buildEntry(key, value), index);
    }

    public void put(String key, String value) {
        this.put(key, value, this.size());
    }

    public void put(String key, String value, int insertIndex) {
        int index = this.getIndex(key);
        if (index >= 0) {
            this.setValueAt(key, value, index);
        } else {
            this.insertValueAt(key, value, insertIndex);
        }
    }

    public void read(InputStream in) throws Exception {
        String s;
        BufferedReader manifestReader = new BufferedReader(new InputStreamReader(in));
        while ((s = manifestReader.readLine()) != null) {
            this.manifest.addElement(s);
        }
        manifestReader.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(ZipFile zipFile) throws Exception {
        ZipEntry entry = zipFile.getEntry("META-INF/MANIFEST.MF");
        if (entry == null) {
            throw new Exception("No manifest file META-INF/MANIFEST.MF found in " + zipFile);
        }
        InputStream in = zipFile.getInputStream(entry);
        try {
            this.read(in);
        }
        finally {
            in.close();
        }
    }

    public void removeEntryAt(int index) {
        this.manifest.removeElementAt(index);
    }

    public void removeKey(String key) {
        int i;
        while ((i = this.getIndex(key)) >= 0) {
            this.removeEntryAt(i);
        }
    }

    @Override
    public void resolveVariable(String varName, String varValue) {
        int count = this.size();
        for (int c = 0; c < count; ++c) {
            int i;
            String key = this.getKeyAt(c);
            String value = this.getValueAt(c);
            if (value == null) continue;
            while ((i = value.indexOf(varName)) >= 0) {
                value = value.substring(0, i) + varValue + value.substring(i + varName.length());
            }
            this.setValueAt(key, value, c);
        }
    }

    public void setEntryAt(String entry, int index) {
        this.manifest.setElementAt(entry, index);
    }

    public void setValueAt(String key, String value, int index) {
        this.setEntryAt(this.buildEntry(key, value), index);
    }

    @Override
    public int size() {
        return this.manifest.size();
    }

    public void write(OutputStream out) throws Exception {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out));
        int count = this.manifest.size();
        for (int c = 0; c < count; ++c) {
            writer.write((String)this.manifest.elementAt(c));
            writer.write("\n");
        }
        writer.flush();
    }
}

