/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.beans;

import com.spacekiller.infection.beans.JavaArchive;
import com.spacekiller.infection.beans.VirtualMachine;
import java.io.File;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class DefaultVirtualMachine
implements VirtualMachine,
Serializable {
    private static final long serialVersionUID = 3589691729247867224L;
    private String executablePath = "";
    private String extraClassPath = "";
    private String jvmVendorUrl = "";
    private String jvmVersion = "";
    private String jvmHome = "http://home";
    private String jvmVmVersion = "";
    private String jvmVmName = "";
    private String jvmVmInfo = "";
    private double version = 0.0;
    private Vector javaArchives = new Vector();

    public void addJavaArchive(JavaArchive cp) {
        if (cp == null) {
            return;
        }
        if (this.javaArchives.indexOf(cp) >= 0) {
            return;
        }
        this.javaArchives.addElement(cp);
    }

    protected String[] buildBootCommand(String classPath, String bootJarPath, String bootClassName, Properties sysProps, String[] args) {
        boolean bootJar = bootJarPath != null;
        Vector<String> v = new Vector<String>();
        v.addElement(this.getExecutablePath());
        if (bootJar) {
            v.addElement("-jar");
        }
        if (classPath != null && (classPath = classPath.trim()).length() > 0) {
            v.addElement("-cp");
            v.addElement(classPath);
        }
        if (sysProps != null) {
            Enumeration<Object> en = sysProps.keys();
            while (en.hasMoreElements()) {
                Object key = en.nextElement();
                Object value = sysProps.get(key);
                v.addElement("-D" + key + "=" + value);
            }
        }
        if (bootJar) {
            v.addElement(bootJarPath);
        } else {
            v.addElement(bootClassName);
        }
        for (int c = 0; c < args.length; ++c) {
            v.addElement(args[c]);
        }
        String[] cmd = new String[v.size()];
        for (int c = 0; c < cmd.length; ++c) {
            cmd[c] = (String)v.elementAt(c);
        }
        return cmd;
    }

    @Override
    public String[] buildClassBootCommand(String classPath, String bootClassName, Properties sysProps, String[] args) {
        return this.buildBootCommand(classPath, null, bootClassName, sysProps, args);
    }

    @Override
    public String buildClassPath(String[] paths) {
        String cp = "";
        String sep = File.pathSeparator;
        for (int c = 0; c < paths.length; ++c) {
            String s = paths[c];
            if (s == null) continue;
            if ((s = s.trim()).startsWith(sep)) {
                s = s.substring(sep.length());
            }
            if (s.endsWith(sep)) {
                s = s.substring(0, s.length() - sep.length());
            }
            if (s.equals("")) continue;
            if (!cp.equals("")) {
                cp = cp + sep;
            }
            cp = cp + s;
        }
        return cp;
    }

    @Override
    public String buildClassPath(Vector classPathEntries) {
        String cp = "";
        for (int c = 0; c < classPathEntries.size(); ++c) {
            JavaArchive entry = (JavaArchive)classPathEntries.elementAt(c);
            if (c > 0) {
                cp = cp + File.pathSeparator;
            }
            cp = cp + "" + entry.getPath();
        }
        return cp;
    }

    @Override
    public String[] buildJarBootCommand(String classPath, String bootJarPath, Properties sysProps, String[] args) {
        return this.buildBootCommand(classPath, bootJarPath, null, sysProps, args);
    }

    protected static int comparePreferredExecutable(String[] prefExec, String path1, String path2) {
        if (prefExec == null) {
            return 0;
        }
        if (prefExec.length < 1) {
            return 0;
        }
        String name1 = new File(path1).getName();
        String name2 = new File(path2).getName();
        int index1 = -1;
        for (int c = 0; c < prefExec.length; ++c) {
            if (!prefExec[c].equalsIgnoreCase(name1)) continue;
            index1 = c;
            break;
        }
        int index2 = -1;
        for (int c = 0; c < prefExec.length; ++c) {
            if (!prefExec[c].equalsIgnoreCase(name2)) continue;
            index2 = c;
            break;
        }
        if (index1 >= 0) {
            if (index2 < 0) {
                return 1;
            }
            return index1 < index2 ? 1 : 2;
        }
        if (index2 < 0) {
            return 0;
        }
        return 2;
    }

    protected static int comparePreferredVendorUrl(String prefUrl, String url1, String url2) {
        boolean pref2;
        if (prefUrl == null) {
            return 0;
        }
        if (prefUrl.length() < 1) {
            return 0;
        }
        boolean pref1 = url1 == null ? false : prefUrl.equals(url1);
        boolean bl = pref2 = url2 == null ? false : prefUrl.equals(url2);
        if (pref1 && !pref2) {
            return 1;
        }
        if (pref2 && !pref1) {
            return 2;
        }
        return 0;
    }

    protected static int comparePreferredVersion(double prefVersion, double ver1, double ver2) {
        if (ver1 == ver2) {
            return 0;
        }
        if (prefVersion > 0.0) {
            double delta2;
            boolean pref2;
            boolean pref1 = ver1 == prefVersion;
            boolean bl = pref2 = ver2 == prefVersion;
            if (pref1 && pref2) {
                return 0;
            }
            if (pref1) {
                return 1;
            }
            if (pref2) {
                return 2;
            }
            if (ver1 > prefVersion && ver2 < prefVersion) {
                return 1;
            }
            if (ver2 > prefVersion && ver1 < prefVersion) {
                return 2;
            }
            double delta1 = Math.abs(prefVersion - ver1);
            return delta1 < (delta2 = Math.abs(prefVersion - ver2)) ? 1 : 2;
        }
        return ver1 > ver2 ? 1 : 2;
    }

    @Override
    public String getExecutablePath() {
        return this.executablePath;
    }

    @Override
    public String getExtraClassPath() {
        return this.extraClassPath;
    }

    @Override
    public JavaArchive getJavaArchiveAt(int i) {
        return (JavaArchive)this.javaArchives.elementAt(i);
    }

    @Override
    public int getJavaArchiveCount() {
        return this.javaArchives.size();
    }

    @Override
    public int getJavaArchiveIndex(JavaArchive cp) {
        return this.javaArchives.indexOf(cp);
    }

    @Override
    public void getJavaArchives(Vector classPathEntries) {
        for (int c = 0; c < this.getJavaArchiveCount(); ++c) {
            JavaArchive p = this.getJavaArchiveAt(c);
            if (classPathEntries.indexOf(p) >= 0) continue;
            classPathEntries.addElement(p);
        }
    }

    @Override
    public String getJvmHome() {
        return this.jvmHome;
    }

    @Override
    public String getJvmVendorUrl() {
        return this.jvmVendorUrl;
    }

    @Override
    public String getJvmVersion() {
        return this.jvmVersion;
    }

    @Override
    public String getJvmVmInfo() {
        return this.jvmVmInfo;
    }

    @Override
    public String getJvmVmName() {
        return this.jvmVmName;
    }

    @Override
    public String getJvmVmVersion() {
        return this.jvmVmVersion;
    }

    public static VirtualMachine getPreferredVM(VirtualMachine vm1, VirtualMachine vm2, double minVersion, double prefVersion, String prefVendor, String[] prefExec) {
        boolean ok2;
        boolean ok1 = vm1.getVersion() >= minVersion;
        boolean bl = ok2 = vm2.getVersion() >= minVersion;
        if (!ok1 && !ok2) {
            return null;
        }
        if (!ok1) {
            return vm2;
        }
        if (!ok2) {
            return vm1;
        }
        int cmp = DefaultVirtualMachine.comparePreferredVersion(prefVersion, vm1.getVersion(), vm2.getVersion());
        if (cmp == 1) {
            return vm1;
        }
        if (cmp == 2) {
            return vm2;
        }
        cmp = DefaultVirtualMachine.comparePreferredVendorUrl(prefVendor, vm1.getJvmVendorUrl(), vm2.getJvmVendorUrl());
        if (cmp == 1) {
            return vm1;
        }
        if (cmp == 2) {
            return vm2;
        }
        cmp = DefaultVirtualMachine.comparePreferredExecutable(prefExec, vm1.getExecutablePath(), vm2.getExecutablePath());
        if (cmp == 1) {
            return vm1;
        }
        if (cmp == 2) {
            return vm2;
        }
        return vm1;
    }

    @Override
    public double getVersion() {
        return this.version;
    }

    public void refreshVersion() {
        double v = 0.0;
        String numChars = "0123456789";
        String s = this.getJvmVersion();
        if (s == null) {
            s = "";
        }
        int i = 0;
        boolean dot = false;
        while (i < s.length()) {
            char ch = s.charAt(i);
            if (numChars.indexOf(ch) >= 0) {
                ++i;
                continue;
            }
            if (!dot && ch == '.') {
                dot = true;
                ++i;
                continue;
            }
            s = s.substring(0, i) + s.substring(i + 1);
        }
        try {
            v = Double.parseDouble(s);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.setVersion(v);
    }

    public void removeJavaArchive(JavaArchive cp) {
        if (cp == null) {
            return;
        }
        if (this.javaArchives.indexOf(cp) < 0) {
            return;
        }
        this.javaArchives.removeElement(cp);
    }

    public void setExecutablePath(String newExecutablePath) {
        this.executablePath = newExecutablePath;
    }

    public void setExtraClassPath(String newExtraClassPath) {
        this.extraClassPath = newExtraClassPath;
    }

    public void setJvmHome(String newJvmHome) {
        this.jvmHome = newJvmHome;
    }

    public void setJvmVendorUrl(String newJvmVendorUrl) {
        this.jvmVendorUrl = newJvmVendorUrl;
    }

    public void setJvmVersion(String newJvmVersion) {
        this.jvmVersion = newJvmVersion;
    }

    public void setJvmVmInfo(String newJvmVmInfo) {
        this.jvmVmInfo = newJvmVmInfo;
    }

    public void setJvmVmName(String newJvmVmName) {
        this.jvmVmName = newJvmVmName;
    }

    public void setJvmVmVersion(String newJvmVmVersion) {
        this.jvmVmVersion = newJvmVmVersion;
    }

    public void setVersion(double newVersion) {
        this.version = newVersion;
    }

    public String toString() {
        return "" + this.getExecutablePath() + "  (" + this.getJvmVendorUrl() + ", Version " + this.getJvmVersion() + ")";
    }
}

