/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.platform;

import com.spacekiller.infection.platform.InfectionLauncher;
import com.spacekiller.infection.platform.InfectionPlatform;
import com.spacekiller.infection.platform.InfectionUndoManager;
import com.spacekiller.infection.platform.InfectionWorkbench;
import com.spacekiller.infection.platform.InfectionWorkspace;
import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.FileContext;
import com.spacekiller.util.Platform;
import com.spacekiller.util.Preferences;
import com.spacekiller.util.PreferencesRegistry;
import com.spacekiller.util.Tools;
import com.spacekiller.util.beans.BeanDropManager;
import com.spacekiller.util.beans.BeanDropSupport;
import com.spacekiller.util.beans.ClipboardManager;
import com.spacekiller.util.beans.DefaultBeanDropSupport;
import com.spacekiller.util.beans.DefaultBeansToolkit;
import com.spacekiller.util.beans.FileCustomizerProvider;
import com.spacekiller.util.beans.FileDirNode;
import com.spacekiller.util.beans.FileIconProvider;
import com.spacekiller.util.beans.FileLeafNode;
import com.spacekiller.util.workbench.Perspective;
import com.spacekiller.util.workbench.Workbench;
import com.spacekiller.util.workbench.WorkbenchPlugin;
import com.spacekiller.util.workbench.WorkbenchUtilities;
import com.spacekiller.util.workspace.SyncManager;
import com.spacekiller.util.workspace.Workspace;
import com.spacekiller.util.workspace.WorkspacePlugin;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.beancontext.BeanContext;
import java.io.File;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.undo.UndoManager;

public class DefaultInfectionLauncher
extends InfectionLauncher {
    private static final Logger logger = Logger.getLogger(DefaultInfectionLauncher.class.getName());
    private InfectionWorkbench infectionWorkbench;
    private InfectionUndoManager infectionUndoManager;
    private ClipboardManager defaultClipboardManager;
    private BeanDropManager defaultBeanDropManager;
    private FileCustomizerProvider fileCustomizerProvider;
    private FileIconProvider fileIconProvider;

    protected DefaultInfectionLauncher() {
    }

    public static void main(String[] args) {
        new DefaultInfectionLauncher().launch(args);
    }

    @Override
    protected boolean shutdownNormally() {
        InfectionWorkbench wb;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("shutdownNormally...");
        }
        if ((wb = this.infectionWorkbench) != null && !wb.shutdownNormally()) {
            return false;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("shutdown...");
        }
        return super.shutdownNormally();
    }

    protected void workbenchClosed(Workbench workbench) {
        if (workbench == null || workbench != this.infectionWorkbench) {
            return;
        }
        workbench.dispose();
        try {
            Platform.getInstance().exit(0);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    @Override
    protected UndoManager getDefaultUndoManager() throws Exception {
        return this.getInfectionUndoManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InfectionUndoManager getInfectionUndoManager() {
        if (this.infectionUndoManager == null) {
            DefaultInfectionLauncher defaultInfectionLauncher = this;
            synchronized (defaultInfectionLauncher) {
                if (this.infectionUndoManager == null) {
                    this.infectionUndoManager = this.createInfectionUndoManager();
                }
            }
        }
        return this.infectionUndoManager;
    }

    protected InfectionUndoManager createInfectionUndoManager() {
        return new InfectionUndoManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ClipboardManager getDefaultClipboardManager() throws Exception {
        if (this.defaultClipboardManager == null) {
            DefaultInfectionLauncher defaultInfectionLauncher = this;
            synchronized (defaultInfectionLauncher) {
                if (this.defaultClipboardManager == null) {
                    this.defaultClipboardManager = this.createClipboardManager();
                }
            }
        }
        return this.defaultClipboardManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected BeanDropManager getDefaultBeanDropManager() throws Exception {
        if (this.defaultBeanDropManager == null) {
            DefaultInfectionLauncher defaultInfectionLauncher = this;
            synchronized (defaultInfectionLauncher) {
                if (this.defaultBeanDropManager == null) {
                    this.defaultBeanDropManager = this.createDefaultBeanDropManager();
                }
            }
        }
        return this.defaultBeanDropManager;
    }

    protected BeanDropManager createDefaultBeanDropManager() throws Exception {
        BeanDropManager dropMan = new BeanDropManager();
        DefaultBeansToolkit btk = this.getDefaultBeansToolkit();
        if (btk != null) {
            dropMan.registerBeanDropSupport((BeanDropSupport)new DefaultBeanDropSupport((BeansToolkit)btk));
        }
        return dropMan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Workbench getMainWorkbench() throws Exception {
        if (this.infectionWorkbench == null) {
            DefaultInfectionLauncher defaultInfectionLauncher = this;
            synchronized (defaultInfectionLauncher) {
                if (this.infectionWorkbench == null) {
                    this.infectionWorkbench = this.createInfectionWorkbench();
                }
            }
        }
        return this.infectionWorkbench;
    }

    protected synchronized InfectionWorkbench createInfectionWorkbench() throws Exception {
        BeanContext syncManagers;
        SyncManager syncManager = null;
        Platform plat = Platform.getInstance();
        WorkspacePlugin workspacePlugin = (WorkspacePlugin)plat.getPlugin("com.spacekiller.util.workspace.WorkspacePlugin");
        if (workspacePlugin != null && (syncManagers = workspacePlugin.getSyncManagers()) != null) {
            for (SyncManager sm : syncManagers) {
                if (sm == null) continue;
                syncManager = sm;
                break;
            }
        }
        if (logger.isLoggable(Level.CONFIG)) {
            logger.config("SyncManager: " + syncManager);
        }
        InfectionWorkspace workspace = new InfectionWorkspace();
        workspace.setSyncManager(syncManager);
        InfectionWorkbench workbench = new InfectionWorkbench();
        workbench.addWindowListener(new WorkbenchWindowHandler((Workbench)workbench));
        workbench.setWorkspace((Workspace)workspace);
        this.initInfectionWorkbench(workbench);
        this.infectionWorkbench = workbench;
        return workbench;
    }

    protected void initInfectionWorkbench(InfectionWorkbench workbench) throws Exception {
        WorkbenchPlugin wbPlugin = WorkbenchUtilities.getWorkbenchPlugin();
        BeansToolkit beansToolkit = Platform.getInstance().getBeansToolkit();
        BeanDropManager beanDropSupport = this.getDefaultBeanDropManager();
        ClipboardManager clipboardManager = this.getDefaultClipboardManager();
        if (logger.isLoggable(Level.CONFIG)) {
            logger.config("BeansToolkit: " + beansToolkit);
            logger.config("BeanDropSupport: " + beanDropSupport);
            logger.config("ClipboardManager: " + clipboardManager);
        }
        workbench.setBeansToolkit(beansToolkit);
        workbench.setBeanDropSupport((BeanDropSupport)beanDropSupport);
        workbench.setClipboardManager(clipboardManager);
        InfectionUndoManager undoMan = this.getInfectionUndoManager();
        if (undoMan != null) {
            workbench.setUndoManager(undoMan);
            undoMan.setWorkbench((Workbench)workbench);
        }
        wbPlugin.getViewProviders();
        BeanContext pers = wbPlugin.getPerspectives();
        if (pers != null) {
            Iterator i = pers.iterator();
            while (i.hasNext()) {
                try {
                    Perspective p = (Perspective)i.next();
                    if (p == null) continue;
                    workbench.addPerspective(p);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
        Perspective perspective = null;
        int numPerspectives = workbench.getPerspectiveCount();
        if (logger.isLoggable(Level.CONFIG)) {
            logger.config("Perspectives: " + numPerspectives);
        }
        if (numPerspectives > 0) {
            perspective = workbench.getPerspectiveAt(0);
        }
        if (logger.isLoggable(Level.CONFIG)) {
            logger.config("Perspective: " + perspective);
        }
        if (perspective == null) {
            throw new Exception("No perspective available!");
        }
        workbench.setPerspective(perspective);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected FileIconProvider getFileIconProvider() throws Exception {
        if (this.fileIconProvider == null) {
            DefaultInfectionLauncher defaultInfectionLauncher = this;
            synchronized (defaultInfectionLauncher) {
                if (this.fileIconProvider == null) {
                    this.fileIconProvider = this.createFileIconProvider();
                }
            }
        }
        return this.fileIconProvider;
    }

    protected FileIconProvider createFileIconProvider() {
        FileIconProvider fip = new FileIconProvider();
        fip.setBeanTypes(new Class[]{File.class, FileContext.class, FileLeafNode.class, FileLeafNode.NamedFileLeafNode.class, FileDirNode.class, FileDirNode.NamedFileDirNode.class, FileDirNode.DirOnlyNode.class, FileDirNode.NamedDirOnlyNode.class});
        fip.setFileIcon(Tools.getIcon(this.getClass(), (String)"/com/spacekiller/infection/platform/icons/file.gif"));
        fip.setFileNotFoundIcon(Tools.getIcon(this.getClass(), (String)"/com/spacekiller/infection/platform/icons/fileNotFound.gif"));
        fip.setDirectoryIcon(Tools.getIcon(this.getClass(), (String)"/com/spacekiller/infection/platform/icons/folder.gif"));
        fip.setDirectoryNotFoundIcon(Tools.getIcon(this.getClass(), (String)"/com/spacekiller/infection/platform/icons/folderNotFound.gif"));
        fip.setRootIcon(Tools.getIcon(this.getClass(), (String)"/com/spacekiller/infection/platform/icons/fileSystem.gif"));
        fip.setRootNotFoundIcon(Tools.getIcon(this.getClass(), (String)"/com/spacekiller/infection/platform/icons/fileSystemNotFound.gif"));
        return fip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected FileCustomizerProvider getFileCustomizerProvider() throws Exception {
        if (this.fileCustomizerProvider == null) {
            DefaultInfectionLauncher defaultInfectionLauncher = this;
            synchronized (defaultInfectionLauncher) {
                if (this.fileCustomizerProvider == null) {
                    this.fileCustomizerProvider = this.createFileCustomizerProvider();
                }
            }
        }
        return this.fileCustomizerProvider;
    }

    protected FileCustomizerProvider createFileCustomizerProvider() {
        FileCustomizerProvider fcp = new FileCustomizerProvider();
        fcp.setBeanTypes(new Class[]{File.class, FileContext.class, FileLeafNode.class, FileLeafNode.NamedFileLeafNode.class, FileDirNode.class, FileDirNode.NamedFileDirNode.class});
        return fcp;
    }

    @Override
    protected void postStartup(InfectionPlatform platform) throws Exception {
        this.loadPerspectives();
        this.loadProjects();
        super.postStartup(platform);
    }

    protected void loadPerspectives() {
        InfectionWorkbench workbench = this.infectionWorkbench;
        if (workbench == null) {
            return;
        }
        try {
            Platform plat = Platform.getInstance();
            PreferencesRegistry prefReg = plat.getPreferencesRegistry();
            if (prefReg == null) {
                return;
            }
            Perspective activePers = null;
            if (activePers != null) {
                workbench.setPerspective(activePers);
            }
            int persCount = workbench.getPerspectiveCount();
            for (int i = 0; i < persCount; ++i) {
                Perspective perspective = workbench.getPerspectiveAt(i);
                if (perspective == null) {
                    return;
                }
                String persName = perspective.getName();
                logger.info("Loading perspective: " + persName);
                long ms2 = -System.currentTimeMillis();
                String prefsKey = "perspective." + persName;
                Preferences persPrefs = prefReg.getPreferences(prefsKey);
                if (persPrefs != null) {
                    perspective.loadPreferences(persPrefs);
                }
                logger.info("Perspective loaded in " + (ms2 += System.currentTimeMillis()) + " ms.");
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected void loadProjects() {
        InfectionWorkbench workbench = this.infectionWorkbench;
        if (workbench == null) {
            return;
        }
        try {
            workbench.loadWorkspace();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected class WorkbenchWindowHandler
    extends WindowAdapter {
        final Workbench workbench;

        public WorkbenchWindowHandler(Workbench workbench) {
            this.workbench = workbench;
        }

        @Override
        public void windowClosed(WindowEvent ev) {
            DefaultInfectionLauncher.this.workbenchClosed(this.workbench);
        }
    }
}

