/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.platform;

import com.spacekiller.infection.Debug;
import com.spacekiller.infection.InfectionRuntime;
import com.spacekiller.infection.load.ArtifactLoader;
import com.spacekiller.infection.old.ErrorDialog;
import com.spacekiller.infection.platform.DefaultInfectionLauncher;
import com.spacekiller.infection.platform.InfectionClassRegistry;
import com.spacekiller.infection.platform.InfectionDesktopManager;
import com.spacekiller.infection.platform.InfectionFileLocator;
import com.spacekiller.infection.platform.InfectionLogHistory;
import com.spacekiller.infection.platform.InfectionLoginManager;
import com.spacekiller.infection.platform.InfectionPreferencesConstants;
import com.spacekiller.infection.platform.InfectionPreferencesRegistry;
import com.spacekiller.infection.platform.InfectionProductRegistry;
import com.spacekiller.infection.platform.InfectionWindowManager;
import com.spacekiller.infection.platform.LegacySupport;
import com.spacekiller.infection.platform.LogHistory;
import com.spacekiller.infection.platform.PluginRuntimeContext;
import com.spacekiller.infection.platform.ProductRegistry;
import com.spacekiller.infection.platform.RegistrationPanel;
import com.spacekiller.infection.util.TempFileIndex;
import com.spacekiller.util.ClassRegistry;
import com.spacekiller.util.DesktopManager;
import com.spacekiller.util.ExecutionManager;
import com.spacekiller.util.FileLocator;
import com.spacekiller.util.LoginManager;
import com.spacekiller.util.Platform;
import com.spacekiller.util.Plugin;
import com.spacekiller.util.PluginPrerequisite;
import com.spacekiller.util.Preferences;
import com.spacekiller.util.PreferencesRegistry;
import com.spacekiller.util.RuntimeContext;
import com.spacekiller.util.SensorManager;
import com.spacekiller.util.Tools;
import com.spacekiller.util.buffer.Base64Util;
import com.spacekiller.util.collect.WeakIdentityHashMap;
import com.spacekiller.util.platform.AbstractPlatform;
import com.spacekiller.util.platform.PluginLoader;
import com.spacekiller.util.platform.RuntimePluginDescriptor;
import com.spacekiller.util.swing.WindowManager;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.PrivilegedAction;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class InfectionPlatform
extends AbstractPlatform
implements InfectionPreferencesConstants {
    private static final Logger logger = Logger.getLogger(InfectionPlatform.class.getName());
    public static final String DEFAULT_CLASSREGISTRY_FILENAME = "classes.registry";
    public static final String DEFAULT_TEMPFILEINDEX_FILENAME = "tempfile.dat";
    public static final String INFECTION_PLATFORM_PRODUCT_ID = "Infection Platform";
    private static final String urlPrefix = "http://bene.homeunix.org/register.php?data=";
    private static Logger log = Logger.getLogger(InfectionPlatform.class.getName());
    private InfectionRuntime infectionRuntime;
    private String platformClassPath;
    private TempFileIndex tempFileIndex;
    private boolean headless;
    private RuntimeContext runtimeContext;
    private InfectionPreferencesRegistry infectionpreferencesRegistry;
    private ClassRegistry classRegistry;
    private ProductRegistry productRegistry;
    private InfectionProductRegistry infectionProductRegistry;
    private Vector runtimePluginDescriptors = new Vector();
    private Map runtimeContextByPlugin = new HashMap();
    private String instanceId;
    private PublicKey publicKey;
    private LogHistory logHistory;
    private WindowManager windowManager;
    private LoginManager loginManager;
    private FileLocator fileLocator;
    private DesktopManager desktopManager;

    public static void main(String[] args) {
        final String[] params = args;
        PrivilegedAction action = new PrivilegedAction(){

            public Object run() {
                try {
                    InfectionPlatform.mainPrivileged(params);
                    return null;
                }
                catch (Throwable e) {
                    log.log(Level.SEVERE, "Error while launching Infection Platform: " + e, e);
                    ErrorDialog.showErrorDialog((Throwable)e);
                    return null;
                }
            }
        };
        AccessController.doPrivileged(action);
    }

    private static void mainPrivileged(String[] args) {
        try {
            boolean info = log.isLoggable(Level.INFO);
            boolean fine = log.isLoggable(Level.FINE);
            if (info) {
                String platformVersion = "N/A";
                Package pkg = Package.getPackage("com.spacekiller.infection.platform");
                if (pkg != null) {
                    platformVersion = "" + pkg.getImplementationTitle() + " " + pkg.getImplementationVersion();
                }
                log.info("Infection Platform version: " + platformVersion);
            }
            if (fine) {
                CodeSource source = InfectionPlatform.class.getProtectionDomain().getCodeSource();
                log.fine("Infection Platform source: " + source.getLocation());
                log.fine("Java version: " + System.getProperty("java.version"));
            }
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        DefaultInfectionLauncher.main(args);
    }

    public InfectionPlatform(InfectionRuntime infectionAccess, File platformHomeDir, File dataDir, File logDir, File configDir, File tempDir, ClassLoader platformClassLoader, String platformClassPath, RuntimePluginDescriptor[] pluginDescriptors, RuntimeContext rc, ExecutionManager execManager) throws Exception {
        this.infectionRuntime = infectionAccess;
        this.setHomeDir(platformHomeDir);
        this.setDataDir(dataDir);
        this.setLogDir(logDir);
        this.setConfigDir(configDir);
        this.setTempDir(tempDir);
        this.tempFileIndex = new TempFileIndex(new File(tempDir, DEFAULT_TEMPFILEINDEX_FILENAME));
        this.setPlatformClassLoader(platformClassLoader);
        this.setPlatformClassPath(platformClassPath);
        this.setRuntimeContext(rc);
        this.setExecutionManager(execManager);
        this.initPlatform();
        Platform.setInstance((Platform)this);
        infectionAccess.debugReference((Object)this);
        this.initPlugins(pluginDescriptors);
    }

    public static InfectionPlatform getInfectionPlatform() {
        return (InfectionPlatform)InfectionPlatform.getInstance();
    }

    protected synchronized void postStartup() throws Exception {
        super.postStartup();
    }

    protected void addRuntimePluginDescriptor(RuntimePluginDescriptor runtimePluginDescriptor) {
        if (runtimePluginDescriptor != null && !this.runtimePluginDescriptors.contains(runtimePluginDescriptor)) {
            this.runtimePluginDescriptors.add(runtimePluginDescriptor);
        }
    }

    public Map createIdentityHashMap() {
        return this.createIdentityHashMap(false);
    }

    public Map createIdentityHashMap(boolean weakKeys) {
        if (weakKeys) {
            return new WeakIdentityHashMap(true);
        }
        try {
            Class<?> clazz = Class.forName("java.util.IdentityHashMap");
            return (Map)Tools.newInstance(clazz);
        }
        catch (Exception e) {
            return new WeakIdentityHashMap(false);
        }
    }

    protected RuntimeContext createPluginRuntimeContext(Plugin plugin) {
        return new PluginRuntimeContext(this.getRuntimeContext());
    }

    protected ClassRegistry createClassRegistry() {
        boolean fine = log.isLoggable(Level.FINE);
        if (fine) {
            log.info("Initializing System-ClassRegistry...");
        }
        String classPath = this.getPlatformClassPath();
        File configDir = this.getConfigDir();
        File classRegistryFile = new File(configDir, DEFAULT_CLASSREGISTRY_FILENAME);
        if (fine) {
            log.fine("Class registry path: " + classRegistryFile);
        }
        InfectionClassRegistry registry = new InfectionClassRegistry(this.getPlatformClassLoader(), classPath, classRegistryFile);
        if (fine) {
            log.fine("ClassRegistry: " + registry);
        }
        return registry;
    }

    protected final String getPlatformClassPath() {
        return this.platformClassPath;
    }

    public RuntimeContext getRuntimeContext() {
        return this.runtimeContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RuntimeContext getRuntimeContext(Plugin plugin) {
        if (plugin != null) {
            RuntimeContext rc = (RuntimeContext)this.runtimeContextByPlugin.get(plugin);
            if (rc == null) {
                InfectionPlatform infectionPlatform = this;
                synchronized (infectionPlatform) {
                    rc = (RuntimeContext)this.runtimeContextByPlugin.get(plugin);
                    if (rc == null && (rc = this.createPluginRuntimeContext(plugin)) != null) {
                        this.runtimeContextByPlugin.put(plugin, rc);
                    }
                }
            }
            return rc;
        }
        return null;
    }

    protected RuntimePluginDescriptor getRuntimePluginDescriptor(PluginPrerequisite prereq) {
        String prereqId = prereq.getPluginId();
        RuntimePluginDescriptor[] rpd = this.getRuntimePluginDescriptors();
        if (rpd != null) {
            for (int c = 0; c < rpd.length; ++c) {
                if (!prereqId.equals(rpd[c].getId())) continue;
                return rpd[c];
            }
        }
        return null;
    }

    protected RuntimePluginDescriptor[] getRuntimePluginDescriptors() {
        RuntimePluginDescriptor[] rc = new RuntimePluginDescriptor[this.runtimePluginDescriptors.size()];
        rc = this.runtimePluginDescriptors.toArray(rc);
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassRegistry getClassRegistry() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            // empty if block
        }
        if (this.classRegistry == null) {
            InfectionPlatform infectionPlatform = this;
            synchronized (infectionPlatform) {
                if (this.classRegistry == null) {
                    this.setClassRegistry(this.createClassRegistry());
                }
            }
        }
        return this.classRegistry;
    }

    protected void handleException(Throwable e) {
        logger.log(Level.SEVERE, e.getMessage(), e);
    }

    protected void initPlatform() throws Exception {
        this.getLogHistory();
        boolean fine = log.isLoggable(Level.FINE);
        if (fine) {
            log.fine("Initializing Infection Platform...");
        }
        if (GraphicsEnvironment.isHeadless()) {
            this.setHeadless(true);
        }
    }

    private void setPlatformClassPath(String newPlatformClassPath) {
        this.platformClassPath = newPlatformClassPath;
    }

    protected void setPluginPreferences(Plugin plugin, Preferences prefs) {
    }

    private void setRuntimeContext(RuntimeContext newRuntimeContext) {
        this.runtimeContext = newRuntimeContext;
    }

    protected void setClassRegistry(ClassRegistry newSystemClassRegistry) {
        this.classRegistry = newSystemClassRegistry;
    }

    protected PluginLoader createPluginLoader() {
        ClassLoader platformClassLoader = this.getPlatformClassLoader();
        ClassLoader[] loaders = new ClassLoader[]{platformClassLoader};
        return this.createPluginLoader(loaders);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws Exception {
        block12: {
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkPermission(new RuntimePermission("infection.platform.shutdown"));
            }
            InfectionPlatform infectionPlatform = this;
            synchronized (infectionPlatform) {
                if (this.isShutdownInProgress()) {
                    return;
                }
                this.setShutdownInProgress(true);
            }
            try {
                InfectionRuntime runtime = this.infectionRuntime;
                log.info("===============================================================");
                log.info("Platform shutdown: " + this);
                super.shutdown();
                log.fine("Closing registry files...");
                if (this.infectionpreferencesRegistry != null) {
                    this.infectionpreferencesRegistry.close();
                }
                this.tempFileIndex.deleteAllTempFiles();
                this.unregisterPlatform();
                this.classRegistry = null;
                this.infectionProductRegistry = null;
                this.productRegistry = null;
                this.publicKey = null;
                this.runtimeContextByPlugin = null;
                this.runtimePluginDescriptors = null;
                log.info("Platform shutdown completed: " + this);
                log.info("===============================================================");
                if (runtime == null) break block12;
                try {
                    runtime.shutdown();
                }
                catch (Exception e) {
                    throw e;
                }
                catch (Throwable e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            finally {
                this.setShutdownInProgress(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exit(int exitCode) throws Exception {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(new RuntimePermission("infection.platform.exit"));
        }
        InfectionPlatform infectionPlatform = this;
        synchronized (infectionPlatform) {
            if (this.isShutdownInProgress()) {
                return;
            }
        }
        InfectionRuntime runtime = this.infectionRuntime;
        this.shutdown();
        try {
            if (runtime != null) {
                runtime.exit(exitCode);
            }
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void openUpdateManager() throws Exception {
        this.infectionRuntime.openUpdateManager();
    }

    protected boolean isAutoSoftwareUpdateEnabled() throws Exception {
        return this.infectionRuntime.isAutoSoftwareUpdateEnabled();
    }

    protected void startAutoSoftwareUpdate(boolean promptCheck, boolean promptDownload, boolean promptApply) throws Exception {
        this.infectionRuntime.startAutoSoftwareUpdate(promptCheck, promptDownload, promptApply);
    }

    public void openLoggingConfigPanel() throws Exception {
        this.infectionRuntime.openLoggingConfigPanel();
    }

    private String lookupInstanceId(PreferencesRegistry reg) throws Exception {
        Object obj;
        String key = "platform.instance";
        String prop = "iid";
        Preferences prefs = null;
        String iid = null;
        if (reg.containsKey(key) && (prefs = reg.getPreferences(key)) != null && (obj = prefs.getObject(prop)) != null) {
            iid = String.valueOf(obj);
        }
        if (iid == null) {
            iid = this.generateInstanceId();
            if (prefs == null) {
                prefs = reg.createPreferences(key);
            }
            prefs.setObject(prop, (Object)iid);
            reg.savePreferences(prefs);
        }
        return iid;
    }

    private String generateInstanceId() throws Exception {
        int len = 32;
        String chars = "0123456789-abcdefghijklmnopqrstuvwxyz0123456789-";
        StringBuffer buf = new StringBuffer();
        for (int c = 0; c < len; ++c) {
            double rand = Math.random();
            int i = (int)(rand * (double)chars.length());
            buf.append(chars.charAt(i));
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getInstanceId() throws Exception {
        if (this.instanceId == null) {
            InfectionPlatform infectionPlatform = this;
            synchronized (infectionPlatform) {
                if (this.instanceId == null) {
                    this.setInstanceId(this.lookupInstanceId(this.getPreferencesRegistry()));
                }
            }
        }
        return this.instanceId;
    }

    private void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    protected ProductRegistry createProductRegistry() {
        try {
            InfectionProductRegistry pr;
            this.infectionProductRegistry = pr = new InfectionProductRegistry(this.getPreferencesRegistry());
            return new InfectionProductRegistry.Facade(pr);
        }
        catch (Exception e) {
            this.handleException(e);
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProductRegistry getProductRegistry() {
        if (this.productRegistry == null) {
            InfectionPlatform infectionPlatform = this;
            synchronized (infectionPlatform) {
                if (this.productRegistry == null) {
                    this.setProductRegistry(this.createProductRegistry());
                }
            }
        }
        return this.productRegistry;
    }

    private void setProductRegistry(ProductRegistry productRegistry) {
        this.productRegistry = productRegistry;
    }

    void registerProduct(String product, String productKey) throws Exception {
        this.getProductRegistry();
        if (!this.verifyProductKey(product, productKey)) {
            throw new Exception("Invalid product key: " + productKey);
        }
        this.infectionProductRegistry.registerProduct(product, productKey);
    }

    private boolean verifyProductKey(String product, String productKey) throws Exception {
        int n;
        byte[] encrypted = Base64Util.getDecoder().decode(productKey);
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(2, this.publicKey);
        ByteArrayInputStream bin = new ByteArrayInputStream(encrypted);
        CipherInputStream cin = new CipherInputStream(bin, cipher);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while ((n = cin.read(buf)) >= 0) {
            bout.write(buf, 0, n);
        }
        cin.close();
        bout.flush();
        byte[] inputDigest = bout.toByteArray();
        log.fine("MD5: length[1]=" + inputDigest.length);
        bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        dout.writeUTF(product);
        dout.writeUTF(this.instanceId);
        dout.flush();
        bout.flush();
        byte[] data = bout.toByteArray();
        bout.close();
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(data);
        byte[] digest = md.digest();
        log.fine("MD5: length[2]=" + digest.length);
        return Arrays.equals(digest, inputDigest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final PublicKey getPublicKey() throws Exception {
        if (this.publicKey == null) {
            InfectionPlatform infectionPlatform = this;
            synchronized (infectionPlatform) {
                if (this.publicKey == null) {
                    int n;
                    String pkResource = "/com/spacekiller/infection/key/public.key";
                    URL pkURL = this.getClass().getResource(pkResource);
                    if (pkURL == null) {
                        throw new IOException("Resource not found: " + pkResource);
                    }
                    InputStream in = pkURL.openStream();
                    byte[] buf = new byte[1024];
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    while ((n = in.read(buf)) >= 0) {
                        bout.write(buf, 0, n);
                    }
                    bout.flush();
                    byte[] publicKeyData = bout.toByteArray();
                    KeyFactory rSAKeyFactory = KeyFactory.getInstance("RSA");
                    X509EncodedKeySpec pubSpec = new X509EncodedKeySpec(publicKeyData);
                    this.publicKey = rSAKeyFactory.generatePublic(pubSpec);
                }
            }
        }
        return this.publicKey;
    }

    public static boolean isRegistered() throws Exception {
        return InfectionPlatform.isProductRegistered(INFECTION_PLATFORM_PRODUCT_ID);
    }

    public static boolean isProductRegistered(String product) throws Exception {
        String productKey;
        InfectionPlatform ip;
        ProductRegistry reg;
        Platform plat = Platform.getInstance();
        if (plat == null) {
            return false;
        }
        if (plat instanceof InfectionPlatform && (reg = (ip = (InfectionPlatform)plat).getProductRegistry()) != null && (productKey = reg.getProductKey(product)) != null) {
            return ip.verifyProductKey(product, productKey);
        }
        return false;
    }

    public void openRegistrationPanel() throws Exception {
        this.getProductRegistry();
        InfectionProductRegistry prodReg = this.infectionProductRegistry;
        String productId = INFECTION_PLATFORM_PRODUCT_ID;
        String instanceId = this.getInstanceId();
        String userName = System.getProperty("user.name");
        if (userName == null) {
            userName = "";
        }
        PublicKey pk = this.getPublicKey();
        RegistrationPanel panel = new RegistrationPanel();
        panel.showDialog(prodReg, urlPrefix, productId, instanceId, userName, pk);
    }

    public boolean isHeadless() {
        return this.headless;
    }

    protected void setHeadless(boolean headless) {
        this.headless = headless;
    }

    protected LogHistory createLogHistory() {
        int maxHistoryRecords = 10000;
        InfectionLogHistory history = new InfectionLogHistory(maxHistoryRecords);
        this.infectionRuntime.registerGlobalHandler((Handler)history.getLogHandler());
        return history;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogHistory getLogHistory() {
        if (this.logHistory == null) {
            InfectionPlatform infectionPlatform = this;
            synchronized (infectionPlatform) {
                if (this.logHistory == null) {
                    this.setLogHistory(this.createLogHistory());
                }
            }
        }
        return this.logHistory;
    }

    private void setLogHistory(LogHistory logHistory) {
        this.logHistory = logHistory;
    }

    protected WindowManager createWindowManager() {
        InfectionWindowManager dwm = new InfectionWindowManager();
        return dwm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WindowManager getWindowManager() {
        if (this.windowManager == null) {
            InfectionPlatform infectionPlatform = this;
            synchronized (infectionPlatform) {
                if (this.windowManager == null) {
                    this.setWindowManager(this.createWindowManager());
                }
            }
        }
        return this.windowManager;
    }

    private void setWindowManager(WindowManager windowManager) {
        this.windowManager = windowManager;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        logger.fine("Platform.finalize: " + this);
    }

    public void debugReference(Object object) {
        if (this.infectionRuntime != null) {
            this.infectionRuntime.debugReference(object);
        }
    }

    protected LoginManager createLoginManager() {
        return new InfectionLoginManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoginManager getLoginManager() {
        if (this.loginManager == null) {
            InfectionPlatform infectionPlatform = this;
            synchronized (infectionPlatform) {
                if (this.loginManager == null) {
                    this.setLoginManager(this.createLoginManager());
                }
            }
        }
        return this.loginManager;
    }

    private void setLoginManager(LoginManager loginManager) {
        this.loginManager = loginManager;
    }

    public double getJavaVersion() {
        return Debug.getJavaVersion();
    }

    public File createTempFile(String prefix, String suffix) throws IOException {
        File tempDir = this.getTempDir();
        File tempFile = null;
        tempFile = tempDir == null ? File.createTempFile(prefix, suffix) : File.createTempFile(prefix, suffix, tempDir);
        tempFile.deleteOnExit();
        this.tempFileIndex.registerTempFile(tempFile);
        return tempFile;
    }

    public Package[] getPackages() {
        ArtifactLoader[] loaders;
        InfectionRuntime runtime;
        HashSet<Package> pkgList = new HashSet<Package>();
        Package[] pkgs = Package.getPackages();
        if (pkgs != null) {
            for (int k = 0; k < pkgs.length; ++k) {
                pkgList.add(pkgs[k]);
            }
        }
        if ((runtime = this.infectionRuntime) != null && (loaders = runtime.getArtifactLoaders()) != null) {
            for (int i = 0; i < loaders.length; ++i) {
                ArtifactLoader loader = loaders[i];
                pkgs = runtime.getPackages(loader);
                if (pkgs == null) continue;
                for (int k = 0; k < pkgs.length; ++k) {
                    pkgList.add(pkgs[k]);
                }
            }
        }
        HashSet<Package> pkgSet = pkgList;
        return pkgSet.toArray(new Package[pkgSet.size()]);
    }

    public String getApplicationName() {
        return this.infectionRuntime.getApplicationName();
    }

    public String getApplicationTitle() {
        return this.infectionRuntime.getApplicationTitle();
    }

    public String getApplicationVersion() {
        return this.infectionRuntime.getApplicationVersion();
    }

    public String getDistributionProperty(String key) {
        return this.infectionRuntime.getDistributionProperty(key);
    }

    public byte[] getDistributionResourceData(String key) throws IOException {
        return this.infectionRuntime.getDistributionResourceData(key);
    }

    public Icon getDistributionResourceIcon(String key) throws IOException {
        byte[] data = Platform.getInstance().getDistributionResourceData(key);
        if (data == null) {
            return null;
        }
        return new ImageIcon(data);
    }

    public Image getDistributionResourceImage(String key) throws IOException {
        byte[] data = Platform.getInstance().getDistributionResourceData(key);
        if (data == null) {
            return null;
        }
        return new ImageIcon(data).getImage();
    }

    protected FileLocator createFileLocator() {
        return new InfectionFileLocator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileLocator getFileLocator() {
        if (this.fileLocator == null) {
            InfectionPlatform infectionPlatform = this;
            synchronized (infectionPlatform) {
                if (this.fileLocator == null) {
                    this.setFileLocator(this.createFileLocator());
                }
            }
        }
        return this.fileLocator;
    }

    protected void setFileLocator(FileLocator fileLocator) {
        this.fileLocator = fileLocator;
    }

    protected DesktopManager createDesktopManager() {
        return new InfectionDesktopManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DesktopManager getDesktopManager() {
        if (this.desktopManager == null) {
            InfectionPlatform infectionPlatform = this;
            synchronized (infectionPlatform) {
                if (this.desktopManager == null) {
                    this.setDesktopManager(this.createDesktopManager());
                }
            }
        }
        return this.desktopManager;
    }

    protected void setDesktopManager(DesktopManager desktopManager) {
        this.desktopManager = desktopManager;
    }

    public SensorManager getSensorManager() {
        throw new UnsupportedOperationException("TODO getSensorManager: " + this);
    }

    public boolean showJavaRuntimeWizard(Object invoker) {
        return this.infectionRuntime.showJavaRuntimeWizard(invoker);
    }

    protected void startPlugins() throws Exception {
        super.startPlugins();
    }

    protected PreferencesRegistry createPreferencesRegistry() {
        InfectionPreferencesRegistry preferencesRegistry = null;
        try {
            File configDir = this.getConfigDir();
            String prefIndexFileName = "preferences.properties";
            File prefIndexFile = new File(configDir, prefIndexFileName);
            if (log.isLoggable(Level.CONFIG)) {
                log.config("PreferencesRegistry: " + prefIndexFile);
            }
            boolean exists = prefIndexFile.exists();
            preferencesRegistry = new InfectionPreferencesRegistry(prefIndexFile);
            try {
                preferencesRegistry.initialize();
            }
            catch (Exception e) {
                this.handleException(e);
            }
            if (!exists) {
                this.resetDefaultPreferences((PreferencesRegistry)preferencesRegistry, this.infectionRuntime);
            }
            if (!exists) {
                LegacySupport.migrateLegacyPreferencesRegistry(configDir, (PreferencesRegistry)preferencesRegistry);
                LegacySupport.migrateLegacyPreferences((PreferencesRegistry)preferencesRegistry);
            }
        }
        catch (Exception e) {
            this.handleException(e);
            throw new RuntimeException(e);
        }
        this.infectionpreferencesRegistry = preferencesRegistry;
        return preferencesRegistry.createFacade();
    }

    protected final void resetDefaultPreferences(PreferencesRegistry reg, InfectionRuntime runtime) throws Exception {
        String lafStyle;
        String lafType;
        Preferences prefs = reg.getPreferences("platform.update");
        if (prefs == null) {
            prefs = reg.createPreferences("platform.update");
        }
        prefs.setBoolean("autoUpdateEnabled", true);
        prefs.setLong("autoUpdatePeriod", 604800000L);
        prefs.setBoolean("promptCheck", false);
        prefs.setBoolean("promptDownload", true);
        prefs.setBoolean("promptApply", false);
        prefs.setLong("lastAutoUpdate", 0L);
        prefs = reg.getPreferences("platform.look-and-feel");
        if (prefs == null) {
            prefs = reg.createPreferences("platform.look-and-feel");
        }
        if ((lafType = runtime.getDistributionProperty("laf.type")) != null) {
            prefs.setObject("laf.type", (Object)lafType);
        }
        if ((lafStyle = runtime.getDistributionProperty("laf.style")) != null) {
            prefs.setObject("laf.style", (Object)lafStyle);
        }
        reg.savePreferences(prefs);
    }
}

